package mx.accessibility
{
   import flash.accessibility.AccessibilityImplementation;
   import mx.core.mx_internal;
   import mx.core.IFlexModuleFactory;
   import flash.system.ApplicationDomain;
   import mx.core.UIComponent;
   import flash.display.DisplayObjectContainer;
   import mx.managers.ISystemManager;
   import mx.resources.ResourceManager;
   import mx.resources.IResourceManager;
   import flash.display.DisplayObject;
   import flash.events.Event;
   import flash.accessibility.Accessibility;
   import flash.accessibility.AccessibilityProperties;
   
   use namespace mx_internal;
   
   [ResourceBundle("controls")]
   public class AccImpl extends AccessibilityImplementation
   {
      
      mx_internal static const VERSION:String = "4.1.0.16076";
       
      protected var master:UIComponent;
      
      protected var role:uint;
      
      public function AccImpl(master:UIComponent)
      {
         var n:int = 0;
         var i:int = 0;
         super();
         this.master = master;
         stub = false;
         if(!master.accessibilityProperties)
         {
            master.accessibilityProperties = new AccessibilityProperties();
         }
         var events:Array = this.eventsToHandle;
         if(events)
         {
            n = events.length;
            for(i = 0; i < n; i++)
            {
               master.addEventListener(events[i],this.eventHandler);
            }
         }
      }
      
      mx_internal static function getDefinition(name:String, moduleFactory:IFlexModuleFactory) : Object
      {
         var currentDomain:ApplicationDomain = null;
         if(moduleFactory)
         {
            currentDomain = moduleFactory.info()["currentDomain"];
         }
         else
         {
            currentDomain = ApplicationDomain.currentDomain;
         }
         if(currentDomain.hasDefinition(name))
         {
            return currentDomain.getDefinition(name);
         }
         return null;
      }
      
      public static function isAncestorDisabled(component:UIComponent) : Boolean
      {
         var par:DisplayObjectContainer = component.parent;
         while(Boolean(par && (par is UIComponent && UIComponent(par).enabled)) && Boolean(!(par is ISystemManager)) && Boolean(par != component.root))
         {
            par = par.parent;
         }
         if(!(par is UIComponent))
         {
            return false;
         }
         return !UIComponent(par).enabled;
      }
      
      public static function getFormName(component:UIComponent) : String
      {
         var formName:String = "";
         var containerClass:Class = Class(getDefinition("mx.core.Container",component.moduleFactory));
         if(Boolean(containerClass) && Boolean(component is containerClass))
         {
            return formName;
         }
         var formItemClass:Class = Class(getDefinition("mx.containers.FormItem",component.moduleFactory));
         var par:DisplayObjectContainer = component.parent;
         while(Boolean(par && !(formItemClass && par is formItemClass)) && Boolean(!(par is ISystemManager)) && Boolean(par != component.root))
         {
            par = par.parent;
         }
         if(Boolean(par) && Boolean(formItemClass) && Boolean(par is formItemClass))
         {
            formName = updateFormItemString(par);
         }
         return formName;
      }
      
      private static function joinWithSpace(s1:String, s2:String) : String
      {
         if(s1 == " ")
         {
            s1 = "";
         }
         if(s2 == " ")
         {
            s2 = "";
         }
         if(Boolean(s1) && Boolean(s2))
         {
            s1 = s1 + (" " + s2);
         }
         else if(s2)
         {
            s1 = s2;
         }
         return s1;
      }
      
      private static function updateFormItemString(formItem:Object) : String
      {
         var formHeadingClass:Class = null;
         var formItemIndex:int = 0;
         var i:int = 0;
         var child:UIComponent = null;
         var formName:String = "";
         var resourceManager:IResourceManager = ResourceManager.getInstance();
         var formClass:Class = Class(getDefinition("mx.containers.Form",formItem.moduleFactory));
         var form:UIComponent = UIComponent(formItem.parent);
         if(Boolean(formClass) && Boolean(form is formClass))
         {
            formHeadingClass = Class(getDefinition("mx.containers.FormHeading",formItem.moduleFactory));
            formItemIndex = form.getChildIndex(DisplayObject(formItem));
            for(i = formItemIndex; i >= 0; i--)
            {
               child = UIComponent(form.getChildAt(i));
               if(Boolean(formHeadingClass) && Boolean(child is formHeadingClass))
               {
                  if(formHeadingClass(child).accessibilityProperties)
                  {
                     formName = formHeadingClass(child).accessibilityProperties.name;
                  }
                  if(formName == "")
                  {
                     formName = formHeadingClass(child).label;
                  }
                  break;
               }
            }
         }
         if(formItem.required)
         {
            formName = joinWithSpace(formName,resourceManager.getString("controls","requiredField"));
         }
         var f:String = "";
         if(formItem.accessibilityProperties)
         {
            f = formItem.accessibilityProperties.name;
         }
         if(f == "")
         {
            f = formItem.label;
         }
         formName = joinWithSpace(formName,f);
         return formName;
      }
      
      protected function get eventsToHandle() : Array
      {
         return ["errorStringChanged","toolTipChanged","show","hide"];
      }
      
      override public function get_accRole(childID:uint) : uint
      {
         return this.role;
      }
      
      override public function get_accName(childID:uint) : String
      {
         var accName:String = null;
         if(childID)
         {
            accName = this.getName(childID);
            return Boolean(accName != null) && Boolean(accName != "")?accName:null;
         }
         accName = getFormName(this.master);
         if(Boolean(this.master.accessibilityProperties) && Boolean(this.master.accessibilityProperties.name != null) && Boolean(this.master.accessibilityProperties.name != ""))
         {
            accName = joinWithSpace(accName,this.master.accessibilityProperties.name);
         }
         else
         {
            accName = joinWithSpace(accName,this.getName(0) || this.master.toolTip);
         }
         accName = joinWithSpace(accName,this.getStatusName());
         return Boolean(accName != null) && Boolean(accName != "")?accName:null;
      }
      
      override public function getChildIDArray() : Array
      {
         return [];
      }
      
      override public function accSelect(selFlag:uint, childID:uint) : void
      {
      }
      
      protected function getName(childID:uint) : String
      {
         return null;
      }
      
      protected function getState(childID:uint) : uint
      {
         var accState:uint = AccConst.STATE_SYSTEM_NORMAL;
         if(Boolean(!UIComponent(this.master).enabled) || Boolean(isAncestorDisabled(this.master)))
         {
            accState = accState & ~AccConst.STATE_SYSTEM_FOCUSABLE;
            accState = accState | AccConst.STATE_SYSTEM_UNAVAILABLE;
         }
         else
         {
            accState = accState | AccConst.STATE_SYSTEM_FOCUSABLE;
            if(UIComponent(this.master) == UIComponent(this.master).getFocus())
            {
               accState = accState | AccConst.STATE_SYSTEM_FOCUSED;
            }
         }
         return accState;
      }
      
      private function getStatusName() : String
      {
         var statusName:String = "";
         if(Boolean(this.master is UIComponent) && Boolean(UIComponent(this.master).errorString))
         {
            statusName = UIComponent(this.master).errorString;
         }
         return statusName;
      }
      
      protected function createChildIDArray(n:int) : Array
      {
         var a:Array = new Array(n);
         for(var i:int = 0; i < n; i++)
         {
            a[i] = i + 1;
         }
         return a;
      }
      
      protected function eventHandler(event:Event) : void
      {
         this.$eventHandler(event);
      }
      
      protected final function $eventHandler(event:Event) : void
      {
         switch(event.type)
         {
            case "errorStringChanged":
            case "toolTipChanged":
               Accessibility.sendEvent(this.master,0,AccConst.EVENT_OBJECT_NAMECHANGE);
               Accessibility.updateProperties();
               break;
            case "show":
               Accessibility.sendEvent(this.master,0,AccConst.EVENT_OBJECT_SHOW);
               Accessibility.updateProperties();
               break;
            case "hide":
               Accessibility.sendEvent(this.master,0,AccConst.EVENT_OBJECT_HIDE);
               Accessibility.updateProperties();
         }
      }
   }
}
