package flashx.textLayout.property
{
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class StringProperty extends Property
   {
       
      public function StringProperty(nameValue:String, defaultValue:String, inherited:Boolean, category:String)
      {
         super(nameValue,defaultValue,inherited,category);
      }
      
      tlf_internal static function doHash(val:String, seed:uint) : uint
      {
         if(val == null)
         {
            return seed;
         }
         var len:uint = val.length;
         var hash:uint = seed;
         for(var ix:uint = 0; ix < len / 2; ix++)
         {
            hash = UintProperty.doHash(val.charCodeAt(2 * ix) << 16 | val.charCodeAt(2 * ix + 1),hash);
         }
         if(len % 2 != 0)
         {
            hash = UintProperty.doHash(val.charCodeAt(len - 1),hash);
         }
         return hash;
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(Boolean(newObject === undefined) || Boolean(newObject is String))
         {
            return newObject;
         }
         Property.errorHandler(this,newObject);
         return currVal;
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         return doHash(val as String,seed);
      }
   }
}
