package flashx.textLayout.property
{
   import flashx.textLayout.elements.GlobalSettings;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.formats.FormatValue;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class Property
   {
      
      public static var errorHandler:Function = defaultErrorHandler;
      
      public static const NO_LIMITS:String = "noLimits";
      
      public static const LOWER_LIMIT:String = "lowerLimit";
      
      public static const UPPER_LIMIT:String = "upperLimit";
      
      public static const ALL_LIMITS:String = "allLimits";
      
      tlf_internal static const inheritHashValue:uint = 314159;
      
      private static const nullStyleObject:Object = new Object();
       
      private var _name:String;
      
      private var _default:Object;
      
      private var _inherited:Boolean;
      
      private var _limits:String;
      
      private var _category:String;
      
      public function Property(nameValue:String, defaultValue:Object, inherited:Boolean, category:String)
      {
         super();
         this._name = nameValue;
         this._default = defaultValue;
         this._limits = ALL_LIMITS;
         this._inherited = inherited;
         this._category = category;
      }
      
      public static function defaultErrorHandler(p:Property, value:Object) : void
      {
         throw new RangeError(createErrorString(p,value));
      }
      
      public static function createErrorString(p:Property, value:Object) : String
      {
         return GlobalSettings.resourceStringFunction("badPropertyValue",[p.name,value.toString()]);
      }
      
      public static function defaultsAllHelper(description:Object, current:Object) : void
      {
         var prop:Property = null;
         for each(prop in description)
         {
            current[prop.name] = prop.defaultValue;
         }
      }
      
      public static function equalAllHelper(description:Object, p1:Object, p2:Object) : Boolean
      {
         var prop:Property = null;
         var name:String = null;
         if(p1 == p2)
         {
            return true;
         }
         if(Boolean(p1 == null) || Boolean(p2 == null))
         {
            return false;
         }
         for each(prop in description)
         {
            name = prop.name;
            if(!prop.equalHelper(p1[name],p2[name]))
            {
               return false;
            }
         }
         return true;
      }
      
      public static function extractInCategory(formatClass:Class, description:Object, props:Object, category:String) : Object
      {
         var prop:Property = null;
         var rslt:Object = null;
         for each(prop in description)
         {
            if(Boolean(prop.category == category) && Boolean(props[prop.name] != null))
            {
               if(rslt == null)
               {
                  rslt = new formatClass();
               }
               rslt[prop.name] = props[prop.name];
            }
         }
         return rslt;
      }
      
      public static function shallowCopy(src:Object) : Object
      {
         var val:* = null;
         var rslt:Object = new Object();
         for(val in src)
         {
            rslt[val] = src[val];
         }
         return rslt;
      }
      
      public static function equalStyleObjects(o1:Object, o2:Object) : Boolean
      {
         var val:* = null;
         var o2len:int = 0;
         if(o1 == null)
         {
            o1 = nullStyleObject;
         }
         if(o2 == null)
         {
            o2 = nullStyleObject;
         }
         var o1len:int = 0;
         for(val in o1)
         {
            if(o1[val] != o2[val])
            {
               return false;
            }
            o1len++;
         }
         o2len = 0;
         for(val in o2)
         {
            o2len++;
         }
         return o1len == o2len;
      }
      
      public static function equalCoreStyles(o1:Object, o2:Object, description:Object) : Boolean
      {
         var val:* = null;
         var o2len:int = 0;
         var o1val:Object = null;
         var o2val:Object = null;
         var valClass:Class = null;
         if(o1 == null)
         {
            o1 = nullStyleObject;
         }
         if(o2 == null)
         {
            o2 = nullStyleObject;
         }
         var o1len:int = 0;
         for(val in o1)
         {
            o1val = o1[val];
            o2val = o2[val];
            if(o1val != o2val)
            {
               if(Boolean(!(o1val is Array)) || Boolean(!(o2val is Array)) || Boolean(o1val.length != o2val.length))
               {
                  return false;
               }
               valClass = description[val].memberType;
               if(!Property.equalAllHelper(valClass.tlf_internal::description,o1val,o2val))
               {
                  return false;
               }
            }
            o1len++;
         }
         o2len = 0;
         for(val in o2)
         {
            o2len++;
         }
         return o1len == o2len;
      }
      
      protected function checkLowerLimit() : Boolean
      {
         return Boolean(this._limits == ALL_LIMITS) || Boolean(this._limits == LOWER_LIMIT);
      }
      
      protected function checkUpperLimit() : Boolean
      {
         return Boolean(this._limits == ALL_LIMITS) || Boolean(this._limits == LOWER_LIMIT);
      }
      
      public function get name() : String
      {
         return this._name;
      }
      
      public function get defaultValue() : Object
      {
         return this._default;
      }
      
      public function get inherited() : Object
      {
         return this._inherited;
      }
      
      public function get category() : String
      {
         return this._category;
      }
      
      public function setHelper(currVal:*, newVal:*) : *
      {
         if(newVal === null)
         {
            newVal = undefined;
         }
         return newVal;
      }
      
      public function concatInheritOnlyHelper(currVal:*, concatVal:*) : *
      {
         return Boolean(this._inherited) && Boolean(currVal === undefined) || Boolean(currVal == FormatValue.INHERIT)?concatVal:currVal;
      }
      
      public function concatHelper(currVal:*, concatVal:*) : *
      {
         if(this._inherited)
         {
            return Boolean(currVal === undefined) || Boolean(currVal == FormatValue.INHERIT)?concatVal:currVal;
         }
         if(currVal === undefined)
         {
            return this.defaultValue;
         }
         return currVal == FormatValue.INHERIT?concatVal:currVal;
      }
      
      public function equalHelper(v1:*, v2:*) : Boolean
      {
         return v1 == v2;
      }
      
      public function toXMLString(val:Object) : String
      {
         return val.toString();
      }
      
      public function hash(val:Object, seed:uint) : uint
      {
         return 0;
      }
   }
}
