package flashx.textLayout.property
{
   import flashx.textLayout.formats.FormatValue;
   import flashx.textLayout.tlf_internal;
   
   use namespace tlf_internal;
   
   [ExcludeClass]
   public class IntProperty extends Property
   {
       
      private var _minValue:int;
      
      private var _maxValue:int;
      
      public function IntProperty(nameValue:String, defaultValue:int, inherited:Boolean, category:String, minValue:int, maxValue:int)
      {
         super(nameValue,defaultValue,inherited,category);
         this._minValue = minValue;
         this._maxValue = maxValue;
      }
      
      public function get minValue() : int
      {
         return this._minValue;
      }
      
      public function get maxValue() : int
      {
         return this._maxValue;
      }
      
      override public function setHelper(currVal:*, newObject:*) : *
      {
         if(newObject === null)
         {
            newObject = undefined;
         }
         if(Boolean(newObject === undefined) || Boolean(newObject == FormatValue.INHERIT))
         {
            return newObject;
         }
         var newValNumber:Number = parseInt(newObject);
         if(isNaN(newValNumber))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         var newVal:int = int(newValNumber);
         if(Boolean(checkLowerLimit()) && Boolean(newVal < this._minValue))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         if(Boolean(checkUpperLimit()) && Boolean(newVal > this._maxValue))
         {
            Property.errorHandler(this,newObject);
            return currVal;
         }
         return newVal;
      }
      
      override public function hash(val:Object, seed:uint) : uint
      {
         if(val == FormatValue.INHERIT)
         {
            return UintProperty.doHash(inheritHashValue,seed);
         }
         return UintProperty.doHash(val as uint,seed);
      }
   }
}
