package flashx.textLayout.operations
{
   import flashx.textLayout.edit.TextScrap;
   import flashx.textLayout.edit.TextFlowEdit;
   import flashx.textLayout.edit.SelectionState;
   
   public class PasteOperation extends FlowTextOperation
   {
       
      private var _textScrap:TextScrap;
      
      private var _tScrapUnderSelection:TextScrap;
      
      private var _numCharsAdded:int = 0;
      
      public function PasteOperation(operationState:SelectionState, textScrap:TextScrap)
      {
         super(operationState);
         this._textScrap = textScrap;
      }
      
      override public function doOperation() : Boolean
      {
         if(this._textScrap != null)
         {
            this._tScrapUnderSelection = TextFlowEdit.createTextScrap(originalSelectionState.textFlow,originalSelectionState.absoluteStart,originalSelectionState.absoluteEnd);
            this.internalDoOperation();
         }
         return true;
      }
      
      private function internalDoOperation() : void
      {
         if(absoluteStart != absoluteEnd)
         {
            TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteEnd,null);
            if(textFlow.interactionManager)
            {
               textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,absoluteStart - absoluteEnd);
            }
         }
         var nextInsertPosition:int = TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteStart,this._textScrap);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,nextInsertPosition - absoluteStart);
         }
         this._numCharsAdded = nextInsertPosition - absoluteStart;
      }
      
      override public function undo() : SelectionState
      {
         if(this._textScrap != null)
         {
            TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteStart + this._numCharsAdded,this._tScrapUnderSelection);
            if(textFlow.interactionManager)
            {
               textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,-this._numCharsAdded);
            }
         }
         return originalSelectionState;
      }
      
      override public function redo() : SelectionState
      {
         if(this._textScrap != null)
         {
            this.internalDoOperation();
         }
         return new SelectionState(textFlow,absoluteStart + this._numCharsAdded,absoluteStart + this._numCharsAdded,null);
      }
      
      public function get textScrap() : TextScrap
      {
         return this._textScrap;
      }
      
      public function set textScrap(val:TextScrap) : void
      {
         this._textScrap = val;
      }
   }
}
