package flashx.textLayout.operations
{
   import flashx.textLayout.edit.TextScrap;
   import flashx.textLayout.edit.TextFlowEdit;
   import flashx.textLayout.edit.SelectionState;
   
   public class CutOperation extends FlowTextOperation
   {
       
      private var _tScrap:TextScrap;
      
      public function CutOperation(operationState:SelectionState, scrapToCut:TextScrap)
      {
         super(operationState);
         this._tScrap = scrapToCut;
      }
      
      override public function doOperation() : Boolean
      {
         var beforeOpLen:int = textFlow.textLength;
         TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteEnd,null);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,-(absoluteEnd - absoluteStart));
         }
         if(textFlow.textLength == beforeOpLen)
         {
            this._tScrap = null;
         }
         return true;
      }
      
      override public function undo() : SelectionState
      {
         if(this._tScrap != null)
         {
            TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteStart,this._tScrap);
            if(textFlow.interactionManager)
            {
               textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,absoluteEnd - absoluteStart);
            }
         }
         return originalSelectionState;
      }
      
      override public function redo() : SelectionState
      {
         TextFlowEdit.replaceRange(textFlow,absoluteStart,absoluteEnd,null);
         if(textFlow.interactionManager)
         {
            textFlow.interactionManager.notifyInsertOrDelete(absoluteStart,-(absoluteEnd - absoluteStart));
         }
         return new SelectionState(textFlow,absoluteStart,absoluteStart,null);
      }
      
      public function get scrapToCut() : TextScrap
      {
         return this._tScrap;
      }
      
      public function set scrapToCut(val:TextScrap) : void
      {
         this._tScrap = val;
      }
   }
}
