package flashx.textLayout.operations
{
   import flashx.textLayout.formats.ITextLayoutFormat;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.formats.TextLayoutFormat;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.edit.SelectionState;
   
   use namespace tlf_internal;
   
   public class ClearFormatOnElementOperation extends FlowElementOperation
   {
       
      private var _format:ITextLayoutFormat;
      
      private var undoCoreStyles:Object;
      
      public function ClearFormatOnElementOperation(operationState:SelectionState, targetElement:FlowElement, format:ITextLayoutFormat, relativeStart:int = 0, relativeEnd:int = -1)
      {
         super(operationState,targetElement,relativeStart,relativeEnd);
         this._format = format;
      }
      
      public function get format() : ITextLayoutFormat
      {
         return this._format;
      }
      
      public function set format(value:ITextLayoutFormat) : void
      {
         this._format = value;
      }
      
      override public function doOperation() : Boolean
      {
         var newFormat:TextLayoutFormatValueHolder = null;
         var prop:* = null;
         var targetElement:FlowElement = getTargetElement();
         adjustForDoOperation(targetElement);
         this.undoCoreStyles = targetElement.coreStyles;
         if(this._format)
         {
            newFormat = new TextLayoutFormatValueHolder(targetElement.format);
            for(prop in TextLayoutFormat.description)
            {
               if(this._format[prop] !== undefined)
               {
                  newFormat[prop] = undefined;
               }
            }
            targetElement.format = newFormat;
         }
         return true;
      }
      
      override public function undo() : SelectionState
      {
         var targetElement:FlowElement = getTargetElement();
         targetElement.setCoreStylesInternal(this.undoCoreStyles);
         adjustForUndoOperation(targetElement);
         return originalSelectionState;
      }
   }
}
