package flashx.textLayout.operations
{
   import flashx.textLayout.edit.TextScrap;
   import flashx.textLayout.elements.FlowLeafElement;
   import flashx.textLayout.elements.TCYElement;
   import flashx.textLayout.edit.TextFlowEdit;
   import flashx.textLayout.edit.SelectionState;
   
   public class ApplyTCYOperation extends FlowTextOperation
   {
       
      private var makeBegIdx:int;
      
      private var makeEndIdx:int;
      
      private var removeBegIdx:int;
      
      private var removeEndIdx:int;
      
      private var removeRedoBegIdx:int;
      
      private var removeRedoEndIdx:int;
      
      private var _textScrap:TextScrap;
      
      private var _tcyOn:Boolean;
      
      public function ApplyTCYOperation(operationState:SelectionState, tcyOn:Boolean)
      {
         super(operationState);
         if(tcyOn)
         {
            this.makeBegIdx = operationState.absoluteStart;
            this.makeEndIdx = operationState.absoluteEnd;
         }
         else
         {
            this.removeBegIdx = operationState.absoluteStart;
            this.removeEndIdx = operationState.absoluteEnd;
         }
         this._tcyOn = tcyOn;
      }
      
      public function get tcyOn() : Boolean
      {
         return this._tcyOn;
      }
      
      public function set tcyOn(val:Boolean) : void
      {
         this._tcyOn = val;
      }
      
      override public function doOperation() : Boolean
      {
         var leaf:FlowLeafElement = null;
         var tcyElem:TCYElement = null;
         if(Boolean(this._tcyOn) && Boolean(this.makeEndIdx <= this.makeBegIdx))
         {
            return false;
         }
         if(Boolean(!this._tcyOn) && Boolean(this.removeEndIdx <= this.removeBegIdx))
         {
            return false;
         }
         if(this._tcyOn)
         {
            this._textScrap = TextFlowEdit.createTextScrap(textFlow,this.makeBegIdx,this.makeEndIdx);
            TextFlowEdit.makeTCY(textFlow,this.makeBegIdx,this.makeEndIdx);
         }
         else
         {
            leaf = textFlow.findLeaf(this.removeBegIdx);
            tcyElem = leaf.getParentByType(TCYElement) as TCYElement;
            this.removeRedoBegIdx = this.removeBegIdx;
            this.removeRedoEndIdx = this.removeEndIdx;
            this.removeBegIdx = tcyElem.getAbsoluteStart();
            this.removeEndIdx = this.removeBegIdx + tcyElem.textLength;
            this._textScrap = TextFlowEdit.createTextScrap(textFlow,this.removeBegIdx,this.removeEndIdx);
            TextFlowEdit.removeTCY(textFlow,this.removeRedoBegIdx,this.removeRedoEndIdx);
         }
         return true;
      }
      
      override public function undo() : SelectionState
      {
         if(this._textScrap != null)
         {
            if(this._tcyOn)
            {
               TextFlowEdit.replaceRange(textFlow,this.makeBegIdx,this.makeEndIdx,this._textScrap);
            }
            else
            {
               TextFlowEdit.replaceRange(textFlow,this.removeBegIdx,this.removeEndIdx,this._textScrap);
            }
         }
         return originalSelectionState;
      }
      
      override public function redo() : SelectionState
      {
         if(this._textScrap != null)
         {
            if(this._tcyOn)
            {
               TextFlowEdit.makeTCY(textFlow,this.makeBegIdx,this.makeEndIdx);
            }
            else
            {
               TextFlowEdit.removeTCY(textFlow,this.removeRedoBegIdx,this.removeRedoEndIdx);
            }
         }
         return originalSelectionState;
      }
   }
}
