package flashx.textLayout.elements
{
   import flashx.textLayout.tlf_internal;
   import flash.utils.getQualifiedClassName;
   import flash.display.DisplayObjectContainer;
   import flash.text.engine.ContentElement;
   import flash.text.engine.GroupElement;
   import flashx.textLayout.container.ContainerController;
   import flashx.textLayout.events.ModelChange;
   import flashx.textLayout.compose.FlowDamageType;
   import flashx.textLayout.formats.TextLayoutFormatValueHolder;
   import flashx.textLayout.formats.FormatValue;
   
   use namespace tlf_internal;
   
   [DefaultProperty("mxmlChildren")]
   public class FlowGroupElement extends flashx.textLayout.elements.FlowElement
   {
       
      private var _childArray:Array;
      
      private var _singleChild:flashx.textLayout.elements.FlowElement;
      
      private var _numChildren:int;
      
      public function FlowGroupElement()
      {
         super();
         this._numChildren = 0;
      }
      
      private static function getNestedArgCount(obj:Object) : uint
      {
         return obj is Array?uint(obj.length):uint(1);
      }
      
      private static function getNestedArg(obj:Object, index:uint) : flashx.textLayout.elements.FlowElement
      {
         return (obj is Array?obj[index]:obj) as FlowElement;
      }
      
      override public function deepCopy(startPos:int = 0, endPos:int = -1) : flashx.textLayout.elements.FlowElement
      {
         var newFlowElement:flashx.textLayout.elements.FlowElement = null;
         var child:flashx.textLayout.elements.FlowElement = null;
         var possiblyEmptyFlowElement:flashx.textLayout.elements.FlowElement = null;
         if(endPos == -1)
         {
            endPos = textLength;
         }
         var retFlow:FlowGroupElement = shallowCopy(startPos,endPos) as FlowGroupElement;
         for(var idx:int = 0; idx < this._numChildren; idx++)
         {
            child = this.getChildAt(idx);
            if(Boolean(startPos - child.parentRelativeStart < child.textLength) && Boolean(endPos - child.parentRelativeStart > 0))
            {
               newFlowElement = child.deepCopy(startPos - child.parentRelativeStart,endPos - child.parentRelativeStart);
               retFlow.replaceChildren(retFlow.numChildren,retFlow.numChildren,newFlowElement);
               if(retFlow.numChildren > 1)
               {
                  possiblyEmptyFlowElement = retFlow.getChildAt(retFlow.numChildren - 2);
                  if(possiblyEmptyFlowElement.textLength == 0)
                  {
                     retFlow.replaceChildren(retFlow.numChildren - 2,retFlow.numChildren - 1);
                  }
               }
            }
         }
         return retFlow;
      }
      
      override public function getText(relativeStart:int = 0, relativeEnd:int = -1, paragraphSeparator:String = "\n") : String
      {
         var child:flashx.textLayout.elements.FlowElement = null;
         var copyStart:int = 0;
         var copyEnd:int = 0;
         var text:String = super.getText();
         if(relativeEnd == -1)
         {
            relativeEnd = textLength;
         }
         var pos:int = relativeStart;
         var idx:int = this.findChildIndexAtPosition(relativeStart);
         while(Boolean(idx < this._numChildren) && Boolean(pos < relativeEnd))
         {
            child = this.getChildAt(idx);
            copyStart = pos - child.parentRelativeStart;
            copyEnd = Math.min(relativeEnd - child.parentRelativeStart,child.textLength);
            text = text + child.getText(copyStart,copyEnd,paragraphSeparator);
            pos = pos + (copyEnd - copyStart);
            if(Boolean(paragraphSeparator) && Boolean(child is ParagraphFormattedElement) && Boolean(pos < relativeEnd))
            {
               text = text + paragraphSeparator;
            }
            idx++;
         }
         return text;
      }
      
      override tlf_internal function formatChanged(notifyModelChanged:Boolean = true) : void
      {
         var child:flashx.textLayout.elements.FlowElement = null;
         super.formatChanged(notifyModelChanged);
         for(var idx:int = 0; idx < this._numChildren; idx++)
         {
            child = this.getChildAt(idx);
            child.formatChanged(false);
         }
      }
      
      [RichTextContent]
      public function get mxmlChildren() : Array
      {
         return this._numChildren == 0?null:this._numChildren == 1?[this._singleChild]:this._childArray.slice();
      }
      
      public function set mxmlChildren(array:Array) : void
      {
         var child:Object = null;
         var s:SpanElement = null;
         this.replaceChildren(0,this._numChildren);
         var effectiveParent:FlowGroupElement = this;
         for each(child in array)
         {
            if(child is FlowElement)
            {
               if(child is ParagraphFormattedElement)
               {
                  effectiveParent = this;
               }
               else if(effectiveParent is ContainerFormattedElement)
               {
                  effectiveParent = new ParagraphElement();
                  effectiveParent.impliedElement = true;
                  this.replaceChildren(this._numChildren,this._numChildren,effectiveParent);
               }
               if(Boolean(child is SpanElement) || Boolean(child is SubParagraphGroupElement))
               {
                  child.bindableElement = true;
               }
               effectiveParent.replaceChildren(effectiveParent.numChildren,effectiveParent.numChildren,FlowElement(child));
            }
            else if(child is String)
            {
               s = new SpanElement();
               s.text = String(child);
               s.bindableElement = true;
               s.impliedElement = true;
               if(effectiveParent is ContainerFormattedElement)
               {
                  effectiveParent = new ParagraphElement();
                  this.replaceChildren(this._numChildren,this._numChildren,effectiveParent);
                  effectiveParent.impliedElement = true;
               }
               effectiveParent.replaceChildren(effectiveParent.numChildren,effectiveParent.numChildren,s);
            }
            else if(child != null)
            {
               throw new TypeError(GlobalSettings.resourceStringFunction("badMXMLChildrenArgument",[getQualifiedClassName(child)]));
            }
         }
      }
      
      override tlf_internal function createGeometry(parentToBe:DisplayObjectContainer) : void
      {
         var child:flashx.textLayout.elements.FlowElement = null;
         for(var idx:int = 0; idx < this._numChildren; idx++)
         {
            child = this.getChildAt(idx);
            child.createGeometry(parentToBe);
         }
      }
      
      public function get numChildren() : int
      {
         return this._numChildren;
      }
      
      public function getChildIndex(child:flashx.textLayout.elements.FlowElement) : int
      {
         var mid:int = 0;
         var p:flashx.textLayout.elements.FlowElement = null;
         var testmid:int = 0;
         var hi:int = this._numChildren - 1;
         if(hi <= 0)
         {
            return this._singleChild == child?int(0):int(-1);
         }
         var lo:int = 0;
         while(lo <= hi)
         {
            mid = (lo + hi) / 2;
            p = this._childArray[mid];
            if(p.parentRelativeStart == child.parentRelativeStart)
            {
               if(p == child)
               {
                  return mid;
               }
               if(p.textLength == 0)
               {
                  for(testmid = mid; testmid < this._numChildren; testmid++)
                  {
                     p = this._childArray[testmid];
                     if(p == child)
                     {
                        return testmid;
                     }
                     if(p.textLength != 0)
                     {
                        break;
                     }
                  }
               }
               while(true)
               {
                  if(mid > 0)
                  {
                     mid--;
                     p = this._childArray[mid];
                     if(p == child)
                     {
                        break;
                     }
                     if(p.textLength == 0)
                     {
                        continue;
                     }
                  }
                  return -1;
               }
               return mid;
            }
            if(p.parentRelativeStart < child.parentRelativeStart)
            {
               lo = mid + 1;
            }
            else
            {
               hi = mid - 1;
            }
         }
         return -1;
      }
      
      public function getChildAt(index:int) : flashx.textLayout.elements.FlowElement
      {
         if(this._numChildren > 1)
         {
            return this._childArray[index];
         }
         return index == 0?this._singleChild:null;
      }
      
      tlf_internal function getNextLeafHelper(param1:FlowGroupElement, param2:flashx.textLayout.elements.FlowElement) : FlowLeafElement
      {
         var _loc3_:int = this.getChildIndex(param2);
         if(_loc3_ == -1)
         {
            return null;
         }
         if(_loc3_ == this._numChildren - 1)
         {
            if(Boolean(param1 == this) || Boolean(!parent))
            {
               return null;
            }
            return parent.getNextLeafHelper(param1,this);
         }
         param2 = this.getChildAt(_loc3_ + 1);
         return param2 is FlowLeafElement?FlowLeafElement(param2):FlowGroupElement(param2).getFirstLeaf();
      }
      
      tlf_internal function getPreviousLeafHelper(param1:FlowGroupElement, param2:flashx.textLayout.elements.FlowElement) : FlowLeafElement
      {
         var _loc3_:int = this.getChildIndex(param2);
         if(_loc3_ == -1)
         {
            return null;
         }
         if(_loc3_ == 0)
         {
            if(Boolean(param1 == this) || Boolean(!parent))
            {
               return null;
            }
            return parent.getPreviousLeafHelper(param1,this);
         }
         param2 = this.getChildAt(_loc3_ - 1);
         return param2 is FlowLeafElement?FlowLeafElement(param2):FlowGroupElement(param2).getLastLeaf();
      }
      
      public function findLeaf(relativePosition:int) : FlowLeafElement
      {
         var child:flashx.textLayout.elements.FlowElement = null;
         var childRelativePos:int = 0;
         var found:FlowLeafElement = null;
         var childIdx:int = this.findChildIndexAtPosition(relativePosition);
         if(childIdx != -1)
         {
            do
            {
               child = this.getChildAt(childIdx++);
               if(!child)
               {
                  break;
               }
               childRelativePos = relativePosition - child.parentRelativeStart;
               if(child is FlowGroupElement)
               {
                  found = FlowGroupElement(child).findLeaf(childRelativePos);
               }
               else if(Boolean(childRelativePos >= 0) && Boolean(childRelativePos < child.textLength) || Boolean(child.textLength == 0) && Boolean(this._numChildren == 1))
               {
                  found = FlowLeafElement(child);
               }
            }
            while(Boolean(!found) && Boolean(!child.textLength));
            
         }
         return found;
      }
      
      public function findChildIndexAtPosition(relativePosition:int) : int
      {
         var mid:int = 0;
         var child:flashx.textLayout.elements.FlowElement = null;
         var lo:int = 0;
         var hi:int = this._numChildren - 1;
         while(lo <= hi)
         {
            mid = (lo + hi) / 2;
            child = this.getChildAt(mid);
            if(child.parentRelativeStart <= relativePosition)
            {
               if(child.parentRelativeStart == relativePosition)
               {
                  while(mid != 0)
                  {
                     child = this.getChildAt(mid - 1);
                     if(child.textLength != 0)
                     {
                        break;
                     }
                     mid--;
                  }
                  return mid;
               }
               if(child.parentRelativeStart + child.textLength > relativePosition)
               {
                  return mid;
               }
               lo = mid + 1;
            }
            else
            {
               hi = mid - 1;
            }
         }
         return -1;
      }
      
      public function getFirstLeaf() : FlowLeafElement
      {
         var idx:int = 0;
         var child:flashx.textLayout.elements.FlowElement = null;
         var leaf:FlowLeafElement = null;
         if(this._numChildren > 1)
         {
            for(idx = 0; idx < this._numChildren; idx++)
            {
               child = this._childArray[idx];
               leaf = child is FlowGroupElement?FlowGroupElement(child).getFirstLeaf():FlowLeafElement(child);
               if(leaf)
               {
                  return leaf;
               }
            }
            return null;
         }
         return this._numChildren == 0?null:this._singleChild is FlowGroupElement?FlowGroupElement(this._singleChild).getFirstLeaf():FlowLeafElement(this._singleChild);
      }
      
      public function getLastLeaf() : FlowLeafElement
      {
         var idx:int = 0;
         var child:flashx.textLayout.elements.FlowElement = null;
         var leaf:FlowLeafElement = null;
         if(this._numChildren > 1)
         {
            for(idx = this._numChildren; idx != 0; idx--)
            {
               child = this._childArray[idx - 1];
               leaf = child is FlowGroupElement?FlowGroupElement(child).getLastLeaf():FlowLeafElement(child);
               if(leaf)
               {
                  return leaf;
               }
            }
            return null;
         }
         return this._numChildren == 0?null:this._singleChild is FlowGroupElement?FlowGroupElement(this._singleChild).getLastLeaf():FlowLeafElement(this._singleChild);
      }
      
      override public function getCharAtPosition(relativePosition:int) : String
      {
         var leaf:FlowLeafElement = this.findLeaf(relativePosition);
         return Boolean(leaf)?leaf.getCharAtPosition(relativePosition - leaf.getElementRelativeStart(this)):"";
      }
      
      override tlf_internal function getElementByIDHelper(idName:String) : flashx.textLayout.elements.FlowElement
      {
         var idx:int = 0;
         var child:flashx.textLayout.elements.FlowElement = null;
         var rslt:flashx.textLayout.elements.FlowElement = super.getElementByIDHelper(idName);
         if(rslt == null)
         {
            for(idx = 0; idx < this._numChildren; idx++)
            {
               child = this.getChildAt(idx);
               rslt = child.getElementByIDHelper(idName);
               if(rslt != null)
               {
                  break;
               }
            }
         }
         return rslt;
      }
      
      override tlf_internal function getElementsByStyleNameHelper(a:Array, styleName:String) : void
      {
         var child:flashx.textLayout.elements.FlowElement = null;
         super.getElementsByStyleNameHelper(a,styleName);
         for(var idx:int = 0; idx < this._numChildren; idx++)
         {
            child = this.getChildAt(idx);
            child.getElementsByStyleNameHelper(a,styleName);
         }
      }
      
      tlf_internal function removeBlockElement(child:flashx.textLayout.elements.FlowElement, block:ContentElement) : void
      {
      }
      
      tlf_internal function insertBlockElement(child:flashx.textLayout.elements.FlowElement, block:ContentElement) : void
      {
      }
      
      tlf_internal function hasBlockElement() : Boolean
      {
         return false;
      }
      
      tlf_internal function createContentAsGroup() : GroupElement
      {
         return null;
      }
      
      tlf_internal function addChildAfterInternal(child:flashx.textLayout.elements.FlowElement, newChild:flashx.textLayout.elements.FlowElement) : void
      {
         if(this._numChildren > 1)
         {
            this._childArray.splice(this._childArray.indexOf(child) + 1,0,newChild);
         }
         else
         {
            this._childArray = [this._singleChild,newChild];
            this._singleChild = null;
         }
         this._numChildren++;
         newChild.setParentAndRelativeStartOnly(this,child.parentRelativeEnd);
      }
      
      tlf_internal function canOwnFlowElement(elem:flashx.textLayout.elements.FlowElement) : Boolean
      {
         return Boolean(!(elem is TextFlow)) && Boolean(!(elem is FlowLeafElement)) && Boolean(!(elem is SubParagraphGroupElement));
      }
      
      public function replaceChildren(beginChildIndex:int, endChildIndex:int, ... rest) : void
      {
         var flatNewChildList:Array = null;
         var newChildToAdd:flashx.textLayout.elements.FlowElement = null;
         var newChild:flashx.textLayout.elements.FlowElement = null;
         var idx:int = 0;
         var obj:Object = null;
         var child:flashx.textLayout.elements.FlowElement = null;
         var len:int = 0;
         var numNestedArgs:int = 0;
         var childIndex:int = 0;
         var addedTextLength:uint = 0;
         var enclosingContainer:ContainerController = null;
         var tFlow:TextFlow = null;
         if(Boolean(beginChildIndex > this._numChildren) || Boolean(endChildIndex > this._numChildren))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("badReplaceChildrenIndex"));
         }
         var thisAbsStart:int = getAbsoluteStart();
         var absStartIdx:int = thisAbsStart + (beginChildIndex == this._numChildren?textLength:this.getChildAt(beginChildIndex).parentRelativeStart);
         var relStartIdx:int = beginChildIndex == this._numChildren?int(textLength):int(this.getChildAt(beginChildIndex).parentRelativeStart);
         if(beginChildIndex < endChildIndex)
         {
            len = 0;
            while(beginChildIndex < endChildIndex)
            {
               child = this.getChildAt(beginChildIndex);
               child.modelChanged(ModelChange.ELEMENT_REMOVAL,0,child.textLength);
               len = len + child.textLength;
               child.setParentAndRelativeStart(null,0);
               if(this._numChildren == 1)
               {
                  this._singleChild = null;
                  this._numChildren = 0;
               }
               else
               {
                  this._childArray.splice(beginChildIndex,1);
                  this._numChildren--;
                  if(this._numChildren == 1)
                  {
                     this._singleChild = this._childArray[0];
                     this._childArray = null;
                  }
               }
               endChildIndex--;
            }
            if(len)
            {
               while(endChildIndex < this._numChildren)
               {
                  child = this.getChildAt(endChildIndex);
                  child.setParentRelativeStart(child.parentRelativeStart - len);
                  endChildIndex++;
               }
               updateLengths(absStartIdx,-len,true);
               deleteContainerText(relStartIdx + len,len);
            }
         }
         var childrenToAdd:int = 0;
         for each(obj in rest)
         {
            if(obj)
            {
               numNestedArgs = getNestedArgCount(obj);
               for(idx = 0; idx < numNestedArgs; idx++)
               {
                  newChild = getNestedArg(obj,idx);
                  if(newChild)
                  {
                     if(newChild.parent)
                     {
                        if(newChild.parent == this)
                        {
                           childIndex = this.getChildIndex(newChild);
                           newChild.parent.removeChild(newChild);
                           thisAbsStart = getAbsoluteStart();
                           if(childIndex <= beginChildIndex)
                           {
                              beginChildIndex--;
                              absStartIdx = thisAbsStart + (beginChildIndex == this._numChildren?textLength:this.getChildAt(beginChildIndex).parentRelativeStart);
                              relStartIdx = beginChildIndex == this._numChildren?int(textLength):int(this.getChildAt(beginChildIndex).parentRelativeStart);
                           }
                        }
                        else
                        {
                           thisAbsStart = getAbsoluteStart();
                           newChild.parent.removeChild(newChild);
                        }
                     }
                     if(!this.canOwnFlowElement(newChild))
                     {
                        throw ArgumentError(GlobalSettings.resourceStringFunction("invalidChildType"));
                     }
                     if(childrenToAdd == 0)
                     {
                        newChildToAdd = newChild;
                     }
                     else if(childrenToAdd == 1)
                     {
                        flatNewChildList = [newChildToAdd,newChild];
                     }
                     else
                     {
                        flatNewChildList.push(newChild);
                     }
                     childrenToAdd++;
                  }
               }
            }
         }
         if(childrenToAdd)
         {
            addedTextLength = 0;
            for(idx = 0; idx < childrenToAdd; idx++)
            {
               newChild = childrenToAdd == 1?newChildToAdd:flatNewChildList[idx];
               if(this._numChildren == 0)
               {
                  this._singleChild = newChild;
               }
               else if(this._numChildren > 1)
               {
                  this._childArray.splice(beginChildIndex,0,newChild);
               }
               else
               {
                  this._childArray = beginChildIndex == 0?[newChild,this._singleChild]:[this._singleChild,newChild];
                  this._singleChild = null;
               }
               this._numChildren++;
               newChild.setParentAndRelativeStart(this,relStartIdx + addedTextLength);
               addedTextLength = addedTextLength + newChild.textLength;
               beginChildIndex++;
            }
            if(addedTextLength)
            {
               while(beginChildIndex < this._numChildren)
               {
                  child = this.getChildAt(beginChildIndex++);
                  child.setParentRelativeStart(child.parentRelativeStart + addedTextLength);
               }
               updateLengths(absStartIdx,addedTextLength,true);
               enclosingContainer = getEnclosingController(relStartIdx);
               if(enclosingContainer)
               {
                  ContainerController(enclosingContainer).setTextLength(enclosingContainer.textLength + addedTextLength);
               }
            }
            for(idx = 0; idx < childrenToAdd; idx++)
            {
               newChild = childrenToAdd == 1?newChildToAdd:flatNewChildList[idx];
               newChild.modelChanged(ModelChange.ELEMENT_ADDED,0,newChild.textLength);
            }
         }
         else
         {
            tFlow = getTextFlow();
            if(tFlow != null)
            {
               if(beginChildIndex < this._numChildren)
               {
                  idx = thisAbsStart + this.getChildAt(beginChildIndex).parentRelativeStart;
               }
               else if(beginChildIndex > 1)
               {
                  newChild = this.getChildAt(beginChildIndex - 1);
                  idx = thisAbsStart + newChild.parentRelativeStart + newChild.textLength - 1;
               }
               else
               {
                  idx = thisAbsStart;
                  if(idx >= tFlow.textLength)
                  {
                     idx--;
                  }
               }
               tFlow.damage(idx,1,FlowDamageType.GEOMETRY,false);
            }
         }
      }
      
      public function addChild(child:flashx.textLayout.elements.FlowElement) : flashx.textLayout.elements.FlowElement
      {
         this.replaceChildren(this._numChildren,this._numChildren,child);
         return child;
      }
      
      public function addChildAt(index:uint, child:flashx.textLayout.elements.FlowElement) : flashx.textLayout.elements.FlowElement
      {
         this.replaceChildren(index,index,child);
         return child;
      }
      
      public function removeChild(child:flashx.textLayout.elements.FlowElement) : flashx.textLayout.elements.FlowElement
      {
         var index:int = this.getChildIndex(child);
         if(index == -1)
         {
            throw ArgumentError(GlobalSettings.resourceStringFunction("badRemoveChild"));
         }
         this.removeChildAt(index);
         return child;
      }
      
      public function removeChildAt(index:uint) : flashx.textLayout.elements.FlowElement
      {
         var childToReplace:flashx.textLayout.elements.FlowElement = this.getChildAt(index);
         this.replaceChildren(index,index + 1);
         return childToReplace;
      }
      
      public function splitAtIndex(childIndex:int) : FlowGroupElement
      {
         var childArray:Array = null;
         var myidx:int = 0;
         if(childIndex > this._numChildren)
         {
            throw RangeError(GlobalSettings.resourceStringFunction("invalidSplitAtIndex"));
         }
         var newSibling:FlowGroupElement = shallowCopy() as FlowGroupElement;
         var numChildrenToMove:int = this._numChildren - childIndex;
         if(numChildrenToMove == 1)
         {
            newSibling.addChild(this.removeChildAt(childIndex));
         }
         else if(numChildrenToMove != 0)
         {
            childArray = this._childArray.slice(childIndex);
            this.replaceChildren(childIndex,this._numChildren - 1);
            newSibling.replaceChildren(0,0,childArray);
         }
         if(parent)
         {
            myidx = parent.getChildIndex(this);
            parent.replaceChildren(myidx + 1,myidx + 1,newSibling);
         }
         return newSibling;
      }
      
      override public function splitAtPosition(relativePosition:int) : flashx.textLayout.elements.FlowElement
      {
         var curElementIdx:int = 0;
         var curFlowElement:flashx.textLayout.elements.FlowElement = null;
         if(Boolean(relativePosition < 0) || Boolean(relativePosition > textLength))
         {
            throw RangeError(GlobalSettings.resourceStringFunction("invalidSplitAtPosition"));
         }
         if(relativePosition == textLength)
         {
            curElementIdx = this._numChildren;
         }
         else
         {
            curElementIdx = this.findChildIndexAtPosition(relativePosition);
            curFlowElement = this.getChildAt(curElementIdx);
            if(curFlowElement.parentRelativeStart != relativePosition)
            {
               if(curFlowElement is FlowGroupElement)
               {
                  FlowGroupElement(curFlowElement).splitAtPosition(relativePosition - curFlowElement.parentRelativeStart);
               }
               else
               {
                  SpanElement(curFlowElement).splitAtPosition(relativePosition - curFlowElement.parentRelativeStart);
               }
               curElementIdx++;
            }
         }
         return this.splitAtIndex(curElementIdx);
      }
      
      override tlf_internal function normalizeRange(normalizeStart:uint, normalizeEnd:uint) : void
      {
         var child:flashx.textLayout.elements.FlowElement = null;
         var origChildEnd:int = 0;
         var newChildEnd:int = 0;
         var idx:int = this.findChildIndexAtPosition(normalizeStart);
         if(Boolean(idx != -1) && Boolean(idx < this._numChildren))
         {
            child = this.getChildAt(idx);
            for(normalizeStart = normalizeStart - child.parentRelativeStart; true; )
            {
               origChildEnd = child.parentRelativeStart + child.textLength;
               child.normalizeRange(normalizeStart,normalizeEnd - child.parentRelativeStart);
               newChildEnd = child.parentRelativeStart + child.textLength;
               normalizeEnd = normalizeEnd + (newChildEnd - origChildEnd);
               if(Boolean(child.textLength == 0) && Boolean(!child.bindableElement))
               {
                  this.replaceChildren(idx,idx + 1);
               }
               else
               {
                  idx++;
               }
               if(idx == this._numChildren)
               {
                  break;
               }
               child = this.getChildAt(idx);
               if(child.parentRelativeStart > normalizeEnd)
               {
                  break;
               }
               normalizeStart = 0;
            }
         }
      }
      
      override tlf_internal function applyWhiteSpaceCollapse(collapse:String) : void
      {
         var ffc:TextLayoutFormatValueHolder = null;
         var wsc:* = undefined;
         var child:flashx.textLayout.elements.FlowElement = null;
         if(collapse == null)
         {
            collapse = this.computedFormat.whiteSpaceCollapse;
         }
         else
         {
            ffc = this.formatForCascade;
            wsc = Boolean(ffc)?ffc.whiteSpaceCollapse:undefined;
            if(Boolean(wsc !== undefined) && Boolean(wsc != FormatValue.INHERIT))
            {
               collapse = wsc;
            }
         }
         for(var idx:int = 0; idx < this._numChildren; )
         {
            child = this.getChildAt(idx);
            child.applyWhiteSpaceCollapse(collapse);
            if(child.parent == this)
            {
               idx++;
            }
         }
         if(Boolean(textLength == 0) && Boolean(impliedElement) && Boolean(parent != null))
         {
            parent.removeChild(this);
         }
         super.applyWhiteSpaceCollapse(collapse);
      }
      
      override tlf_internal function appendElementsForDelayedUpdate(tf:TextFlow) : void
      {
         var child:flashx.textLayout.elements.FlowElement = null;
         for(var idx:int = 0; idx < this._numChildren; idx++)
         {
            child = this.getChildAt(idx);
            child.appendElementsForDelayedUpdate(tf);
         }
      }
   }
}
