package flashx.textLayout.edit
{
   import flashx.textLayout.elements.TextRange;
   import flashx.textLayout.elements.TextFlow;
   import flashx.textLayout.tlf_internal;
   import flashx.textLayout.elements.FlowElement;
   import flashx.textLayout.elements.FlowGroupElement;
   
   use namespace tlf_internal;
   
   public class TextScrap
   {
       
      private var _textFlow:TextFlow;
      
      private var _beginMissingArray:Array;
      
      private var _endMissingArray:Array;
      
      public function TextScrap(textFlow:TextFlow = null)
      {
         super();
         this._textFlow = textFlow;
         this._textFlow.flowComposer = null;
         this._beginMissingArray = new Array();
         this._endMissingArray = new Array();
      }
      
      public static function createTextScrap(range:TextRange) : TextScrap
      {
         return TextFlowEdit.createTextScrap(range.textFlow,range.absoluteStart,range.absoluteEnd);
      }
      
      tlf_internal function get textFlow() : TextFlow
      {
         return this._textFlow;
      }
      
      tlf_internal function isBeginMissing(fl:FlowElement) : Boolean
      {
         var arrLen:int = this._beginMissingArray.length;
         var currPos:int = 0;
         while(currPos < arrLen)
         {
            if(this._beginMissingArray[currPos] == fl)
            {
               return true;
            }
            currPos++;
         }
         return false;
      }
      
      tlf_internal function isEndMissing(fl:FlowElement) : Boolean
      {
         var arrLen:int = this._endMissingArray.length;
         var currPos:int = 0;
         while(currPos < arrLen)
         {
            if(this._endMissingArray[currPos] == fl)
            {
               return true;
            }
            currPos++;
         }
         return false;
      }
      
      tlf_internal function addToBeginMissing(fl:FlowElement) : void
      {
         this._beginMissingArray.push(fl);
      }
      
      tlf_internal function addToEndMissing(fl:FlowElement) : void
      {
         this._endMissingArray.push(fl);
      }
      
      tlf_internal function get beginMissingArray() : Array
      {
         return this._beginMissingArray;
      }
      
      tlf_internal function get endMissingArray() : Array
      {
         return this._endMissingArray;
      }
      
      tlf_internal function set beginMissingArray(arr:Array) : void
      {
         this._beginMissingArray = arr;
      }
      
      tlf_internal function set endMissingArray(arr:Array) : void
      {
         this._endMissingArray = arr;
      }
      
      public function clone() : TextScrap
      {
         var curFlElement:FlowElement = null;
         var curFlElementIndex:int = 0;
         var newBeginArray:Array = null;
         var newEndArray:Array = null;
         var t:TextFlow = this.textFlow.deepCopy() as TextFlow;
         var newTextScrap:TextScrap = new TextScrap(t);
         var beginMissingArray:Array = this._beginMissingArray;
         var endMissingArray:Array = this._endMissingArray;
         var curPos:int = beginMissingArray.length - 2;
         var newFlowElement:FlowElement = newTextScrap.textFlow;
         if(beginMissingArray.length > 0)
         {
            newBeginArray = new Array();
            newBeginArray.push(newFlowElement);
            while(curPos >= 0)
            {
               curFlElement = beginMissingArray[curPos];
               curFlElementIndex = curFlElement.parent.getChildIndex(curFlElement);
               if(newFlowElement is FlowGroupElement)
               {
                  newFlowElement = (newFlowElement as FlowGroupElement).getChildAt(curFlElementIndex);
                  newBeginArray.push(newFlowElement);
               }
               curPos--;
            }
            newTextScrap.beginMissingArray = newBeginArray;
         }
         curPos = endMissingArray.length - 2;
         newFlowElement = newTextScrap.textFlow;
         if(endMissingArray.length > 0)
         {
            newEndArray = new Array();
            newEndArray.push(newFlowElement);
            while(curPos >= 0)
            {
               curFlElement = endMissingArray[curPos];
               curFlElementIndex = curFlElement.parent.getChildIndex(curFlElement);
               if(newFlowElement is FlowGroupElement)
               {
                  newFlowElement = (newFlowElement as FlowGroupElement).getChildAt(curFlElementIndex);
                  newEndArray.push(newFlowElement);
               }
               curPos--;
            }
            newTextScrap.endMissingArray = newEndArray;
         }
         return newTextScrap;
      }
   }
}
