package
{
   import spark.components.Application;
   import mx.binding.IBindingClient;
   import mx.binding.IWatcherSetupUtil2;
   import mx.collections.ArrayList;
   import spark.components.Button;
   import spark.components.Label;
   import mx.controls.Image;
   import spark.components.Group;
   import spark.components.DropDownList;
   import mx.core.IFlexModuleFactory;
   import flash.geom.Point;
   import flash.utils.Dictionary;
   import flash.filters.ColorMatrixFilter;
   import com.beka.util.EEMath;
   import spark.components.TextInput;
   import flash.system.Capabilities;
   import com.beka.util.BekaErrorEvent;
   import com.beka.feuchterechner.Converter;
   import caurina.transitions.Tweener;
   import flash.events.MouseEvent;
   import mx.controls.Alert;
   import com.beka.feuchterechner.PDFCreator;
   import flash.system.System;
   import spark.events.IndexChangeEvent;
   import flash.events.FocusEvent;
   import flash.events.KeyboardEvent;
   import flash.net.navigateToURL;
   import flash.net.URLRequest;
   import mx.binding.BindingManager;
   import mx.controls.HRule;
   import mx.events.FlexEvent;
   import mx.binding.Binding;
   import flash.utils.Proxy;
   import mx.core.mx_internal;
   import mx.styles.CSSStyleDeclaration;
   import mx.styles.CSSCondition;
   import mx.styles.CSSSelector;
   import mx.events.PropertyChangeEvent;
   import flash.utils.getDefinitionByName;
   import mx.core.DeferredInstanceFromFunction;
   
   use namespace mx_internal;
   
   [Frame(factoryClass="_EEHumidityCalculator_mx_managers_SystemManager")]
   [Frame(extraClass="_EEHumidityCalculator_FlexInit")]
   [SWF(width="800",height="800")]
   [ResourceBundle("locale")]
   public class EEHumidityCalculator extends Application implements IBindingClient
   {
      
      private static var _watcherSetupUtil:IWatcherSetupUtil2;
       
      public var _EEHumidityCalculator_ArrayList1:ArrayList;
      
      public var _EEHumidityCalculator_ArrayList2:ArrayList;
      
      public var _EEHumidityCalculator_Button3:Button;
      
      public var _EEHumidityCalculator_Label1:Label;
      
      public var _EEHumidityCalculator_Label101:Label;
      
      public var _EEHumidityCalculator_Label105:Label;
      
      public var _EEHumidityCalculator_Label109:Label;
      
      public var _EEHumidityCalculator_Label113:Label;
      
      public var _EEHumidityCalculator_Label116:Label;
      
      public var _EEHumidityCalculator_Label120:Label;
      
      public var _EEHumidityCalculator_Label124:Label;
      
      public var _EEHumidityCalculator_Label128:Label;
      
      public var _EEHumidityCalculator_Label13:Label;
      
      public var _EEHumidityCalculator_Label17:Label;
      
      public var _EEHumidityCalculator_Label21:Label;
      
      public var _EEHumidityCalculator_Label24:Label;
      
      public var _EEHumidityCalculator_Label28:Label;
      
      public var _EEHumidityCalculator_Label3:Label;
      
      public var _EEHumidityCalculator_Label32:Label;
      
      public var _EEHumidityCalculator_Label36:Label;
      
      public var _EEHumidityCalculator_Label40:Label;
      
      public var _EEHumidityCalculator_Label43:Label;
      
      public var _EEHumidityCalculator_Label47:Label;
      
      public var _EEHumidityCalculator_Label51:Label;
      
      public var _EEHumidityCalculator_Label55:Label;
      
      public var _EEHumidityCalculator_Label59:Label;
      
      public var _EEHumidityCalculator_Label6:Label;
      
      public var _EEHumidityCalculator_Label63:Label;
      
      public var _EEHumidityCalculator_Label66:Label;
      
      public var _EEHumidityCalculator_Label68:Label;
      
      public var _EEHumidityCalculator_Label71:Label;
      
      public var _EEHumidityCalculator_Label74:Label;
      
      public var _EEHumidityCalculator_Label78:Label;
      
      public var _EEHumidityCalculator_Label82:Label;
      
      public var _EEHumidityCalculator_Label86:Label;
      
      public var _EEHumidityCalculator_Label9:Label;
      
      public var _EEHumidityCalculator_Label90:Label;
      
      public var _EEHumidityCalculator_Label93:Label;
      
      public var _EEHumidityCalculator_Label97:Label;
      
      private var _1332194002background:Image;
      
      private var _1700385006baseGrpList:Group;
      
      private var _1700319696baseGrpNorm:Group;
      
      private var _1017248418clipButton:Button;
      
      private var _1094147633dvGrpList:Group;
      
      private var _1094212943dvGrpNorm:Group;
      
      private var _1887962878eGrpList:Group;
      
      private var _1888028188eGrpNorm:Group;
      
      private var _1078062433eLableList:Label;
      
      private var _1077997123eLableNorm:Label;
      
      private var _1895004705eiGrpList:Group;
      
      private var _1894939395eiGrpNorm:Group;
      
      private var _1327390016eiLableList:Label;
      
      private var _1327455326eiLableNorm:Label;
      
      private var _1029503505ewGrpList:Group;
      
      private var _1029568815ewGrpNorm:Group;
      
      private var _1423799054ewLableList:Label;
      
      private var _1423733744ewLableNorm:Label;
      
      private var _1473540709hGrpList:Group;
      
      private var _1473475399hGrpNorm:Group;
      
      private var _38651069helpLableList:Label;
      
      private var _38585759helpLableNorm:Label;
      
      private var _1954846127inputBg:Image;
      
      private var _805811475inputBgList:Image;
      
      private var _1819206675langSelector:DropDownList;
      
      private var _2027298025logoList:Image;
      
      private var _2027363335logoNorm:Image;
      
      private var _1610332128methodSelector:DropDownList;
      
      private var _415959917pGrpList:Group;
      
      private var _415894607pGrpNorm:Group;
      
      private var _51853628pdfButton:Button;
      
      private var _927923906qvGrpList:Group;
      
      private var _927858596qvGrpNorm:Group;
      
      private var _1225306543rGrpList:Group;
      
      private var _1225241233rGrpNorm:Group;
      
      private var _626125218rsGrpList:Group;
      
      private var _626190528rsGrpNorm:Group;
      
      private var _2034653169tGrpList:Group;
      
      private var _2034587859tGrpNorm:Group;
      
      private var _933832339tdGrpList:Group;
      
      private var _933897649tdGrpNorm:Group;
      
      private var _124485713tfGrpList:Group;
      
      private var _124551023tfGrpNorm:Group;
      
      private var _1057949422tiGrpList:Group;
      
      private var _1058014732tiGrpNorm:Group;
      
      private var _312509664twGrpList:Group;
      
      private var _312444354twGrpNorm:Group;
      
      private var _749505041uiGrpList:Group;
      
      private var _749439731uiGrpNorm:Group;
      
      private var _2119964127uwGrpList:Group;
      
      private var _2119898817uwGrpNorm:Group;
      
      private var _895032740viewSelector:DropDownList;
      
      private var _1112251204wvGrpList:Group;
      
      private var _1112316514wvGrpNorm:Group;
      
      private var __moduleFactoryInitialized:Boolean = false;
      
      private var _342488600logoImg:Class;
      
      private var _3141bg:Class;
      
      private var _1914223881bgElement:Class;
      
      private var _788601913bgElementP:Class;
      
      private var _788601910bgElementM:Class;
      
      private var _231533515bgElementList:Class;
      
      private var _1415216247bgElementPList:Class;
      
      private var _1412445684bgElementMList:Class;
      
      private var _213314058headerImg:Class;
      
      private var _646922200footerImg:Class;
      
      private var useComma:Boolean;
      
      private var isCleanPhase:Boolean;
      
      private var isListView:Boolean;
      
      private var pressureSet:Boolean;
      
      private var temperatureSet:Boolean;
      
      private var lastName:String;
      
      private var isCurErr:Boolean;
      
      private var curInput:Group;
      
      private var oldPos:Point;
      
      private var ew:Number;
      
      private var ei:Number;
      
      private var ewData:Dictionary;
      
      private var eiData:Dictionary;
      
      private var values:Dictionary;
      
      private var deviations:Dictionary;
      
      private var pValStore:String;
      
      private var pDevStore:String;
      
      private var groupToMapNorm:Dictionary;
      
      private var mapToGroupNorm:Dictionary;
      
      private var groupToMapList:Dictionary;
      
      private var mapToGroupList:Dictionary;
      
      private var formatInfo:Dictionary;
      
      private var redFilter:ColorMatrixFilter;
      
      private var symbols:Array;
      
      private const errorEvt:String = "ErrEvt";
      
      mx_internal var _EEHumidityCalculator_StylesInit_done:Boolean = false;
      
      mx_internal var _bindings:Array;
      
      mx_internal var _watchers:Array;
      
      mx_internal var _bindingsByDestination:Object;
      
      mx_internal var _bindingsBeginWithWord:Object;
      
      public function EEHumidityCalculator()
      {
         var target:Object = null;
         var watcherSetupUtilClass:Object = null;
         this._342488600logoImg = EEHumidityCalculator_logoImg;
         this._3141bg = EEHumidityCalculator_bg;
         this._1914223881bgElement = EEHumidityCalculator_bgElement;
         this._788601913bgElementP = EEHumidityCalculator_bgElementP;
         this._788601910bgElementM = EEHumidityCalculator_bgElementM;
         this._231533515bgElementList = EEHumidityCalculator_bgElementList;
         this._1415216247bgElementPList = EEHumidityCalculator_bgElementPList;
         this._1412445684bgElementMList = EEHumidityCalculator_bgElementMList;
         this._213314058headerImg = EEHumidityCalculator_headerImg;
         this._646922200footerImg = EEHumidityCalculator_footerImg;
         this.symbols = ["p","t","ew\'","ei\'","rs","h","ti","tw","qv","wv","dv","r","tf","td","Ui","Uw","e\'"];
         this._bindings = [];
         this._watchers = [];
         this._bindingsByDestination = {};
         this._bindingsBeginWithWord = {};
         super();
         var bindings:Array = this._EEHumidityCalculator_bindingsSetup();
         var watchers:Array = [];
         target = this;
         if(_watcherSetupUtil == null)
         {
            watcherSetupUtilClass = getDefinitionByName("_EEHumidityCalculatorWatcherSetupUtil");
            watcherSetupUtilClass["init"](null);
         }
         _watcherSetupUtil.setup(this,function(propertyName:String):*
         {
            return target[propertyName];
         },function(param1:String):*
         {
            return EEHumidityCalculator[param1];
         },bindings,watchers);
         mx_internal::_bindings = mx_internal::_bindings.concat(bindings);
         mx_internal::_watchers = mx_internal::_watchers.concat(watchers);
         this.height = 800;
         this.width = 800;
         this.mxmlContentFactory = new DeferredInstanceFromFunction(this._EEHumidityCalculator_Array1_c);
         this.addEventListener("applicationComplete",this.___EEHumidityCalculator_Application1_applicationComplete);
         var i:uint = 0;
         while(i < bindings.length)
         {
            Binding(bindings[i]).execute();
            i++;
         }
      }
      
      public static function set watcherSetupUtil(param1:IWatcherSetupUtil2) : void
      {
         EEHumidityCalculator._watcherSetupUtil = param1;
      }
      
      override public function set moduleFactory(param1:IFlexModuleFactory) : void
      {
         super.moduleFactory = param1;
         if(this.__moduleFactoryInitialized)
         {
            return;
         }
         this.__moduleFactoryInitialized = true;
         mx_internal::_EEHumidityCalculator_StylesInit();
      }
      
      override public function initialize() : void
      {
         super.initialize();
      }
      
      protected function InitApp() : void
      {
         var redFilterMatrix:Array = new Array();
         redFilterMatrix = redFilterMatrix.concat([1,0,0,0,0]);
         redFilterMatrix = redFilterMatrix.concat([0,0,0,0,0]);
         redFilterMatrix = redFilterMatrix.concat([0,0,0,0,0]);
         redFilterMatrix = redFilterMatrix.concat([0,0,0,1,0]);
         this.redFilter = new ColorMatrixFilter(redFilterMatrix);
         EEMath.getInstance().addEventListener(this.errorEvt,this.handleError);
         this.values = new Dictionary();
         this.values["p"] = 1013.25;
         TextInput(this.pGrpNorm.getChildByName("input")).toolTip = this.values["p"].toString();
         this.values["t"] = 23;
         TextInput(this.tGrpNorm.getChildByName("input")).toolTip = this.values["t"].toString();
         this.deviations = new Dictionary();
         this.deviations["p"] = 0;
         TextInput(this.pGrpNorm.getChildByName("devInput")).toolTip = this.deviations["p"].toString();
         this.deviations["t"] = 0;
         TextInput(this.tGrpNorm.getChildByName("devInput")).toolTip = this.deviations["t"].toString();
         this.useComma = false;
         this.isCleanPhase = false;
         this.isCurErr = false;
         this.pressureSet = true;
         this.temperatureSet = true;
         this.lastName = "";
         this.setBackgroundImages();
         this.fillMaps();
         this.fillFormatInfo();
         this.isListView = true;
         this.fillSelectors();
         this.isListView = false;
         this.fillSelectors();
         this.checkValues(this.lastName);
         if(Capabilities.screenResolutionY < 900)
         {
            this.viewSelector.selectedIndex = 1;
            this.changeNormListHandler();
         }
         if(Capabilities.language == "de")
         {
            this.langSelector.selectedIndex = 1;
            this.changeLocaleHandler();
         }
      }
      
      protected function setBackgroundImages() : void
      {
         this.background.source = this.bg;
         this.logoNorm.source = this.logoImg;
         this.logoList.source = this.logoImg;
         this.inputBg.source = this.bgElement;
         this.inputBgList.source = this.bgElementList;
         Image(this.pGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.tGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.ewGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.eiGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.rsGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.hGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.tiGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.twGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.qvGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.wvGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.dvGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.rGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.tfGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.tdGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.uiGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.uwGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.eGrpNorm.getChildByName("bg")).source = this.bgElement;
         Image(this.tiGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.twGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.qvGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.wvGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.dvGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.rGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.tfGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.tdGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.uiGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.uwGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.eGrpNorm.getChildByName("icon")).source = this.bgElementP;
         Image(this.pGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.tGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.ewGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.eiGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.rsGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.hGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.tiGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.twGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.qvGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.wvGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.dvGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.rGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.tfGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.tdGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.uiGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.uwGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.eGrpList.getChildByName("bg")).source = this.bgElementList;
         Image(this.tiGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.twGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.qvGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.wvGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.dvGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.rGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.tfGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.tdGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.uiGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.uwGrpList.getChildByName("icon")).source = this.bgElementPList;
         Image(this.eGrpList.getChildByName("icon")).source = this.bgElementPList;
      }
      
      protected function fillSelectors() : void
      {
         var data:ArrayList = null;
         data = new ArrayList();
         data.addItem({
            "data":"en_US",
            "label":"English"
         });
         data.addItem({
            "data":"de_DE",
            "label":"Deutsch"
         });
         data.addItem({
            "data":"es_ES",
            "label":"Español"
         });
         data.addItem({
            "data":"fr_FR",
            "label":"Français"
         });
         data.addItem({
            "data":"ru_RU",
            "label":"Polish"
         });
         data.addItem({
            "data":"it_IT",
            "label":"Italian"
         });
         data.addItem({
            "data":"nl_NL",
            "label":"Nederlands"
         });
         data.addItem({
            "data":"zh_CN",
            "label":"官話"
         });
         this.langSelector.dataProvider = data;
         this.langSelector.selectedIndex = 0;
         this.resourceManager.localeChain = [this.langSelector.selectedItem["data"]];
         data = new ArrayList();
         data.addItem({
            "type":"celsius",
            "label":"°C"
         });
         data.addItem({
            "type":"fahrenheit",
            "label":"°F"
         });
         data.addItem({
            "type":"kelvin",
            "label":"K"
         });
         DropDownList(this.getGroupeByName("t").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("t").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"hpa",
            "label":"hPa"
         });
         data.addItem({
            "type":"psi",
            "label":"psi"
         });
         DropDownList(this.getGroupeByName("p").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("p").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"hpa",
            "label":"hPa"
         });
         data.addItem({
            "type":"psi",
            "label":"psi"
         });
         DropDownList(this.getGroupeByName("ew").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("ew").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"hpa",
            "label":"hPa"
         });
         data.addItem({
            "type":"psi",
            "label":"psi"
         });
         DropDownList(this.getGroupeByName("ei").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("ei").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"gkg",
            "label":"g/kg"
         });
         data.addItem({
            "type":"grlb",
            "label":"gr/lb"
         });
         DropDownList(this.getGroupeByName("rs").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("rs").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"kjkg",
            "label":"kJ/kg"
         });
         data.addItem({
            "type":"btulb",
            "label":"Btu/lb"
         });
         DropDownList(this.getGroupeByName("h").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("h").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"celsius",
            "label":"°C"
         });
         data.addItem({
            "type":"fahrenheit",
            "label":"°F"
         });
         data.addItem({
            "type":"kelvin",
            "label":"K"
         });
         DropDownList(this.getGroupeByName("ti").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("ti").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"celsius",
            "label":"°C"
         });
         data.addItem({
            "type":"fahrenheit",
            "label":"°F"
         });
         data.addItem({
            "type":"kelvin",
            "label":"K"
         });
         DropDownList(this.getGroupeByName("tw").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("tw").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"gkg",
            "label":"g/kg"
         });
         data.addItem({
            "type":"grlb",
            "label":"gr/lb"
         });
         DropDownList(this.getGroupeByName("qv").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("qv").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"per",
            "label":"%"
         });
         data.addItem({
            "type":"ooo",
            "label":"o/oo"
         });
         data.addItem({
            "type":"ppm",
            "label":"ppm"
         });
         DropDownList(this.getGroupeByName("wv").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("wv").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"gm3",
            "label":"g/m^3"
         });
         data.addItem({
            "type":"grft3",
            "label":"gr/ft^3"
         });
         DropDownList(this.getGroupeByName("dv").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("dv").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"gkg",
            "label":"g/kg"
         });
         data.addItem({
            "type":"grlb",
            "label":"gr/lb"
         });
         DropDownList(this.getGroupeByName("r").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("r").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"celsius",
            "label":"°C"
         });
         data.addItem({
            "type":"fahrenheit",
            "label":"°F"
         });
         data.addItem({
            "type":"kelvin",
            "label":"K"
         });
         DropDownList(this.getGroupeByName("tf").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("tf").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"celsius",
            "label":"°C"
         });
         data.addItem({
            "type":"fahrenheit",
            "label":"°F"
         });
         data.addItem({
            "type":"kelvin",
            "label":"K"
         });
         DropDownList(this.getGroupeByName("td").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("td").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({"label":"%"});
         DropDownList(this.getGroupeByName("ui").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("ui").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({"label":"%"});
         DropDownList(this.getGroupeByName("uw").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("uw").getChildByName("drop")).selectedIndex = 0;
         data = new ArrayList();
         data.addItem({
            "type":"hpa",
            "label":"hPa"
         });
         data.addItem({
            "type":"psi",
            "label":"psi"
         });
         DropDownList(this.getGroupeByName("e").getChildByName("drop")).dataProvider = data;
         DropDownList(this.getGroupeByName("e").getChildByName("drop")).selectedIndex = 0;
      }
      
      protected function fillMaps() : void
      {
         this.groupToMapNorm = new Dictionary();
         this.groupToMapNorm[this.pGrpNorm] = "p";
         this.groupToMapNorm[this.tGrpNorm] = "t";
         this.groupToMapNorm[this.ewGrpNorm] = "ew";
         this.groupToMapNorm[this.eiGrpNorm] = "ei";
         this.groupToMapNorm[this.rsGrpNorm] = "rs";
         this.groupToMapNorm[this.hGrpNorm] = "h";
         this.groupToMapNorm[this.tiGrpNorm] = "ti";
         this.groupToMapNorm[this.twGrpNorm] = "tw";
         this.groupToMapNorm[this.qvGrpNorm] = "qv";
         this.groupToMapNorm[this.wvGrpNorm] = "wv";
         this.groupToMapNorm[this.rGrpNorm] = "r";
         this.groupToMapNorm[this.dvGrpNorm] = "dv";
         this.groupToMapNorm[this.tfGrpNorm] = "tf";
         this.groupToMapNorm[this.tdGrpNorm] = "td";
         this.groupToMapNorm[this.uwGrpNorm] = "uw";
         this.groupToMapNorm[this.uiGrpNorm] = "ui";
         this.groupToMapNorm[this.eGrpNorm] = "e";
         this.mapToGroupNorm = new Dictionary();
         this.mapToGroupNorm["p"] = this.pGrpNorm;
         this.mapToGroupNorm["t"] = this.tGrpNorm;
         this.mapToGroupNorm["ew"] = this.ewGrpNorm;
         this.mapToGroupNorm["ei"] = this.eiGrpNorm;
         this.mapToGroupNorm["rs"] = this.rsGrpNorm;
         this.mapToGroupNorm["h"] = this.hGrpNorm;
         this.mapToGroupNorm["ti"] = this.tiGrpNorm;
         this.mapToGroupNorm["tw"] = this.twGrpNorm;
         this.mapToGroupNorm["qv"] = this.qvGrpNorm;
         this.mapToGroupNorm["wv"] = this.wvGrpNorm;
         this.mapToGroupNorm["r"] = this.rGrpNorm;
         this.mapToGroupNorm["dv"] = this.dvGrpNorm;
         this.mapToGroupNorm["tf"] = this.tfGrpNorm;
         this.mapToGroupNorm["td"] = this.tdGrpNorm;
         this.mapToGroupNorm["uw"] = this.uwGrpNorm;
         this.mapToGroupNorm["ui"] = this.uiGrpNorm;
         this.mapToGroupNorm["e"] = this.eGrpNorm;
         this.groupToMapList = new Dictionary();
         this.groupToMapList[this.pGrpList] = "p";
         this.groupToMapList[this.tGrpList] = "t";
         this.groupToMapList[this.ewGrpList] = "ew";
         this.groupToMapList[this.eiGrpList] = "ei";
         this.groupToMapList[this.rsGrpList] = "rs";
         this.groupToMapList[this.hGrpList] = "h";
         this.groupToMapList[this.tiGrpList] = "ti";
         this.groupToMapList[this.twGrpList] = "tw";
         this.groupToMapList[this.qvGrpList] = "qv";
         this.groupToMapList[this.wvGrpList] = "wv";
         this.groupToMapList[this.rGrpList] = "r";
         this.groupToMapList[this.dvGrpList] = "dv";
         this.groupToMapList[this.tfGrpList] = "tf";
         this.groupToMapList[this.tdGrpList] = "td";
         this.groupToMapList[this.uwGrpList] = "uw";
         this.groupToMapList[this.uiGrpList] = "ui";
         this.groupToMapList[this.eGrpList] = "e";
         this.mapToGroupList = new Dictionary();
         this.mapToGroupList["p"] = this.pGrpList;
         this.mapToGroupList["t"] = this.tGrpList;
         this.mapToGroupList["ew"] = this.ewGrpList;
         this.mapToGroupList["ei"] = this.eiGrpList;
         this.mapToGroupList["rs"] = this.rsGrpList;
         this.mapToGroupList["h"] = this.hGrpList;
         this.mapToGroupList["ti"] = this.tiGrpList;
         this.mapToGroupList["tw"] = this.twGrpList;
         this.mapToGroupList["qv"] = this.qvGrpList;
         this.mapToGroupList["wv"] = this.wvGrpList;
         this.mapToGroupList["r"] = this.rGrpList;
         this.mapToGroupList["dv"] = this.dvGrpList;
         this.mapToGroupList["tf"] = this.tfGrpList;
         this.mapToGroupList["td"] = this.tdGrpList;
         this.mapToGroupList["uw"] = this.uwGrpList;
         this.mapToGroupList["ui"] = this.uiGrpList;
         this.mapToGroupList["e"] = this.eGrpList;
      }
      
      protected function fillFormatInfo() : void
      {
         this.formatInfo = new Dictionary();
         this.formatInfo["p"] = {"significantdigits":4};
         this.formatInfo["t"] = {"significantdigits":4};
         this.formatInfo["ew"] = {"significantdigits":4};
         this.formatInfo["ei"] = {"significantdigits":4};
         this.formatInfo["rs"] = {"significantdigits":4};
         this.formatInfo["h"] = {"significantdigits":4};
         this.formatInfo["ti"] = {"significantdigits":4};
         this.formatInfo["tw"] = {"significantdigits":4};
         this.formatInfo["qv"] = {"significantdigits":4};
         this.formatInfo["wv"] = {"significantdigits":4};
         this.formatInfo["r"] = {"significantdigits":4};
         this.formatInfo["dv"] = {"significantdigits":4};
         this.formatInfo["tf"] = {"significantdigits":3};
         this.formatInfo["td"] = {"significantdigits":3};
         this.formatInfo["uw"] = {"significantdigits":4};
         this.formatInfo["ui"] = {"significantdigits":4};
         this.formatInfo["e"] = {"significantdigits":4};
      }
      
      protected function handleError(event:BekaErrorEvent) : void
      {
         this.showError(event.getGrpName(),event.getShortErr(),event.getLongErr(),false);
      }
      
      protected function showError(grpName:String, shortErr:String, longErr:String, merkDev:Boolean) : void
      {
         var grp:Group = this.getGroupeByName(grpName);
         this.markGroup(true,grpName);
         this.cleanForm();
         if(merkDev)
         {
            TextInput(grp.getChildByName("devInput")).text = this.resourceManager.getString("locale",shortErr);
            TextInput(grp.getChildByName("devInput")).toolTip = this.resourceManager.getString("locale",longErr);
         }
         else
         {
            TextInput(grp.getChildByName("input")).text = this.resourceManager.getString("locale",shortErr);
            TextInput(grp.getChildByName("input")).toolTip = this.resourceManager.getString("locale",longErr);
         }
         if(Boolean(longErr == "tor") || Boolean(longErr == "tori"))
         {
            this.markGroup(true,"t");
            TextInput(this.getGroupeByName("t").getChildByName("input")).text = this.resourceManager.getString("locale","or");
            TextInput(this.getGroupeByName("t").getChildByName("input")).toolTip = this.resourceManager.getString("locale",longErr);
         }
         if(longErr == "por")
         {
            this.markGroup(true,"p");
            TextInput(this.getGroupeByName("p").getChildByName("input")).text = this.resourceManager.getString("locale","or");
            TextInput(this.getGroupeByName("p").getChildByName("input")).toolTip = this.resourceManager.getString("locale","por");
         }
      }
      
      protected function markGroup(mark:Boolean, grpName:String) : void
      {
         if(mark)
         {
            if(grpName == this.getGroupName(this.curInput))
            {
               this.isCurErr = true;
            }
            Image(this.getGroupeByName(grpName).getChildByName("bg")).filters = [this.redFilter];
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("chromeColor",10485760);
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("focusColor",9633792);
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("selectionColor",16714768);
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("rollOverColor",16724784);
            TextInput(this.getGroupeByName(grpName).getChildByName("input")).setStyle("chromeColor",10485760);
            TextInput(this.getGroupeByName(grpName).getChildByName("input")).setStyle("focusColor",9633792);
            TextInput(this.getGroupeByName(grpName).getChildByName("devInput")).setStyle("chromeColor",10485760);
            TextInput(this.getGroupeByName(grpName).getChildByName("devInput")).setStyle("focusColor",9633792);
            if(this.getGroupeByName(grpName).getChildByName("icon") != null)
            {
               Image(this.getGroupeByName(grpName).getChildByName("icon")).filters = [this.redFilter];
            }
         }
         else
         {
            if(grpName == this.getGroupName(this.curInput))
            {
               this.isCurErr = false;
            }
            Image(this.getGroupeByName(grpName).getChildByName("bg")).filters = [];
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("chromeColor",7122740);
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("focusColor",4025877);
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("selectionColor",7976779);
            DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).setStyle("rollOverColor",11719824);
            TextInput(this.getGroupeByName(grpName).getChildByName("input")).setStyle("chromeColor",7122740);
            TextInput(this.getGroupeByName(grpName).getChildByName("input")).setStyle("focusColor",4025877);
            TextInput(this.getGroupeByName(grpName).getChildByName("devInput")).setStyle("chromeColor",7122740);
            TextInput(this.getGroupeByName(grpName).getChildByName("devInput")).setStyle("focusColor",4025877);
            if(this.getGroupeByName(grpName).getChildByName("icon") != null)
            {
               Image(this.getGroupeByName(grpName).getChildByName("icon")).filters = [];
            }
         }
      }
      
      protected function checkForInputError(grpName:String) : Boolean
      {
         var value:Number = Number(TextInput(this.getGroupeByName(grpName).getChildByName("input")).text.replace(",","."));
         var dev:Number = Number(TextInput(this.getGroupeByName(grpName).getChildByName("devInput")).text.replace(",","."));
         var tmp:String = DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).dataProvider.getItemAt(0)["label"];
         var curIndex:int = DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).selectedIndex;
         var percent:Boolean = DropDownList(this.getGroupeByName(grpName).getChildByName("drop")).dataProvider.getItemAt(curIndex)["label"] == "%";
         if(Boolean(percent) && (Boolean(value < 0) || Boolean(value > 100)))
         {
            this.showError(grpName,"or","percentError",false);
            return true;
         }
         if(Boolean(!isNaN(value)) && Boolean(!isNaN(dev)))
         {
            this.markGroup(false,grpName);
            return false;
         }
         if(isNaN(value))
         {
            this.showError(grpName,"nan","nanError",false);
         }
         if(isNaN(dev))
         {
            this.showError(grpName,"nan","nanError",true);
         }
         return true;
      }
      
      protected function checkValues(curName:String) : void
      {
         if(curName == "p")
         {
            this.pressureSet = true;
         }
         else if(curName == "t")
         {
            this.temperatureSet = true;
         }
         else if(Boolean(curName != "") && Boolean(curName != null))
         {
            this.lastName = curName;
         }
         if(Boolean(this.pressureSet) && Boolean(this.temperatureSet) || Boolean(this.temperatureSet) && Boolean(this.isCleanPhase))
         {
            this.calcSimpleValues();
            if(this.lastName != "")
            {
               this.calcValues(false);
            }
            else
            {
               this.cleanForm();
            }
         }
      }
      
      protected function cleanForm() : void
      {
         if(!this.isCleanPhase)
         {
            TextInput(this.getGroupeByName("h").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("h").getChildByName("input")).toolTip = "";
            TextInput(this.getGroupeByName("h").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("h").getChildByName("devInput")).toolTip = "";
            if(this.curInput != this.getGroupeByName("ti"))
            {
               TextInput(this.getGroupeByName("ti").getChildByName("input")).text = "";
               TextInput(this.getGroupeByName("ti").getChildByName("input")).toolTip = "";
               TextInput(this.getGroupeByName("ti").getChildByName("devInput")).text = "";
               TextInput(this.getGroupeByName("ti").getChildByName("devInput")).toolTip = "";
            }
            if(this.curInput != this.getGroupeByName("tw"))
            {
               TextInput(this.getGroupeByName("tw").getChildByName("input")).text = "";
               TextInput(this.getGroupeByName("tw").getChildByName("input")).toolTip = "";
               TextInput(this.getGroupeByName("tw").getChildByName("devInput")).text = "";
               TextInput(this.getGroupeByName("tw").getChildByName("devInput")).toolTip = "";
            }
            if(this.curInput != this.getGroupeByName("qv"))
            {
               TextInput(this.getGroupeByName("qv").getChildByName("input")).text = "";
               TextInput(this.getGroupeByName("qv").getChildByName("input")).toolTip = "";
               TextInput(this.getGroupeByName("qv").getChildByName("devInput")).text = "";
               TextInput(this.getGroupeByName("qv").getChildByName("devInput")).toolTip = "";
            }
            if(this.curInput != this.getGroupeByName("wv"))
            {
               TextInput(this.getGroupeByName("wv").getChildByName("input")).text = "";
               TextInput(this.getGroupeByName("wv").getChildByName("input")).toolTip = "";
               TextInput(this.getGroupeByName("wv").getChildByName("devInput")).text = "";
               TextInput(this.getGroupeByName("wv").getChildByName("devInput")).toolTip = "";
            }
            if(this.curInput != this.getGroupeByName("r"))
            {
               TextInput(this.getGroupeByName("r").getChildByName("input")).text = "";
               TextInput(this.getGroupeByName("r").getChildByName("input")).toolTip = "";
               TextInput(this.getGroupeByName("r").getChildByName("devInput")).text = "";
               TextInput(this.getGroupeByName("r").getChildByName("devInput")).toolTip = "";
            }
         }
         if(this.curInput != this.getGroupeByName("dv"))
         {
            TextInput(this.getGroupeByName("dv").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("dv").getChildByName("input")).toolTip = "";
            TextInput(this.getGroupeByName("dv").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("dv").getChildByName("devInput")).toolTip = "";
         }
         if(this.curInput != this.getGroupeByName("tf"))
         {
            TextInput(this.getGroupeByName("tf").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("tf").getChildByName("input")).toolTip = "";
            TextInput(this.getGroupeByName("tf").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("tf").getChildByName("devInput")).toolTip = "";
         }
         if(this.curInput != this.getGroupeByName("td"))
         {
            TextInput(this.getGroupeByName("td").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("td").getChildByName("input")).toolTip = "";
            TextInput(this.getGroupeByName("td").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("td").getChildByName("devInput")).toolTip = "";
         }
         if(this.curInput != this.getGroupeByName("ui"))
         {
            TextInput(this.getGroupeByName("ui").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("ui").getChildByName("input")).toolTip = "";
            TextInput(this.getGroupeByName("ui").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("ui").getChildByName("devInput")).toolTip = "";
         }
         if(this.curInput != this.getGroupeByName("uw"))
         {
            TextInput(this.getGroupeByName("uw").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("uw").getChildByName("input")).toolTip = "";
            TextInput(this.getGroupeByName("uw").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("uw").getChildByName("devInput")).toolTip = "";
         }
         if(this.curInput != this.getGroupeByName("e"))
         {
            TextInput(this.getGroupeByName("e").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("e").getChildByName("input")).toolTip = "";
            TextInput(this.getGroupeByName("e").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("e").getChildByName("devInput")).toolTip = "";
         }
         this.lastName = "";
         var curName:String = this.getGroupName(this.curInput);
         var value:Number = this.values[curName];
         var p:Number = this.values["p"];
         var t:Number = this.values["t"];
         var eiCur:Number = this.values["ei"];
         var ewCur:Number = this.values["ew"];
         var rsCur:Number = this.values["rs"];
         this.values = new Dictionary();
         if(curName != null)
         {
            this.values[curName] = value;
         }
         this.values["p"] = p;
         this.values["t"] = t;
         this.values["ei"] = eiCur;
         this.values["ew"] = ewCur;
         this.values["rs"] = rsCur;
      }
      
      protected function formatInput(value:Number, fractionDigits:int) : String
      {
         var factor:Number = NaN;
         var ret:String = "";
         var scientific:Boolean = Boolean(Math.abs(value) < 0.1) || Boolean(Math.abs(value) >= 1000);
         if(Boolean(!scientific) || Boolean(value == 0))
         {
            if(Boolean(value >= 1) && Boolean(Math.abs(value) < 10))
            {
               fractionDigits = fractionDigits - 1;
            }
            else if(Boolean(Math.abs(value) >= 10) && Boolean(Math.abs(value) < 100))
            {
               fractionDigits = fractionDigits - 2;
            }
            else if(Boolean(Math.abs(value) >= 100) && Boolean(Math.abs(value) < 1000))
            {
               fractionDigits = fractionDigits - 3;
            }
            ret = value.toFixed(fractionDigits);
         }
         else
         {
            factor = Math.pow(10,fractionDigits - Math.ceil(Math.log(Math.abs(value)) / Math.LN10));
            value = Math.round(value * factor) / factor;
            value = value + Math.pow(10,Math.ceil(Math.log(Math.abs(value)) / Math.LN10) - fractionDigits - 1);
            fractionDigits = fractionDigits - 1;
            ret = value.toExponential(fractionDigits);
         }
         if(this.useComma)
         {
            ret = ret.replace(".",",");
         }
         return ret;
      }
      
      protected function writeValueResult(result:Dictionary) : void
      {
         var key:* = null;
         var grp:Group = null;
         var value:Number = NaN;
         var curIndex:int = 0;
         for(key in result)
         {
            grp = this.getGroupeByName(key);
            this.values[key] = result[key];
            this.markGroup(false,key);
            curIndex = DropDownList(grp.getChildByName("drop")).selectedIndex;
            if(key == "h")
            {
               value = Converter.getInstance().converth(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],this.values[key],result["r"]);
            }
            else
            {
               value = Converter.getInstance().convert(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],this.values[key]);
            }
            TextInput(grp.getChildByName("input")).text = this.formatInput(value,this.formatInfo[key]["significantdigits"]);
            if(Boolean(key == "e") && Boolean(this.isCleanPhase))
            {
               TextInput(this.getGroupeByName("p").getChildByName("input")).text = TextInput(this.getGroupeByName("e").getChildByName("input")).text;
            }
            if(isNaN(value))
            {
               TextInput(grp.getChildByName("input")).toolTip = this.resourceManager.getString("locale","nanLong");
            }
            else
            {
               TextInput(grp.getChildByName("input")).toolTip = value.toString();
            }
         }
      }
      
      protected function writeDevResult(result:Dictionary) : void
      {
         var key:* = null;
         var grp:Group = null;
         var curIndex:int = 0;
         var dev:Number = NaN;
         for(key in result)
         {
            grp = this.getGroupeByName(key);
            if(grp != null)
            {
               this.deviations[key] = result[key];
               curIndex = DropDownList(grp.getChildByName("drop")).selectedIndex;
               dev = Converter.getInstance().convertDev(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],this.deviations[key]);
               TextInput(grp.getChildByName("devInput")).text = this.formatInput(dev,this.formatInfo[key]["significantdigits"]);
               if(Boolean(key == "e") && Boolean(this.isCleanPhase))
               {
                  TextInput(this.getGroupeByName("p").getChildByName("devInput")).text = TextInput(this.getGroupeByName("e").getChildByName("devInput")).text;
               }
               if(isNaN(this.values[key]))
               {
                  TextInput(grp.getChildByName("devInput")).toolTip = this.resourceManager.getString("locale","nanLong");
               }
               else
               {
                  TextInput(grp.getChildByName("devInput")).toolTip = dev.toString();
               }
            }
         }
      }
      
      protected function calcSimpleValues() : void
      {
         var resultDev:Dictionary = null;
         var p:Number = this.values["p"];
         var t:Number = this.values["t"];
         var dp:Number = this.deviations["p"];
         var dt:Number = this.deviations["t"];
         var result:Dictionary = EEMath.getInstance().calcValuesFrom_p_t(p,t);
         if(result != null)
         {
            if(result["ew"] != null)
            {
               this.ew = result["ew"];
            }
            if(result["ei"] != null)
            {
               this.ei = result["ei"];
            }
            this.writeValueResult(result);
            resultDev = EEMath.getInstance().calcDeviationFrom_p_t(p,dp,t,dt,this.ei,this.ew);
            if(resultDev != null)
            {
               this.writeDevResult(resultDev);
               this.ewData = resultDev["ewData"];
               this.eiData = resultDev["eiData"];
            }
         }
      }
      
      protected function calcValues(silent:Boolean) : void
      {
         var result:Dictionary = null;
         var resultDev:Dictionary = null;
         if(this.lastName == "")
         {
            return;
         }
         var p:Number = this.values["p"];
         var t:Number = this.values["t"];
         var dp:Number = this.deviations["p"];
         var dt:Number = this.deviations["t"];
         var dv:Number = 0;
         if(!isNaN(this.deviations[this.lastName]))
         {
            dv = this.deviations[this.lastName];
         }
         else
         {
            dv = 0;
         }
         if(this.values[this.lastName] == null)
         {
            return;
         }
         var value:Number = this.values[this.lastName];
         switch(this.lastName)
         {
            case "ti":
               result = EEMath.getInstance().calcValuesFrom_ti(p,t,this.ei,this.ew,value);
               break;
            case "tw":
               result = EEMath.getInstance().calcValuesFrom_tw(p,t,this.ei,this.ew,value);
               break;
            case "qv":
               result = EEMath.getInstance().calcValuesFrom_qv(p,t,this.ei,this.ew,value);
               break;
            case "wv":
               result = EEMath.getInstance().calcValuesFrom_wv(p,t,this.ei,this.ew,value);
               break;
            case "dv":
               result = EEMath.getInstance().calcValuesFrom_dv(p,t,this.ei,this.ew,value);
               break;
            case "r":
               result = EEMath.getInstance().calcValuesFrom_r(p,t,this.ei,this.ew,value);
               break;
            case "tf":
               result = EEMath.getInstance().calcValuesFrom_tf(p,t,this.ei,this.ew,value);
               break;
            case "td":
               result = EEMath.getInstance().calcValuesFrom_td(p,t,this.ei,this.ew,value);
               break;
            case "ui":
               result = EEMath.getInstance().calcValuesFrom_ui(p,t,this.ei,this.ew,value);
               break;
            case "uw":
               result = EEMath.getInstance().calcValuesFrom_uw(p,t,this.ei,this.ew,value);
               break;
            case "e":
               result = EEMath.getInstance().calcValuesFrom_e(p,t,this.ei,this.ew,value);
               break;
            default:
               result = null;
         }
         if(Boolean(result != null) && Boolean(!silent))
         {
            this.writeValueResult(result);
            resultDev = EEMath.getInstance().calcDeviation(this.lastName,p,dp,t,dt,result["e"] != null?Number(result["e"]):Number(value),this.eiData,this.ewData,value,dv);
            if(resultDev != null)
            {
               this.writeDevResult(resultDev);
            }
         }
         else
         {
            this.lastName = "";
         }
         if(Boolean(silent) && Boolean(this.isCurErr) && Boolean(result != null) && Boolean(this.values[this.getGroupName(this.curInput)] != null))
         {
            this.showError(this.getGroupName(this.curInput),"nan","nanError",false);
         }
      }
      
      protected function enableGrp(grp:Group) : void
      {
         TextInput(grp.getChildByName("input")).editable = true;
         TextInput(grp.getChildByName("devInput")).editable = true;
         if(this.isListView)
         {
            Image(grp.getChildByName("icon")).source = this.bgElementMList;
         }
         else
         {
            Image(grp.getChildByName("icon")).source = this.bgElementM;
         }
      }
      
      protected function disableGrp(grp:Group) : void
      {
         TextInput(grp.getChildByName("input")).editable = false;
         TextInput(grp.getChildByName("devInput")).editable = false;
         if(this.isListView)
         {
            Image(grp.getChildByName("icon")).source = this.bgElementPList;
         }
         else
         {
            Image(grp.getChildByName("icon")).source = this.bgElementP;
         }
      }
      
      protected function genData(clip:Boolean) : Array
      {
         var name:String = null;
         var baseGrp:Group = null;
         var grp:Group = null;
         var value:Number = NaN;
         var dev:Number = NaN;
         var curIndex:int = 0;
         var newData:Array = null;
         var data:Array = new Array();
         if(this.isListView)
         {
            baseGrp = this.baseGrpList;
         }
         else
         {
            baseGrp = this.baseGrpNorm;
         }
         var i:int = 0;
         for(var c:int = 0; c < baseGrp.numChildren; c++)
         {
            if(Boolean(baseGrp.getChildAt(c) is Group) && Boolean(Group(baseGrp.getChildAt(c)).getChildByName("head") != null) && Boolean(Group(baseGrp.getChildAt(c)).getChildByName("input").visible == true))
            {
               grp = Group(baseGrp.getChildAt(c));
               value = this.values[this.getGroupName(grp)];
               dev = this.deviations[this.getGroupName(grp)];
               curIndex = DropDownList(grp.getChildByName("drop")).selectedIndex;
               if(this.getGroupName(grp) == "h")
               {
                  value = Converter.getInstance().converth(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],value,this.values["r"]);
               }
               else
               {
                  value = Converter.getInstance().convert(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],value);
               }
               dev = Converter.getInstance().convertDev(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],dev);
               if(grp == this.curInput)
               {
                  name = Label(grp.getChildByName("head")).text;
                  if(name.indexOf("-") != -1)
                  {
                     name = name.replace("-","");
                  }
                  newData = data.splice(0,2);
                  newData.push({
                     "name":name,
                     "value":TextInput(grp.getChildByName("input")).text,
                     "type":(DropDownList(grp.getChildByName("drop")).selectedItem != null?DropDownList(grp.getChildByName("drop")).selectedItem["label"]:"none"),
                     "dev":(!!clip?"±" + this.formatInput(dev,this.formatInfo[this.getGroupName(grp)]["significantdigits"]):this.formatInput(dev,this.formatInfo[this.getGroupName(grp)]["significantdigits"])),
                     "range":this.symbols[i]
                  });
                  data = newData.concat(data);
                  i++;
               }
               else
               {
                  name = Label(grp.getChildByName("head")).text;
                  if(name.indexOf("-") != -1)
                  {
                     name = name.replace("-","");
                  }
                  data.push({
                     "name":name,
                     "value":(Boolean(grp == this.getGroupeByName("p")) || Boolean(grp == this.getGroupeByName("t"))?TextInput(grp.getChildByName("input")).text:this.formatInput(value,this.formatInfo[this.getGroupName(grp)]["significantdigits"])),
                     "type":(DropDownList(grp.getChildByName("drop")).selectedItem != null?DropDownList(grp.getChildByName("drop")).selectedItem["label"]:"none"),
                     "dev":(!!clip?"±" + this.formatInput(dev,this.formatInfo[this.getGroupName(grp)]["significantdigits"]):this.formatInput(dev,this.formatInfo[this.getGroupName(grp)]["significantdigits"])),
                     "range":this.symbols[i]
                  });
                  i++;
               }
            }
         }
         return data;
      }
      
      protected function moveGrp(grp:Group) : void
      {
         var dest:Point = new Point(0,0);
         if(this.isListView)
         {
            dest.x = 155;
            dest.y = 68;
         }
         else
         {
            dest.x = 495;
            dest.y = 103;
         }
         if(this.curInput == grp)
         {
            Tweener.addTween(grp,{
               "x":this.oldPos.x,
               "y":this.oldPos.y,
               "onComplete":this.disableGrp,
               "onCompleteParams":[grp],
               "time":0.5,
               "transition":"easeInOutQuint"
            });
            if(this.isListView)
            {
               Tweener.addTween(this.helpLableList,{
                  "alpha":1,
                  "time":0.8,
                  "delay":0.2
               });
            }
            else
            {
               Tweener.addTween(this.helpLableNorm,{
                  "alpha":1,
                  "time":0.8,
                  "delay":0.2
               });
            }
            if(this.isCurErr)
            {
               this.markGroup(false,this.getGroupName(grp));
               TextInput(grp.getChildByName("input")).text = "";
               TextInput(grp.getChildByName("input")).toolTip = null;
               TextInput(grp.getChildByName("devInput")).text = "";
               TextInput(grp.getChildByName("devInput")).toolTip = null;
               this.isCurErr = false;
            }
            if(isNaN(Number(TextInput(this.getGroupeByName("t").getChildByName("input")).text.replace(",","."))))
            {
               TextInput(this.getGroupeByName("t").getChildByName("input")).text = "23.000";
               TextInput(this.getGroupeByName("t").getChildByName("input")).toolTip = null;
               TextInput(this.getGroupeByName("t").getChildByName("devInput")).text = "0.00";
               TextInput(this.getGroupeByName("t").getChildByName("devInput")).toolTip = null;
               this.values["t"] = 23;
            }
            if(isNaN(Number(TextInput(this.getGroupeByName("p").getChildByName("input")).text.replace(",","."))))
            {
               TextInput(this.getGroupeByName("p").getChildByName("input")).text = "1013.250";
               TextInput(this.getGroupeByName("p").getChildByName("input")).toolTip = null;
               TextInput(this.getGroupeByName("p").getChildByName("devInput")).text = "0.00";
               TextInput(this.getGroupeByName("p").getChildByName("devInput")).toolTip = null;
               this.values["p"] = 1013.25;
            }
            this.checkForInputError("p");
            this.checkForInputError("t");
            this.calcSimpleValues();
            this.curInput = null;
            this.lastName = "";
            this.oldPos = null;
         }
         else
         {
            if(this.curInput != null)
            {
               Tweener.addTween(this.curInput,{
                  "x":this.oldPos.x,
                  "y":this.oldPos.y,
                  "onComplete":this.disableGrp,
                  "onCompleteParams":[this.curInput],
                  "time":0.5,
                  "transition":"easeInOutQuint"
               });
            }
            else if(this.isListView)
            {
               Tweener.addTween(this.helpLableList,{
                  "alpha":0,
                  "time":1
               });
            }
            else
            {
               Tweener.addTween(this.helpLableNorm,{
                  "alpha":0,
                  "time":1
               });
            }
            if(this.isCurErr)
            {
               this.markGroup(false,this.getGroupName(this.curInput));
               TextInput(this.curInput.getChildByName("input")).text = "";
               TextInput(this.curInput.getChildByName("input")).toolTip = null;
               TextInput(this.curInput.getChildByName("devInput")).text = "";
               TextInput(this.curInput.getChildByName("devInput")).toolTip = null;
               this.isCurErr = false;
            }
            this.checkForInputError("p");
            this.checkForInputError("t");
            this.lastName = "";
            this.curInput = grp;
            this.oldPos = new Point(grp.x,grp.y);
            TextInput(grp.getChildByName("input")).toolTip = null;
            TextInput(grp.getChildByName("devInput")).toolTip = null;
            Tweener.addTween(grp,{
               "x":dest.x,
               "y":dest.y,
               "time":0.5,
               "onComplete":this.enableGrp,
               "onCompleteParams":[grp],
               "transition":"easeInOutQuint"
            });
         }
      }
      
      protected function getGroupName(grp:Group) : String
      {
         if(this.isListView)
         {
            return this.groupToMapList[grp];
         }
         return this.groupToMapNorm[grp];
      }
      
      protected function getGroupeByName(name:String) : Group
      {
         if(this.isListView)
         {
            return this.mapToGroupList[name];
         }
         return this.mapToGroupNorm[name];
      }
      
      protected function handleValueInput(grp:Group) : void
      {
         var lastNameOld:String = null;
         var inText:String = TextInput(grp.getChildByName("input")).text;
         if(inText == "")
         {
            return;
         }
         if(this.useComma)
         {
            if(inText.indexOf(".") != -1)
            {
               TextInput(grp.getChildByName("input")).text = inText.replace(".",",");
               TextInput(grp.getChildByName("input")).toolTip = inText.replace(".",",");
            }
            else
            {
               TextInput(grp.getChildByName("input")).toolTip = inText;
            }
         }
         else if(!this.useComma)
         {
            if(inText.indexOf(",") != -1)
            {
               TextInput(grp.getChildByName("input")).text = inText.replace(",",".");
               TextInput(grp.getChildByName("input")).toolTip = inText.replace(",",".");
            }
            else
            {
               TextInput(grp.getChildByName("input")).toolTip = inText;
            }
         }
         var value:Number = Number(inText.replace(",","."));
         var curIndex:int = DropDownList(grp.getChildByName("drop")).selectedIndex;
         if(!isNaN(value))
         {
            value = Converter.getInstance().convert(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],value);
            this.values[this.getGroupName(grp)] = value;
            if(!this.checkForInputError(this.getGroupName(grp)))
            {
               if(Boolean(this.getGroupName(grp) == "e") && Boolean(this.isCleanPhase))
               {
                  TextInput(this.getGroupeByName("p").getChildByName("input")).text = TextInput(this.getGroupeByName("e").getChildByName("input")).text;
               }
               lastNameOld = this.lastName;
               this.lastName = this.getGroupName(this.curInput);
               this.calcValues(true);
               this.lastName = lastNameOld;
               if(Boolean(this.lastName == "") && (Boolean(this.getGroupName(grp) == "p") || Boolean(this.getGroupName(grp) == "t")))
               {
                  this.lastName = this.getGroupName(this.curInput);
               }
               this.checkValues(this.getGroupName(grp));
            }
         }
         else
         {
            this.checkForInputError(this.getGroupName(grp));
            this.checkValues("");
         }
      }
      
      protected function handleDevInput(grp:Group) : void
      {
         var lastNameOld:String = null;
         var inText:String = TextInput(grp.getChildByName("devInput")).text;
         if(inText == "")
         {
            return;
         }
         if(inText.charAt() == "-")
         {
            inText = inText.slice(1);
         }
         if(this.useComma)
         {
            if(inText.indexOf(".") != -1)
            {
               TextInput(grp.getChildByName("devInput")).text = inText.replace(".",",");
               TextInput(grp.getChildByName("devInput")).toolTip = inText.replace(".",",");
            }
            else
            {
               TextInput(grp.getChildByName("devInput")).toolTip = inText;
            }
         }
         else if(!this.useComma)
         {
            if(inText.indexOf(",") != -1)
            {
               TextInput(grp.getChildByName("devInput")).text = inText.replace(",",".");
               TextInput(grp.getChildByName("devInput")).toolTip = inText.replace(",",".");
            }
            else
            {
               TextInput(grp.getChildByName("devInput")).toolTip = inText;
            }
         }
         var value:Number = Number(inText.replace(",","."));
         var curIndex:int = DropDownList(grp.getChildByName("drop")).selectedIndex;
         if(!isNaN(value))
         {
            value = Converter.getInstance().convertDev(DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(curIndex)["type"],DropDownList(grp.getChildByName("drop")).dataProvider.getItemAt(0)["type"],value);
            this.deviations[this.getGroupName(grp)] = value;
            if(!this.checkForInputError(this.getGroupName(grp)))
            {
               if(Boolean(this.getGroupName(grp) == "e") && Boolean(this.isCleanPhase))
               {
                  TextInput(this.getGroupeByName("p").getChildByName("devInput")).text = TextInput(this.getGroupeByName("e").getChildByName("devInput")).text;
               }
               lastNameOld = this.lastName;
               this.lastName = this.getGroupName(this.curInput);
               this.calcValues(true);
               this.lastName = lastNameOld;
               if(Boolean(this.lastName == "") && (Boolean(this.getGroupName(grp) == "p") || Boolean(this.getGroupName(grp) == "t")))
               {
                  this.lastName = this.getGroupName(this.curInput);
               }
               this.checkValues(this.getGroupName(grp));
            }
         }
         else
         {
            this.checkForInputError(this.getGroupName(grp));
            this.checkValues("");
         }
      }
      
      protected function copyUnits() : void
      {
         var key:* = null;
         var normGrp:Group = null;
         var listGrp:Group = null;
         for(key in this.mapToGroupNorm)
         {
            normGrp = this.mapToGroupNorm[key];
            listGrp = this.mapToGroupList[key];
            if(this.isListView)
            {
               DropDownList(listGrp.getChildByName("drop")).selectedIndex = DropDownList(normGrp.getChildByName("drop")).selectedIndex;
            }
            else
            {
               DropDownList(normGrp.getChildByName("drop")).selectedIndex = DropDownList(listGrp.getChildByName("drop")).selectedIndex;
            }
         }
      }
      
      protected function inputHandler(event:MouseEvent) : void
      {
         this.moveGrp(event.target.parent);
      }
      
      protected function createPDF(event:MouseEvent) : void
      {
         if(this.curInput == null)
         {
            Alert.show(resourceManager.getString("locale","inputError"),resourceManager.getString("locale","error"),Alert.OK);
            return;
         }
         PDFCreator.getInstance().genPDF(this.genData(true),new this.headerImg(),new this.footerImg(),this.resourceManager);
      }
      
      protected function clipButton_clickHandler(event:MouseEvent) : void
      {
         if(this.curInput == null)
         {
            Alert.show(resourceManager.getString("locale","inputError"),resourceManager.getString("locale","error"),Alert.OK);
            return;
         }
         var data:Array = this.genData(false);
         var clipBoard:String = "";
         clipBoard = clipBoard + (resourceManager.getString("locale","name") + "\t" + resourceManager.getString("locale","symbol") + "\t" + resourceManager.getString("locale","value") + "\t" + resourceManager.getString("locale","dev") + "\t" + resourceManager.getString("locale","unit") + "\n");
         for(var i:int = 0; i < data.length; i++)
         {
            clipBoard = clipBoard + (data[i]["name"] + "\t" + data[i]["range"] + "\t" + data[i]["value"] + "\t" + data[i]["dev"] + "\t" + data[i]["type"] + "\n");
         }
         System.setClipboard(clipBoard);
      }
      
      protected function changeLocaleHandler() : void
      {
         var key:* = null;
         var grp:Group = null;
         this.resourceManager.localeChain = [this.langSelector.selectedItem["data"]];
         switch(this.langSelector.selectedItem["data"])
         {
            case "de_DE":
               this.useComma = true;
               break;
            case "en_US":
               this.useComma = false;
         }
         for(key in this.mapToGroupNorm)
         {
            grp = this.getGroupeByName(key);
            if(this.useComma)
            {
               TextInput(grp.getChildByName("input")).text = TextInput(grp.getChildByName("input")).text.replace(".",",");
               TextInput(grp.getChildByName("devInput")).text = TextInput(grp.getChildByName("devInput")).text.replace(".",",");
            }
            else
            {
               TextInput(grp.getChildByName("input")).text = TextInput(grp.getChildByName("input")).text.replace(",",".");
               TextInput(grp.getChildByName("devInput")).text = TextInput(grp.getChildByName("devInput")).text.replace(",",".");
            }
         }
      }
      
      protected function changeNormListHandler() : void
      {
         var newGrp:Group = null;
         var value:Number = NaN;
         var p:Number = this.values["p"];
         var t:Number = this.values["t"];
         if(this.curInput != null)
         {
            value = this.values[this.getGroupName(this.curInput)];
         }
         this.values = new Dictionary();
         if(Boolean(this.isCurErr) && Boolean(this.curInput != null))
         {
            this.markGroup(false,this.getGroupName(this.curInput));
            this.isCurErr = true;
         }
         if(this.viewSelector.selectedIndex == 1)
         {
            if(this.curInput != null)
            {
               newGrp = this.mapToGroupList[this.getGroupName(this.curInput)];
               this.curInput.x = this.oldPos.x;
               this.curInput.y = this.oldPos.y;
               this.oldPos.x = newGrp.x;
               this.oldPos.y = newGrp.y;
               newGrp.x = 155;
               newGrp.y = 68;
               this.values[this.getGroupName(this.curInput)] = value;
               TextInput(newGrp.getChildByName("input")).text = TextInput(this.curInput.getChildByName("input")).text;
               TextInput(newGrp.getChildByName("devInput")).text = TextInput(this.curInput.getChildByName("devInput")).text;
               TextInput(newGrp.getChildByName("input")).toolTip = TextInput(this.curInput.getChildByName("input")).toolTip;
               TextInput(newGrp.getChildByName("devInput")).toolTip = TextInput(this.curInput.getChildByName("devInput")).toolTip;
               TextInput(this.curInput.getChildByName("input")).editable = false;
               TextInput(this.curInput.getChildByName("devInput")).editable = false;
               Image(this.curInput.getChildByName("icon")).source = this.bgElementP;
               TextInput(newGrp.getChildByName("input")).editable = true;
               TextInput(newGrp.getChildByName("devInput")).editable = true;
               Image(newGrp.getChildByName("icon")).source = this.bgElementMList;
               this.helpLableList.alpha = 0;
               this.helpLableNorm.alpha = 1;
               this.curInput = newGrp;
               if(Boolean(!isNaN(Number(TextInput(newGrp.getChildByName("input")).text))) && Boolean(TextInput(newGrp.getChildByName("input")).text != ""))
               {
                  this.lastName = this.groupToMapList[this.curInput];
               }
            }
            this.isListView = true;
            this.values["p"] = p;
            this.values["t"] = t;
            TextInput(this.pGrpList.getChildByName("input")).text = TextInput(this.pGrpNorm.getChildByName("input")).text;
            TextInput(this.tGrpList.getChildByName("input")).text = TextInput(this.tGrpNorm.getChildByName("input")).text;
            TextInput(this.pGrpList.getChildByName("devInput")).text = TextInput(this.pGrpNorm.getChildByName("devInput")).text;
            TextInput(this.tGrpList.getChildByName("devInput")).text = TextInput(this.tGrpNorm.getChildByName("devInput")).text;
            TextInput(this.pGrpList.getChildByName("input")).toolTip = TextInput(this.pGrpNorm.getChildByName("input")).toolTip;
            TextInput(this.tGrpList.getChildByName("input")).toolTip = TextInput(this.tGrpNorm.getChildByName("input")).toolTip;
            TextInput(this.pGrpList.getChildByName("devInput")).toolTip = TextInput(this.pGrpNorm.getChildByName("devInput")).toolTip;
            TextInput(this.tGrpList.getChildByName("devInput")).toolTip = TextInput(this.tGrpNorm.getChildByName("devInput")).toolTip;
            this.methodSelector.y = 43;
            this.baseGrpNorm.visible = false;
            this.baseGrpList.visible = true;
         }
         else
         {
            if(this.curInput != null)
            {
               newGrp = this.mapToGroupNorm[this.getGroupName(this.curInput)];
               this.curInput.x = this.oldPos.x;
               this.curInput.y = this.oldPos.y;
               this.oldPos.x = newGrp.x;
               this.oldPos.y = newGrp.y;
               newGrp.x = 495;
               newGrp.y = 103;
               this.values[this.getGroupName(this.curInput)] = value;
               TextInput(newGrp.getChildByName("input")).text = TextInput(this.curInput.getChildByName("input")).text;
               TextInput(newGrp.getChildByName("devInput")).text = TextInput(this.curInput.getChildByName("devInput")).text;
               TextInput(newGrp.getChildByName("input")).toolTip = TextInput(this.curInput.getChildByName("input")).toolTip;
               TextInput(newGrp.getChildByName("devInput")).toolTip = TextInput(this.curInput.getChildByName("devInput")).toolTip;
               TextInput(this.curInput.getChildByName("input")).editable = false;
               TextInput(this.curInput.getChildByName("devInput")).editable = false;
               Image(this.curInput.getChildByName("icon")).source = this.bgElementPList;
               TextInput(newGrp.getChildByName("input")).editable = true;
               TextInput(newGrp.getChildByName("devInput")).editable = true;
               Image(newGrp.getChildByName("icon")).source = this.bgElementM;
               this.helpLableList.alpha = 1;
               this.helpLableNorm.alpha = 0;
               this.curInput = newGrp;
               if(Boolean(!isNaN(Number(TextInput(newGrp.getChildByName("input")).text))) && Boolean(TextInput(newGrp.getChildByName("input")).text != ""))
               {
                  this.lastName = this.groupToMapNorm[this.curInput];
               }
            }
            this.isListView = false;
            this.values["p"] = p;
            this.values["t"] = t;
            TextInput(this.pGrpNorm.getChildByName("input")).text = TextInput(this.pGrpList.getChildByName("input")).text;
            TextInput(this.tGrpNorm.getChildByName("input")).text = TextInput(this.tGrpList.getChildByName("input")).text;
            TextInput(this.pGrpNorm.getChildByName("devInput")).text = TextInput(this.pGrpList.getChildByName("devInput")).text;
            TextInput(this.tGrpNorm.getChildByName("devInput")).text = TextInput(this.tGrpList.getChildByName("devInput")).text;
            TextInput(this.pGrpNorm.getChildByName("input")).toolTip = TextInput(this.pGrpList.getChildByName("input")).toolTip;
            TextInput(this.tGrpNorm.getChildByName("input")).toolTip = TextInput(this.tGrpList.getChildByName("input")).toolTip;
            TextInput(this.pGrpNorm.getChildByName("devInput")).toolTip = TextInput(this.pGrpList.getChildByName("devInput")).toolTip;
            TextInput(this.tGrpNorm.getChildByName("devInput")).toolTip = TextInput(this.tGrpList.getChildByName("devInput")).toolTip;
            this.methodSelector.y = 136;
            this.baseGrpNorm.visible = true;
            this.baseGrpList.visible = false;
         }
         if(Boolean(this.isCurErr) && Boolean(this.curInput != null))
         {
            this.markGroup(true,this.getGroupName(this.curInput));
         }
         if(isNaN(Number(TextInput(this.getGroupeByName("t").getChildByName("input")).text.replace(",","."))))
         {
            this.markGroup(true,"t");
         }
         else
         {
            this.markGroup(false,"t");
         }
         if(isNaN(Number(TextInput(this.getGroupeByName("p").getChildByName("input")).text.replace(",","."))))
         {
            this.markGroup(true,"p");
         }
         else
         {
            this.markGroup(false,"p");
         }
         this.copyUnits();
         this.changeRealPhaseHandler(false);
         this.checkValues(this.lastName);
      }
      
      protected function changeRealPhaseHandler(copyValues:Boolean) : void
      {
         EEMath.getInstance().setCleanPhase(this.methodSelector.selectedIndex == 1);
         if(this.methodSelector.selectedIndex == 1)
         {
            this.isCleanPhase = true;
            if(this.isListView)
            {
               this.ewLableList.text = "e";
               this.eiLableList.text = "e";
               this.eLableList.text = "e";
               this.pGrpList.enabled = false;
            }
            else
            {
               this.ewLableNorm.text = "e";
               this.eiLableNorm.text = "e";
               this.eLableNorm.text = "e";
               this.pGrpNorm.enabled = false;
            }
            if(this.getGroupeByName("r") == this.curInput)
            {
               this.moveGrp(this.getGroupeByName("r"));
            }
            if(this.getGroupeByName("wv") == this.curInput)
            {
               this.moveGrp(this.getGroupeByName("wv"));
            }
            if(this.getGroupeByName("qv") == this.curInput)
            {
               this.moveGrp(this.getGroupeByName("qv"));
            }
            if(this.getGroupeByName("tw") == this.curInput)
            {
               this.moveGrp(this.getGroupeByName("tw"));
            }
            if(this.getGroupeByName("ti") == this.curInput)
            {
               this.moveGrp(this.getGroupeByName("ti"));
            }
            this.getGroupeByName("rs").enabled = false;
            this.getGroupeByName("h").enabled = false;
            this.getGroupeByName("r").enabled = false;
            this.getGroupeByName("wv").enabled = false;
            this.getGroupeByName("qv").enabled = false;
            this.getGroupeByName("tw").enabled = false;
            this.getGroupeByName("ti").enabled = false;
            TextInput(this.getGroupeByName("rs").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("r").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("h").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("wv").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("qv").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("tw").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("ti").getChildByName("input")).text = "";
            TextInput(this.getGroupeByName("rs").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("r").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("h").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("wv").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("qv").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("tw").getChildByName("devInput")).text = "";
            TextInput(this.getGroupeByName("ti").getChildByName("devInput")).text = "";
            this.values["rs"] = NaN;
            this.values["h"] = NaN;
            this.values["r"] = NaN;
            this.values["wv"] = NaN;
            this.values["qv"] = NaN;
            this.values["tw"] = NaN;
            this.values["ti"] = NaN;
            if(copyValues)
            {
               this.pValStore = TextInput(this.getGroupeByName("p").getChildByName("input")).text;
               this.pDevStore = TextInput(this.getGroupeByName("p").getChildByName("devInput")).text;
               TextInput(this.getGroupeByName("p").getChildByName("input")).text = TextInput(this.getGroupeByName("e").getChildByName("input")).text;
               TextInput(this.getGroupeByName("p").getChildByName("devInput")).text = TextInput(this.getGroupeByName("e").getChildByName("devInput")).text;
            }
         }
         else
         {
            this.isCleanPhase = false;
            if(this.isListView)
            {
               this.ewLableList.text = "e  \'";
               this.eiLableList.text = "e \'";
               this.eLableList.text = "e\'";
               this.pGrpList.enabled = true;
            }
            else
            {
               this.ewLableNorm.text = "e  \'";
               this.eiLableNorm.text = "e \'";
               this.eLableNorm.text = "e\'";
               this.pGrpNorm.enabled = true;
            }
            if(copyValues)
            {
               TextInput(this.getGroupeByName("p").getChildByName("input")).text = this.pValStore;
               TextInput(this.getGroupeByName("p").getChildByName("devInput")).text = this.pDevStore;
            }
            this.getGroupeByName("rs").enabled = true;
            this.getGroupeByName("h").enabled = true;
            this.getGroupeByName("r").enabled = true;
            this.getGroupeByName("wv").enabled = true;
            this.getGroupeByName("qv").enabled = true;
            this.getGroupeByName("tw").enabled = true;
            this.getGroupeByName("ti").enabled = true;
         }
         this.checkValues(null);
      }
      
      protected function selectorChange(event:IndexChangeEvent) : void
      {
         var dev:Number = NaN;
         var gName:String = this.getGroupName(Group(event.currentTarget.parent));
         if(Boolean(this.curInput == event.target.parent) && Boolean(this.isCurErr))
         {
            return;
         }
         if(this.values[gName] == null)
         {
            return;
         }
         var value:Number = Converter.getInstance().convert(DropDownList(event.currentTarget.parent.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(event.currentTarget.parent.getChildByName("drop")).dataProvider.getItemAt(event.newIndex)["type"],this.values[gName]);
         TextInput(event.currentTarget.parent.getChildByName("input")).text = this.formatInput(value,this.formatInfo[gName]["significantdigits"]);
         if(isNaN(value))
         {
            TextInput(event.currentTarget.parent.getChildByName("input")).toolTip = this.resourceManager.getString("locale","nanLong");
         }
         else
         {
            TextInput(event.currentTarget.parent.getChildByName("input")).toolTip = value.toString();
         }
         if(Boolean(this.deviations[gName] != null) && Boolean(this.deviations[gName] != 0))
         {
            dev = Converter.getInstance().convertDev(DropDownList(event.currentTarget.parent.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(event.currentTarget.parent.getChildByName("drop")).dataProvider.getItemAt(event.newIndex)["type"],this.deviations[gName]);
            TextInput(event.currentTarget.parent.getChildByName("devInput")).text = this.formatInput(dev,this.formatInfo[gName]["significantdigits"]);
            if(isNaN(value))
            {
               TextInput(event.currentTarget.parent.getChildByName("devInput")).toolTip = this.resourceManager.getString("locale","nanLong");
            }
            else
            {
               TextInput(event.currentTarget.parent.getChildByName("devInput")).toolTip = dev.toString();
            }
         }
      }
      
      protected function selectorHChange(event:IndexChangeEvent) : void
      {
         var dev:Number = NaN;
         var gName:String = this.getGroupName(Group(event.currentTarget.parent));
         if(this.values[gName] == null)
         {
            return;
         }
         var rValue:Number = this.values["r"];
         if(isNaN(rValue))
         {
            rValue = 0;
         }
         var hValue:Number = this.values[gName];
         if(isNaN(hValue))
         {
            hValue = 0;
         }
         var value:Number = Converter.getInstance().converth(DropDownList(this.hGrpNorm.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(this.hGrpNorm.getChildByName("drop")).dataProvider.getItemAt(event.newIndex)["type"],hValue,rValue);
         TextInput(event.currentTarget.parent.getChildByName("input")).text = this.formatInput(value,this.formatInfo[gName]["significantdigits"]);
         if(isNaN(value))
         {
            TextInput(this.hGrpNorm.getChildByName("input")).toolTip = this.resourceManager.getString("locale","nanLong");
         }
         else
         {
            TextInput(this.hGrpNorm.getChildByName("input")).toolTip = value.toString();
         }
         if(Boolean(this.deviations[gName] != null) && Boolean(this.deviations[gName] != 0))
         {
            dev = Converter.getInstance().convertDev(DropDownList(event.currentTarget.parent.getChildByName("drop")).dataProvider.getItemAt(0)["type"],DropDownList(event.currentTarget.parent.getChildByName("drop")).dataProvider.getItemAt(event.newIndex)["type"],this.deviations[gName]);
            TextInput(event.currentTarget.parent.getChildByName("devInput")).text = this.formatInput(dev,this.formatInfo[gName]["significantdigits"]);
            if(isNaN(value))
            {
               TextInput(event.currentTarget.parent.getChildByName("devInput")).toolTip = this.resourceManager.getString("locale","nanLong");
            }
            else
            {
               TextInput(event.currentTarget.parent.getChildByName("devInput")).toolTip = dev.toString();
            }
         }
      }
      
      protected function inputChanged(event:FocusEvent, isInput:Boolean) : void
      {
         if(Boolean(isInput) && Boolean(event.currentTarget.editable == true))
         {
            this.handleValueInput(event.currentTarget.parent);
         }
      }
      
      protected function inputKeyUp(event:KeyboardEvent, isInput:Boolean) : void
      {
         if(Boolean(event.keyCode == 13) && Boolean(isInput) && Boolean(event.currentTarget.editable == true))
         {
            this.handleValueInput(event.currentTarget.parent);
         }
      }
      
      protected function inputChangedDev(event:FocusEvent) : void
      {
         if(event.currentTarget.editable == true)
         {
            this.handleDevInput(event.currentTarget.parent);
         }
      }
      
      protected function inputKeyUpDev(event:KeyboardEvent) : void
      {
         if(Boolean(event.keyCode == 13) && Boolean(event.currentTarget.editable == true))
         {
            this.handleDevInput(event.currentTarget.parent);
         }
      }
      
      protected function button1_clickHandler(event:MouseEvent) : void
      {
         if(this.langSelector.selectedIndex == 0)
         {
            navigateToURL(new URLRequest("http://www.humidity-calculator-online.com/help/"),"_blank");
         }
         else
         {
            navigateToURL(new URLRequest("http://www.feuchterechner.de/hilfe/"),"_blank");
         }
      }
      
      private function _EEHumidityCalculator_Array1_c() : Array
      {
         var _loc1_:Array = [this._EEHumidityCalculator_Image1_i(),this._EEHumidityCalculator_Group1_i(),this._EEHumidityCalculator_Group19_i(),this._EEHumidityCalculator_DropDownList35_i(),this._EEHumidityCalculator_DropDownList36_i(),this._EEHumidityCalculator_Button1_i(),this._EEHumidityCalculator_Button2_i(),this._EEHumidityCalculator_Button3_i(),this._EEHumidityCalculator_DropDownList37_i(),this._EEHumidityCalculator_Label131_c(),this._EEHumidityCalculator_Label132_c()];
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image1_i() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 800;
         _loc1_.height = 800;
         _loc1_.autoLoad = true;
         _loc1_.id = "background";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.background = _loc1_;
         BindingManager.executeBindings(this,"background",this.background);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group1_i() : Group
      {
         var _loc1_:Group = new Group();
         _loc1_.visible = true;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image2_i(),this._EEHumidityCalculator_Label1_i(),this._EEHumidityCalculator_Image3_i(),this._EEHumidityCalculator_Label2_i(),this._EEHumidityCalculator_Group2_i(),this._EEHumidityCalculator_Group3_i(),this._EEHumidityCalculator_HRule1_c(),this._EEHumidityCalculator_Group4_i(),this._EEHumidityCalculator_Group5_i(),this._EEHumidityCalculator_Group6_i(),this._EEHumidityCalculator_Group7_i(),this._EEHumidityCalculator_Group8_i(),this._EEHumidityCalculator_Group9_i(),this._EEHumidityCalculator_Group10_i(),this._EEHumidityCalculator_Group11_i(),this._EEHumidityCalculator_Group12_i(),this._EEHumidityCalculator_Group13_i(),this._EEHumidityCalculator_Group14_i(),this._EEHumidityCalculator_Group15_i(),this._EEHumidityCalculator_Group16_i(),this._EEHumidityCalculator_Group17_i(),this._EEHumidityCalculator_Group18_i()];
         _loc1_.id = "baseGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.baseGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"baseGrpNorm",this.baseGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image2_i() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.x = 160;
         _loc1_.y = 10;
         _loc1_.width = 480;
         _loc1_.autoLoad = true;
         _loc1_.id = "logoNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.logoNorm = _loc1_;
         BindingManager.executeBindings(this,"logoNorm",this.logoNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label1_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 159;
         _loc1_.y = 66;
         _loc1_.width = 481;
         _loc1_.height = 29;
         _loc1_.setStyle("fontSize",30);
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("color",5277985);
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.setStyle("fontStyle","italic");
         _loc1_.id = "_EEHumidityCalculator_Label1";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label1 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label1",this._EEHumidityCalculator_Label1);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image3_i() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.x = 490;
         _loc1_.y = 103;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         _loc1_.id = "inputBg";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.inputBg = _loc1_;
         BindingManager.executeBindings(this,"inputBg",this.inputBg);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label2_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 495;
         _loc1_.y = 103;
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",16);
         _loc1_.setStyle("color",10526880);
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "helpLableNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.helpLableNorm = _loc1_;
         BindingManager.executeBindings(this,"helpLableNorm",this.helpLableNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group2_i() : Group
      {
         var _loc1_:Group = new Group();
         _loc1_.name = "p";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 155;
         _loc1_.y = 103;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image4_c(),this._EEHumidityCalculator_Label3_i(),this._EEHumidityCalculator_DropDownList1_c(),this._EEHumidityCalculator_TextInput1_c(),this._EEHumidityCalculator_Label4_c(),this._EEHumidityCalculator_TextInput2_c(),this._EEHumidityCalculator_Label5_c()];
         _loc1_.id = "pGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.pGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"pGrpNorm",this.pGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image4_c() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label3_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "head";
         _loc1_.x = 0;
         _loc1_.y = 5;
         _loc1_.width = 150;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label3";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label3 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label3",this._EEHumidityCalculator_Label3);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList1_c() : DropDownList
      {
         var _loc1_:DropDownList = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList1_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList1_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput1_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "input";
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.text = "1013.250";
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput1_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput1_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput1_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput1_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label4_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput2_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.enabled = true;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.text = "0.00";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput2_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput2_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput2_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput2_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label5_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.text = "p";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group3_i() : Group
      {
         var _loc1_:Group = new Group();
         _loc1_.name = "t";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 325;
         _loc1_.y = 103;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image5_c(),this._EEHumidityCalculator_Label6_i(),this._EEHumidityCalculator_DropDownList2_c(),this._EEHumidityCalculator_TextInput3_c(),this._EEHumidityCalculator_Label7_c(),this._EEHumidityCalculator_TextInput4_c(),this._EEHumidityCalculator_Label8_c()];
         _loc1_.id = "tGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"tGrpNorm",this.tGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image5_c() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label6_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "head";
         _loc1_.x = 0;
         _loc1_.y = 5;
         _loc1_.width = 150;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label6";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label6 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label6",this._EEHumidityCalculator_Label6);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList2_c() : DropDownList
      {
         var _loc1_:DropDownList = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList2_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList2_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput3_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "input";
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.text = "23.000";
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput3_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput3_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput3_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput3_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label7_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput4_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.enabled = true;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.text = "0.00";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput4_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput4_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput4_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput4_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label8_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_HRule1_c() : HRule
      {
         var _loc1_:HRule = new HRule();
         _loc1_.x = 10;
         _loc1_.y = 205;
         _loc1_.width = 780;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group4_i() : Group
      {
         var _loc1_:Group = new Group();
         _loc1_.name = "ei";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 75;
         _loc1_.y = 265;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image6_c(),this._EEHumidityCalculator_Label9_i(),this._EEHumidityCalculator_DropDownList3_c(),this._EEHumidityCalculator_TextInput5_c(),this._EEHumidityCalculator_Label10_c(),this._EEHumidityCalculator_TextInput6_c(),this._EEHumidityCalculator_Label11_i(),this._EEHumidityCalculator_Label12_c()];
         _loc1_.id = "eiGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eiGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"eiGrpNorm",this.eiGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image6_c() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label9_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "head";
         _loc1_.x = 0;
         _loc1_.y = 5;
         _loc1_.width = 150;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label9";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label9 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label9",this._EEHumidityCalculator_Label9);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList3_c() : DropDownList
      {
         var _loc1_:DropDownList = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList3_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList3_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput5_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput5_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput5_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput5_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput5_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label10_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput6_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput6_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput6_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput6_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput6_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label11_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 15;
         _loc1_.y = 38;
         _loc1_.text = "e \'";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","top");
         _loc1_.setStyle("textAlign","left");
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "eiLableNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eiLableNorm = _loc1_;
         BindingManager.executeBindings(this,"eiLableNorm",this.eiLableNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label12_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 14;
         _loc1_.y = 34;
         _loc1_.text = "i";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group5_i() : Group
      {
         var _loc1_:Group = new Group();
         _loc1_.name = "ew";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 240;
         _loc1_.y = 220;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image7_c(),this._EEHumidityCalculator_Label13_i(),this._EEHumidityCalculator_DropDownList4_c(),this._EEHumidityCalculator_TextInput7_c(),this._EEHumidityCalculator_Label14_c(),this._EEHumidityCalculator_TextInput8_c(),this._EEHumidityCalculator_Label15_i(),this._EEHumidityCalculator_Label16_c()];
         _loc1_.id = "ewGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.ewGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"ewGrpNorm",this.ewGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image7_c() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label13_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "head";
         _loc1_.x = 0;
         _loc1_.y = 5;
         _loc1_.width = 150;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label13";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label13 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label13",this._EEHumidityCalculator_Label13);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList4_c() : DropDownList
      {
         var _loc1_:DropDownList = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList4_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList4_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput7_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput7_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput7_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput7_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput7_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label14_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput8_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput8_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput8_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput8_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput8_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label15_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 12;
         _loc1_.y = 38;
         _loc1_.text = "e  \'";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","top");
         _loc1_.setStyle("textAlign","left");
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "ewLableNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.ewLableNorm = _loc1_;
         BindingManager.executeBindings(this,"ewLableNorm",this.ewLableNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label16_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 13;
         _loc1_.y = 35;
         _loc1_.text = "w";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group6_i() : Group
      {
         var _loc1_:Group = new Group();
         _loc1_.name = "rs";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 410;
         _loc1_.y = 220;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image8_c(),this._EEHumidityCalculator_Label17_i(),this._EEHumidityCalculator_DropDownList5_c(),this._EEHumidityCalculator_TextInput9_c(),this._EEHumidityCalculator_Label18_c(),this._EEHumidityCalculator_TextInput10_c(),this._EEHumidityCalculator_Label19_c(),this._EEHumidityCalculator_Label20_c()];
         _loc1_.id = "rsGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.rsGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"rsGrpNorm",this.rsGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image8_c() : Image
      {
         var _loc1_:Image = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label17_i() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "head";
         _loc1_.x = 0;
         _loc1_.y = 5;
         _loc1_.width = 150;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label17";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label17 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label17",this._EEHumidityCalculator_Label17);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList5_c() : DropDownList
      {
         var _loc1_:DropDownList = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList5_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList5_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput9_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput9_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput9_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput9_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput9_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label18_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput10_c() : TextInput
      {
         var _loc1_:TextInput = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput10_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput10_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput10_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput10_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label19_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "r";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label20_c() : Label
      {
         var _loc1_:Label = new Label();
         _loc1_.x = 15;
         _loc1_.y = 34;
         _loc1_.text = "s";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group7_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "h";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 575;
         _loc1_.y = 265;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image9_c(),this._EEHumidityCalculator_Label21_i(),this._EEHumidityCalculator_DropDownList6_c(),this._EEHumidityCalculator_TextInput11_c(),this._EEHumidityCalculator_Label22_c(),this._EEHumidityCalculator_TextInput12_c(),this._EEHumidityCalculator_Label23_c()];
         _loc1_.id = "hGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.hGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"hGrpNorm",this.hGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image9_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label21_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 0;
         _loc1_.y = 5;
         _loc1_.width = 150;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label21";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label21 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label21",this._EEHumidityCalculator_Label21);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList6_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList6_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList6_change(event:IndexChangeEvent) : void
      {
         this.selectorHChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput11_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput11_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput11_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput11_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput11_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label22_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput12_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput12_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput12_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput12_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput12_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label23_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "h";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group8_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "ti";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 600;
         _loc1_.y = 363;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image10_c(),this._EEHumidityCalculator_Image11_c(),this._EEHumidityCalculator_Label24_i(),this._EEHumidityCalculator_DropDownList7_c(),this._EEHumidityCalculator_TextInput13_c(),this._EEHumidityCalculator_Label25_c(),this._EEHumidityCalculator_TextInput14_c(),this._EEHumidityCalculator_Label26_c(),this._EEHumidityCalculator_Label27_c()];
         _loc1_.id = "tiGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tiGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"tiGrpNorm",this.tiGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image10_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image11_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image11_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image11_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label24_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label24";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label24 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label24",this._EEHumidityCalculator_Label24);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList7_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList7_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList7_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput13_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput13_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput13_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput13_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput13_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label25_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput14_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput14_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput14_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput14_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput14_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label26_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label27_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 13;
         _loc1_.y = 34;
         _loc1_.text = "i";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group9_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "tw";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 630;
         _loc1_.y = 460;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image12_c(),this._EEHumidityCalculator_Image13_c(),this._EEHumidityCalculator_Label28_i(),this._EEHumidityCalculator_DropDownList8_c(),this._EEHumidityCalculator_TextInput15_c(),this._EEHumidityCalculator_Label29_c(),this._EEHumidityCalculator_TextInput16_c(),this._EEHumidityCalculator_Label30_c(),this._EEHumidityCalculator_Label31_c()];
         _loc1_.id = "twGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.twGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"twGrpNorm",this.twGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image12_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image13_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image13_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image13_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label28_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label28";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label28 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label28",this._EEHumidityCalculator_Label28);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList8_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList8_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList8_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput15_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput15_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput15_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput15_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput15_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label29_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput16_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput16_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput16_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput16_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput16_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label30_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 30;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label31_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 16;
         _loc1_.y = 32;
         _loc1_.text = "w";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group10_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "qv";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 600;
         _loc1_.y = 557;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image14_c(),this._EEHumidityCalculator_Image15_c(),this._EEHumidityCalculator_Label32_i(),this._EEHumidityCalculator_DropDownList9_c(),this._EEHumidityCalculator_TextInput17_c(),this._EEHumidityCalculator_Label33_c(),this._EEHumidityCalculator_TextInput18_c(),this._EEHumidityCalculator_Label34_c(),this._EEHumidityCalculator_Label35_c()];
         _loc1_.id = "qvGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.qvGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"qvGrpNorm",this.qvGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image14_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image15_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image15_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image15_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label32_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label32";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label32 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label32",this._EEHumidityCalculator_Label32);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList9_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList9_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList9_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput17_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput17_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput17_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput17_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput17_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label33_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput18_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput18_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput18_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput18_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput18_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label34_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "q";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label35_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 16;
         _loc1_.y = 35;
         _loc1_.text = "v";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group11_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "wv";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 575;
         _loc1_.y = 655;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image16_c(),this._EEHumidityCalculator_Image17_c(),this._EEHumidityCalculator_Label36_i(),this._EEHumidityCalculator_DropDownList10_c(),this._EEHumidityCalculator_TextInput19_c(),this._EEHumidityCalculator_Label37_c(),this._EEHumidityCalculator_TextInput20_c(),this._EEHumidityCalculator_Label38_c(),this._EEHumidityCalculator_Label39_c()];
         _loc1_.id = "wvGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.wvGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"wvGrpNorm",this.wvGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image16_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image17_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image17_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image17_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label36_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label36";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label36 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label36",this._EEHumidityCalculator_Label36);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList10_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList10_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList10_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput19_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput19_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput19_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput19_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput19_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label37_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput20_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput20_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput20_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput20_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput20_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label38_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "w";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label39_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 17;
         _loc1_.y = 34;
         _loc1_.text = "v";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group12_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "r";
         _loc1_.x = 410;
         _loc1_.y = 698;
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image18_c(),this._EEHumidityCalculator_Image19_c(),this._EEHumidityCalculator_Label40_i(),this._EEHumidityCalculator_DropDownList11_c(),this._EEHumidityCalculator_TextInput21_c(),this._EEHumidityCalculator_Label41_c(),this._EEHumidityCalculator_TextInput22_c(),this._EEHumidityCalculator_Label42_c()];
         _loc1_.id = "rGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.rGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"rGrpNorm",this.rGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image18_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image19_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image19_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image19_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label40_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label40";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label40 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label40",this._EEHumidityCalculator_Label40);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList11_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList11_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList11_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput21_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput21_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput21_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput21_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput21_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label41_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput22_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput22_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput22_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput22_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput22_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label42_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "r";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group13_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "dv";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 240;
         _loc1_.y = 698;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image20_c(),this._EEHumidityCalculator_Image21_c(),this._EEHumidityCalculator_Label43_i(),this._EEHumidityCalculator_DropDownList12_c(),this._EEHumidityCalculator_TextInput23_c(),this._EEHumidityCalculator_Label44_c(),this._EEHumidityCalculator_TextInput24_c(),this._EEHumidityCalculator_Label45_c(),this._EEHumidityCalculator_Label46_c()];
         _loc1_.id = "dvGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.dvGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"dvGrpNorm",this.dvGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image20_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image21_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image21_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image21_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label43_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label43";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label43 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label43",this._EEHumidityCalculator_Label43);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList12_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList12_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList12_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput23_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput23_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput23_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput23_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput23_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label44_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput24_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput24_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput24_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput24_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput24_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label45_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "d";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label46_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 16;
         _loc1_.y = 34;
         _loc1_.text = "v";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group14_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "tf";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 75;
         _loc1_.y = 655;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image22_c(),this._EEHumidityCalculator_Image23_c(),this._EEHumidityCalculator_Label47_i(),this._EEHumidityCalculator_DropDownList13_c(),this._EEHumidityCalculator_TextInput25_c(),this._EEHumidityCalculator_Label48_c(),this._EEHumidityCalculator_TextInput26_c(),this._EEHumidityCalculator_Label49_c(),this._EEHumidityCalculator_Label50_c()];
         _loc1_.id = "tfGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tfGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"tfGrpNorm",this.tfGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image22_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image23_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image23_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image23_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label47_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label47";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label47 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label47",this._EEHumidityCalculator_Label47);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList13_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList13_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList13_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput25_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput25_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput25_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput25_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput25_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label48_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput26_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput26_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput26_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput26_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput26_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label49_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label50_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 14;
         _loc1_.y = 34;
         _loc1_.text = "f";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group15_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "td";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 50;
         _loc1_.y = 557;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image24_c(),this._EEHumidityCalculator_Image25_c(),this._EEHumidityCalculator_Label51_i(),this._EEHumidityCalculator_DropDownList14_c(),this._EEHumidityCalculator_TextInput27_c(),this._EEHumidityCalculator_Label52_c(),this._EEHumidityCalculator_TextInput28_c(),this._EEHumidityCalculator_Label53_c(),this._EEHumidityCalculator_Label54_c()];
         _loc1_.id = "tdGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tdGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"tdGrpNorm",this.tdGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image24_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image25_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image25_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image25_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label51_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label51";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label51 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label51",this._EEHumidityCalculator_Label51);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList14_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList14_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList14_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput27_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput27_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput27_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput27_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput27_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label52_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput28_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput28_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput28_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput28_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput28_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label53_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label54_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 15;
         _loc1_.y = 34;
         _loc1_.text = "d";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group16_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "ui";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 20;
         _loc1_.y = 460;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image26_c(),this._EEHumidityCalculator_Image27_c(),this._EEHumidityCalculator_Label55_i(),this._EEHumidityCalculator_DropDownList15_c(),this._EEHumidityCalculator_TextInput29_c(),this._EEHumidityCalculator_Label56_c(),this._EEHumidityCalculator_TextInput30_c(),this._EEHumidityCalculator_Label57_c(),this._EEHumidityCalculator_Label58_c()];
         _loc1_.id = "uiGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.uiGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"uiGrpNorm",this.uiGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image26_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image27_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image27_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image27_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label55_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label55";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label55 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label55",this._EEHumidityCalculator_Label55);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList15_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList15_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList15_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput29_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput29_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput29_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput29_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput29_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label56_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput30_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput30_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput30_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput30_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput30_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label57_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "U";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label58_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 15;
         _loc1_.y = 34;
         _loc1_.text = "i";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group17_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "uw";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 50;
         _loc1_.y = 363;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image28_c(),this._EEHumidityCalculator_Image29_c(),this._EEHumidityCalculator_Label59_i(),this._EEHumidityCalculator_DropDownList16_c(),this._EEHumidityCalculator_TextInput31_c(),this._EEHumidityCalculator_Label60_c(),this._EEHumidityCalculator_TextInput32_c(),this._EEHumidityCalculator_Label61_c(),this._EEHumidityCalculator_Label62_c()];
         _loc1_.id = "uwGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.uwGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"uwGrpNorm",this.uwGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image28_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image29_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image29_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image29_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label59_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label59";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label59 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label59",this._EEHumidityCalculator_Label59);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList16_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList16_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList16_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput31_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput31_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput31_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput31_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput31_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label60_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput32_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput32_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput32_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput32_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput32_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label61_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "U";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label62_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 17;
         _loc1_.y = 34;
         _loc1_.text = "w";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group18_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "e";
         _loc1_.width = 150;
         _loc1_.height = 90;
         _loc1_.x = 325;
         _loc1_.y = 460;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image30_c(),this._EEHumidityCalculator_Image31_c(),this._EEHumidityCalculator_Label63_i(),this._EEHumidityCalculator_DropDownList17_c(),this._EEHumidityCalculator_TextInput33_c(),this._EEHumidityCalculator_Label64_c(),this._EEHumidityCalculator_TextInput34_c(),this._EEHumidityCalculator_Label65_i()];
         _loc1_.id = "eGrpNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eGrpNorm = _loc1_;
         BindingManager.executeBindings(this,"eGrpNorm",this.eGrpNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image30_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 160;
         _loc1_.height = 90;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image31_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = -5;
         _loc1_.y = 0;
         _loc1_.width = 20;
         _loc1_.height = 20;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image31_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image31_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label63_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 20;
         _loc1_.y = 5;
         _loc1_.width = 130;
         _loc1_.height = 25;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label63";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label63 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label63",this._EEHumidityCalculator_Label63);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList17_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 40;
         _loc1_.y = 32;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList17_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList17_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_TextInput33_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 5;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput33_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput33_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput33_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput33_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label64_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 70;
         _loc1_.y = 62;
         _loc1_.width = 10;
         _loc1_.height = 23;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput34_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 80;
         _loc1_.y = 62;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput34_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput34_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput34_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput34_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label65_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 5;
         _loc1_.y = 32;
         _loc1_.text = "e\'";
         _loc1_.width = 30;
         _loc1_.height = 23;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "eLableNorm";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eLableNorm = _loc1_;
         BindingManager.executeBindings(this,"eLableNorm",this.eLableNorm);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group19_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.visible = false;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image32_i(),this._EEHumidityCalculator_Label66_i(),this._EEHumidityCalculator_Image33_i(),this._EEHumidityCalculator_Label67_i(),this._EEHumidityCalculator_Group20_i(),this._EEHumidityCalculator_Group21_i(),this._EEHumidityCalculator_HRule2_c(),this._EEHumidityCalculator_HRule3_c(),this._EEHumidityCalculator_HRule4_c(),this._EEHumidityCalculator_Group22_i(),this._EEHumidityCalculator_Group23_i(),this._EEHumidityCalculator_Group24_i(),this._EEHumidityCalculator_Group25_i(),this._EEHumidityCalculator_Group26_i(),this._EEHumidityCalculator_Group27_i(),this._EEHumidityCalculator_Group28_i(),this._EEHumidityCalculator_Group29_i(),this._EEHumidityCalculator_Group30_i(),this._EEHumidityCalculator_Group31_i(),this._EEHumidityCalculator_Group32_i(),this._EEHumidityCalculator_Group33_i(),this._EEHumidityCalculator_Group34_i(),this._EEHumidityCalculator_Group35_i(),this._EEHumidityCalculator_Group36_i()];
         _loc1_.id = "baseGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.baseGrpList = _loc1_;
         BindingManager.executeBindings(this,"baseGrpList",this.baseGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image32_i() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.x = 20;
         _loc1_.y = 550;
         _loc1_.width = 480;
         _loc1_.autoLoad = true;
         _loc1_.rotation = -90;
         _loc1_.id = "logoList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.logoList = _loc1_;
         BindingManager.executeBindings(this,"logoList",this.logoList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label66_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 76;
         _loc1_.y = 550;
         _loc1_.rotation = -90;
         _loc1_.width = 481;
         _loc1_.height = 29;
         _loc1_.setStyle("fontSize",30);
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("color",5277985);
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.setStyle("fontStyle","italic");
         _loc1_.id = "_EEHumidityCalculator_Label66";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label66 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label66",this._EEHumidityCalculator_Label66);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image33_i() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.x = 155;
         _loc1_.y = 68;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.id = "inputBgList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.inputBgList = _loc1_;
         BindingManager.executeBindings(this,"inputBgList",this.inputBgList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label67_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 155;
         _loc1_.y = 70;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",16);
         _loc1_.setStyle("color",10526880);
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "helpLableList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.helpLableList = _loc1_;
         BindingManager.executeBindings(this,"helpLableList",this.helpLableList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group20_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "p";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 10;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image34_c(),this._EEHumidityCalculator_Label68_i(),this._EEHumidityCalculator_TextInput35_c(),this._EEHumidityCalculator_Label69_c(),this._EEHumidityCalculator_TextInput36_c(),this._EEHumidityCalculator_Label70_c(),this._EEHumidityCalculator_DropDownList18_c()];
         _loc1_.id = "pGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.pGrpList = _loc1_;
         BindingManager.executeBindings(this,"pGrpList",this.pGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image34_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label68_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label68";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label68 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label68",this._EEHumidityCalculator_Label68);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput35_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.text = "1013.250";
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput35_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput35_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput35_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput35_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label69_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput36_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.enabled = true;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.text = "0.00";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput36_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput36_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput36_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput36_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label70_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.text = "p";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList18_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList18_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList18_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group21_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "t";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 39;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image35_c(),this._EEHumidityCalculator_Label71_i(),this._EEHumidityCalculator_TextInput37_c(),this._EEHumidityCalculator_Label72_c(),this._EEHumidityCalculator_TextInput38_c(),this._EEHumidityCalculator_Label73_c(),this._EEHumidityCalculator_DropDownList19_c()];
         _loc1_.id = "tGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tGrpList = _loc1_;
         BindingManager.executeBindings(this,"tGrpList",this.tGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image35_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label71_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label71";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label71 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label71",this._EEHumidityCalculator_Label71);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput37_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.text = "23.000";
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput37_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput37_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput37_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput37_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label72_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput38_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.enabled = true;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.text = "0.00";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput38_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput38_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput38_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput38_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label73_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList19_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList19_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList19_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_HRule2_c() : HRule
      {
         var _loc1_:HRule = null;
         _loc1_ = new HRule();
         _loc1_.x = 130;
         _loc1_.y = 105;
         _loc1_.width = 540;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_HRule3_c() : HRule
      {
         var _loc1_:HRule = null;
         _loc1_ = new HRule();
         _loc1_.x = 130;
         _loc1_.y = 106;
         _loc1_.width = 540;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_HRule4_c() : HRule
      {
         var _loc1_:HRule = null;
         _loc1_ = new HRule();
         _loc1_.x = 130;
         _loc1_.y = 107;
         _loc1_.width = 540;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Group22_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "ti";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 376;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image36_c(),this._EEHumidityCalculator_Image37_c(),this._EEHumidityCalculator_Label74_i(),this._EEHumidityCalculator_TextInput39_c(),this._EEHumidityCalculator_Label75_c(),this._EEHumidityCalculator_TextInput40_c(),this._EEHumidityCalculator_Label76_c(),this._EEHumidityCalculator_Label77_c(),this._EEHumidityCalculator_DropDownList20_c()];
         _loc1_.id = "tiGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tiGrpList = _loc1_;
         BindingManager.executeBindings(this,"tiGrpList",this.tiGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image36_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image37_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image37_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image37_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label74_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label74";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label74 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label74",this._EEHumidityCalculator_Label74);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput39_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput39_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput39_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput39_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput39_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label75_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput40_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput40_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput40_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput40_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput40_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label76_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label77_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 199;
         _loc1_.y = 9;
         _loc1_.text = "i";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList20_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList20_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList20_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group23_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "tw";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 347;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image38_c(),this._EEHumidityCalculator_Image39_c(),this._EEHumidityCalculator_Label78_i(),this._EEHumidityCalculator_TextInput41_c(),this._EEHumidityCalculator_Label79_c(),this._EEHumidityCalculator_TextInput42_c(),this._EEHumidityCalculator_Label80_c(),this._EEHumidityCalculator_Label81_c(),this._EEHumidityCalculator_DropDownList21_c()];
         _loc1_.id = "twGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.twGrpList = _loc1_;
         BindingManager.executeBindings(this,"twGrpList",this.twGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image38_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image39_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image39_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image39_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label78_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label78";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label78 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label78",this._EEHumidityCalculator_Label78);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput41_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput41_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput41_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput41_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput41_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label79_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput42_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput42_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput42_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput42_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput42_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label80_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label81_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 201;
         _loc1_.y = 9;
         _loc1_.text = "w";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList21_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList21_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList21_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group24_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "qv";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 318;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image40_c(),this._EEHumidityCalculator_Image41_c(),this._EEHumidityCalculator_Label82_i(),this._EEHumidityCalculator_TextInput43_c(),this._EEHumidityCalculator_Label83_c(),this._EEHumidityCalculator_TextInput44_c(),this._EEHumidityCalculator_Label84_c(),this._EEHumidityCalculator_Label85_c(),this._EEHumidityCalculator_DropDownList22_c()];
         _loc1_.id = "qvGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.qvGrpList = _loc1_;
         BindingManager.executeBindings(this,"qvGrpList",this.qvGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image40_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image41_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image41_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image41_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label82_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label82";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label82 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label82",this._EEHumidityCalculator_Label82);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput43_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput43_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput43_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput43_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput43_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label83_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput44_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput44_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput44_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput44_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput44_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label84_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "q";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label85_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 201;
         _loc1_.y = 8;
         _loc1_.text = "v";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList22_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList22_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList22_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group25_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "wv";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 289;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image42_c(),this._EEHumidityCalculator_Image43_c(),this._EEHumidityCalculator_Label86_i(),this._EEHumidityCalculator_TextInput45_c(),this._EEHumidityCalculator_Label87_c(),this._EEHumidityCalculator_TextInput46_c(),this._EEHumidityCalculator_Label88_c(),this._EEHumidityCalculator_Label89_c(),this._EEHumidityCalculator_DropDownList23_c()];
         _loc1_.id = "wvGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.wvGrpList = _loc1_;
         BindingManager.executeBindings(this,"wvGrpList",this.wvGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image42_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image43_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image43_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image43_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label86_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label86";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label86 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label86",this._EEHumidityCalculator_Label86);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput45_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput45_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput45_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput45_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput45_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label87_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput46_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput46_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput46_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput46_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput46_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label88_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "w";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label89_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 202;
         _loc1_.y = 8;
         _loc1_.text = "v";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList23_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList23_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList23_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group26_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "r";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 260;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image44_c(),this._EEHumidityCalculator_Image45_c(),this._EEHumidityCalculator_Label90_i(),this._EEHumidityCalculator_TextInput47_c(),this._EEHumidityCalculator_Label91_c(),this._EEHumidityCalculator_TextInput48_c(),this._EEHumidityCalculator_Label92_c(),this._EEHumidityCalculator_DropDownList24_c()];
         _loc1_.id = "rGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.rGrpList = _loc1_;
         BindingManager.executeBindings(this,"rGrpList",this.rGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image44_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image45_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image45_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image45_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label90_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label90";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label90 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label90",this._EEHumidityCalculator_Label90);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput47_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput47_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput47_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput47_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput47_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label91_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput48_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput48_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput48_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput48_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput48_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label92_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "r";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList24_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList24_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList24_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group27_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "dv";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 231;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image46_c(),this._EEHumidityCalculator_Image47_c(),this._EEHumidityCalculator_Label93_i(),this._EEHumidityCalculator_TextInput49_c(),this._EEHumidityCalculator_Label94_c(),this._EEHumidityCalculator_TextInput50_c(),this._EEHumidityCalculator_Label95_c(),this._EEHumidityCalculator_Label96_c(),this._EEHumidityCalculator_DropDownList25_c()];
         _loc1_.id = "dvGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.dvGrpList = _loc1_;
         BindingManager.executeBindings(this,"dvGrpList",this.dvGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image46_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image47_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image47_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image47_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label93_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label93";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label93 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label93",this._EEHumidityCalculator_Label93);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput49_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput49_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput49_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput49_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput49_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label94_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput50_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput50_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput50_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput50_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput50_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label95_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "d";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label96_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 201;
         _loc1_.y = 8;
         _loc1_.text = "v";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList25_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList25_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList25_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group28_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "tf";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 202;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image48_c(),this._EEHumidityCalculator_Image49_c(),this._EEHumidityCalculator_Label97_i(),this._EEHumidityCalculator_TextInput51_c(),this._EEHumidityCalculator_Label98_c(),this._EEHumidityCalculator_TextInput52_c(),this._EEHumidityCalculator_Label99_c(),this._EEHumidityCalculator_Label100_c(),this._EEHumidityCalculator_DropDownList26_c()];
         _loc1_.id = "tfGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tfGrpList = _loc1_;
         BindingManager.executeBindings(this,"tfGrpList",this.tfGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image48_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image49_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image49_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image49_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label97_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label97";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label97 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label97",this._EEHumidityCalculator_Label97);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput51_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput51_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput51_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput51_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput51_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label98_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput52_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput52_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput52_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput52_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput52_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label99_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label100_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 199;
         _loc1_.y = 9;
         _loc1_.text = "f";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList26_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList26_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList26_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group29_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "td";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 173;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image50_c(),this._EEHumidityCalculator_Image51_c(),this._EEHumidityCalculator_Label101_i(),this._EEHumidityCalculator_TextInput53_c(),this._EEHumidityCalculator_Label102_c(),this._EEHumidityCalculator_TextInput54_c(),this._EEHumidityCalculator_Label103_c(),this._EEHumidityCalculator_Label104_c(),this._EEHumidityCalculator_DropDownList27_c()];
         _loc1_.id = "tdGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.tdGrpList = _loc1_;
         BindingManager.executeBindings(this,"tdGrpList",this.tdGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image50_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image51_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image51_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image51_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label101_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label101";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label101 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label101",this._EEHumidityCalculator_Label101);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput53_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput53_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput53_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput53_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput53_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label102_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput54_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput54_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput54_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput54_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput54_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label103_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "t";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label104_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 200;
         _loc1_.y = 9;
         _loc1_.text = "d";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList27_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList27_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList27_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group30_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "ui";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 144;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image52_c(),this._EEHumidityCalculator_Image53_c(),this._EEHumidityCalculator_Label105_i(),this._EEHumidityCalculator_TextInput55_c(),this._EEHumidityCalculator_Label106_c(),this._EEHumidityCalculator_TextInput56_c(),this._EEHumidityCalculator_Label107_c(),this._EEHumidityCalculator_Label108_c(),this._EEHumidityCalculator_DropDownList28_c()];
         _loc1_.id = "uiGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.uiGrpList = _loc1_;
         BindingManager.executeBindings(this,"uiGrpList",this.uiGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image52_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image53_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image53_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image53_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label105_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label105";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label105 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label105",this._EEHumidityCalculator_Label105);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput55_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput55_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput55_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput55_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput55_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label106_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput56_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput56_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput56_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput56_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput56_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label107_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "U";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label108_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 199;
         _loc1_.y = 8;
         _loc1_.text = "i";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList28_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList28_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList28_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group31_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "uw";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 115;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image54_c(),this._EEHumidityCalculator_Image55_c(),this._EEHumidityCalculator_Label109_i(),this._EEHumidityCalculator_TextInput57_c(),this._EEHumidityCalculator_Label110_c(),this._EEHumidityCalculator_TextInput58_c(),this._EEHumidityCalculator_Label111_c(),this._EEHumidityCalculator_Label112_c(),this._EEHumidityCalculator_DropDownList29_c()];
         _loc1_.id = "uwGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.uwGrpList = _loc1_;
         BindingManager.executeBindings(this,"uwGrpList",this.uwGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image54_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image55_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image55_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image55_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label109_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label109";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label109 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label109",this._EEHumidityCalculator_Label109);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput57_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput57_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput57_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput57_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput57_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label110_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput58_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput58_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput58_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput58_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput58_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label111_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "U";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label112_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 202;
         _loc1_.y = 8;
         _loc1_.text = "w";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList29_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList29_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList29_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group32_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "h";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 405;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image56_c(),this._EEHumidityCalculator_Label113_i(),this._EEHumidityCalculator_TextInput59_c(),this._EEHumidityCalculator_Label114_c(),this._EEHumidityCalculator_TextInput60_c(),this._EEHumidityCalculator_Label115_c(),this._EEHumidityCalculator_DropDownList30_c()];
         _loc1_.id = "hGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.hGrpList = _loc1_;
         BindingManager.executeBindings(this,"hGrpList",this.hGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image56_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label113_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label113";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label113 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label113",this._EEHumidityCalculator_Label113);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput59_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput59_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput59_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput59_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput59_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label114_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput60_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput60_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput60_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput60_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput60_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label115_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "h";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList30_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList30_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList30_change(event:IndexChangeEvent) : void
      {
         this.selectorHChange(event);
      }
      
      private function _EEHumidityCalculator_Group33_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "rs";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 434;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image57_c(),this._EEHumidityCalculator_Label116_i(),this._EEHumidityCalculator_TextInput61_c(),this._EEHumidityCalculator_Label117_c(),this._EEHumidityCalculator_TextInput62_c(),this._EEHumidityCalculator_Label118_c(),this._EEHumidityCalculator_Label119_c(),this._EEHumidityCalculator_DropDownList31_c()];
         _loc1_.id = "rsGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.rsGrpList = _loc1_;
         BindingManager.executeBindings(this,"rsGrpList",this.rsGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image57_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label116_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label116";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label116 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label116",this._EEHumidityCalculator_Label116);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput61_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput61_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput61_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput61_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput61_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label117_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput62_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput62_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput62_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput62_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput62_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label118_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 0;
         _loc1_.text = "r";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label119_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 199;
         _loc1_.y = 7;
         _loc1_.text = "s";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList31_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList31_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList31_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group34_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "ei";
         _loc1_.width = 50;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 463;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image58_c(),this._EEHumidityCalculator_Label120_i(),this._EEHumidityCalculator_TextInput63_c(),this._EEHumidityCalculator_Label121_c(),this._EEHumidityCalculator_TextInput64_c(),this._EEHumidityCalculator_Label122_i(),this._EEHumidityCalculator_Label123_c(),this._EEHumidityCalculator_DropDownList32_c()];
         _loc1_.id = "eiGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eiGrpList = _loc1_;
         BindingManager.executeBindings(this,"eiGrpList",this.eiGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image58_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label120_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label120";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label120 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label120",this._EEHumidityCalculator_Label120);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput63_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput63_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput63_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput63_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput63_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label121_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput64_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("fontSize",12);
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput64_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput64_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput64_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput64_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label122_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 200;
         _loc1_.y = 0;
         _loc1_.text = "e \'";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","left");
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "eiLableList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eiLableList = _loc1_;
         BindingManager.executeBindings(this,"eiLableList",this.eiLableList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label123_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 199;
         _loc1_.y = 7;
         _loc1_.text = "i";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList32_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList32_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList32_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group35_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "ew";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 492;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image59_c(),this._EEHumidityCalculator_Label124_i(),this._EEHumidityCalculator_TextInput65_c(),this._EEHumidityCalculator_Label125_c(),this._EEHumidityCalculator_TextInput66_c(),this._EEHumidityCalculator_Label126_i(),this._EEHumidityCalculator_Label127_c(),this._EEHumidityCalculator_DropDownList33_c()];
         _loc1_.id = "ewGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.ewGrpList = _loc1_;
         BindingManager.executeBindings(this,"ewGrpList",this.ewGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image59_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label124_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label124";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label124 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label124",this._EEHumidityCalculator_Label124);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput65_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput65_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput65_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput65_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput65_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label125_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput66_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput66_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput66_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput66_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput66_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label126_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 200;
         _loc1_.y = 0;
         _loc1_.text = "e  \'";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","left");
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "ewLableList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.ewLableList = _loc1_;
         BindingManager.executeBindings(this,"ewLableList",this.ewLableList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label127_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 201;
         _loc1_.y = 7;
         _loc1_.text = "w";
         _loc1_.width = 22;
         _loc1_.height = 23;
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontSize",10);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList33_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList33_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList33_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_Group36_i() : Group
      {
         var _loc1_:Group = null;
         _loc1_ = new Group();
         _loc1_.name = "e";
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.x = 155;
         _loc1_.y = 521;
         _loc1_.mxmlContent = [this._EEHumidityCalculator_Image60_c(),this._EEHumidityCalculator_Image61_c(),this._EEHumidityCalculator_Label128_i(),this._EEHumidityCalculator_TextInput67_c(),this._EEHumidityCalculator_Label129_c(),this._EEHumidityCalculator_TextInput68_c(),this._EEHumidityCalculator_Label130_i(),this._EEHumidityCalculator_DropDownList34_c()];
         _loc1_.id = "eGrpList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eGrpList = _loc1_;
         BindingManager.executeBindings(this,"eGrpList",this.eGrpList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image60_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "bg";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 500;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Image61_c() : Image
      {
         var _loc1_:Image = null;
         _loc1_ = new Image();
         _loc1_.name = "icon";
         _loc1_.x = 0;
         _loc1_.y = 0;
         _loc1_.width = 31;
         _loc1_.height = 31;
         _loc1_.autoLoad = true;
         _loc1_.buttonMode = true;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Image61_click);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Image61_click(event:MouseEvent) : void
      {
         this.inputHandler(event);
      }
      
      private function _EEHumidityCalculator_Label128_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "head";
         _loc1_.x = 40;
         _loc1_.y = 2;
         _loc1_.width = 150;
         _loc1_.height = 30;
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.id = "_EEHumidityCalculator_Label128";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Label128 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Label128",this._EEHumidityCalculator_Label128);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput67_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "input";
         _loc1_.editable = false;
         _loc1_.x = 225;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.widthInChars = 8;
         _loc1_.maxChars = 16;
         _loc1_.height = 23;
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput67_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput67_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput67_focusOut(event:FocusEvent) : void
      {
         this.inputChanged(event,true);
      }
      
      public function ___EEHumidityCalculator_TextInput67_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUp(event,true);
      }
      
      private function _EEHumidityCalculator_Label129_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 290;
         _loc1_.y = 0;
         _loc1_.width = 10;
         _loc1_.height = 30;
         _loc1_.text = "±";
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_TextInput68_c() : TextInput
      {
         var _loc1_:TextInput = null;
         _loc1_ = new TextInput();
         _loc1_.name = "devInput";
         _loc1_.editable = false;
         _loc1_.x = 300;
         _loc1_.y = 4;
         _loc1_.width = 65;
         _loc1_.height = 23;
         _loc1_.restrict = "0-9.,+\\-e";
         _loc1_.setStyle("textAlign","right");
         _loc1_.addEventListener("focusOut",this.___EEHumidityCalculator_TextInput68_focusOut);
         _loc1_.addEventListener("keyUp",this.___EEHumidityCalculator_TextInput68_keyUp);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_TextInput68_focusOut(event:FocusEvent) : void
      {
         this.inputChangedDev(event);
      }
      
      public function ___EEHumidityCalculator_TextInput68_keyUp(event:KeyboardEvent) : void
      {
         this.inputKeyUpDev(event);
      }
      
      private function _EEHumidityCalculator_Label130_i() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.name = "dev";
         _loc1_.x = 190;
         _loc1_.y = 2;
         _loc1_.text = "e\'";
         _loc1_.width = 30;
         _loc1_.height = 30;
         _loc1_.setStyle("fontSize",14);
         _loc1_.setStyle("verticalAlign","middle");
         _loc1_.setStyle("textAlign","center");
         _loc1_.setStyle("fontWeight","bold");
         _loc1_.id = "eLableList";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.eLableList = _loc1_;
         BindingManager.executeBindings(this,"eLableList",this.eLableList);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_DropDownList34_c() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.name = "drop";
         _loc1_.x = 380;
         _loc1_.y = 4;
         _loc1_.width = 105;
         _loc1_.height = 23;
         _loc1_.addEventListener("change",this.___EEHumidityCalculator_DropDownList34_change);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_DropDownList34_change(event:IndexChangeEvent) : void
      {
         this.selectorChange(event);
      }
      
      private function _EEHumidityCalculator_DropDownList35_i() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.x = 680;
         _loc1_.y = 10;
         _loc1_.addEventListener("change",this.__langSelector_change);
         _loc1_.id = "langSelector";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.langSelector = _loc1_;
         BindingManager.executeBindings(this,"langSelector",this.langSelector);
         return _loc1_;
      }
      
      public function __langSelector_change(event:IndexChangeEvent) : void
      {
         this.changeLocaleHandler();
      }
      
      private function _EEHumidityCalculator_DropDownList36_i() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.x = 680;
         _loc1_.y = 36;
         _loc1_.selectedIndex = 0;
         _loc1_.dataProvider = this._EEHumidityCalculator_ArrayList1_i();
         _loc1_.addEventListener("change",this.__viewSelector_change);
         _loc1_.id = "viewSelector";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.viewSelector = _loc1_;
         BindingManager.executeBindings(this,"viewSelector",this.viewSelector);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_ArrayList1_i() : ArrayList
      {
         var _loc1_:ArrayList = null;
         _loc1_ = new ArrayList();
         this._EEHumidityCalculator_ArrayList1 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_ArrayList1",this._EEHumidityCalculator_ArrayList1);
         return _loc1_;
      }
      
      public function __viewSelector_change(event:IndexChangeEvent) : void
      {
         this.changeNormListHandler();
      }
      
      private function _EEHumidityCalculator_Button1_i() : Button
      {
         var _loc1_:Button = null;
         _loc1_ = new Button();
         _loc1_.x = 680;
         _loc1_.y = 63;
         _loc1_.width = 112;
         _loc1_.addEventListener("click",this.__pdfButton_click);
         _loc1_.id = "pdfButton";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.pdfButton = _loc1_;
         BindingManager.executeBindings(this,"pdfButton",this.pdfButton);
         return _loc1_;
      }
      
      public function __pdfButton_click(event:MouseEvent) : void
      {
         this.createPDF(event);
      }
      
      private function _EEHumidityCalculator_Button2_i() : Button
      {
         var _loc1_:Button = null;
         _loc1_ = new Button();
         _loc1_.x = 680;
         _loc1_.y = 91;
         _loc1_.width = 112;
         _loc1_.addEventListener("click",this.__clipButton_click);
         _loc1_.id = "clipButton";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.clipButton = _loc1_;
         BindingManager.executeBindings(this,"clipButton",this.clipButton);
         return _loc1_;
      }
      
      public function __clipButton_click(event:MouseEvent) : void
      {
         this.clipButton_clickHandler(event);
      }
      
      private function _EEHumidityCalculator_Button3_i() : Button
      {
         var _loc1_:Button = null;
         _loc1_ = new Button();
         _loc1_.x = 680;
         _loc1_.y = 119;
         _loc1_.width = 112;
         _loc1_.addEventListener("click",this.___EEHumidityCalculator_Button3_click);
         _loc1_.id = "_EEHumidityCalculator_Button3";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this._EEHumidityCalculator_Button3 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_Button3",this._EEHumidityCalculator_Button3);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Button3_click(event:MouseEvent) : void
      {
         this.button1_clickHandler(event);
      }
      
      private function _EEHumidityCalculator_DropDownList37_i() : DropDownList
      {
         var _loc1_:DropDownList = null;
         _loc1_ = new DropDownList();
         _loc1_.x = 22;
         _loc1_.y = 136;
         _loc1_.selectedIndex = 0;
         _loc1_.dataProvider = this._EEHumidityCalculator_ArrayList2_i();
         _loc1_.addEventListener("change",this.__methodSelector_change);
         _loc1_.id = "methodSelector";
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         this.methodSelector = _loc1_;
         BindingManager.executeBindings(this,"methodSelector",this.methodSelector);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_ArrayList2_i() : ArrayList
      {
         var _loc1_:ArrayList = null;
         _loc1_ = new ArrayList();
         this._EEHumidityCalculator_ArrayList2 = _loc1_;
         BindingManager.executeBindings(this,"_EEHumidityCalculator_ArrayList2",this._EEHumidityCalculator_ArrayList2);
         return _loc1_;
      }
      
      public function __methodSelector_change(event:IndexChangeEvent) : void
      {
         this.changeRealPhaseHandler(true);
      }
      
      private function _EEHumidityCalculator_Label131_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 748;
         _loc1_.y = 770;
         _loc1_.text = "Version: 1.0.1";
         _loc1_.setStyle("fontSize",8);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      private function _EEHumidityCalculator_Label132_c() : Label
      {
         var _loc1_:Label = null;
         _loc1_ = new Label();
         _loc1_.x = 642;
         _loc1_.y = 782;
         _loc1_.text = "Copyright © 2010 E+E ELEKTRONIK GmbH";
         _loc1_.setStyle("fontSize",8);
         if(!_loc1_.document)
         {
            _loc1_.document = this;
         }
         BindingManager.executeBindings(this,"temp",_loc1_);
         return _loc1_;
      }
      
      public function ___EEHumidityCalculator_Application1_applicationComplete(event:FlexEvent) : void
      {
         this.InitApp();
      }
      
      private function _EEHumidityCalculator_bindingsSetup() : Array
      {
         var result:Array = null;
         result = [];
         result[0] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","title");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label1.text");
         result[1] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","help");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"helpLableNorm.text");
         result[2] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","p");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label3.text");
         result[3] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","pTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label3.toolTip");
         result[4] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","t");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label6.text");
         result[5] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label6.toolTip");
         result[6] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ei");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label9.text");
         result[7] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","eiTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label9.toolTip");
         result[8] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ew");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label13.text");
         result[9] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ewTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label13.toolTip");
         result[10] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","rs");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label17.text");
         result[11] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","rsTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label17.toolTip");
         result[12] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","h");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label21.text");
         result[13] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","hTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label21.toolTip");
         result[14] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ti");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label24.text");
         result[15] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tiTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label24.toolTip");
         result[16] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tw");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label28.text");
         result[17] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","twTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label28.toolTip");
         result[18] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","qv");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label32.text");
         result[19] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","qvTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label32.toolTip");
         result[20] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","wv");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label36.text");
         result[21] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","wvTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label36.toolTip");
         result[22] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","r");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label40.text");
         result[23] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","rTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label40.toolTip");
         result[24] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","dv");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label43.text");
         result[25] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","dvTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label43.toolTip");
         result[26] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tf");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label47.text");
         result[27] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tfTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label47.toolTip");
         result[28] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","td");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label51.text");
         result[29] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tdTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label51.toolTip");
         result[30] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","Ui");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label55.text");
         result[31] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","UiTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label55.toolTip");
         result[32] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","Uw");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label59.text");
         result[33] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","UwTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label59.toolTip");
         result[34] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","e");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label63.text");
         result[35] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","eTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label63.toolTip");
         result[36] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","title");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label66.text");
         result[37] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","help");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"helpLableList.text");
         result[38] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","p");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label68.text");
         result[39] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","pTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label68.toolTip");
         result[40] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","t");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label71.text");
         result[41] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label71.toolTip");
         result[42] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ti");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label74.text");
         result[43] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tiTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label74.toolTip");
         result[44] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","twlist");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label78.text");
         result[45] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","twTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label78.toolTip");
         result[46] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","qv");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label82.text");
         result[47] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","qvTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label82.toolTip");
         result[48] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","wv");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label86.text");
         result[49] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","wvTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label86.toolTip");
         result[50] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","r");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label90.text");
         result[51] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","rTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label90.toolTip");
         result[52] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","dv");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label93.text");
         result[53] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","dvTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label93.toolTip");
         result[54] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tf");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label97.text");
         result[55] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tfTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label97.toolTip");
         result[56] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","td");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label101.text");
         result[57] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","tdTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label101.toolTip");
         result[58] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","Ui");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label105.text");
         result[59] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","UiTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label105.toolTip");
         result[60] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","Uw");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label109.text");
         result[61] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","UwTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label109.toolTip");
         result[62] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","h");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label113.text");
         result[63] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","hTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label113.toolTip");
         result[64] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","rs");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label116.text");
         result[65] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","rsTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label116.toolTip");
         result[66] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ei");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label120.text");
         result[67] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","eiTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label120.toolTip");
         result[68] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ew");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label124.text");
         result[69] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","ewTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label124.toolTip");
         result[70] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","e");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label128.text");
         result[71] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","eTooltip");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Label128.toolTip");
         result[72] = new Binding(this,function():Array
         {
            var _loc1_:* = undefined;
            _loc1_ = [resourceManager.getString("locale","norView"),resourceManager.getString("locale","listView")];
            return Boolean(_loc1_ == null) || Boolean(_loc1_ is Array) || Boolean(_loc1_ is Proxy)?_loc1_:[_loc1_];
         },null,"_EEHumidityCalculator_ArrayList1.source");
         result[73] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","export");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"pdfButton.label");
         result[74] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","clipboard");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"clipButton.label");
         result[75] = new Binding(this,function():String
         {
            var _loc1_:* = undefined;
            _loc1_ = resourceManager.getString("locale","helpBtn");
            return _loc1_ == undefined?null:String(_loc1_);
         },null,"_EEHumidityCalculator_Button3.label");
         result[76] = new Binding(this,function():Array
         {
            var _loc1_:* = undefined;
            _loc1_ = [resourceManager.getString("locale","realgas"),resourceManager.getString("locale","phaseclean")];
            return Boolean(_loc1_ == null) || Boolean(_loc1_ is Array) || Boolean(_loc1_ is Proxy)?_loc1_:[_loc1_];
         },null,"_EEHumidityCalculator_ArrayList2.source");
         return result;
      }
      
      mx_internal function _EEHumidityCalculator_StylesInit() : void
      {
         var style:CSSStyleDeclaration = null;
         var effects:Array = null;
         var conditions:Array = null;
         var condition:CSSCondition = null;
         var selector:CSSSelector = null;
         if(mx_internal::_EEHumidityCalculator_StylesInit_done)
         {
            return;
         }
         mx_internal::_EEHumidityCalculator_StylesInit_done = true;
         selector = null;
         conditions = null;
         conditions = null;
         selector = new CSSSelector("global",conditions,selector);
         style = styleManager.getStyleDeclaration("global");
         if(!style)
         {
            style = new CSSStyleDeclaration(selector,styleManager);
         }
         if(style.factory == null)
         {
            style.factory = function():void
            {
               this.focusColor = 4025877;
               this.symbolColor = 0;
               this.chromeColor = 7122740;
               this.rollOverColor = 11719824;
               this.selectionColor = 7976779;
            };
         }
         selector = null;
         conditions = null;
         conditions = null;
         selector = new CSSSelector("mx.controls.ToolTip",conditions,selector);
         style = styleManager.getStyleDeclaration("mx.controls.ToolTip");
         if(!style)
         {
            style = new CSSStyleDeclaration(selector,styleManager);
         }
         if(style.factory == null)
         {
            style.factory = function():void
            {
               this.fontWeight = "normal";
               this.color = 0;
               this.backgroundColor = 9687139;
               this.fontSize = 14;
            };
         }
         styleManager.initProtoChainRoots();
      }
      
      [Bindable(event="propertyChange")]
      public function get background() : Image
      {
         return this._1332194002background;
      }
      
      public function set background(param1:Image) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1332194002background;
         if(_loc2_ !== param1)
         {
            this._1332194002background = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"background",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get baseGrpList() : Group
      {
         return this._1700385006baseGrpList;
      }
      
      public function set baseGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1700385006baseGrpList;
         if(_loc2_ !== param1)
         {
            this._1700385006baseGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"baseGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get baseGrpNorm() : Group
      {
         return this._1700319696baseGrpNorm;
      }
      
      public function set baseGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1700319696baseGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1700319696baseGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"baseGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get clipButton() : Button
      {
         return this._1017248418clipButton;
      }
      
      public function set clipButton(param1:Button) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1017248418clipButton;
         if(_loc2_ !== param1)
         {
            this._1017248418clipButton = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"clipButton",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get dvGrpList() : Group
      {
         return this._1094147633dvGrpList;
      }
      
      public function set dvGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1094147633dvGrpList;
         if(_loc2_ !== param1)
         {
            this._1094147633dvGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"dvGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get dvGrpNorm() : Group
      {
         return this._1094212943dvGrpNorm;
      }
      
      public function set dvGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1094212943dvGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1094212943dvGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"dvGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eGrpList() : Group
      {
         return this._1887962878eGrpList;
      }
      
      public function set eGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1887962878eGrpList;
         if(_loc2_ !== param1)
         {
            this._1887962878eGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eGrpNorm() : Group
      {
         return this._1888028188eGrpNorm;
      }
      
      public function set eGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1888028188eGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1888028188eGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eLableList() : Label
      {
         return this._1078062433eLableList;
      }
      
      public function set eLableList(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1078062433eLableList;
         if(_loc2_ !== param1)
         {
            this._1078062433eLableList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eLableList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eLableNorm() : Label
      {
         return this._1077997123eLableNorm;
      }
      
      public function set eLableNorm(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1077997123eLableNorm;
         if(_loc2_ !== param1)
         {
            this._1077997123eLableNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eLableNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eiGrpList() : Group
      {
         return this._1895004705eiGrpList;
      }
      
      public function set eiGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1895004705eiGrpList;
         if(_loc2_ !== param1)
         {
            this._1895004705eiGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eiGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eiGrpNorm() : Group
      {
         return this._1894939395eiGrpNorm;
      }
      
      public function set eiGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1894939395eiGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1894939395eiGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eiGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eiLableList() : Label
      {
         return this._1327390016eiLableList;
      }
      
      public function set eiLableList(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1327390016eiLableList;
         if(_loc2_ !== param1)
         {
            this._1327390016eiLableList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eiLableList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get eiLableNorm() : Label
      {
         return this._1327455326eiLableNorm;
      }
      
      public function set eiLableNorm(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1327455326eiLableNorm;
         if(_loc2_ !== param1)
         {
            this._1327455326eiLableNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"eiLableNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get ewGrpList() : Group
      {
         return this._1029503505ewGrpList;
      }
      
      public function set ewGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1029503505ewGrpList;
         if(_loc2_ !== param1)
         {
            this._1029503505ewGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"ewGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get ewGrpNorm() : Group
      {
         return this._1029568815ewGrpNorm;
      }
      
      public function set ewGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1029568815ewGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1029568815ewGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"ewGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get ewLableList() : Label
      {
         return this._1423799054ewLableList;
      }
      
      public function set ewLableList(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1423799054ewLableList;
         if(_loc2_ !== param1)
         {
            this._1423799054ewLableList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"ewLableList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get ewLableNorm() : Label
      {
         return this._1423733744ewLableNorm;
      }
      
      public function set ewLableNorm(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1423733744ewLableNorm;
         if(_loc2_ !== param1)
         {
            this._1423733744ewLableNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"ewLableNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get hGrpList() : Group
      {
         return this._1473540709hGrpList;
      }
      
      public function set hGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1473540709hGrpList;
         if(_loc2_ !== param1)
         {
            this._1473540709hGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"hGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get hGrpNorm() : Group
      {
         return this._1473475399hGrpNorm;
      }
      
      public function set hGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1473475399hGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1473475399hGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"hGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get helpLableList() : Label
      {
         return this._38651069helpLableList;
      }
      
      public function set helpLableList(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._38651069helpLableList;
         if(_loc2_ !== param1)
         {
            this._38651069helpLableList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"helpLableList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get helpLableNorm() : Label
      {
         return this._38585759helpLableNorm;
      }
      
      public function set helpLableNorm(param1:Label) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._38585759helpLableNorm;
         if(_loc2_ !== param1)
         {
            this._38585759helpLableNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"helpLableNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get inputBg() : Image
      {
         return this._1954846127inputBg;
      }
      
      public function set inputBg(param1:Image) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1954846127inputBg;
         if(_loc2_ !== param1)
         {
            this._1954846127inputBg = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"inputBg",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get inputBgList() : Image
      {
         return this._805811475inputBgList;
      }
      
      public function set inputBgList(param1:Image) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._805811475inputBgList;
         if(_loc2_ !== param1)
         {
            this._805811475inputBgList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"inputBgList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get langSelector() : DropDownList
      {
         return this._1819206675langSelector;
      }
      
      public function set langSelector(param1:DropDownList) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1819206675langSelector;
         if(_loc2_ !== param1)
         {
            this._1819206675langSelector = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"langSelector",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get logoList() : Image
      {
         return this._2027298025logoList;
      }
      
      public function set logoList(param1:Image) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._2027298025logoList;
         if(_loc2_ !== param1)
         {
            this._2027298025logoList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"logoList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get logoNorm() : Image
      {
         return this._2027363335logoNorm;
      }
      
      public function set logoNorm(param1:Image) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._2027363335logoNorm;
         if(_loc2_ !== param1)
         {
            this._2027363335logoNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"logoNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get methodSelector() : DropDownList
      {
         return this._1610332128methodSelector;
      }
      
      public function set methodSelector(param1:DropDownList) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1610332128methodSelector;
         if(_loc2_ !== param1)
         {
            this._1610332128methodSelector = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"methodSelector",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get pGrpList() : Group
      {
         return this._415959917pGrpList;
      }
      
      public function set pGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._415959917pGrpList;
         if(_loc2_ !== param1)
         {
            this._415959917pGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"pGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get pGrpNorm() : Group
      {
         return this._415894607pGrpNorm;
      }
      
      public function set pGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._415894607pGrpNorm;
         if(_loc2_ !== param1)
         {
            this._415894607pGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"pGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get pdfButton() : Button
      {
         return this._51853628pdfButton;
      }
      
      public function set pdfButton(param1:Button) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._51853628pdfButton;
         if(_loc2_ !== param1)
         {
            this._51853628pdfButton = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"pdfButton",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get qvGrpList() : Group
      {
         return this._927923906qvGrpList;
      }
      
      public function set qvGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._927923906qvGrpList;
         if(_loc2_ !== param1)
         {
            this._927923906qvGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"qvGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get qvGrpNorm() : Group
      {
         return this._927858596qvGrpNorm;
      }
      
      public function set qvGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._927858596qvGrpNorm;
         if(_loc2_ !== param1)
         {
            this._927858596qvGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"qvGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get rGrpList() : Group
      {
         return this._1225306543rGrpList;
      }
      
      public function set rGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1225306543rGrpList;
         if(_loc2_ !== param1)
         {
            this._1225306543rGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"rGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get rGrpNorm() : Group
      {
         return this._1225241233rGrpNorm;
      }
      
      public function set rGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1225241233rGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1225241233rGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"rGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get rsGrpList() : Group
      {
         return this._626125218rsGrpList;
      }
      
      public function set rsGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._626125218rsGrpList;
         if(_loc2_ !== param1)
         {
            this._626125218rsGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"rsGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get rsGrpNorm() : Group
      {
         return this._626190528rsGrpNorm;
      }
      
      public function set rsGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._626190528rsGrpNorm;
         if(_loc2_ !== param1)
         {
            this._626190528rsGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"rsGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tGrpList() : Group
      {
         return this._2034653169tGrpList;
      }
      
      public function set tGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._2034653169tGrpList;
         if(_loc2_ !== param1)
         {
            this._2034653169tGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tGrpNorm() : Group
      {
         return this._2034587859tGrpNorm;
      }
      
      public function set tGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._2034587859tGrpNorm;
         if(_loc2_ !== param1)
         {
            this._2034587859tGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tdGrpList() : Group
      {
         return this._933832339tdGrpList;
      }
      
      public function set tdGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._933832339tdGrpList;
         if(_loc2_ !== param1)
         {
            this._933832339tdGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tdGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tdGrpNorm() : Group
      {
         return this._933897649tdGrpNorm;
      }
      
      public function set tdGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._933897649tdGrpNorm;
         if(_loc2_ !== param1)
         {
            this._933897649tdGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tdGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tfGrpList() : Group
      {
         return this._124485713tfGrpList;
      }
      
      public function set tfGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._124485713tfGrpList;
         if(_loc2_ !== param1)
         {
            this._124485713tfGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tfGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tfGrpNorm() : Group
      {
         return this._124551023tfGrpNorm;
      }
      
      public function set tfGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._124551023tfGrpNorm;
         if(_loc2_ !== param1)
         {
            this._124551023tfGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tfGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tiGrpList() : Group
      {
         return this._1057949422tiGrpList;
      }
      
      public function set tiGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1057949422tiGrpList;
         if(_loc2_ !== param1)
         {
            this._1057949422tiGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tiGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get tiGrpNorm() : Group
      {
         return this._1058014732tiGrpNorm;
      }
      
      public function set tiGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1058014732tiGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1058014732tiGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"tiGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get twGrpList() : Group
      {
         return this._312509664twGrpList;
      }
      
      public function set twGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._312509664twGrpList;
         if(_loc2_ !== param1)
         {
            this._312509664twGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"twGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get twGrpNorm() : Group
      {
         return this._312444354twGrpNorm;
      }
      
      public function set twGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._312444354twGrpNorm;
         if(_loc2_ !== param1)
         {
            this._312444354twGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"twGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get uiGrpList() : Group
      {
         return this._749505041uiGrpList;
      }
      
      public function set uiGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._749505041uiGrpList;
         if(_loc2_ !== param1)
         {
            this._749505041uiGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"uiGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get uiGrpNorm() : Group
      {
         return this._749439731uiGrpNorm;
      }
      
      public function set uiGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._749439731uiGrpNorm;
         if(_loc2_ !== param1)
         {
            this._749439731uiGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"uiGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get uwGrpList() : Group
      {
         return this._2119964127uwGrpList;
      }
      
      public function set uwGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._2119964127uwGrpList;
         if(_loc2_ !== param1)
         {
            this._2119964127uwGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"uwGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get uwGrpNorm() : Group
      {
         return this._2119898817uwGrpNorm;
      }
      
      public function set uwGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._2119898817uwGrpNorm;
         if(_loc2_ !== param1)
         {
            this._2119898817uwGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"uwGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get viewSelector() : DropDownList
      {
         return this._895032740viewSelector;
      }
      
      public function set viewSelector(param1:DropDownList) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._895032740viewSelector;
         if(_loc2_ !== param1)
         {
            this._895032740viewSelector = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"viewSelector",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get wvGrpList() : Group
      {
         return this._1112251204wvGrpList;
      }
      
      public function set wvGrpList(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1112251204wvGrpList;
         if(_loc2_ !== param1)
         {
            this._1112251204wvGrpList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"wvGrpList",_loc2_,param1));
            }
         }
      }
      
      [Bindable(event="propertyChange")]
      public function get wvGrpNorm() : Group
      {
         return this._1112316514wvGrpNorm;
      }
      
      public function set wvGrpNorm(param1:Group) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1112316514wvGrpNorm;
         if(_loc2_ !== param1)
         {
            this._1112316514wvGrpNorm = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"wvGrpNorm",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/logo.png")]
      [Bindable(event="propertyChange")]
      private function get logoImg() : Class
      {
         return this._342488600logoImg;
      }
      
      private function set logoImg(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._342488600logoImg;
         if(_loc2_ !== param1)
         {
            this._342488600logoImg = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"logoImg",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/BG.jpg")]
      [Bindable(event="propertyChange")]
      private function get bg() : Class
      {
         return this._3141bg;
      }
      
      private function set bg(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._3141bg;
         if(_loc2_ !== param1)
         {
            this._3141bg = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"bg",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/bgElement.png")]
      [Bindable(event="propertyChange")]
      private function get bgElement() : Class
      {
         return this._1914223881bgElement;
      }
      
      private function set bgElement(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1914223881bgElement;
         if(_loc2_ !== param1)
         {
            this._1914223881bgElement = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"bgElement",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/bgElementP.png")]
      [Bindable(event="propertyChange")]
      private function get bgElementP() : Class
      {
         return this._788601913bgElementP;
      }
      
      private function set bgElementP(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._788601913bgElementP;
         if(_loc2_ !== param1)
         {
            this._788601913bgElementP = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"bgElementP",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/bgElementM.png")]
      [Bindable(event="propertyChange")]
      private function get bgElementM() : Class
      {
         return this._788601910bgElementM;
      }
      
      private function set bgElementM(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._788601910bgElementM;
         if(_loc2_ !== param1)
         {
            this._788601910bgElementM = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"bgElementM",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/bgElementList.png")]
      [Bindable(event="propertyChange")]
      private function get bgElementList() : Class
      {
         return this._231533515bgElementList;
      }
      
      private function set bgElementList(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._231533515bgElementList;
         if(_loc2_ !== param1)
         {
            this._231533515bgElementList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"bgElementList",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/bgElementPList.png")]
      [Bindable(event="propertyChange")]
      private function get bgElementPList() : Class
      {
         return this._1415216247bgElementPList;
      }
      
      private function set bgElementPList(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1415216247bgElementPList;
         if(_loc2_ !== param1)
         {
            this._1415216247bgElementPList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"bgElementPList",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/bgElementMList.png")]
      [Bindable(event="propertyChange")]
      private function get bgElementMList() : Class
      {
         return this._1412445684bgElementMList;
      }
      
      private function set bgElementMList(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._1412445684bgElementMList;
         if(_loc2_ !== param1)
         {
            this._1412445684bgElementMList = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"bgElementMList",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/header.png")]
      [Bindable(event="propertyChange")]
      private function get headerImg() : Class
      {
         return this._213314058headerImg;
      }
      
      private function set headerImg(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._213314058headerImg;
         if(_loc2_ !== param1)
         {
            this._213314058headerImg = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"headerImg",_loc2_,param1));
            }
         }
      }
      
      [Embed(source="data/img/footer.png")]
      [Bindable(event="propertyChange")]
      private function get footerImg() : Class
      {
         return this._646922200footerImg;
      }
      
      private function set footerImg(param1:Class) : void
      {
         var _loc2_:Object = null;
         _loc2_ = this._646922200footerImg;
         if(_loc2_ !== param1)
         {
            this._646922200footerImg = param1;
            if(this.hasEventListener("propertyChange"))
            {
               this.dispatchEvent(PropertyChangeEvent.createUpdateEvent(this,"footerImg",_loc2_,param1));
            }
         }
      }
   }
}
