////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Curve Style Dialog.                                                   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231124 - Modified for FPC (A.K.)                                         //
// 20240626 - ApplyParams                                                     //
////////////////////////////////////////////////////////////////////////////////

unit form_curvestyledialog; // Form Curve Style Dialog

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons,
 lcltype, lclintf, ColorBox,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo, _crw_ef,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type

  { TFormCurveStyleDialog }

  TFormCurveStyleDialog = class(TMasterForm)
    ColorBox: TColorBox;
    EditCurveName: TEdit;
    GroupBoxCurveName: TGroupBox;
    PanelControls: TPanel;
    PanelButtons: TPanel;
    GroupBoxCurveColor: TGroupBox;
    GroupBoxMarkerStyle: TGroupBox;
    SpeedButtonMarkerStyle0: TSpeedButton;
    SpeedButtonMarkerStyle1: TSpeedButton;
    SpeedButtonMarkerStyle2: TSpeedButton;
    SpeedButtonMarkerStyle3: TSpeedButton;
    SpeedButtonMarkerStyle4: TSpeedButton;
    SpeedButtonMarkerStyle5: TSpeedButton;
    SpeedButtonMarkerStyle6: TSpeedButton;
    SpeedButtonMarkerStyle7: TSpeedButton;
    SpeedButtonMarkerStyle8: TSpeedButton;
    SpeedButtonMarkerStyle9: TSpeedButton;
    SpeedButtonMarkerStyle10: TSpeedButton;
    SpeedButtonMarkerStyle11: TSpeedButton;
    SpeedButtonMarkerStyle12: TSpeedButton;
    SpeedButtonMarkerStyle13: TSpeedButton;
    SpeedButtonMarkerStyle14: TSpeedButton;
    SpeedButtonMarkerStyle15: TSpeedButton;
    GroupBoxLineStyle: TGroupBox;
    SpeedButtonLineStyle0: TSpeedButton;
    SpeedButtonLineStyle1: TSpeedButton;
    SpeedButtonLineStyle2: TSpeedButton;
    SpeedButtonLineStyle3: TSpeedButton;
    SpeedButtonLineStyle4: TSpeedButton;
    SpeedButtonLineStyle5: TSpeedButton;
    SpeedButtonLineStyle6: TSpeedButton;
    SpeedButtonLineStyle7: TSpeedButton;
    SpeedButtonLineStyle8: TSpeedButton;
    SpeedButtonLineStyle9: TSpeedButton;
    SpeedButtonLineStyle10: TSpeedButton;
    SpeedButtonLineStyle11: TSpeedButton;
    SpeedButtonLineStyle12: TSpeedButton;
    SpeedButtonLineStyle13: TSpeedButton;
    SpeedButtonLineStyle14: TSpeedButton;
    SpeedButtonLineStyle15: TSpeedButton;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure ColorBoxChange(Sender: TObject);
    procedure SpeedButtonLineStyle0Click(Sender: TObject);
    procedure SpeedButtonLineStyle1Click(Sender: TObject);
    procedure SpeedButtonLineStyle2Click(Sender: TObject);
    procedure SpeedButtonLineStyle3Click(Sender: TObject);
    procedure SpeedButtonLineStyle4Click(Sender: TObject);
    procedure SpeedButtonLineStyle5Click(Sender: TObject);
    procedure SpeedButtonLineStyle6Click(Sender: TObject);
    procedure SpeedButtonLineStyle7Click(Sender: TObject);
    procedure SpeedButtonLineStyle8Click(Sender: TObject);
    procedure SpeedButtonLineStyle9Click(Sender: TObject);
    procedure SpeedButtonLineStyle10Click(Sender: TObject);
    procedure SpeedButtonLineStyle11Click(Sender: TObject);
    procedure SpeedButtonLineStyle12Click(Sender: TObject);
    procedure SpeedButtonLineStyle13Click(Sender: TObject);
    procedure SpeedButtonLineStyle14Click(Sender: TObject);
    procedure SpeedButtonLineStyle15Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle0Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle1Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle2Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle3Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle4Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle5Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle6Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle7Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle8Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle9Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle10Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle11Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle12Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle13Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle14Click(Sender: TObject);
    procedure SpeedButtonMarkerStyle15Click(Sender: TObject);
    procedure LabelCurveNameClick(Sender: TObject);
  private
    { Private declarations }
    myFormLink : TForm;
    function  LineBtn(i:LongInt):TSpeedButton;
    function  MarkBtn(i:LongInt):TSpeedButton;
    procedure SetLineStyle(StyleIndex:LongInt);
    procedure SetMarkerStyle(StyleIndex:LongInt);
  public
    { Public declarations }
    procedure ResetColor;
  end;

procedure RunCurveStyleDialog(Form:TForm; const aParams:LongString='');

implementation

{$R *.lfm}

uses
 Form_CurveWindow;

const
  FormCurveStyleDialog : TFormCurveStyleDialog = nil;

procedure RunCurveStyleDialog(Form:TForm; const aParams:LongString='');
var SaveColor:TColor; SaveStyle:Cardinal; apFlags:Integer;
begin
 if CanShowModal(FormCurveStyleDialog) then
 try
  if Form is TFormCurveWindow then
  if (Form as TFormCurveWindow).HasSelection then
  if not (Form as TFormCurveWindow).CheckIsDataProtected then begin
   if not Assigned(FormCurveStyleDialog)  then begin
    Application.CreateForm(TFormCurveStyleDialog, FormCurveStyleDialog);
    FormCurveStyleDialog.Master:=@FormCurveStyleDialog;
   end;
   if Assigned(FormCurveStyleDialog) then begin
    apFlags:=FormCurveStyleDialog.ApplyParams(aParams);
    if not HasFlags(apFlags,apf_FormPos)
    then LocateFormToCenterOfScreen(FormCurveStyleDialog);
    FormCurveStyleDialog.myFormLink:=Form;
    with (Form as TFormCurveWindow) do begin
     SaveColor:=DefCurve.Color;
     SaveStyle:=DefCurve.Style;
     FormCurveStyleDialog.ResetColor;
     FormCurveStyleDialog.MarkBtn(SaveStyle and $F).Down:=true;
     FormCurveStyleDialog.LineBtn((SaveStyle shr 4) and $F).Down:=true;
     FormCurveStyleDialog.EditCurveName.Text:=DefCurve.Name;
     if mrVoice(FormCurveStyleDialog.ShowModal)=mrOk then begin
      try
       LockDraw;
       DefCurve.Name:=FormCurveStyleDialog.EditCurveName.Text;
      finally
       UnlockDraw;
      end;
     end else begin
      try
       LockDraw;
       DefCurve.Color:=SaveColor;
       DefCurve.Style:=SaveStyle;
      finally
       UnlockDraw;
      end;
     end;
    end;
    FormCurveStyleDialog.myFormLink:=nil;
   end;
  end;
 except
  on E:Exception do BugReport(E);
 end else begin
  Error(RusEng('В окне нет выбранной кривой!','No curve selected in the window!'));
 end;
end;

procedure TFormCurveStyleDialog.FormCreate(Sender: TObject);
var i:LongInt; p:TPoint;
begin
 myFormLink:=nil;
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 for i:=0 to 15 do begin
  p:=Point(16*2+2,8);
  LineBtn(i).Glyph.Width:=p.x;
  LineBtn(i).Glyph.Height:=p.y;
  DrawBar(LineBtn(i).Glyph.Canvas,Rect2I(0,0,p.x+1,p.y+1),clBtnFace,bsSolid);
  DrawLineMarker(LineBtn(i).Glyph.Canvas,Point2I(1,1),Point2I(16*2,1),clBlack,i);
  LineBtn(i).Glyph.TransparentColor:=clBtnFace;
  LineBtn(i).Glyph.Transparent:=true;
 end;
 for i:=0 to 15 do begin
  p:=Point(18,18);
  MarkBtn(i).Glyph.Width:=p.x;
  MarkBtn(i).Glyph.Height:=p.y;
  DrawBar(MarkBtn(i).Glyph.Canvas,Rect2I(0,0,p.x+1,p.y+1),clBtnFace,bsSolid);
  DrawPointMarker(MarkBtn(i).Glyph.Canvas,Point2I(9,9),clBlack,i);
  MarkBtn(i).Glyph.TransparentColor:=clBtnFace;
  MarkBtn(i).Glyph.Transparent:=true;
 end;
 Caption:=RusEng('Диалог выбора имени, цвета и стиля кривой','Curve name, color and style selection dialog');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 SmartUpdate(GroupBoxCurveColor,RusEng('Цвет','Color'));
 SmartUpdate(GroupBoxMarkerStyle,RusEng('Маркер','Marker'));
 SmartUpdate(GroupBoxLineStyle,RusEng('Линия','Line'));
 SmartUpdate(GroupBoxCurveName,RusEng('Имя кривой:','Curve name:'));
end;

procedure TFormCurveStyleDialog.ColorBoxChange(Sender: TObject);
begin
 if (myFormLink is TFormCurveWindow) then
 with TFormCurveWindow(myFormLink)  do
 if HasSelection then begin
  try
   LockDraw;
   DefCurve.Color:=ColorBox.Selected;
  finally
   UnlockDraw;
  end;
 end;
end;

procedure TFormCurveStyleDialog.ResetColor;
begin
 if (myFormLink is TFormCurveWindow) then
 with TFormCurveWindow(myFormLink)  do
 if HasSelection then begin
  ColorBox.Selected:=DefCurve.Color;
 end;
end;

function TFormCurveStyleDialog.LineBtn(i:LongInt):TSpeedButton;
begin
 case i and 15 of
  0 :Result:=SpeedButtonLineStyle0;
  1 :Result:=SpeedButtonLineStyle1;
  2 :Result:=SpeedButtonLineStyle2;
  3 :Result:=SpeedButtonLineStyle3;
  4 :Result:=SpeedButtonLineStyle4;
  5 :Result:=SpeedButtonLineStyle5;
  6 :Result:=SpeedButtonLineStyle6;
  7 :Result:=SpeedButtonLineStyle7;
  8 :Result:=SpeedButtonLineStyle8;
  9 :Result:=SpeedButtonLineStyle9;
  10:Result:=SpeedButtonLineStyle10;
  11:Result:=SpeedButtonLineStyle11;
  12:Result:=SpeedButtonLineStyle12;
  13:Result:=SpeedButtonLineStyle13;
  14:Result:=SpeedButtonLineStyle14;
  15:Result:=SpeedButtonLineStyle15;
  else Result:=nil;
 end;
end;

function TFormCurveStyleDialog.MarkBtn(i:LongInt):TSpeedButton;
begin
 case i and 15 of
  0 :Result:=SpeedButtonMarkerStyle0;
  1 :Result:=SpeedButtonMarkerStyle1;
  2 :Result:=SpeedButtonMarkerStyle2;
  3 :Result:=SpeedButtonMarkerStyle3;
  4 :Result:=SpeedButtonMarkerStyle4;
  5 :Result:=SpeedButtonMarkerStyle5;
  6 :Result:=SpeedButtonMarkerStyle6;
  7 :Result:=SpeedButtonMarkerStyle7;
  8 :Result:=SpeedButtonMarkerStyle8;
  9 :Result:=SpeedButtonMarkerStyle9;
  10:Result:=SpeedButtonMarkerStyle10;
  11:Result:=SpeedButtonMarkerStyle11;
  12:Result:=SpeedButtonMarkerStyle12;
  13:Result:=SpeedButtonMarkerStyle13;
  14:Result:=SpeedButtonMarkerStyle14;
  15:Result:=SpeedButtonMarkerStyle15;
  else Result:=nil;
 end;
end;

procedure TFormCurveStyleDialog.SetLineStyle(StyleIndex:LongInt);
begin
 if myFormLink is TFormCurveWindow then with myFormLink as TFormCurveWindow do
 if HasSelection then begin
  try
   LockDraw;
   DefCurve.Style:=(DefCurve.Style and not $F0) or ((StyleIndex and $F) shl 4);
  finally
   UnlockDraw;
  end;
 end;
end;

procedure TFormCurveStyleDialog.SetMarkerStyle(StyleIndex:LongInt);
begin
 if myFormLink is TFormCurveWindow then with myFormLink as TFormCurveWindow do
 if HasSelection then begin
  try
   LockDraw;
   DefCurve.Style:=(DefCurve.Style and not $F) or (StyleIndex and $F);
  finally
   UnlockDraw;
  end;
 end;
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle0Click(Sender: TObject);
begin
 SetLineStyle(0);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle1Click(Sender: TObject);
begin
 SetLineStyle(1);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle2Click(Sender: TObject);
begin
 SetLineStyle(2);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle3Click(Sender: TObject);
begin
 SetLineStyle(3);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle4Click(Sender: TObject);
begin
 SetLineStyle(4);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle5Click(Sender: TObject);
begin
 SetLineStyle(5);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle6Click(Sender: TObject);
begin
 SetLineStyle(6);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle7Click(Sender: TObject);
begin
 SetLineStyle(7);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle8Click(Sender: TObject);
begin
 SetLineStyle(8);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle9Click(Sender: TObject);
begin
 SetLineStyle(9);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle10Click(Sender: TObject);
begin
 SetLineStyle(10);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle11Click(Sender: TObject);
begin
 SetLineStyle(11);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle12Click(Sender: TObject);
begin
 SetLineStyle(12);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle13Click(Sender: TObject);
begin
 SetLineStyle(13);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle14Click(Sender: TObject);
begin
 SetLineStyle(14);
end;

procedure TFormCurveStyleDialog.SpeedButtonLineStyle15Click(Sender: TObject);
begin
 SetLineStyle(15);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle0Click(Sender: TObject);
begin
 SetMarkerStyle(0);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle1Click(Sender: TObject);
begin
 SetMarkerStyle(1);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle2Click(Sender: TObject);
begin
 SetMarkerStyle(2);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle3Click(Sender: TObject);
begin
 SetMarkerStyle(3);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle4Click(Sender: TObject);
begin
 SetMarkerStyle(4);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle5Click(Sender: TObject);
begin
 SetMarkerStyle(5);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle6Click(Sender: TObject);
begin
 SetMarkerStyle(6);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle7Click(Sender: TObject);
begin
 SetMarkerStyle(7);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle8Click(Sender: TObject);
begin
 SetMarkerStyle(8);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle9Click(Sender: TObject);
begin
 SetMarkerStyle(9);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle10Click(Sender: TObject);
begin
 SetMarkerStyle(10);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle11Click(Sender: TObject);
begin
 SetMarkerStyle(11);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle12Click(Sender: TObject);
begin
 SetMarkerStyle(12);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle13Click(Sender: TObject);
begin
 SetMarkerStyle(13);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle14Click(Sender: TObject);
begin
 SetMarkerStyle(14);
end;

procedure TFormCurveStyleDialog.SpeedButtonMarkerStyle15Click(Sender: TObject);
begin
 SetMarkerStyle(15);
end;

procedure TFormCurveStyleDialog.LabelCurveNameClick(Sender: TObject);
begin
 SmartFocus(EditCurveName);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_curvestyledialog;
begin
end;

procedure Free_form_curvestyledialog;
begin
end;

initialization

 Init_form_curvestyledialog;

finalization

 Free_form_curvestyledialog;

end.

//////////////
// END OF FILE
//////////////

