#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

########################
# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function do_menus(){
 find . -type f -name '*.pas' | xargs -n 1 cat | grep -i 'UpdateMenu(Menu' | sort | uniq;
};

function units_finder(){
 case $1 in
  menus) do_menus; ;;
  *) echo "Usage: $scriptname [menus]";
 esac;
};

function main(){
 if pushd $scriptHOME > /dev/null 2>&1; then
  if [ -t 1 ]; then
   units_finder $*;
  else
   exec xterm -fa 'PT Mono' -fs 12 -geometry 118x35+167+100 -hold -e "$scriptFILE $*";
  fi;
 fi;
 popd $scriptHOME > /dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
