###########################################################
# This example contains SML code with a bug (a local loop),
# which makes State Machine hanging, when AUTO_PILOT is ON.
# That is example of possible logical error(s) in FSM code.
# The bug (local loop) works by sequence:
#  AUTO_PILOT when (RUN not_in_state RUNNING) do X_ACTIVATE
#  RUN RECOVER          (call from AUTO_PILOT X_ACTIVATE)
#  EVT_BUILRED RECOVER  (fail if BUILDER in state RUNNING)
#  RUN START_RUN        (call from AUTO_PILOT X_ACTIVATE)
#      if (not EVT_BUILDER in_state READY) => RUN STOPPED
#  ... then loop again
# The call "do STOP EVT_BUILDER" in "RUN RECOVER" action
# removes this bug (local loop) and fix a logical error.
###########################################################

object: AUTO_PILOT
    state: OFF                                              !color: FwStateOKNotPhysics
        action: ACTIVATE
            if (RUN in_state ERROR) then
                do RECOVER RUN
            endif
            do START_RUN RUN
            move_to ON
    state: ON                                               !color: FwStateOkPhysics
    when (RUN not_in_state RUNNING) do X_ACTIVATE
        action: DISACTIVATE
            move_to OFF
        action: X_ACTIVATE
            if (RUN in_state ERROR) then
                do RECOVER RUN
            endif
            do START_RUN RUN
            move_to ON
            
object: RUN_TYPE
    state: TEST                                             !color: FwStateOKNotPhysics
        action: PHYSICS
            do LOG LOGGER
            if (LOGGER in_state LOGGING) then
                move_to PHYSICS
            endif
            move_to TEST
    state: PHYSICS                                          !color: FwStateOkPhysics
        action: TEST
            do NOLOG LOGGER
            if (LOGGER in_state NOT_LOGGING) then
                move_to TEST
            endif
            move_to PHYSICS
            
object: RUN
    parameters: int NUMBER_T = 0,
                int NUMBER_P = 0,
                RUN_MODE = "DEMO"
    state: STOPPED                                          !color: FwStateOKNotPhysics
        action: START_RUN
            set NUMBER_T = EVT_BUILDER<NUMBER_T>
            set NUMBER_P = EVT_BUILDER<NUMBER_P>
            if (not EVT_BUILDER in_state READY) then
                move_to STOPPED
            endif
            if (RUN_TYPE in_state PHYSICS) then
                do LOG LOGGER
                if (not LOGGER in_state LOGGING) then
                    move_to STOPPED
                endif
            endif
            if (LOGGER in_state LOGGING) then
                do X_OPEN_FILE LOGGER
            endif
            if (RUN_TYPE in_state PHYSICS) then
                set RUN_MODE = "PHYSICS"
                do START (TYPE="PHYSICS",NR=NUMBER_P) EVT_BUILDER
            else
                set RUN_MODE = "TEST"
                do START (TYPE="TEST",NR=NUMBER_T) EVT_BUILDER
            endif
            if (EVT_BUILDER in_state RUNNING) then
                move_to RUNNING
            endif
            move_to STOPPED
    state: RUNNING                                          !color: FwStateOkPhysics
    when (EVT_BUILDER in_state ERROR) do X_SET_ERROR
        action: STOP_RUN
            do STOP EVT_BUILDER
            if (LOGGER in_state WRITING) then
                do X_CLOSE_FILE LOGGER
            endif
            move_to STOPPED
        action: X_SET_ERROR
            if (LOGGER in_state WRITING) then
                do X_CLOSE_FILE LOGGER
            endif
            move_to ERROR
    state: ERROR                                            !color: FwAlarmFatalAck
        action: RECOVER
            do RECOVER EVT_BUILDER
        !   do STOP EVT_BUILDER         # uncomment this line to fix a bug 
            move_to STOPPED

object: LOGGER
    state: NOT_LOGGING                                      !color: FwCorporateColor
        action: LOG
            move_to LOGGING
    state: LOGGING                                          !color: FwStateOkNotPhysics
        action: NOLOG
            move_to NOT_LOGGING
        action: X_OPEN_FILE
            move_to WRITING
    state: WRITING                                          !color: FwStateOkPhysics
        action: X_CLOSE_FILE
            move_to LOGGING
        
object: EVT_BUILDER
    parameters: int NUMBER_T = 0, int NUMBER_P = 0
    state: READY                                            !color: FwStateOKNotPhysics
        action: START(TYPE, int NR)
            if (TYPE == "PHYSICS") then
                set NUMBER_P = NR + 1
            endif
            if (TYPE == "TEST") then
                set NUMBER_T = NR + 1
            endif
            move_to RUNNING
    state: RUNNING                                          !color: FwStateOkPhysics
        action: STOP
            move_to READY
    state: ERROR                                            !color: FwAlarmFatalAck
        action: RECOVER
            move_to READY
