#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
# Remove *.exe, *.dll, lib*.so and executable files placed
# in script directory and below. Includes only executables
# without extension with file full path like /…/name/name.
##########################################################

########################
# Script identification.
########################
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

function rm_file(){
 if [ -e "$1" ]; then
  rm -fv "$1";
 fi;
};

function clear_exe_dll(){
 if [ -d "$1" ]; then
  for fname in $(find "$1" -type f -name '*.exe' ); do
   rm_file "$fname";
  done;
  for fname in $(find "$1" -type f -name '*.dll' ); do
   rm_file "$fname";
  done;
  for fname in $(find "$1" -type f -name 'lib*.so' ); do
   rm_file "$fname";
  done;
  for fname in $(find "$1" -type f -executable ); do
   local bname="$(basename "$fname")";
   local dname="$(basename "$(dirname "$fname")")";
   if [ "$bname" = "$dname" ] && [ -z "$(echo -n "$bname" | grep '\.')" ]; then
    rm_file "$fname";
   fi;
  done;
  for dir in $(find "$1" -type d -empty -name backup); do rmdir -v "$dir"; done;
  for dir in $(find "$1" -type d -empty -name lib);    do rmdir -v "$dir"; done;
 fi;
};

function main(){
 if pushd $scriptHOME > /dev/null 2>&1; then
  clear_exe_dll "$scriptHOME";
 fi;
 popd $scriptHOME > /dev/null 2>&1;
};

main "$@";

##############
## END OF FILE
##############
