﻿---

[[toc]]

---

# Справка по DownSampling

Для ускорения рисования графиков в окнах **CurveWindow** добавлена команда
управления дискретностью (или понижения уровня
дискретности - **[DownSampling](./)**.
Для иллюстрации работы **DownSampling** имеется
демонстрационный **[пример](www.base.is/flot/index.html)**.

---

## Что такое DownSampling (понижение дискретности)

Понижение дискретности (**DownSampling**) - это способ кардинально
(в десятки раз) повысить скорость отображения графиков
при большом числе точек (например, больше **2000**). Идея понижения
дискретности проста. На экране есть ограниченное число пикселей,
например, **1920** пикселей по горизонтали. Строить график функции
с числом точек, намного превышающим число пикселей - бессмысленно,
т.к. близкие точки все равно сольются на экране в одну точку
(или один отрезок линии). Поэтому можно понизить число отображаемых
точек до разумного предела. Тогда их отображение происходит намного
быстрее. Фактически при понижении дискретности отображается только часть
точек из кривой, а остальные точки отбрасываются. Другими словами,
**DownSampling** - это выборка данных с пониженным числом точек,
представляющая (на экране) исходный (большой) массив данных.

Главным вопросом реализации **DownSampling** является
**репрезентативность** данных, т.е. качество представления (на экране)
большого объема данных с помощью выборки гораздо меньшего объема.
Для обеспечения репрезентативности был разработан целый ряд алгоритмов,
некоторые из которых описаны в диссертации **Sveinn Steinarsson**
 из университета Рейкьявика (Исландия),
см. **[ss_msthesis.pdf](ss_msthesis.pdf)**.
Предложенные в диссертации алгоритмы позволяют делать выборки данных,
которые при отображении графиков дают изображение, мало отличающееся
от изображения, построенного по всему (большому) массиву данных.
При этом получается большой (в десятки раз) выигрыш в скорости
построения графиков.

Общая идея понижения дискретности примерно такая.
Интервал аргумента **X** разбивается на заданное (**DownLeng**) число отрезков,
которые обычно называются "корзинками" (_bucket_), т.к. в этот отрезок попадает
некоторое количество точек исходных данных - и получается корзинка с данными.
В каждой корзинке среди точек исходных данных, попавших в эту корзинку,
по заданному методу выбирается "представитель" - т.е. точка, которая наиболее
точно (репрезантативно) представляет всю корзинку. Эта точка и берется для
рисования графика, а остальные точки отбрасываются. Подробности можно прочитать
в указанной выше диссертации.

---

## Параметры описания дискретности

Как следует из приведенного выше описания, **DownSampling**
применяется только к **большим данным** (т.е. кривым с большим
числом точек - назовем его **DataLeng**.
Кривые с числом точек ниже **порога** отображаются без понижения
дискретности (в исходном виде). Для вычисления порога для пониженного
числа точек (назовем его **DownLeng**) применяется следующий метод.

- Задается **`DownSampling.Method`** - алгоритм выборки данных
  для отображения из исходного массива.  
  Рекомендуемый алгоритм: **1** = **LargestTrianleThreeBuckets**.

- Задается **`DownSampling.Mode`** - режим работы, т.е. набор
  битовых флагов:  
    + **Бит 0** - разрешить использование **DownSampling**.
    + **Бит 1** - разрешить использование **AbsLen**.
    + **Бит 2** - разрешить использование **PerPix**.
    + **Бит 3** - разрешить использование **Tail**.

- Задается **`DownSampling.AbsLen`** - абсолютный порог для длины
  данных (т.е. для числа точек кривой).

- Задается **`DownSampling.PerPix`** - число точек на пиксель.
  Порог длины данных вычисляется как **`DownLeng=PerPix*PixWidth`**,
  где **`PixWidth`** - ширина графика в пикселях.

- Задается **`DownSampling.Tail`** - число "хвостовых" точек данных
  в конце кривой, которые остаются неизменными
  (т.е. не участвуют в понижении дискретности).
  Хвотовые точки нужны для отображения данных в режиме **Online**,
  когда данные добавляются в реальном времени, в том числе в процессе
  рисования кривых. Наличие неизменённого "хвоста" позволяет отображать
  данные, поступающие в реальном времени, без искажений.


При работе алгоритма перед построением графика вычисляется порог для
числа точек как **`DownLeng=Min(AbsLen,PerPix*PixWidth)`**,
где **`PixWidth`** - ширина графика в пикселях.
Если длина данных не превышает порога (т.е. **`DataLeng<=DownLeng`**),
график рисуется "как есть", без понижения дискретности.
Если число точек кривой больше порога и понижение дискретности разрешено,
применяется заданный алгоритм **DownSampling.Method**.
При этом число точек для отображения не будет превышать
пороговое значение независимо от размера исходных данных.

---

## Индикатор статуса дискретности

На панели инструментов окна кривых имеется команда "**Дискретность**".  
Её вид зависит от параметров дискретности:

- ![Дискретность запрещена](250-16x16-lightning.bmp) - понижение дискретности
  запрещено и график построен без понижения дискретности.

- ![Дискретность понижена](253-16x16-lightning.bmp) - дискретность
  разрешена и график был построен  с использованием понижения дискретности.

- ![Дискретность не задействована](258-16x16-lightning.bmp) - дискретность
  разрешена, но график был построен без понижения дискретности,
  т.к. число точек кривой оказалось ниже порога.

При нажатии кнопки появляется диалог:

![Параметры дискретности](downsampling_dialog.png)

В этом диалоге можно задать параметры понижения дискретности.

Также команда "**Дискретность** помещена в меню "**Правка**".

---

## Конфигурирование дискретности

Для задания начальных значений дискретности в пакете **CRW-DAQ**
добавлен параметр конфигурации:

``` ini
Файл Crw32.ini:

[System]
DefDownSamplingParams = 1, 15, 4096, 2, 3

где:
    1    - алгоритм LargestTrianleThreeBuckets
    15   - режим, разрешающий использование дискретности
    4096 - абсолютный порог для числа точек
    2    - число точек на пиксель для вычисления порога
    3    - число точек в "хвосте", которые не меняются
```
Также в конфигурацию окон кривых **DAQ** системы добавлен
параметр **[UsesDownSampling](../crw-daq-[windows].htm#curve_win)**,
принимающий значения **0/1** (по умолчанию **1**).  
Этот параметр позволяет отключать/включать использование дискретности в окне.


---

## Заключение

Алгоритм понижения дискретности позволяет кардинально (в десятки раз)
повысить скорость рисования графиков при большом (более **2000** точек)
числе точек кривой, причем скорость рисования будет слабо зависеть
от объема данных в кривой, т.к. выборка будет понижать число точек
до заданного порогового уровня.

При этом использование режима увеличения (**zoom**) позволяет
при необходимости рассматривать массив больших данных с любой степенью
подробности. При масштабировании рисуется только фрагмент кривой,
попавший в поле графика, так что начиная с определенного уровня
увеличения понижение дискретности автоматически выключается, когда
в поле графика попадает число точек ниже порога.
Это позволяет рассматривать данные быстро и без потери качества.

> В целом алгоритм управления
> дискретностью является значительным шагом вперед
> и позволяет эффективно работать с данными большого объема
> с высокой производительностью.


---

Желаю успешного использования алгоритма **DownSampling**.

---

> CRW-DAQ Copyright (c) 2001-2023 Alex Kuryakin <daqgroup@mail.ru>

---