program client;                             // Test client to illustrate DIM features.

{$APPTYPE CONSOLE}

uses
  Windows, SysUtils, _dim,_dimc;            // This demo uses addon client-server class library.

var
 DnsVersion   : TDicInfoService = nil;      // To receive DNS version.
 DicInfo1     : TDicInfoService = nil;      // I:Call counter; I:GetTickCount; D:Current time
 DicInfo2     : TDicInfoService = nil;      // X:System time as file time; C:Date and time string
 Terminated   : Boolean = false;            // Terminator for main loop

 //
 // Thread safe printing: Print(s,1) => StdOut, Print(s,2) => StdErr
 //
function Print(const Msg:AnsiString; n:Integer=1):DWORD;
var h:THandle;
begin
 if n=1 then h:=GetStdHandle(STD_OUTPUT_HANDLE) else
 if n=2 then h:=GetStdHandle(STD_ERROR_HANDLE) else h:=0;
 if not WriteFile(h,PChar(Msg)^,Length(Msg),Result,nil) then Result:=0;
end;

function PrintLn(const Msg:AnsiString; n:Integer=1):DWORD;
const Delimeter=#13#10;
begin
 Result:=Print(Msg+Delimeter,n);
end;

 //
 // Callback on receive DNS version
 //
procedure OnDnsVersionGot(Service:TDicInfoService);
begin
 if (Service<>nil) then
 try
  if (Service.MessageLeng=sizeof(Integer)) and (Service.Buffer.GetAsInteger = -1) then begin
   PrintLn('DNS server is dead. Please restart DNS.EXE.',2);
   Exit;
  end;
  if (Service.MessageLeng=sizeof(Integer))
  then PrintLn(Format('Got DNS version: %d, server:%s',[Service.Buffer.GetAsInteger,Service.ServerName]))
  else PrintLn(Format('Invalid data size: %d, server:%s',[Service.MessageLeng,Service.ServerName]),2);
 except
  on E:Exception do PrintLn(E.Message,2);
 end;
end;

 //
 // Callback on receive information service data
 //
procedure OnInfoGot(Service:TDicInfoService);
begin
 if (Service<>nil) then // Use Service.Buffer.GetAsType(Offset) to access data in Buffer.
 try
  if (Service.MessageLeng=SizeOf(Integer)) and (Service.Buffer.GetAsInteger = -1) then begin
   PrintLn(Format('Service %s disconnected. Please restart server.',[Service.ServiceName]));
   Exit;
  end;
  if (Service=DicInfo1) then begin
   if (Service.MessageLeng=Service.Buffer.Size) then begin
    PrintLn(Format('Got data: CallCount=%d, TickCount=%d, Now=%g from server %s PID %d',
                    [DicInfo1.Buffer.GetAsInteger(0),DicInfo1.Buffer.GetAsInteger(4),DicInfo1.Buffer.GetAsDouble(8),
                    Service.ServerName,Service.ServerPid]));
   end else PrintLn(Format('Invalid data set %s',[Service.ServiceName]));
  end else
  if (Service=DicInfo2) then begin // Message length may vary
   if (Service.MessageLeng>SizeOf(Int64)) and (Service.MessageLeng<=Service.Buffer.Size) then begin
    PrintLn(Format('Got data: FileTime=%d, DateTime=%s from server %s PID %d',
                    [DicInfo2.Buffer.GetAsInt64(0),DicInfo2.Buffer.GetAsString(8),
                    Service.ServerName,Service.ServerPid]));
   end else PrintLn(Format('Invalid data set %s',[Service.ServiceName]));
  end else
  PrintLn(Format('Invalid service %s',[Service.ServiceName]));
 except
  on E:Exception do PrintLn(E.Message,2);
 end;
end;

 //
 // Callback on command sent to server
 //
procedure OnCmndSent(Service:TDicCmndService; ret_code:Integer);
begin
 if (Service<>nil) then
 try
  if ret_code>0
  then PrintLn(Format('Sent command %s - Ok',[Service.ServiceName]))
  else PrintLn(Format('Could not send command %s',[Service.ServiceName]));
 except
  on E:Exception do PrintLn(E.Message,2);
 end;
end;

 //
 // Callback on Client Error
 //
procedure on_client_error(severity:Integer; error_code:Integer; error_message:PChar); cdecl;
begin
 try
  PrintLn(Format('%s - %s (%d) - %s',[FormatDateTime('yyyy.mm.dd-hh:nn:ss',Now),
                                      dim_severity_name(severity),error_code,error_message]));
  if (dic_get_error_services<>nil) and (strlen(dic_get_error_services)>0)
  then PrintLn('Error services: '+dic_get_error_services);
 except
  on E:Exception do PrintLn(E.Message,2);
 end;
end;

 //
 // Callback on DIM Exception
 //
procedure TheBugReport(E:Exception; O:TObject);
var Msg:AnsiString;
begin
 if (E=nil) then Exit;
 Msg:='Exception '+E.ClassName+': '+E.Message+'.';
 if (O<>nil) then Msg:=Msg+' Note: '+O.ClassName+'.';
 PrintLn(FormatDateTime('yyyy.mm.dd-hh:nn:ss',Now)+' - '+Msg);
end;

procedure Main;
var cmnd:AnsiString;
begin
 try
  //
  // 1. Initialize DIM, set DNS node.
  //
  dim_init;
  dis_disable_padding;
  dic_disable_padding;
  SetDimBugReport(TheBugReport);
  dic_add_error_handler(on_client_error);
  if GetDimDnsNode='' then SetDimDnsNode('localhost');
  if GetDimDnsNode='' then raise EDimFail.Create('Fail set DNS.');
  PrintLn('DIM_DNS_NODE='+GetDimDnsNode);
  //
  // 2. Subscribe DNS server version to call it only once.
  //
  DnsVersion:=TDicInfoService.Create('DIS_DNS/VERSION_NUMBER',DimServiceTypeSize('I'),ONCE_ONLY,10);
  DnsVersion.Filler.SetAsInteger(-1,0,true); // Data to send in case of timeout
  DnsVersion.OnInfoGot:=OnDnsVersionGot;     // Handler on data received
  //
  // 3. Subscribe information services published by server.
  //
  DicInfo1:=TDicInfoService.Create('DEMO/INFO1',DimServiceTypeSize('I:2;D'),MONITORED,10);
  DicInfo2:=TDicInfoService.Create('DEMO/INFO2',DimServiceTypeSize('X:1;C',256),MONITORED,10);
  DicInfo1.Filler.SetAsInteger(-1,0,true); // Data to send in case of timeout
  DicInfo2.Filler.SetAsInteger(-1,0,true); // Data to send in case of timeout
  DicInfo1.OnInfoGot:=OnInfoGot;           // Handler on data received
  DicInfo2.OnInfoGot:=OnInfoGot;           // Handler on data received
  //
  // 4. Start to serve published services.
  //
  if not DimClients.StartServing
  then raise EDicFail.Create('DIM Could not start clients!');
  //
  // 5. Main client loop
  //
  while not Terminated do begin
   PrintLn('Enter command to send to server (RESET for example):');
   readln(cmnd);
   if Length(cmnd)=0 then continue;
   if SameText(cmnd,'QUIT') then break;
   PrintLn(Format('Sending command: "%s"',[cmnd]));
   DicCmndSend('DEMO/COMMAND1',cmnd);
  end;
  //
  // 5. Stop DIM.
  //
  PrintLn('Stop DIM...');
  DimClients.StopServing;
  DimClients.FreeServices;
 except
  on E:Exception do PrintLn(E.Message,2);
 end;
 PrintLn('Goodbye.');
 Sleep(2000);
end;

begin
 Main;
end.



