@echo off

rem ############################################################
rem Copyright(c) 2018 by Alexey Kuryakin, Sarov Russia 20181127.
rem This script uses to open TCP ports for DimServer connections
rem ############################################################
:Main
if "%~1" == "" ( call :Usage & goto :EOF )
:CheckUserAccess
net session 1>nul 2>nul && goto :AccessGranted
echo Access denied to user "%UserName%".
ping -n 2 127.0.0.1 1>nul 2>nul
goto :EOF
:AccessGranted
echo Access granted to user "%UserName%".
echo.
echo Enable firewall ports for DIM...
echo.
setlocal
call :CheckArguments %*
call :CheckInterface vboxnet0 vboxnet0found
if "%todo%" == "" ( call :Usage & goto :EOF )
if /I "%todo%" == "show" ( call :FirewallShowPortopening & goto :EOF )
for /L %%i in (2505,1,2505) do call :FirewallPortopening TCP %%i "DIM DNS"  %mode% "SUBNET" ALL vboxnet0
for /L %%i in (5100,1,5120) do call :FirewallPortopening TCP %%i "DIM DATA" %mode% "SUBNET" ALL vboxnet0
for /L %%i in (2500,1,2501) do call :FirewallPortopening TCP %%i "DIM WEB"  %mode% "SUBNET" ALL vboxnet0
endlocal
goto :EOF

:FirewallPortopening
if "%~1" == "" goto :EOF & if "%~2" == "" goto :EOF & if "%~3" == "" goto :EOF & if "%~4" == "" goto :EOF & if "%~5" == "" goto :EOF & if "%~6" == "" goto :EOF
if /I "%todo%" == "add"    netsh firewall add    portopening protocol = %~1 port = %~2 name = "%~1 %~2 - %~3" mode = %~4 scope = %~5 profile = %~6    1>nul && echo %todo% %~1 %~2 %~4 success, profile %~6   || echo %todo% %~1 %~2 %~4 failed, profile %~6
if /I "%todo%" == "delete" netsh firewall delete portopening protocol = %~1 port = %~2                                               profile = %~6    1>nul && echo %todo% %~1 %~2     success, profile %~6   || echo %todo% %~1 %~2 %~4 failed, profile %~6
if "%~7" == "" goto :EOF & if "%vboxnet0found%" == "0" goto :EOF
if /I "%todo%" == "add"    netsh firewall add    portopening protocol = %~1 port = %~2 name = "%~1 %~2 - %~3" mode = %~4             interface = %~7  1>nul && echo %todo% %~1 %~2 %~4 success, interface %~7 || echo %todo% %~1 %~2 %~4 failed, interface %~7
if /I "%todo%" == "delete" netsh firewall delete portopening protocol = %~1 port = %~2                                               interface = %~7  1>nul && echo %todo% %~1 %~2     success, interface %~7 || echo %todo% %~1 %~2 %~4 failed, interface %~7
goto :EOF

:CheckArguments
set todo=
set mode=ENABLE
:CheckArgumentsLoop
if "%~1" == "" goto :EOF
call :CheckArgumentsLoop %2 %3 %4 %5 %6 %7 %8 %9
if /I "%~1" == "ADD"      set todo=add
if /I "%~1" == "SHOW"     set todo=show
if /I "%~1" == "DELETE"   set todo=delete
if /I "%~1" == "ENABLE"   set mode=ENABLE
if /I "%~1" == "DISABLE"  set mode=DISABLE
goto :EOF

:FirewallShowPortopening
netsh firewall show portopening verbose = ENABLE 
goto :EOF

:CheckInterface
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
set /a %~2=0
for /F %%j in ('ipconfig ^| findstr /i /c:"%~1"') do set /a %~2+=1
goto :EOF

:Usage
echo.
echo Copyright^(c^) 2018 Alexey Kuryakin kouriakine@mail.ru
echo %~n0 - tool to add/delete/enable/disable DIM ports
echo DIM uses TCP ports 2505,5100..5108
echo see http://http://dim.web.cern.ch
echo.
echo Usage:
echo  %~n0               - help
echo  %~n0 show          - show all opened ports
echo  %~n0 delete        - delete opened   DIM ports
echo  %~n0 add           - add and enable  DIM ports
echo  %~n0 add enable    - add and enable  DIM ports
echo  %~n0 add disable   - add and disable DIM ports
echo.
goto :EOF

:SamplesToCopy
echo Delete ports from profile ALL...
netsh firewall delete portopening protocol = TCP port = 2505 profile = ALL
netsh firewall delete portopening protocol = TCP port = 5100 profile = ALL
netsh firewall delete portopening protocol = TCP port = 5101 profile = ALL
netsh firewall delete portopening protocol = TCP port = 5102 profile = ALL
echo Delete ports from interface vboxnet0...
netsh firewall delete portopening protocol = TCP port = 2505 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 5100 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 5101 interface = vboxnet0
netsh firewall delete portopening protocol = TCP port = 5102 interface = vboxnet0
echo Add ports to profile ALL...
netsh firewall add portopening protocol = TCP port = 2505 name = "TCP 2505 - DIM DNS" mode = ENABLE scope = SUBNET profile = ALL
netsh firewall add portopening protocol = TCP port = 5100 name = "TCP 5100 - DIM DATA" mode = ENABLE scope = SUBNET profile = ALL
netsh firewall add portopening protocol = TCP port = 5101 name = "TCP 5101 - DIM DATA" mode = ENABLE scope = SUBNET profile = ALL
netsh firewall add portopening protocol = TCP port = 5102 name = "TCP 5102 - DIM DATA" mode = ENABLE scope = SUBNET profile = ALL
echo Add ports to interface vboxnet0...
netsh firewall add portopening protocol = TCP port = 2505 name = "TCP 2505 - DIM DNS" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 5100 name = "TCP 5100 - DIM DATA" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 5101 name = "TCP 5101 - DIM DATA" mode = ENABLE interface = vboxnet0
netsh firewall add portopening protocol = TCP port = 5102 name = "TCP 5102 - DIM DATA" mode = ENABLE interface = vboxnet0
echo Firewall show firewall portopening...
netsh firewall show portopening verbose = ENABLE 
goto :EOF