 //
 // Standard types for StdLibrary
 //
 TTagRef = record   // Tag related data
  tag : Integer;    // Tag reference handle
  nai : Integer;    // Analog  Input  number
  nao : Integer;    // Analog  Output number
  ndi : Integer;    // Digital Input  number
  ndo : Integer;    // Digital Output number
  ref : Integer;    // Associated Reference
  crv : Integer;    // Associated Curve
  tid : Integer;    // Associated Task Id
  pid : Integer;    // Associated Process Id
  cid : Integer;    // Associated Command Id
  key : Integer;    // Associated Key
  lnk : Integer;    // Associated Link
  obj : Integer;    // Associated Object
  dat : Real;       // Associated Data
  val : Real;       // Associated Value
  tim : Real;       // Associated Time stamp
 end;               ////////////////////////
 //
 // Statistics sums
 //
 TStatSum2D     = record    // Stat. sums in 2D space:
  Num           : Integer;  // Number of data entries
  Sum, Mean     : record    // Sum and Mean values
   X,Y,XX,XY,YY : Real;     // Of (X, Y, X*X, X*Y, Y*Y)
  end;                      //
  Disp, Sigma   : record    // Dispersion + RMSD
   X,Y          : Real;     // Of (X, Y)
  end;                      //
  CovXY         : Real;     // Covariation of (X,Y)
  Line          : record    // Linear regression:
   C0,C1        : Real;     // Y = C0 + C1 * X
   Disp, Sigma  : Real;     // Dispersion + RMSD
   Corr         : Real;     // Linear correlation
  end;                      //
  TimeStamp     : Real;     // Time stamp for updates
 end;                       /////////////////////////
 //
 // Type TVector uses to implement one-dimension, zero-base array
 // Vector is a string buffer that implements dynamic size arrays
 //
 TVector = String;
 //
 // For compatibility with crwlib
 //
 LongString = String;
