 {
 Standard routines for Tasks:
 function  Task_Readln(tid:Integer; var Line,Buff:String):Boolean;
 function  ExecCmdWait(ExeFile,CmdLine,Priority,OutFile:String; Display,TimeOut:Integer):Boolean;
 procedure CheckBorlndmmDll(ServerExe:String);
 function  PidCounter(exe:String):Integer;
 function  RunSysCommand(CmdLine,Params,InText:String; var OutText:String; Timeout:Integer):Integer;
 function  RunSysCommandAsText(CmdLine,Params,InText:String; var Code:Integer; Timeout:Integer):String; 
 function  ExecuteProcessSafe(cmd,arg,opt:String; timeout:Integer):Integer;
 procedure ClearStdTasks;
 procedure InitStdTasks;
 procedure FreeStdTasks;
 procedure PollStdTasks;
 }
 {
 Read line (Line) from task (tid) stdout pipe with CR or LF line terminator (EOL).
 Temporary buffer (Buff) should be global lifetime variable with startup initialization.
 }
 function Task_Readln(tid:Integer; var Line,Buff:String):Boolean;
 const MaxLeng = 16384;
 var p:Integer;
 begin
  Line:='';
  Task_Readln:=False;
  if (Task_Pid(tid)<>0) then begin
   if (Length(Buff)<MaxLeng) and (Task_RxCount(tid)>0)
   then Buff:=Buff+Task_Recv(tid,MaxLeng-Length(Buff));
   p:=PosEol(Buff,1,0);
   if (p>0) then begin
    Task_Readln:=True;
    if (p>1) then Line:=Copy(Buff,1,p-1);
    Buff:=Copy(Buff,PosEol(Buff,p,1),MaxInt);
   end else begin
    if (Length(Buff)>=MaxLeng) then begin
     Trouble('Received line is too long!');
     Buff:='';
    end;
   end;
  end;
 end;
 {
 Execute ExeFile with CmdLine parameters, redirect StdOut to OutFile and wait.
 Terminate process execution if it is running longer then TimeOut milliseconds.
 }
 function ExecCmdWait(ExeFile,CmdLine,Priority,OutFile:String; Display,TimeOut:Integer):Boolean;
 var pid:Integer; t0:Real;
 begin
  ExecCmdWait:=False;
  if FileExists(ExeFile) then begin
   pid:=Task_Init(ExeFile+' '+CmdLine);
   sNul(Task_Ctrl(pid,'Display='+Str(Display)));
   if Length(OutFile)>0 then sNul(Task_Ctrl(pid,'StdOutFileName='+OutFile));
   if Length(Priority)>0 then sNul(Task_Ctrl(pid,'ProcessPriority='+Priority));
   t0:=mSecNow;
   if Task_Run(pid) then begin
    while (mSecNow-t0<TimeOut) and Task_Wait(pid,1) do bNul(wdt_Reset(True)>0);
    if Task_Wait(pid,0) then begin
     bNul(Task_Kill(pid,0,1,1000));
     bNul(FileErase(OutFile));
    end else ExecCmdWait:=True;
   end;
   bNul(Task_Free(pid));
  end;
 end;
 {
 Check borlndmm.dll presence, copy from home directory if needed.
 }
 procedure CheckBorlndmmDll(ServerExe:String);
 begin
  if FileExists(ServerExe) then begin
   if not FileExists(AddBackSlash(ExtractFilePath(ServerExe))+'borlndmm.dll')
   then bNul(FileCopy(AddBackSlash(ParamStr('HomeDir'))+'borlndmm.dll'+' '+
                      AddBackSlash(ExtractFilePath(ServerExe))+'borlndmm.dll'));
   if not FileExists(AddBackSlash(ExtractFilePath(ServerExe))+'borlndmm.dll')
   then Trouble('Could not find borlndmm.dll');
  end;
 end;
 {
 Return number of exe program instances running now.
 Example: PidCounter('Crw32.exe')
 }
 function PidCounter(exe:String):Integer;
 var t,i,n:Integer;
 begin
  n:=0;
  exe:=Trim(exe);
  if Length(exe)>0 then begin
   t:=PidList(Text_New);
   for i:=0 to Text_Numln(t)-1 do
   if IsSameText(exe,Trim(SkipWords(4,Text_GetLn(t,i)))) then n:=n+1;
   bNul(Text_Free(t));
  end;
  PidCounter:=n;
 end;
 {
 Run operation system Command (CmdLine),
 use Params, on startup send InText to process StdIn.
 Return Exit Code or -1 on fail and OutText from StdOut.
 Example: RunSysCommand('uname -n','HomeDir=/tmp','',outstr,2000);
 }
 function RunSysCommand(CmdLine,Params,InText:String; var OutText:String; Timeout:Integer):Integer;
 var code,tid,pid,i,p:Integer; s,sn,sv:String; ms,deadline:Real;
 begin
  s:=''; sn:=''; sv:='';
  code:=-1; OutText:='';
  CmdLine:=Trim(CmdLine); ms:=msecnow;
  if (CmdLine<>'') and (Timeout>0) then begin
   tid:=task_init(CmdLine);
   sNul(task_ctrl(tid,'Display=0'));
   sNul(task_ctrl(tid,'StdInPipeSize=65536'));
   sNul(task_ctrl(tid,'StdOutPipeSize=65536'));
   if (Params<>'') then
   for i:=0 to TextLineCount(Params,EOL)-1 do begin
    s:=ExtractTextLine(i,Params,EOL);
    p:=ExtractNameValuePair(s,sn,sv,'=',3);
    if (p>0) then sNul(task_ctrl(tid,sn+'='+sv));
    sNul(task_ctrl(tid,'TxSync=1000'));
   end;
   if task_run(tid) then begin
    pid:=task_pid(tid);
    if (InText<>'') then iNul(task_send(tid,InText));
    deadline:=msecnow+timeout;
    repeat
     if (task_rxcount(tid)>0) then
     OutText:=OutText+task_recv(tid,MaxInt);
     if not task_wait(tid,1) then deadline:=0;
    until (msecnow>deadline);
    if task_wait(tid,0) then begin
     if not task_kill(tid,1,1,500) then
     if not task_kill(tid,0,1,500) then
     Problem('Could not kill PID '+Str(pid));
    end;
    code:=task_result(tid);
    sNul(task_ctrl(tid,'RxSync=1000'));
    if (task_rxcount(tid)>0) then
    OutText:=OutText+task_recv(tid,MaxInt);
   end;
   bNul(task_free(tid));
  end;
  if DebugFlagEnabled(dfDetails)
  then Details('RunCommand('+cmdline+') = '+Str(code)
  +', '+Str(length(OutText))+' bytes read, '+Str(msecnow-ms)+' ms elapsed');
  RunSysCommand:=code;
  s:=''; sn:=''; sv:='';
 end;
 {
 Run operation system Command (CmdLine) as text,
 use Params, on startup send InText to process StdIn.
 Return OutText from StdOut and Exit Code (or -1 on fail).
 Example: RunSysCommand('uname -n','HomeDir=/tmp','',outstr,2000);
 }
 function RunSysCommandAsText(CmdLine,Params,InText:String; var Code:Integer; Timeout:Integer):String; 
 var s:String;
 begin
  s:='';
  Code:=RunSysCommand(CmdLine,Params,InText,s,TimeOut);
  RunSysCommandAsText:=s;
  s:='';
 end;
 {
 Execute process by command (cmd  with arguments (arg) with options (opt) and timeout.
 }
 function ExecuteProcessSafe(cmd,arg,opt:String; timeout:Integer):Integer;
 var tid,i,list,code:Integer; ms:Real;
 begin
  code:=-1;
  ms:=mSecNow;
  cmd:=Trim(cmd); arg:=Trim(arg);
  if (cmd+arg<>'') and (timeout>0) then begin
   tid:=task_init(Trim(cmd+' '+arg));
   if (tid<>0) then begin
    if (opt<>'') then begin
     list:=StringToText(opt);
     for i:=0 to text_numln(list)-1 do
     if (Pos('=',text_getln(list,i))>0)
     then sNul(task_ctrl(tid,Trim(text_getln(list,i))));
     bNul(text_free(list));
    end;
    if task_run(tid) then begin
     if task_wait(tid,timeout) then
     if task_wait(tid,0) then bNul(task_kill(tid,1,1,500));
     if task_wait(tid,0) then bNul(task_kill(tid,0,1,500));
     code:=task_result(tid);
    end;
    ms:=mSecNow-ms;
    if DebugFlagEnabled(dfDetails)
    then Details('Executed: '+task_ctrl(tid,'CmdLine')+EOL+
     'ExitCode: '+Str(code)+', Time: '+Str(Round(ms))+' ms');
    bNul(task_free(tid));
   end;
  end;
  ExecuteProcessSafe:=code;
 end;
 {
 Clear standard Tasks.
 }
 procedure ClearStdTasks;
 begin
 end;
 {
 Initialize standard Tasks.
 }
 procedure InitStdTasks;
 begin
  CurrentProcessId:=Val(GetEnv('CRW_DAQ_SYS_EXE_PID'));
  ShouldPollStdTasks:=false;
 end;
 {
 Finalize standard Tasks.
 }
 procedure FreeStdTasks;
 begin
 end;
 {
 Poll standard Tasks.
 }
 procedure PollStdTasks;
 begin
 end;
