 {
 ***********************************************************************
 Daq Pascal application program R4WIRE.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Rs#i          - print resistance Rs#i, i=0..num.AO's.
| @Rs#i R        - set value R of reference resistor Rs#i.
|********************************************************
[]
 ***********************************************************************
 Example:
 [DeviceList]
 &DEMO.R(T) = device software program
 [&DEMO.R(T)]
 Comment       = 4-wire resistance calculation (R in Ohms)
 InquiryPeriod = 1
 DevicePolling = 10, tpTimeCritical
 ProgramSource = ~~\Resource\DaqSite\StdLib\DaqPas\_R4WIRE.PAS
 DebugFlags    = 3
 OpenConsole   = 2
 Rs            = 100 ; Default value of Rs
 ;*************** Rs per channel
 Rs#0          = 100.05
 Rs#1          = 100.02
 Rs#2          = 100.04
 ;*************** Analog Inputs
 AnalogFifo    = 512
 AnalogInputs  = 6
 Link AnalogInput  0 with curve DEMO.ai_0
 Link AnalogInput  1 with curve DEMO.ai_1
 Link AnalogInput  2 with curve DEMO.ai_2
 Link AnalogInput  3 with curve DEMO.ai_3
 Link AnalogInput  4 with curve DEMO.ai_4
 Link AnalogInput  5 with curve DEMO.ai_5
 ;*************** Analog outputs: AO(i) = Rs#i * AI(2*i)/AI(2*i+1)
 AnalogOutputs = 3
 Link AnalogOutput  0 with curve DEMO.R_0  history 100
 Link AnalogOutput  1 with curve DEMO.R_1  history 100
 Link AnalogOutput  2 with curve DEMO.R_2  history 100
 ***********************************************************************
 }
program R4WIRE;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxChannel        = 1023;       { Maximal channel number           }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 Rs     : array[0..MaxChannel] of Real; { Reference resistance Rs   }
 LastX  : array[0..MaxChannel] of Real; { X of last point processed }
 cmd_Rs : array[0..MaxChannel] of Integer; { Command @Rs#i          }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Calculate resistance for 4-wire Pt100 or Ni100 connection.
 R(T)=Rs*y2/y1, y2 connected || Rt, y1 connected || Rs.
 Get minimal of x1,x2, then calculate y2/y1 using interpolation.
 Check for division by zero case.
 }
 procedure CalculateRT(i:Integer);
 var i1,i2:Integer; x1,y1,x2,y2,x,y:Real;
 begin
  i1:=i*2;
  i2:=i1+1;
  {avoid case of too few points}
  if (getai_n(i1)>1) and (getai_n(i2)>1) then begin
   x1:=getai_xn(i1);
   x2:=getai_xn(i2);
   x:=min(x1,x2);
   if x>LastX[i] then begin
    y1:=getai(i1,x);
    y2:=getai(i2,x);
    y:=Rs[i]*y2/y1;
    if not isnan(y) and not isinf(y) then UpdateAo(i,x,y);
    LastX[i]:=x;
   end;
  end;
 end;
 {
 Read resistances Rs#0 = ..., Rs#1 = ..., etc
 }
 procedure ReadRs;
 var i:Integer; s:String;
 begin
  s:='';
  for i:=0 to numaos-1 do begin
   s:=ReadIni('Rs#'+Str(i));
   if Length(s)=0 then s:=ReadIni('Rs');
   Rs[i]:=rval(s);
   if IsNan(Rs[i]) or (Rs[i]<=0)
   then Trouble('Rs#'+Str(i)+' = '+Str(Rs[i])+' - invalid')
   else Success('Rs#'+Str(i)+' = '+Str(Rs[i]));
  end;
  s:='';
 end;
 {
 Calculate RvsT for each channel
 }
 procedure CalcRvsT;
 var i:Integer;
 begin
  for i:=0 to numaos-1 do CalculateRT(i);
 end;
 {
 GUI Handler to process user input...
 }
 procedure GUIHandler;
 var ClickCurve:Integer;
 begin
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
      bNul(Voice(snd_Click));
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditState=ef_Done then begin
   {
   Warning, Information dialog completion.
   }
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Warning') then sNul(Edit(''));
   if IsSameText(ExtractWord(1,Edit('?ans 0')),'Information') then sNul(Edit(''));
  end;
  if EditState=ef_Done then begin
   Problem('Uncompleted edit detected!');
   sNul(Edit(''));
  end else
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Edit error detected!');
   sNul(Edit(''));
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 var i:Integer;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  for i:=0 to numaos-1 do
  cmd_Rs[i]:=RegisterStdInCmd('@Rs#'+Str(i),'');
  ReadRs;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  CalcRvsT;
  GUIHandler;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; i:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   @Rs#0 100
   }
   for i:=0 to numaos-1 do
   if (cmdid = cmd_Rs[i]) then begin
    r:=rEvalDef(ExtractWord(1,arg),_NaN);
    if not IsNan(r) and (r>0) then Rs[i]:=r;
    Success(cmd+'='+Str(Rs[i]));
    Data:='';
   end;
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
