 {
 Программа-передатчик для организации связи по сети через сетевой файл.
 ***************************************************************************
 Передает данные со входов AnalogInput(...) в виде потока событий
 (то есть пакетов <канал,время,данные>). Время глобальное в миллисекундах.
 ***************************************************************************
 Для организации односторонней связи передатчика Tx и приемника Rx 
 используется обмен через сетевые файлы Tx,Rx.
 Логика работы такая:
 1) При старте передатчик удаляет файл Tx, а приемник Rx
 2) В цикле опроса передатчик создает файл Tx (если его нет) и записывает 
    в него данные. 
 3) Если файл Rx не существует, то передатчик закрывает файл Tx,
    переименовывает его в Rx и создает новый пустой файл Tx.
 4) Если оба файла Rx и Tx существуют, значит передатчик уже закрыл файл Tx,
    переименовал его и открыл новый. Теперь приемник может безопасно 
    прочитать данные из Rx. 
 5) После чтения данных из файла приемник должен закрыть и удалить файл Rx. 
    Исчезновение файла Rx уведомляет передатчика о том, что данные уже
    прочитаны что можно перейти к следующему циклу.
 Для организации двусторонней связи надо использовать две односторонние.
 То же самое в псевдокоде:
 program Transmitter;
 begin
  fileerase(Tx);
  rewrite(Tx);
  while not quit do begin
   write(Tx,data);
   if not fileexists(Rx) then begin
    close(Tx);
    filerename(Tx,Rx);
    rewrite(Tx);
   end;
  end;
  close(Tx);
  fileerase(Tx);
 end.
 program Receiver;
 begin
  fileerase(Rx);
  while not quit do begin
   if fileexists(Rx) and fileexists(Tx) then begin
    reset(Rx);
    while not eof(Rx) do read(Rx,data);
    close(Rx);
    fileerase(Rx);
   end;
  end;
  fileerase(Rx);
 end.
 ***************************************************************************
 Конфигурация:
 1) В секции тегов должны быть:
  [TagList]
  TxFile     = string  \\alex\datapipe\$pipe.tx ; сетевой файл Tx
  RxFile     = string  \\alex\datapipe\$pipe.rx ; сетевой файл Rx
  TxEnable   = integer 1                        ; разрешение передатчика
  TxErrors   = real    0                        ; счетчик ошибок передатчика
 2) В секции передатчика указать:
  [DeviceList]
  &Transmitter = device software program
  [&Transmitter]
  AnalogInputs = 2
  Link AnalogInput 0 with curve data1
  Link AnalogInput 1 with curve data2
  ProgramSource = ..\daqpas\_pipetx
  PipeSize = 2048        ; максимальное число событий в очереди передатчика
  TagTxFile = TxFile     ; имя string  тега с именем сетевого файла Tx
  TagRxFile = RxFile     ; имя string  тега с именем сетевого файла Rx
  TagTxEnable = TxEnable ; имя integer тега разрешения передачи
  TagTxErrors = TxErrors ; имя real    тега счетчика ошибок передачи
 ***************************************************************************
 }
program _pipetx;
const
 maxai       = 255;
var
 b           : boolean;
 Ok          : boolean;
 errors      : integer;
 tagTxEnable : integer;
 tagTxErrors : integer;
 i           : integer;
 n           : integer;
 t0          : real;
 ti          : real;
 xi          : real;
 yi          : real;
 cnt         : integer;
 maxcnt      : integer;
 TxFile      : string;
 RxFile      : string;
 TxOpen      : boolean;
 lastxi      : array[0..maxai] of real;
 {
 Фиксация ошибки вывода в файл Tx, инкрементирует счетчик ошибок
 }
 procedure TxError(n:integer);
 var b:boolean;
 begin
  b:=rsettag(tagTxErrors,rgettag(tagTxErrors)+1);
 end;
 {
 Процедура инициализации и проверки тега
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 Действия при старте программы
 }
 if runcount=1 then begin
  {
  Найти время старта в глобальных миллисекундах
  }
  t0:=int(msecnow-time*timeunits);
  {
  Найти число каналов и занулить некоторые переменные
  }
  n:=numais;
  if n>maxai+1 then n:=maxai+1;
  for i:=0 to n-1 do lastxi[i]:=0;
  cnt:=0;
  errors:=0;
  TxOpen:=false;
  {
  Прочитать данные из конфигурации и инициализировать теги
  }
  TxFile:=sgettag(findtag(readini('TagTxFile')));
  RxFile:=sgettag(findtag(readini('TagRxFile')));
  maxcnt:=val(readini('PipeSize'));
  if maxcnt<1024 then maxcnt:=1024;
  InitTag(tagTxEnable,readini('TagTxEnable'),1);
  InitTag(tagTxErrors,readini('TagTxErrors'),2);
  b:=rsettag(tagTxErrors,0);
  {
  Удаление файла Tx и анализ ошибок
  }
  if length(TxFile)=0 then errors:=errors+1 else
  if not fileerase(TxFile) then errors:=errors+1;
  if length(RxFile)=0 then errors:=errors+1;
  if n=0 then errors:=errors+1;
  if errors<>0 then b:=fixerror(9);
  Ok:=(errors=0);
 end else
 {
 Действия при остановке программы
 }
 if isinf(runcount) then begin
  {
  Закрыть файл Tx и удалить его
  }
  b:=(rewrite('')=0) and fileerase(TxFile);
  TxFile:='';
  RxFile:='';
  TxOpen:=false;
 end else
 {
 Действия в цикле опроса программы
 }
 if Ok then begin
  {
  Если передача разрешена - передаем события
  Данные передаем только если время изменилось,
  это нужно чтобы не передавать данные дважды.
  Время переводим в глобальные миллисекунды.
  }
  if igettag(tagTxEnable)>0 then begin
   for i:=0 to n-1 do begin
    xi:=getai_xn(i);
    if xi>lastxi[i] then begin
     lastxi[i]:=xi;
     yi:=getai_yn(i);
     if not TxOpen then TxOpen:=(rewrite(TxFile)=0);
     if not TxOpen then TxError(1) else
     if cnt>maxcnt then begin
      TxError(2);
      TxOpen:=(rewrite(TxFile)=0);
      cnt:=0;
     end else begin
      ti:=int(t0+xi*timeunits);
      writeln(i:1,' ',ti:1:0,' ',yi);
      if ioresult<>0 then TxError(3);
      cnt:=cnt+1;
     end;
    end;
   end;
   if not fileexists(RxFile) then begin
    if rewrite('')<>0 then TxError(4);
    if not filerename(TxFile+' '+RxFile) then TxError(5); 
    TxOpen:=(rewrite(TxFile)=0);
    cnt:=0;
   end;
  end else begin
   if TxOpen then begin
    if rewrite('')<>0 then TxError(6);
    TxOpen:=false;
   end;
  end;
  {
  Отработка нажатий сенсоров
  }
  if clickbutton=1 then begin
   {
   Кнопка разрешения передачи
   }
   if clicktag=tagTxEnable then begin
    b:=voice('нажато');
    b:=isettag(tagTxEnable,ord(igettag(tagTxEnable)=0));
   end;
   {
   Очистка счетчика ошибок
   }
   if clicktag=tagTxErrors then begin
    b:=voice('нажато');
    b:=rsettag(tagTxErrors,0);
   end;
  end;
 end;
end.
