 {
 ***********************************************************************
 Daq Pascal application program _LINCORR.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Reset                 - reset all channels.
| @Reset n               - reset channel number n.
| @Clear                 - clear all AO curves connected.
| @Clear n               - clear AO[n] curve connected.
|********************************************************
[]
 ***********************************************************************
 Description:
  For each AI calculate Linear Correlation coeff. (C0,C1) calculated as
  linear regression y=C0+C1*(x-xc) where xc=LastX-SmoothWind
  with window [xc-SmoothWind,xc+SmoothWind].
 Configuration:
  AI[n]     - Input data signal, n=0..AnalogInputs-1.
  AO[2*n]   - coefficient C0.
  AO[2*n+1] - coefficient C1.
 Tags:
  tagGate or tagGateN   (N=0..NumAis-1) - Integer gate tag(s).
  tagSmoothWind or tagSmoothWindN (N=0..NumAis-1) - Real window tag(s).
  Gate tags may be passed, by default Gate=1.
 Example:
  [DeviceList]
  &LinCorr = device software program
  [&LinCorr]
  Comment       = Linear Correlation calculator
  InquiryPeriod = 1
  DevicePolling = 1000, tpNormal
  ProgramSource = ..\DaqPas\_lincorr.pas
  OpenConsole   = 2
  DebugFlags    = 15
  AnalogInputs  = 2
  Link AnalogInput  0 with curve SIGNAL1
  Link AnalogInput  1 with curve SIGNAL2
  AnalogOutputs = 4
  Link AnalogOutput  0 with curve AVERAGE1  history 1000
  Link AnalogOutput  1 with curve DERIVAT1  history 1000
  Link AnalogOutput  2 with curve AVERAGE2  history 1000
  Link AnalogOutput  3 with curve DERIVAT2  history 1000
  tagGate       = SMOOTH_GATE
  tagSmoothWind = SMOOTH_WINDOW
  AutoReset     = 0
  []
 ***********************************************************************
 }
program _LinCorr;                { Calculate Linear Correlation     }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxNumAis         = 1024;       { Maximum number of AnalogInputs   }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 LastX             : array[0..MaxNumAis] of Real; { Last X marker   }
 tagGate           : array[0..MaxNumAis] of Integer; { Gate tags    }
 tagSmoothWind     : array[0..MaxNumAis] of Integer; { Smooth wind  }
 LastGate          : array[0..MaxNumAis] of Integer; { Last value   }
 AutoReset         : Boolean;    { Auto reset on Gate front         }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Clear AO curves corresponded to AI[n] or all AO curves if n<0.
 }
 procedure LINCORR_Clear(n:Integer);
 var nai,cao:Integer;
 begin
  for nai:=0 to NumAis-1 do
  if (n=nai) or (n<0) then begin
   cao:=RefAo(2*nai);
   if cao<>0 then rNul(CrvDel(cao,1,MaxInt));
   cao:=RefAo(2*nai+1);
   if cao<>0 then rNul(CrvDel(cao,1,MaxInt));
  end;
 end;
 {
 Reset channel n or all channels if n<0.
 Reset includes AO clear & LastX marker.
 }
 procedure LINCORR_Reset(n:Integer);
 var nai,cai:Integer;
 begin
  for nai:=0 to NumAis-1 do
  if (n=nai) or (n<0) then begin
   cai:=RefAi(nai);
   if cai<>0 then begin
    bNul(CrvLock(cai));
    if CrvLen(cai)=0
    then LastX[nai]:=_MinusInf
    else LastX[nai]:=CrvX(cai,CrvLen(cai));
    bNul(CrvUnLock(cai));
   end;
  end;
  LINCORR_Clear(n);
 end;
 {
 Initialize tag from INI file nick names.
 For example InitTagByNick(tagGate,'tagGate1 tagGate',1)
 will seach for Integer tag ReadIni('tagGate1'), then ReadIni('tagGate').
 }
 procedure InitTagByNicks(var tag:Integer; nicks:String; typ:Integer);
 var i:Integer;
 begin
  tag:=0;
  for i:=1 to WordCount(nicks) do
  if TypeTag(tag)=0 then begin
   tag:=FindTag(ReadIni(ExtractWord(i,nicks)));
   if (typ<>0) and (TypeTag(tag)<>abs(typ)) then tag:=0;
   if (typ<>0) and (TypeTag(tag)>0) then Success('Init tag '+NameTag(tag)+' by nick '+ExtractWord(i,nicks));
  end;
  if TypeTag(tag)=0 then begin
   if typ>0 then Trouble('Can`t init tag by nicks:'+nicks);
   if typ<0 then Problem('Can`t init tag by nicks:'+nicks);
  end;
 end;
 {
 Initialize.
 }
 procedure LINCORR_Init;
 var nai:Integer;
 begin
  AutoReset:=(Val(ReadIni('AutoReset'))=1);
  for nai:=0 to NumAis-1 do begin
   LastGate[nai]:=0;
   InitTagByNicks(tagGate[nai],       'tagGate'  +Str(nai)+' tagGate',           -1);
   InitTagByNicks(tagSmoothWind[nai], 'tagSmoothWind'+Str(nai)+' tagSmoothWind', -2);
  end;
  LINCORR_Reset(-1);
 end;
 {
 Polling.
 }
 procedure LINCORR_Poll;
 var nai,tag,Gate,cai,i,ia,ib,Entries:Integer;
     x,y,xa,xb,xc,SmoothWind,SummX,SummY,SummXX,SummYY,SummXY:Real;
     MeanX,MeanY,MeanXX,MeanYY,MeanXY,CovXY,DispX,DispY,SigmaX,SigmaY:Real;
     LineC0,LineC1,LineDisp,LineSigma,LineCorr:Real;
 begin
  for nai:=0 to NumAis-1 do begin
   tag:=tagGate[nai]; if TypeTag(tag)=1 then Gate:=iGetTag(tag) else Gate:=1;
   if LastGate[nai]<>Ord(Gate<>0) then begin
    if Gate<>0 then if AutoReset then LINCORR_Reset(-1);
    LastGate[nai]:=Ord(Gate<>0);
   end;
   if Gate<>0 then begin
    cai:=RefAi(nai);
    if cai<>0 then begin
     tag:=tagSmoothWind[nai]; if TypeTag(tag)=2 then SmoothWind:=rGetTag(tag) else SmoothWind:=0;
     Entries:=0; SummX:=0; SummY:=0; SummXX:=0; SummYY:=0; SummXY:=0;
     bNul(CrvLock(cai));
     ib:=Round(CrvLen(cai));
     if ib>0 then begin
      xb:=CrvX(cai,ib);
      if xb>LastX[nai] then begin
       LastX[nai]:=xb;
       ia:=Round(CrvWhere(cai,xb-SmoothWind));
       xa:=CrvX(cai,ia);
       xc:=xa+0.5*(xb-xa);
       for i:=ia to ib do begin
        x:=CrvX(cai,i)-xc;
        y:=CrvY(cai,i);
        Entries:=Entries+1;
        SummX:=SummX+X;
        SummY:=SummY+Y;
        SummXX:=SummXX+X*X;
        SummYY:=SummYY+Y*Y;
        SummXY:=SummXY+X*Y;
       end;
      end;
     end;
     bNul(CrvUnlock(cai));
     if Entries>0 then begin
      MeanX:=SummX/Entries;
      MeanY:=SummY/Entries;
      MeanXX:=SummXX/Entries;
      MeanYY:=SummYY/Entries;
      MeanXY:=SummXY/Entries;
      CovXY:=MeanXY-MeanX*MeanY;
      DispX:=MeanXX-Sqr(MeanX);
      DispY:=MeanYY-Sqr(MeanY);
      SigmaX:=Sqrt(DispX);
      SigmaY:=Sqrt(DispY);
      LineC1:=CovXY/DispX;
      LineC0:=MeanY-LineC1*MeanX;
      LineDisp:=MeanYY-(LineC1*MeanXY+LineC0*MeanY);
      LineSigma:=Sqrt(LineDisp);
      LineCorr:=CovXY/(SigmaX*SigmaY);
      if iAnd(DebugFlags,dfDetails)>0 then begin
       Details('Smooth AI['+Str(nai)+']='+CrvName(cai)+' at '+Str(xc)+' window '+Str(SmoothWind));
       Details('[xa,xb]:  ['+Str(xa)+','+Str(xb)+']');
       Details('Entries:  '+Str(Entries));
       Details('MeanX:    '+RightPad(Str(MeanX),25,' ')+' | '
              +'MeanY:    '+RightPad(Str(MeanY),25,' '));
       Details('MeanXX:   '+RightPad(Str(MeanXX),25,' ')+' | '
              +'MeanYY:   '+RightPad(Str(MeanYY),25,' '));
       Details('MeanXY:   '+RightPad(Str(MeanXY),25,' ')+' | '
              +'CovXY:    '+RightPad(Str(CovXY),25,' '));
       Details('DispX:    '+RightPad(Str(DispX),25,' ')+' | '
              +'DispY:    '+RightPad(Str(DispY),25,' '));
       Details('SigmaX:   '+RightPad(Str(SigmaX),25,' ')+' | '
              +'SigmaY:   '+RightPad(Str(SigmaY),25,' '));
       Details('LineC0:   '+RightPad(Str(LineC0),25,' ')+' | '
              +'LineC1:   '+RightPad(Str(LineC1),25,' '));
       Details('LineDisp: '+RightPad(Str(LineDisp),25,' ')+' | '
              +'LineSigma:'+RightPad(Str(LineSigma),25,' '));
       Details('LineCorr: '+Str(LineCorr));
      end;
      if not IsNan(LineC0) then if not IsInf(LineC0) then UpdateAo(2*nai,   xc, LineC0);
      if not IsNan(LineC1) then if not IsInf(LineC1) then UpdateAo(2*nai+1, xc, LineC1);
     end;
    end;
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  LINCORR_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  LINCORR_Poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; n:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Reset
   @Reset 1
   }
   if IsSameText(cmd,'@Reset') then begin
    n:=iValDef(arg,-1); LINCORR_Reset(n);
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   @Clear
   @Clear 1
   }
   if IsSameText(cmd,'@Clear') then begin
    n:=iValDef(arg,-1); LINCORR_Clear(n);
    Success(cmd+'='+Str(n));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
