﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Библиотечная программа _dllwrap.pas

Программа - оболочка (_wrap_) для вызова динамической библиотеки (_dll = dynamic load library_).

## Назначение программы

Программа **[_dllwrap.pas](_dllwrap.pas)** - это библиотечная программа - оболочка
для загрузки, выгрузки и вызова (опроса) **DAQ** - **[плагинов](../../../manual/crwdaq-plugin.htm#crwdaq_plugin_daq)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Алгоритм работы программы

Программа делает следующее:

- При старте **DAQ**-системы вызывает **`DaqDllInit`** для загрузки библиотеки плагина **`.dll`** или **`lib*.so`**.  
  Затем вызывает **`DaqDllCall(…,DAQ_CMD_INIT)`** для инициализации библиотеки.  
  Имя библиотеки считывается из **INI** параметра **DLL_FILE_PATH**.  

- При завершении **DAQ**-системы вызывает **`DaqDllFree`** для выгрузки библиотеки плагина.  
  Перед этим **`DaqDllCall(…,DAQ_CMD_FREE)`** для завершения библиотеки.  

- В цикле опроса **DAQ**-системы вызывает **`DaqDllCall(…,DAQ_CMD_POLL)`**  для выполнения опроса плагина.  
  Плагин выполняет необходимую работу в цикле опроса.  

Программа **`_dllwrap.pas`** минималистична - она не делает ничего кроме обслуживания вызова
динамической библиотекуи плагина **`*.dll`** или **`lib*.so`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Подключение программы _dllwrap.pas

Для подключения **`_dllwrap.pas`** надо включить в конфигурацию примерно такой текст:

``` ini
[DeviceList]
&DEMO.DLLWRAP = device software program
[&DEMO.DLLWRAP]
Comment       = Wrapper for plugin DLL.
InquiryPeriod = 1
DevicePolling = 100, tpNormal
ProgramSource = ~~\resource\daqsite\stdlib\daqpas\_dllwrap.pas ; Program source file
DLL_FILE_PATH = ..\daqpas\demo_plugin\demo_plugin.dll          ; Plugin DLL file path
OpenConsole   = 2
DebugFlags    = 3
[]
```

Параметр **`DLL_FILE_PATH`** указывает на файл динамической библиотеки **`*.dll`** или **`lib*.so`**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

> Желаем успешного использования программы **`_dllwrap.pas`**!

---
