 {
 ***********************************************************************
 Daq Pascal application program PlotSrv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
 [@Help]
 |Command list: StdIn "@cmd=arg" or "@cmd arg"
 |******************************************************
 | @Clear           - Set &PlotSrv=default, for new plot.
 | @# dat           - Add string dat to GNUPLOT data buffer.
 | @> cmd           - Add string cmd to GNUPLOT job  buffer.
 | @! cmd           - Add string cmd to GNUPLOT batch file.
 | CurveList crv    - Add curve crv to GNUPLOT curve list.
 | @Cd dir          - Set HomeDir, GNUPLOT start directory.
 | @HomeDir dir     - Set HomeDir, GNUPLOT start directory.
 | @Run job dat bat - Run GNUPLOT job, using data file dat.
 |                    Run batch file bat after GNUPLOT run.
 | @TimeOut t       - Set time limit (ms) for GNUPLOT work.
 | @DoneMsg msg     - Set DevSendMsg(msg) if GNUPLOT done  Ok.
 | @FailMsg msg     - Set DevSendMsg(msg) if GNUPLOT was fail.
 | @XTime tb, tu    - Set TimeBase,TimeUnits, time X axis.
 | @XTime Default   - Set default TimeBase,TimeUnits.
 | @YTime tb, tu    - Set TimeBase,TimeUnits, time Y axis.
 | @YTime Default   - Set default TimeBase,TimeUnits.
 | @Reset           - Full &PlotSrv reset.
 | Example:
 |  @Clear
 |  @HomeDir=../temp
 |  @> set encoding utf8; set grid
 |  @> set terminal gif; set output 'sinc.gif'
 |  @> plot [0:10] sin(x)/x
 |  @! unix gif2bmp sinc.gif ../bitmaps/sinc.bmp
 |  @Run sinc.job sinc.dat sinc.bat
 |  Result is ..\Bitmap\sinc.bmp file.
 |******************************************************
 []
 }
program PlotSrv;                 { GNUPLOT server                   }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 CrvMax            = 1024;       { Max number of curves in list     }
 BuffSize          = 512;        { Size of temporary curve buffer   }
 SmallCurve        = 100;        { Threshold for small curves       }
 KillTimeOut       = 100;        { TimeOut to kill process, ms      }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 gnuplot           : String;     { GNUPLOT executable               }
 DoneMsg           : String;     { GNUPLOT message if @run was Ok   }
 FailMsg           : String;     { GNUPLOT message if @run failed   }
 HomeDir           : String;     { GNUPlOT sturtup directory        }
 DefaultHomeDir    : String;     { Default HomeDir value            }
 JobFile           : String;     { GNUPLOT job, commands to run     }
 DefaultJobFile    : String;     { Default JobFile value            }
 DatFile           : String;     { GNUPLOT incoming data file       }
 DefaultDatFile    : String;     { Default DatFile value            }
 BatFile           : String;     { GNUPLOT incoming batch file      }
 DefaultBatFile    : String;     { Default BatFile value            }
 TimeOut           : Integer;    { TimeOut to execute GNUPLOT       }
 DefaultTimeOut    : Integer;    { Default timeout value            }
 JobText           : Integer;    { Text of job to execute           }
 DatText           : Integer;    { Data text to process             }
 BatText           : Integer;    { Batch text to run after GNUPLOT  }
 CrvList           : array[1..CrvMax] of Integer; { Curve Handles   }
 CrvCount          : Integer;    { Count of items in CrvList        }
 XBase,XUnits      : Real;       { TimeBase, TimeUnits for X axis   }
 YBase,YUnits      : Real;       { TimeBase, TimeUnits for Y axis   }
 XTime,YTime       : Boolean;    { Use native time for X,Y          }
 BuffX,BuffY       : array[1..BuffSize] of Real; { Temporary        }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }


 {
 Initalize gnuplot variables.
 }
 procedure GnuPlot_Init;
 var i:Integer;
 begin
  gnuplot:='';
  DoneMsg:=''; FailMsg:='';
  HomeDir:=''; DefaultHomeDir:='';
  JobFile:=''; DefaultJobFile:='';
  DatFile:=''; DefaultDatFile:='';
  BatFile:=''; DefaultBatFile:='';
  JobText:=Text_New;
  DatText:=Text_New;
  BatText:=Text_New;
  for i:=1 to CrvMax do CrvList[i]:=0;
  CrvCount:=0;
 end;
 {
 Finalize gnuplot variables.
 }
 procedure GnuPlot_Free;
 var i:Integer; b:Boolean;
 begin
  gnuplot:='';
  DoneMsg:=''; FailMsg:='';
  HomeDir:=''; DefaultHomeDir:='';
  JobFile:=''; DefaultJobFile:='';
  DatFile:=''; DefaultDatFile:='';
  BatFile:=''; DefaultBatFile:='';
  b:=Text_Free(JobText); JobText:=0;
  b:=Text_Free(DatText); DatText:=0;
  b:=Text_Free(BatText); BatText:=0;
  for i:=1 to CrvCount do CrvList[i]:=0;
  CrvCount:=0;
 end;
 {
 Print GNUPLOT state.
 }
 procedure GnuPlot_State;
 begin
  if FileExists(gnuplot) then Success('+gnuplot="'+gnuplot+'"') else Problem('-gnuplot="'+gnuplot+'"');
  if DirExists(HomeDir)  then Success('+HomeDir="'+HomeDir+'"') else Problem('-HomeDir="'+HomeDir+'"');
  if FileExists(JobFile) then Success('+JobFile="'+JobFile+'"') else Success('-JobFile="'+JobFile+'"');
  if FileExists(DatFile) then Success('+DatFile="'+DatFile+'"') else Problem('-DatFile="'+DatFile+'"');
  if FileExists(BatFile) then Success('+BatFile="'+BatFile+'"') else Success('-BatFile="'+BatFile+'"');
  Success('TimeOut='+Str(TimeOut)); Success('DoneMsg='+DoneMsg); Success('FailMsg='+FailMsg);
  Success('XTime='+Str(Ord(XTime)*XBase)+', '+Str(Ord(XTime)*XUnits));
  Success('YTime='+Str(Ord(YTime)*YBase)+', '+Str(Ord(YTime)*YUnits));
 end;
 {
 Clear GNUPLOT job.
 }
 procedure GnuPlot_Clear;
 begin
  XTime:=False; XBase:=TimeBase; XUnits:=TimeUnits;
  YTime:=False; YBase:=TimeBase; YUnits:=TimeUnits;
  DoneMsg:=''; FailMsg:='';
  TimeOut:=DefaultTimeOut;
  HomeDir:=DefaultHomeDir;
  JobFile:=DefaultJobFile;
  DatFile:=DefaultDatFile;
  BatFile:=DefaultBatFile;
  ClearText(JobText);
  ClearText(DatText);
  ClearText(BatText);
  CrvCount:=0;
 end;
 {
 Reset GNUPLOT to default state. Set n=1 for full reset.
 }
 procedure GnuPlot_Reset;
 var i,t,code:Integer;
 begin
  {}
  if not FileExists(gnuplot) then begin
   if IsWindows then gnuplot:=ParamStr('FileSearch gnuplot.exe');
   if IsUnix then gnuplot:=RunSysCommandAsText('unix which gnuplot','','',code,3000);
  end;
  if not FileExists(gnuplot) then Trouble('gnuplot not found!');
  {}
  DefaultTimeOut:=Val(ReadIni('TimeOut'));
  if DefaultTimeOut<=0 then DefaultTimeOut:=10000;
  {}
  DefaultHomeDir:=AdaptFileName(ExpEnv(ReadIni('HomeDir')));
  if Length(DefaultHomeDir)=0 then DefaultHomeDir:=ParamStr('TempPath');
  if Length(DefaultHomeDir)>0 then DefaultHomeDir:=DaqFileRef(DefaultHomeDir,'');
  if not MkDir(DefaultHomeDir) then Trouble('Could not create HomeDir='+DefaultHomeDir);
  {}
  DefaultDatFile:=AdaptFileName(ReadIni('DatFile'));
  if Length(DefaultDatFile)=0 then DefaultDatFile:=AdaptFileName('gnuplot.dat');
  DefaultDatFile:=DaqFileRef(DefaultDatFile,'.dat');
  {}
  DefaultJobFile:=AdaptFileName(ReadIni('JobFile'));
  if Length(DefaultJobFile)=0 then DefaultJobFile:=AdaptFileName('gnuplot.job');
  DefaultJobFile:=DaqFileRef(DefaultJobFile,'.job');
  {}
  DefaultBatFile:=AdaptExeFileName(ReadIni('BatFile'));
  if Length(DefaultBatFile)=0 then DefaultBatFile:=AdaptExeFileName('gnuplot.bat');
  DefaultBatFile:=DaqFileRef(DefaultBatFile,'.bat');
  {}
  GnuPlot_Clear;
 end;
 {
 Start gnuplot.
 }
 function GnuPlot_Run(aJobFile,aDatFile,aBatFile:String):Integer;
 var b:Boolean; s:String; ms,x,y,a,Expired:Real;
     i,j,tid,pid,Crv,Len,Np,CrvText,BuffN:Integer;
 begin
  s:='';
  pid:=0;
  Expired:=mSecNow+TimeOut;
  {}
  JobFile:=AdaptFileName(aJobFile);
  if Length(JobFile)=0 then JobFile:=DefaultJobFile;
  JobFile:=DefaultPath(JobFile,HomeDir);
  {}
  if Text_NumLn(JobText)>0 then begin
    if Rewrite(JobFile)=0 then begin
    for i:=0 to Text_NumLn(JobText)-1 do begin
     if i mod 256 =0 then b:=Wdt_Reset(True)>0;
     Writeln(Text_GetLn(JobText,i));
     b:=IoError;
    end;
    Writeln('exit'); // Required to avoid hanging
   end else Trouble('Could not rewrite "'+JobFile+'"');
   if Append('')<>0 then Trouble('Could not append CON:');
  end;
  {}
  DatFile:=AdaptFileName(aDatFile);
  if Length(DatFile)=0 then DatFile:=DefaultDatFile;
  DatFile:=DefaultPath(DatFile,HomeDir);
  {}
  if CrvCount>0 then begin
   CrvText:=Text_New;
   for i:=1 to CrvCount do begin
    Crv:=CrvList[i];
    Np:=0; BuffN:=0;
    b:=Text_Addln(CrvText,'# plot index '+Str(i-1));
    if CrvLen(Crv)<SmallCurve then begin
     if CrvLock(Crv) then begin
      for j:=1 to Round(CrvLen(Crv)) do begin
       x:=CrvX(Crv,j); y:=CrvY(Crv,j);
       if XTime then s:=GetDateTime(x*XUnits+XBase) else s:=Str(x);
       if YTime then s:=s+' '+GetDateTime(y*YUnits+YBase) else s:=s+' '+Str(y);
       b:=Text_Addln(CrvText,s); if j mod 256 = 0 then b:=Wdt_Reset(True)>0;
       Np:=Np+1;
      end;
      b:=CrvUnlock(Crv);
     end;
    end else begin
     a:=_MinusInf;
     Len:=Round(CrvLen(Crv));
     while Len>0 do begin
      if CrvLock(Crv) then begin
       Len:=Round(CrvLen(Crv));
       if Len>0 then begin
        j:=Round(CrvWhere(Crv,a));
        if j<1 then Len:=0 else
        while (j<=Len) and (BuffN<BuffSize) do begin
         x:=CrvX(Crv,j);
         if x>a then begin
          y:=CrvY(Crv,j);
          BuffN:=BuffN+1;
          BuffX[BuffN]:=x;
          BuffY[BuffN]:=y;
          a:=x;
         end;
         j:=j+1;
        end;
        if j>Len then Len:=0;
       end;
       b:=CrvUnlock(Crv);
      end else Len:=0;
      for j:=1 to BuffN do begin
       x:=BuffX[j]; y:=BuffY[j];
       if XTime then s:=GetDateTime(x*XUnits+XBase) else s:=Str(x);
       if YTime then s:=s+' '+GetDateTime(y*YUnits+YBase) else s:=s+' '+Str(y);
       b:=Text_Addln(CrvText,s); 
       Np:=Np+1;
      end;
      BuffN:=0;
      b:=Wdt_Reset(True)>0;
     end;
    end; 
    if Np=0 then b:=Text_Addln(CrvText,'- -');
    b:=Text_Addln(CrvText,'');
    b:=Text_Addln(CrvText,'');
    b:=Wdt_Reset(True)>0;
   end;
   if Rewrite(DatFile)=0 then begin
    for i:=0 to Text_NumLn(CrvText)-1 do begin
     if i mod 256 = 0 then b:=Wdt_Reset(True)>0;
     Writeln(Text_GetLn(CrvText,i));
     b:=IoError;
    end;
   end else Trouble('Could not rewrite "'+DatFile+'"');
   if Append('')<>0 then Trouble('Could not append CON:');
   b:=Text_Free(CrvText);
  end;
  {}
  if Text_NumLn(DatText)>0 then begin
   if Rewrite(DatFile)=0 then begin
    for i:=0 to Text_NumLn(DatText)-1 do begin
     if i mod 256 = 0 then b:=Wdt_Reset(True)>0;
     Writeln(Text_GetLn(DatText,i));
     b:=IoError;
    end;
   end else Trouble('Could not rewrite "'+DatFile+'"');
   if Append('')<>0
   then Trouble('Could not append CON:');
  end;
  {}
  BatFile:=AdaptExeFileName(aBatFile);
  if Length(BatFile)=0 then BatFile:=DefaultBatFile;
  BatFile:=DefaultPath(BatFile,HomeDir);
  {}
  if Text_NumLn(BatText)>0 then begin
   if Rewrite(BatFile)=0 then begin
    // Unix scripts required sha-bang to execute
    if IsUnix then Writeln('#!'+GetEnv('SHELL')+EOL);
    for i:=0 to Text_NumLn(BatText)-1 do begin
     if i mod 256 = 0 then b:=Wdt_Reset(True)>0;
     Writeln(Text_GetLn(BatText,i));
     b:=IoError;
    end;
   end else Trouble('Could not rewrite "'+BatFile+'"');
   if Append('')<>0
   then Trouble('Could not append CON:');
  end;
  if FileExists(BatFile) and IsUnix // Make script executable
  then iNul(ExecuteProcessSafe('chmod','755 '+BatFile,'',3000));
  {}
  tid:=Task_Init(GnuPlot+' '+JobFile);
  if not DirExists(HomeDir) then b:=MkDir(HomeDir);
  b:=Pos('?',Task_Ctrl(tid,'HomeDir='+HomeDir))=0;
  b:=Pos('?',Task_Ctrl(tid,'Display=0'))=0;
  if Task_Run(tid) then begin
   pid:=Task_Pid(tid);
   Success('Pid '+Str(Task_Pid(tid))+' started from "'+Task_Ctrl(tid,'CmdLine')+'"');
   ms:=Expired;
   while mSecNow<ms do begin
    if not Task_Wait(tid,10) then ms:=0;
    b:=Wdt_Reset(True)>0;
   end;
   if Task_Wait(tid,0) then pid:=0;
   if Task_Wait(tid,0) then b:=Task_Kill(tid,3,1,KillTimeOut);
   if Task_Wait(tid,0) then b:=Task_Kill(tid,1,1,KillTimeOut);
   if Task_Wait(tid,0) then b:=Task_Kill(tid,0,1,KillTimeOut);
  end else Trouble('Could not start '+Task_Ctrl(tid,'CmdLine'));
  b:=Task_Free(tid);
  {}
  if pid<>0 then
  //if Text_NumLn(BatText)>0 then
  if FileExists(BatFile) then begin
   s:='';
   if IsUnix then s:=BatFile;
   if IsWindows then s:=GetComSpec+' /c set Path=%CRW_DAQ_CONFIG_PATH%;%CRW_DAQ_SYS_PATH%;%Path% && '+BatFile;
   tid:=Task_Init(s);
   if not DirExists(HomeDir) then b:=MkDir(HomeDir);
   b:=Pos('?',Task_Ctrl(tid,'HomeDir='+HomeDir))=0;
   b:=Pos('?',Task_Ctrl(tid,'Display=0'))=0;
   if Task_Run(tid) then begin
    Success('Pid '+Str(Task_Pid(tid))+' started from "'+Task_Ctrl(tid,'CmdLine')+'"');
    ms:=Expired;
    while mSecNow<ms do begin
     if not Task_Wait(tid,10) then ms:=0;
     b:=Wdt_Reset(True)>0;
    end;
    if Task_Wait(tid,0) then pid:=0;
    if Task_Wait(tid,0) then b:=Task_Kill(tid,3,1,KillTimeOut);
    if Task_Wait(tid,0) then b:=Task_Kill(tid,1,1,KillTimeOut);
    if Task_Wait(tid,0) then b:=Task_Kill(tid,0,1,KillTimeOut);
   end else Trouble('Could not start '+Task_Ctrl(tid,'CmdLine'));
   b:=Task_Free(tid);
  end;
  GnuPlot_Run:=pid;
  s:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  gnuplot:='';
  DoneMsg:=''; FailMsg:='';
  HomeDir:=''; DefaultHomeDir:='';
  JobFile:=''; DefaultJobFile:='';
  DatFile:=''; DefaultDatFile:='';
  BatFile:=''; DefaultBatFile:='';
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  GnuPlot_Init;
  GnuPlot_Reset;
  GnuPlot_State;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  GnuPlot_Free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; b:Boolean; r,tb,tu,ms:Real; i,j,Crv,pid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {}
   if IsSameText(cmd,'@>') then begin
    b:=Text_Addln(JobText,Trim(arg));
    Data:='';
   end else
   if IsSameText(cmd,'@#') then begin
    b:=Text_Addln(DatText,Trim(arg));
    Data:='';
   end else
   if IsSameText(cmd,'@!') then begin
    b:=Text_Addln(BatText,Trim(arg));
    Data:='';
   end else
   if IsSameText(cmd,'@CurveList') then begin
    for i:=1 to WordCount(arg) do begin
     Crv:=RefFind('Curve '+ExtractWord(i,arg));
     if (Crv<>0) and (CrvCount<CrvMax) then begin
      j:=0;
      for i:=1 to CrvCount do j:=j+Ord(Crv=CrvList[i]);
      if j=0 then begin
       CrvList[CrvCount+1]:=Crv;
       CrvCount:=CrvCount+1;
      end;
     end;
    end;
    Success(cmd+'='+Str(CrvCount));
    Data:='';
   end else
   if IsSameText(cmd,'@Cd') or IsSameText(cmd,'@HomeDir') then begin
    arg:=AdaptFileName(ExpEnv(Trim(arg)));
    if Length(arg)>0 then
    if MkDir(DaqFileRef(arg,''))
    then HomeDir:=DaqFileRef(arg,'')
    else Trouble('Invalid HomeDir='+arg);
    Success(cmd+'='+HomeDir);
    Data:='';
   end else
   if IsSameText(cmd,'@Run') then begin
    ms:=mSecNow;
    pid:=GnuPlot_Run(URL_Decode(ExtractWord(1,arg)),
                     URL_Decode(ExtractWord(2,arg)),
                     URL_Decode(ExtractWord(3,arg)));
    if pid=0 then begin
     if Length(FailMsg)>0 then r:=DevSendMsg(FailMsg+EOL);
    end else begin
     if Length(DoneMsg)>0 then r:=DevSendMsg(DoneMsg+EOL);
    end;
    Success(cmd+'='+Str(pid)+', '+Str(mSecNow-ms)+' ms, stab:'+Str(MaxAvail));
    Data:='';
   end else
   if IsSameText(cmd,'@TimeOut') then begin
    r:=rVal(arg);
    if (r>=1) and not IsNan(r) then TimeOut:=Round(r);
    Success(cmd+'='+Str(TimeOut));
    Data:='';
   end else
   if IsSameText(cmd,'@XTime') then begin
    arg:=Trim(arg);
    if IsSameText(arg,'Default') then begin
     tb:=TimeBase;
     tu:=TimeUnits;
    end else begin
     tb:=rVal(ExtractWord(1,arg));
     tu:=rVal(ExtractWord(2,arg));
    end;
    if not IsNan(tb) and not IsNan(tu) then begin
     if tb<0 then tb:=TimeBase;
     if tu<0 then tu:=TimeUnits;
     XTime:=(tb<>0) and (tu<>0);
     XBase:=tb; XUnits:=tu;
    end;
    Success(cmd+'='+Str(Ord(XTime)*XBase)+', '+Str(Ord(XTime)*XUnits));
    Data:='';
   end else
   if IsSameText(cmd,'@YTime') then begin
    if IsSameText(arg,'Default') then begin
     tb:=TimeBase;
     tu:=TimeUnits;
    end else begin
     tb:=rVal(ExtractWord(1,arg));
     tu:=rVal(ExtractWord(2,arg));
    end;
    if not IsNan(tb) and not IsNan(tu) then begin
     if tb<0 then tb:=TimeBase;
     if tu<0 then tu:=TimeUnits;
     YTime:=(tb<>0) and (tu<>0);
     YBase:=tb; YUnits:=tu;
    end;
    Success(cmd+'='+Str(Ord(YTime)*YBase)+', '+Str(Ord(YTime)*YUnits));
    Data:='';
   end else
   if IsSameText(cmd,'@DoneMsg') then begin
    arg:=Trim(arg);
    if (Pos('=',Data)>0) or (Length(arg)>0) then DoneMsg:=arg;
    Success(cmd+'='+DoneMsg);
    Data:='';
   end else
   if IsSameText(cmd,'@FailMsg') then begin
    arg:=Trim(arg);
    if (Pos('=',Data)>0) or (Length(arg)>0) then FailMsg:=arg;
    Success(cmd+'='+FailMsg);
    Data:='';
   end else
   if IsSameText(cmd,'@Clear') then begin
    GnuPlot_Clear;
    Data:='';
   end else
   if IsSameText(cmd,'@State') then begin
    GnuPlot_State;
    Data:='';
   end else
   if IsSameText(cmd,'@Reset') then begin
    GnuPlot_Reset;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
