﻿---

<b id="toc" class="big memo">Содержание</b>

[[toc]]

---

# Сервер &EmlSrv

Сервер **[&EmlSrv](#emlsrv)** служит для почтовых рассылок по протоколу **SMTP**.  
Он работает на основе программы **[sendEmail](#sendemail)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Программа sendEmail

<a name="sendemail"></a>

Пакет **CRW-DAQ** содержит свободно распространяемую программу **[sendEmail](../../tools/sendemail/)**,
см. **[сайт](https://github.com/mogaal/sendemail)**.

Её можно использовать в главной консоли с помощью команды **@run** примерно в таком духе:

```
@run unix sendemail -f admilink@mail.ru -t akuryaki@cern.ch -cc kouriakine@mail.ru -bcc admilink@mail.ru -u "Test subject" -s smtp.mail.ru:25 -xu admilink -xp *** -a attach.gif -m "Hello, it is test."

 Здесь
  -f   admilink@mail.ru     - отправитель   (адрес),
  -t   akuryaki@cern.ch     - получатель    (адрес или список через запятую),
  -cc  kouriakine@mail.ru   - копия         (адрес или список через запятую),
  -bcc admilink@mail.ru     - скрытая копия (адрес или список через запятую),
  -u   "Test subject"       - тема письма   (в кавычках, если с пробелами),
  -s   smtp.mail.ru:25      - почтовый сервер:порт (должны быть известны),
  -xu  admilink             - имя пользователя (учетной записи) на почтовом сервере
  -xp  ***                  - пароль этого пользователя
  -a   attach.gif           - вложенный файл или список файлов, разделенный пробелами
  -m   "Hello, it is test." - текст сообщения.
```

Полный список опций командной строки можно найти в файле **[sendemail.htm](../../tools/sendemail/sendemail.htm)**.
Заметим, что опции **`-cc`**, **`-bcc`**, **`-u`** необязательны, а **`-xu`** пользователь и **`-xp`** пароль могут
отсутствовать (это зависит от настроек почтового сервера).

Для работы программы надо также открыть порт **SMPT**, обычно это порт **TCP 25**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Сервер почты &EmlSrv

<a name="emlsrv"></a>

Сервер **&EmlSrv** служит для рассылки электронной почты по протоколу **SMTP** из программ на **DaqPascal**.  
Он может применяться, например, для посылки сообщений экспертам при срабатывании аварийной системы блокировок.

Сервер включает этот файл справки **[emlsrv.htm](emlsrv.htm)**, клиентскую программу **[emlsrv.pas](emlsrv.pas)**,
клиентскую конфигурацию **[emlsrv.cfg](emlsrv.cfg)** и автономную программу **[sendemail](../../tools/sendemail/)**.

Для включения сервера в измерительную конфигурацию надо включить файл клиентской конфигурации в секцию **[ConfigFileList]**:

``` ini
[ConfigFileList]
ConfigFile = ~~\resource\daqsite\default\emlsrv.cfg
[]
```

После этого можно посылать письма вызовом примерно такого кода:

``` pascal
if DevSend(RefFind('Device &EmlSrv'),  // Посылка сообщения серверу &EmlSrv
   '@clear'+EOL                        // Очистка буфера
  +'@from admilink@mail.ru'+EOL        // Адрес отправителя
  +'@to akuryaki@cern.ch'+EOL          // Адрес или список адресов получателя (через запятую)
  +'@cc kouriakine@mail.ru'+EOL        // Адрес или список адресов копии
  +'@bcc admilink@mail.ru'+EOL         // Адрес или список адресов скрытой копии
  +'@subject Test message'+EOL         // Тема письма
  +'@server smtp.mail.ru:25'+EOL       // Имя почтового сервера:порт
  +'@username admilink'+EOL            // Имя пользователя для аутентификации (если требуется)
  +'@password ***'+EOL                 // Пароль пользователя (если требуется)
  +'@attachment demo.gif'+EOL          // Вложенный файл (если есть)
  +'@timeout 10000'+EOL                // Максимальное время на посылку письма, ms
  +'@> That is test message.'+EOL      // Первая строка текста для посылки
  +'@> Please don''t reply.'+EOL       // Вторая строка, и так далее
  +'@send'+EOL+'@clear'+EOL)>0         // Команда посылки письма и очистка буфера
then Success('Ok')                     // Посылка сообщения прошла успешно
else Trouble('FAIL');                  // Посылка сообщения не состоялась.
```

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Желаем успешного использования **&EmlSrv**.

---

> **CRW-DAQ** *Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru*

---
