@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem ======================================================================
rem UAC settings v.20180620
rem see http://www.oszone.net/11424
rem see https://technet.microsoft.com/en-us/library/dd835564(v=ws.10).aspx
rem Copyright(c) Alex Kuryakin 2018 Sarov RU kouriakine@mail.ru under GPL.
rem ======================================================================

:CheckAccessRights
net session 1>nul 2>nul || (
 echo %~nx0: Access denied. Administrator required.
 echo %~nx0: Try to elevate access rights...
 call :Elevate "%~f0" "%~1" "%~dp0"
 goto :EOF
)

:Main
set answer=no
set self=%~n0
pushd "%~dp0" && call :ProcessArgs %*
popd
goto :EOF

:ProcessArgs
if /I "%~1" == "See"        ( call :UAC_See                                            & goto :EOF )
if /I "%~1" == "On"         ( call :UAC_On  "Set UAC settings to switch UAC ON."       & goto :EOF )
if /I "%~1" == "Off"        ( call :UAC_Off "Set UAC settings to switch UAC OFF."      & goto :EOF )
if /I "%~1" == "Pro"        ( call :UAC_Pro "Set UAC settings to Profession defaults." & goto :EOF )
if /I "%~1" == "Ent"        ( call :UAC_Ent "Set UAC settings to Enterprise defaults." & goto :EOF )
if /I "%~1" == "Min"        ( call :UAC_Min "Set UAC settings to use minimal prompts." & goto :EOF )
if /I "%~1" == "Nul"        ( call :UAC_Nul "Set UAC settings to NUL (OFF, ZERO all)." & goto :EOF )
if /I "%~1" == "Low"        ( call :UAC_Low "Set UAC slider to Low position."          & goto :EOF )
if /I "%~1" == "Mid"        ( call :UAC_Mid "Set UAC slider to Middle position."       & goto :EOF )
if /I "%~1" == "Top"        ( call :UAC_Top "Set UAC slider to Top position."          & goto :EOF )
if /I "%~1" == "Man"        ( call :UAC_Man                                            & goto :EOF )
if /I "%~1" == "Doc"        ( call :UAC_Doc                                            & goto :EOF )
if /I "%~1" == "Reg"        ( call :UAC_Reg                                            & goto :EOF )
if /I "%~1" == "Tit"        ( Title %~nx0: Tune User Access Control settings. & color 0a & cls )
call :UAC_Help
goto :EOF

:UAC_Help
echo **************************************************
echo %self%.cmd -^> Utility for User Access Control tuning.
echo Copyright(c) Alex Kuryakin 2017 kouriakine@mail.ru
echo **************************************************
echo.
echo Help on %self%:
echo.
echo  %self% see  - User Access Control status see
echo  %self% on   - User Access Control switch ON
echo  %self% off  - User Access Control switch OFF
echo  %self% pro  - User Access Control Profession defaults
echo  %self% ent  - User Access Control Enterprise defaults
echo  %self% min  - User Access Control use minimum prompts
echo  %self% nul  - User Access Control NUL = OFF, ZERO all
echo  %self% low  - User Access Control slider to Low position
echo  %self% mid  - User Access Control slider to Middle state
echo  %self% top  - User Access Control slider to Top position
if exist %self%.pdf echo  %self% man  - User Access Control manual PDF
if exist %self%-doc echo  %self% doc  - User Access Control documents
if exist %self%-reg echo  %self% reg  - User Access Control reg files
echo  %self% tit  - Show title, color and this Help
echo  %self%      - Show this Help
echo.
goto :EOF

:UAC_See
echo User Access Control status: 
call :RegQuery                      ^
    EnableLUA                       ^
    EnableInstallerDetection        ^
    PromptOnSecureDesktop           ^
    ConsentPromptBehaviorAdmin      ^
    ConsentPromptBehaviorUser       ^
    EnableSecureUIAPaths            ^
    ValidateAdminCodeSignatures     ^
    EnableVirtualization            ^
    EnableUIADesktopToggle          ^
    FilterAdministratorToken        
goto :EOF

:UAC_Doc
start %self%-doc\
goto :EOF

:UAC_Man
start %self%.pdf
goto :EOF

:UAC_Reg
start %self%-reg\
goto :EOF

:UAC_On
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg EnableLUA=1
call :RebootWarning
goto :EOF

:UAC_Off
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg EnableLUA=0
call :RebootWarning
goto :EOF

:UAC_Pro
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg                        ^
    EnableLUA=1                     ^
    EnableInstallerDetection=1      ^
    PromptOnSecureDesktop=1         ^
    ConsentPromptBehaviorAdmin=5    ^
    ConsentPromptBehaviorUser=3     ^
    EnableSecureUIAPaths=1          ^
    ValidateAdminCodeSignatures=0   ^
    EnableVirtualization=1          ^
    EnableUIADesktopToggle=0        ^
    FilterAdministratorToken=0      
call :RebootWarning
goto :EOF

:UAC_Ent
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg                        ^
    EnableLUA=1                     ^
    EnableInstallerDetection=0      ^
    PromptOnSecureDesktop=1         ^
    ConsentPromptBehaviorAdmin=5    ^
    ConsentPromptBehaviorUser=3     ^
    EnableSecureUIAPaths=1          ^
    ValidateAdminCodeSignatures=0   ^
    EnableVirtualization=1          ^
    EnableUIADesktopToggle=0        ^
    FilterAdministratorToken=0      
call :RebootWarning
goto :EOF

:UAC_Min
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg                        ^
    EnableLUA=1                     ^
    EnableInstallerDetection=1      ^
    PromptOnSecureDesktop=0         ^
    ConsentPromptBehaviorAdmin=0    ^
    ConsentPromptBehaviorUser=3     ^
    EnableSecureUIAPaths=0          ^
    ValidateAdminCodeSignatures=0   ^
    EnableVirtualization=1          ^
    EnableUIADesktopToggle=0        ^
    FilterAdministratorToken=0      
call :RebootWarning
goto :EOF

:UAC_Nul
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg                        ^
    EnableLUA=0                     ^
    EnableInstallerDetection=0      ^
    PromptOnSecureDesktop=0         ^
    ConsentPromptBehaviorAdmin=0    ^
    ConsentPromptBehaviorUser=0     ^
    EnableSecureUIAPaths=0          ^
    ValidateAdminCodeSignatures=0   ^
    EnableVirtualization=0          ^
    EnableUIADesktopToggle=0        ^
    FilterAdministratorToken=0      
call :RebootWarning
goto :EOF

:UAC_Low
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg                        ^
    EnableLUA=1                     ^
    PromptOnSecureDesktop=0         ^
    ConsentPromptBehaviorAdmin=5    
call :RebootWarning
goto :EOF

:UAC_Mid
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg                        ^
    EnableLUA=1                     ^
    PromptOnSecureDesktop=1         ^
    ConsentPromptBehaviorAdmin=5    
call :RebootWarning
goto :EOF

:UAC_Top
call :Confirmation %*
if /I not "%answer%" == "y" ( echo %answer% - Cancelled. & goto :EOF )
call :RunReg                        ^
    EnableLUA=1                     ^
    PromptOnSecureDesktop=1         ^
    ConsentPromptBehaviorAdmin=2    
call :RebootWarning
goto :EOF

:Confirmation
if "%~1" == "" goto :EOF
echo.
echo *****************************************
echo ****** User Access Control warning ******
echo Confirmation required to apply operation:
echo *****************************************
echo %~1
echo.
set /p answer=Do you want to continue? [y/n] 
goto :EOF

:RebootWarning
echo.
echo UAC: REBOOT REQUIRED TO APPLY CHANGES.
echo.
msg * /TIME:30 "UAC: REBOOT REQUIRED TO APPLY CHANGES." 1>nul 2>nul
goto :EOF

:RegQuery
if "%~1" == "" goto :EOF
for /F "tokens=1,2,3 delims= " %%i in ('reg query HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System /v %~1') do if /I "%%i" == "%~1" if /I "%%j" == "REG_DWORD" ( set /a value=%%k & echo  %%i=!value! )
shift & goto :RegQuery
goto :EOF

:RegAdd
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
reg add HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\System /v "%~1" /t REG_DWORD /d "%~2" /f 1>nul 2>nul
goto :EOF

:RunReg
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if exist "%self%-reg\%~1=%~2.reg" reg import "%self%-reg\%~1=%~2.reg" 1>nul 2>nul && goto :RunRegDone
call :RegAdd "%~1" "%~2" && goto :RunRegDone
echo Fail: %~1=%~2.reg & goto :RunRegNext
:RunRegDone
echo Done: %~1=%~2.reg
:RunRegNext
shift & shift & goto :RunReg
goto :EOF

:Elevate
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
set APP=%~1
set ARG=%~2
set DIR=%~3
set TIT=%~nx1: Tune User Access Control settings.
set COL=0a
set elevate=%Temp%\elevate_%~nx1.vbs
echo Set objShell = CreateObject(^"Shell.Application^")          >  "%elevate%"
echo Set objWshShell = WScript.CreateObject(^"WScript.Shell^")   >> "%elevate%"
echo Set objWshProcessEnv = objWshShell.Environment(^"PROCESS^") >> "%elevate%"
echo objShell.ShellExecute ^"%ComSpec%^", ^"/k pushd ^"^"%DIR%^"^" ^& title %TIT% ^& color %COL% ^& ^"^"%APP%^"^" %ARG%^", ^"^", ^"runas^" >> "%elevate%"
"%SystemRoot%\System32\WScript.exe" "%elevate%"
del /f /q "%elevate%"
goto :EOF
