@echo off

@chcp 65001

if -%1 == -  goto USAGE
if -%2 == -  goto USAGE
if -%3 == -  goto USAGE
if -%2 == -0 goto QUIT
if -%3 == -0 goto QUIT
goto START

:USAGE
@echo ***********************************
@echo Usage: %0 1 2 3
@echo 1 - Subsystem ID, like LDC1
@echo 2 - Registrator number, 1..7
@echo 3 - Com Port number, 1..256
@echo Registrator=0 or Port=0 -> ignore
@echo Example: %0 LDC1 1 4
@echo ***********************************
Pause
goto QUIT

:START

@echo []
@echo ;*************************************************************************
@echo ;** Подсистема %1, драйвер Smart-UPS-420 номер %2, порт %3
@echo ;**************************************************************************
@echo []
@echo [SerialPort-COM%3]  
@echo Port = COM%3        ; идентификатор COM-порта
@echo BaudRate = 2400    ; скорость передачи, бод
@echo Parity = NONE      ; проверка на четность - NONE, ODD, EVEN
@echo DataBits = 8       ; число бит данных
@echo StopBits = 1       ; число стоп-бит
@echo XonXoff = false    ; использовать ли протокол XON/XOFF
@echo BufSize = 8        ; размер буфера fifo в килобайтах
@echo []
@echo [DataStorage]
@echo %1.UPS%2.U.INP  = Curve 0 1000 Black        0  1 ; напряжение сети 220V
@echo %1.UPS%2.U.OUT  = Curve 0 1000 Blue         0  1 ; напряжение на выходе UPS при питании с сети
@echo %1.UPS%2.V.OUT  = Curve 0 1000 Yellow       0  1 ; напряжение на выходе UPS при питании с батарей
@echo %1.UPS%2.U.BAT  = Curve 0 1000 LightGreen   0  1 ; напряжение батареи
@echo %1.UPS%2.C.BAT  = Curve 0 1000 LightMagenta 0  1 ; заряд батареи в % от макс
@echo %1.UPS%2.P.OUT  = Curve 0 1000 Red          0  1 ; нагрузка в % от макс
@echo %1.UPS%2.FREQ   = Curve 0 1000 LightCyan    0  1 ; частота сети, Герц
@echo []
@echo [TagList]
@echo %1.UPS%2.OnOff.Btn = integer 0 ; кнопка "Вкл UPS"
@echo %1.UPS%2.220.Ind   = integer 0 ; питание от сети
@echo %1.UPS%2.BAT.Ind   = integer 0 ; питание от батарей
@echo %1.UPS%2.CHR.Ind   = integer 0 ; батарея разрядилась
@echo %1.UPS%2.TimeOut   = integer 0 ; тайм-аут при опросе UPS
@echo %1.UPS%2.Test.Btn  = integer 0 ; кнопка "Тест UPS"
@echo []
@echo [Windows]
@echo %1.UPS%2.CONTROL = Circuit_Window
@echo [%1.UPS%2.CONTROL]
@echo Circuit = ..\circuits\UPS%2.CRC
@echo Link sensor UPS.U.INP     with curve %1.UPS%2.U.INP     device %1.UPS%2.DRV
@echo Link sensor UPS.U.OUT     with curve %1.UPS%2.U.OUT     device %1.UPS%2.DRV
@echo Link sensor UPS.V.OUT     with curve %1.UPS%2.V.OUT     device %1.UPS%2.DRV
@echo Link sensor UPS.U.BAT     with curve %1.UPS%2.U.BAT     device %1.UPS%2.DRV
@echo Link sensor UPS.C.BAT     with curve %1.UPS%2.C.BAT     device %1.UPS%2.DRV
@echo Link sensor UPS.P.OUT     with curve %1.UPS%2.P.OUT     device %1.UPS%2.DRV
@echo Link sensor UPS.FREQ      with curve %1.UPS%2.FREQ      device %1.UPS%2.DRV
@echo Link sensor UPS.OnOff.Btn with tag   %1.UPS%2.OnOff.Btn device %1.UPS%2.DRV
@echo Link sensor UPS.220.Ind   with tag   %1.UPS%2.220.Ind   device %1.UPS%2.DRV
@echo Link sensor UPS.BAT.Ind   with tag   %1.UPS%2.BAT.Ind   device %1.UPS%2.DRV
@echo Link sensor UPS.CHR.Ind   with tag   %1.UPS%2.CHR.Ind   device %1.UPS%2.DRV
@echo Link sensor UPS.TimeOut   with tag   %1.UPS%2.TimeOut   device %1.UPS%2.DRV
@echo Link sensor UPS.Test.Btn  with tag   %1.UPS%2.Test.Btn  device %1.UPS%2.DRV
@echo []
@echo [DeviceList]
@echo %1.UPS%2.DRV = device software Program
@echo [%1.UPS%2.DRV]
@echo Comment       = Smart-UPS-420 driver for %1 UPS%2
@echo InquiryPeriod = 40
@echo DevicePolling = 50, tpNormal
@echo AnalogOutputs = 7
@echo Link AnalogOutput  0 with curve %1.UPS%2.U.INP history 1024
@echo Link AnalogOutput  1 with curve %1.UPS%2.U.OUT history 1024
@echo Link AnalogOutput  2 with curve %1.UPS%2.V.OUT history 1024
@echo Link AnalogOutput  3 with curve %1.UPS%2.U.BAT history 1024
@echo Link AnalogOutput  4 with curve %1.UPS%2.C.BAT history 1024
@echo Link AnalogOutput  5 with curve %1.UPS%2.P.OUT history 1024
@echo Link AnalogOutput  6 with curve %1.UPS%2.FREQ  history 1024
@echo ProgramSource    = ..\daqpas\ups_drv.pas
@echo Adam_Slot_Device = %1.UPS%2.SLOT         ; слот RS-485 для связи
@echo tagOnOff         = %1.UPS%2.OnOff.Btn    ; кнопка "Вкл UPS"
@echo tag220           = %1.UPS%2.220.Ind      ; питание от сети
@echo tagBat           = %1.UPS%2.BAT.Ind      ; питание от батарей
@echo tagChr           = %1.UPS%2.CHR.Ind      ; батарея разрядилась
@echo tagTimeOut       = %1.UPS%2.TimeOut      ; тайм-аут при опросе UPS
@echo tagTest          = %1.UPS%2.Test.Btn     ; кнопка "Тест UPS"
@echo winUpsControl    = UPS-%2                  ; имя окна UPS
@echo IndexNumber      = %2                      ; порядковый номер UPS
@echo []
@echo [DeviceList]
@echo %1.UPS%2.SLOT = device adam adam_slot
@echo [%1.UPS%2.SLOT]
@echo InquiryPeriod = 50
@echo Port          = %3
@echo Address       = $FF
@echo UsesCheckSum  = 0
@echo []
:QUIT
