#!/bin/bash

##########################################################
# Copyright (c) 2001-2024 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
## Script to call after DAQ configuration stopped.      ##
##########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

if [ -z "$CRW_DAQ_SYS_HOME_DIR" ];    then fatal 1 "The script should be called from CRW-DAQ system only."; fi;
if [ -z "$CRW_DAQ_CONFIG_HOME_DIR" ]; then fatal 1 "The script should be called from DAQ system only."; fi;

declare logFile="$(realpath $scriptHOME/../temp/$scriptbase.log)";
declare -i errors=0;

function do_greetings(){
 echo "";
 echo "####################################################";
 echo "# CRW-DAQ Finalization script. Run on DAQ logout.  #";
 echo "####################################################";
 echo "";
};

function logger(){
 tee -a "$logFile";
};

function do_logout(){
 do_greetings;
 do_enter_log_file;
 do_clear_temp_dir;
 do_verify_integrity;
 do_leave_log_file;
};

function do_enter_log_file(){
 echo "$(date +%Y.%m.%d-%H:%M:%S):";
 echo "Enter $scriptFILE";
};

function do_leave_log_file(){
 echo "$(date +%Y.%m.%d-%H:%M:%S):";
 echo "Leave $scriptFILE";
};

function do_clear_temp_dir(){
 echo "ClearTempDir:";
 pushd "$PWD/temp" && perform_clear_temp_dir;
 popd;
};

function perform_clear_temp_dir(){
 rm -fv *.lst *.tmp;
 find ./ -type f -mtime +30 -delete;
};

function do_verify_integrity(){
 if utility/daqsys.verify.sh; then
  echo "Verify: succeed $PWD/checksum.md5";
 else
  echo "Verify: failed $PWD/checksum.md5";
  let errors++;
 fi;
};

function main(){
 pushd "$scriptHOME/.." && do_logout "$@" | logger;
 popd;
 if [ $errors -gt 0 ]; then return 1; fi;
};

main "$@";

##############
## END OF FILE
##############
