 {
 ***********************************************************************
 ADAM's simulator.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @PortOpen n xxx - Open port number n with params xxx.
| @PortClose n    - Close port number n.
| @UsesCheckSum n c - uses check sum on port n.
| @PortHandler n r str a - request r handler, port n, answer a.
| @PortHandler n r tag t - request r handler, port n, ans tag t.
| @View n         - view table of port n (0=all).
|********************************************************
[]
 }
program adam_sim;                { Simulator for ADAM's             }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 MaxPortNum = 16;                { Max.number of COM ports          }
 MaxConnNum = 15;                { Max. connection number           }
 
type
 TTagRef    = record tag:Integer; val:Real; end;

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 adam       : record             { ADAM related data                }
  Port      : array[1..MaxPortNum] of record { COM port             }
   Decl     : String;            { Port declaration                 }
   Pipe     : Integer;           { Port pipe                        }
   CSum     : Integer;           { Uses checksum                    }
   Req      : String;            { Temporary for answer             }
   Ans      : String;            { Temporary for request            }
   Buf      : array[0..MaxConnNum] of String;  { Temporary buffer   }
   Hand     : Integer;           { Handles                          }
  end;                           {                                  }
  sim       : record             { Simulator                        }
   Port     : TTagRef;           { Port num                         }
   Req      : TTagRef;           { Request                          }
   Ans      : TTagRef;           { Answer                           }
   Notify   : TTagRef;           { Dialog notify                    }
  end;                           {                                  }
 end;                            {                                  }
 devAdamSimDlg : Integer;        { Simulation dialog                }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Check port number is good to use.
 }
 function adam_port_ok(port:Integer):Boolean;
 begin
  adam_port_ok:=((port>=1) and (port<=MaxPortNum));
 end;
 {
 Calculate checksum.
 }
 function adam_checksum(s:String):Integer;
 var i,cs:Integer;
 begin
  cs:=0; for i:=1 to Length(s) do cs:=cs+Ord(s[i]);
  adam_checksum:=Ord(Chr(cs));
 end;
 {
 Answer on DCON protocol request
 }
 function adam_dcon_ans(port:Integer; req:String):String;
 var ans,arg,han:String; i,tag:Integer;
 begin
  ans:=''; arg:=''; han:='';
  if adam_port_ok(port) then begin
   if Length(req)>1+adam.Port[port].CSum*2 then
   if adam.Port[port].CSum>0 then begin
    if Copy(req,Length(req)-1,2)=HexB(adam_checksum(Copy(req,1,Length(req)-2)))
    then req:=Copy(req,1,Length(req)-2) else req:='';
   end;
   if Length(req)>0 then
   for i:=0 to text_numln(adam.Port[port].Hand)-1 do if Length(ans)=0 then begin
    han:=text_getln(adam.Port[port].Hand,i);
    if req=ExtractWord(1,han) then begin
     if IsSameText(ExtractWord(2,han),'str') then ans:=Trim(SkipWords(2,han)) else
     if IsSameText(ExtractWord(2,han),'tag') then ans:=TagAsText(FindTag(ExtractWord(3,han)));
     if Length(ans)>0 then begin
      if adam.Port[port].CSum>0 then ans:=ans+HexB(adam_checksum(ans));
      ans:=ans+Chr(_CR);
     end;
    end;
   end;
  end;
  adam_dcon_ans:=ans;
  ans:=''; arg:=''; han:='';
 end;
 {
 Adam simulator clean
 }
 procedure adam_clear;
 var port,conn:Integer;
 begin
  for port:=1 to MaxPortNum do begin
   adam.Port[port].Decl:='';
   adam.Port[port].Pipe:=0;
   adam.Port[port].CSum:=0;
   adam.Port[port].Req:='';
   adam.Port[port].Ans:='';
   for conn:=0 to MaxConnNum do adam.Port[port].Buf[conn]:='';
   adam.Port[port].Hand:=0;
  end;
 end;
 {
 Adam port close
 }
 procedure adam_close(port:Integer);
 var conn:Integer;
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do adam_close(port);
  end else
  if adam_port_ok(port) then begin
   if adam.Port[port].Pipe<>0 then begin
    if pipe_free(adam.Port[port].Pipe)
    then Success('Closed port '+Str(port)+' '+adam.Port[port].Decl);
   end;
   if adam.Port[port].Hand<>0 then bNul(text_free(adam.Port[port].Hand));
   adam.Port[port].Decl:='';
   adam.Port[port].Pipe:=0;
   adam.Port[port].CSum:=0;
   adam.Port[port].Req:='';
   adam.Port[port].Ans:='';
   for conn:=0 to MaxConnNum do adam.Port[port].Buf[conn]:='';
   adam.Port[port].Hand:=0;
  end;
 end;
 {
 Adam port open
 }
 procedure adam_open(port:Integer; decl:String);
 begin
  if not IsEmptyStr(decl) then
  if adam_port_ok(port) then begin
   adam_close(port);
   adam.Port[port].Pipe:=pipe_init(decl);
   if adam.Port[port].Pipe<>0 then begin
    Success('Opened port '+Str(port)+' '+adam.Port[port].Decl);
    adam.Port[port].Decl:=Trim(decl);
    adam.Port[port].Hand:=text_new;
   end;
  end;
 end;
 {
 Adam simulator initialization
 }
 procedure adam_init;
 var port:Integer;
 begin
  adam_clear;
  //RunStartupScript;
  InitDevice(devAdamSimDlg,    ReadIni('devAdamSimDlg'),        2);
  InitTag(adam.sim.Port.tag,   ReadIni('tagAdamSim')+'.Port',   1);
  InitTag(adam.sim.Req.tag,    ReadIni('tagAdamSim')+'.Req',    3);
  InitTag(adam.sim.Ans.tag,    ReadIni('tagAdamSim')+'.Ans',    3);
  InitTag(adam.sim.Notify.tag, ReadIni('tagAdamSim')+'.Notify', 1);
 end;
 {
 Adam simulator finalization
 }
 procedure adam_free;
 begin
  RunFinallyScript;
  adam_close(0);
  adam_clear;
 end;
 {
 Adam simulator polling
 }
 procedure adam_poll;
 var port,pipe,conn,sid:Integer;
 begin
  if RunCount=100 then RunStartupScript;
  if devAdamSimDlg<>0 then
  if iGetTag(adam.sim.Notify.tag)<>0 then begin
   if iGetTag(adam.sim.Notify.tag)=1 then begin
    if iGetTag(adam.sim.Port.tag)>0 then
    if not IsEmptyStr(sGetTag(adam.sim.Req.tag)) then
    if not IsEmptyStr(sGetTag(adam.sim.Ans.tag)) then begin
     DevSendCmd(devMySelf,'@PortHandler '+Str(iGetTag(adam.sim.Port.tag))+' '
               +Trim(sGetTag(adam.sim.Req.tag))+' str '
               +Trim(sGetTag(adam.sim.Ans.tag)));
    end;
   end;
   if iGetTag(adam.sim.Notify.tag)=2 then begin
    DevSendCmd(devAdamSimDlg,'Confirm=2');
   end;
   bNul(iSetTag(adam.sim.Notify.tag,0));
  end;
  for port:=1 to MaxPortNum do begin
   pipe:=adam.Port[port].Pipe;
   if pipe<>0 then begin
    adam.Port[port].Req:='';
    adam.Port[port].Ans:='';
    if pipe_connected(pipe)>0 then
    for conn:=0 to Round(Min(MaxConnNum,pipe_count(pipe)-1)) do begin
     sid:=pipe_stream(pipe,conn);
     if pipe_connected(sid)>0 then
     if pipe_readln(sid,adam.Port[port].Req,adam.Port[port].Buf[conn]) then begin
      if Length(adam.Port[port].Req)>0 then begin
       if iAnd(DebugFlags,dfViewImp)<>0 then ViewImp('COM'+Str(port)+' < '+adam.Port[port].Req);
       adam.Port[port].Ans:=adam_dcon_ans(port,Trim(adam.Port[port].Req));
       if Length(adam.Port[port].Ans)>0 then begin
        if iAnd(DebugFlags,dfViewExp)<>0 then ViewExp('COM'+Str(port)+' > '+Trim(adam.Port[port].Ans));
        if pipe_send(sid,adam.Port[port].Ans)=Length(adam.Port[port].Ans) then begin
         if iAnd(DebugFlags,dfDetails)<>0
         then Details('Sent '+Str(Length(adam.Port[port].Ans))+' bytes to port '+Str(port));
        end else Trouble('COM'+Str(port)+' ! Could not send answer ! '+adam.Port[port].Ans);
       end else Trouble('COM'+Str(port)+' ! Bad request, no answer ! '+adam.Port[port].Req);
       adam.Port[port].Req:='';
       adam.Port[port].Ans:='';
      end;
      adam.Port[port].Buf[conn]:='';
      bNul(pipe_rxclear(sid));
     end else begin
      if Length(adam.Port[port].Buf[conn])>255 then begin
       Trouble('COM'+Str(port)+' ! Bad request, overflow !');
       adam.Port[port].Buf[conn]:='';
       bNul(pipe_rxclear(sid));
      end;
     end;
    end;
   end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  adam_clear;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  adam_init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  adam_free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  adam_poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; i,n,port:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @PortOpen 4 COM Port 4 BaudRate 115200 Parity NONE DataBits 8 StopBits 1
   }
   if IsSameText(cmd,'@PortOpen') then begin
    port:=iValDef(ExtractWord(1,arg),0);
    adam_open(port,SkipWords(1,arg));
    Data:='';
   end else
   {
   @PortClose 4
   }
   if IsSameText(cmd,'@PortClose') then begin
    port:=iValDef(ExtractWord(1,arg),0);
    adam_close(port);
    Data:='';
   end else
   {
   @UsesCheckSum 4 1
   }
   if IsSameText(cmd,'@UsesCheckSum') then begin
    port:=iValDef(ExtractWord(1,arg),0);
    if adam_port_ok(port) then begin
     adam.Port[port].CSum:=Ord(iValDef(ExtractWord(2,arg),0)<>0);
     Success(cmd+' '+Str(port)+' '+Str(adam.Port[port].CSum));
    end;;
    Data:='';
   end else
   {
   @PortHandler 4 #01 str 100.00
   }
   if IsSameText(cmd,'@PortHandler') then begin
    port:=iValDef(ExtractWord(1,arg),0);
    if adam_port_ok(port) then begin
     n:=-1;
     for i:=0 to text_numln(adam.Port[port].Hand)-1 do
     if ExtractWord(1,text_getln(adam.Port[port].Hand,i))=ExtractWord(2,arg) then n:=i;
     if n<0
     then bNul(text_addln(adam.Port[port].Hand,SkipWords(1,Trim(arg))))
     else bNul(text_putln(adam.Port[port].Hand,n,SkipWords(1,Trim(arg))));
     Success(cmd+' '+Str(port)+' '+SkipWords(1,Trim(arg)));
    end;;
    Data:='';
   end else
   {
   @View
   }
   if IsSameText(cmd,'@View') then begin
    i:=Val(Trim(arg)); n:=i;
    if i=0 then begin i:=1; n:=MaxPortNum; end; 
    for port:=i to n do
    if adam_port_ok(port) then if adam.Port[port].pipe<>0 then begin
     Success('@PortOpen '+Str(port)+' '+adam.Port[port].Decl);
     Success('@UsesCheckSum '+Str(port)+' '+Str(adam.Port[port].CSum));
     for i:=0 to text_numln(adam.Port[port].Hand)-1 do
     Success('@PortHandler '+Str(port)+' '+text_getln(adam.Port[port].Hand,i));
    end;;
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
