 {
 Demo program to speak via Speech API.
 For working, it needs two COM objects to be installed:
 1)Freeware Microsoft Speech API 4.0 from URL:
   http://activex.microsoft.com/activex/controls/sapi/spchapi.exe
 2)Freeware speech engine Lernout&Hauspie Text-To-Speech from URL:
   http://activex.microsoft.com/activex/controls/agent2/lhttseng.exe - UK English
   http://activex.microsoft.com/activex/controls/agent2/lhttsrur.exe - Russin
 }
program demo_speak;
var r,tm:real; b:boolean;
begin
 {
 Actions on start...
 }
 if runcount=1 then begin
  writeln(devname+' : Start.');
  {*** Open console window ***}
  b:=WinShow(ParamStr('Console '+devname));
  b:=WinSelect(ParamStr('Console '+devname));
  {*** Start Speech API, first available engine ***}
  r:=eval('@system @async @speech engine 1');
  if IsUnix then r:=eval('@system @async @speech engine Aleksandr');
  if IsWindows then r:=eval('@system @async @speech engine Adult Male #1 Russian (L&H)');
  r:=eval('@system @async @speech wait 1');
  {*** Speak few messages ***}
  r:=eval('@system @async @speak Добрый день.');
  r:=eval('@system @async @speak Этот пример иллюстрирует работу речевого синтезатора.');
  r:=eval('@system @async @speak Для его работы необходимо установить Speech API.');
  r:=eval('@system @async @speak Обратите внимание, что все вызовы команд speech и speak асинхронны.');
  {*** Start timer ***}
  tm:=tm_new;
  b:=tm_addint(tm,10000);
  b:=tm_start(tm);
 end else
 {
 Actions on stop...
 }
 if isinf(runcount) then begin
  writeln(devname+' : Stop.');
  {*** Stop Speech API ***}
  r:=eval('@system @async @speech engine 0');
  {*** Free timer ***}
  b:=tm_free(tm);
 end else
 {
 Actions on poll...
 }
 begin
  {*** Each 10 sec speak time ***}
  if tm_event(tm) then begin
   r:=Round(tm_gettime(tm)/timeunits);
   b:=eval('@system @async @speak Прошло '+Str(r)+' секунд.')>0;
   writeln(runcount:5:0,' ',r:5:0,' [sec]');
  end;
 end;
end.
