 {
 ***********************************************************************
 Daq Pascal application program sce_bacc_bstr_vacs_sect.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @smi_proxy cmd - Send command (cmd) to smiProxy.exe.
|********************************************************
[]
 }
program sce_bacc_bstr_vacs_sect;
//{$t+}
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_SmiProxy}              { Include SMI Proxy    constants   }
 {$I sce_bacc_bstr_vacs_const}   { Include all BSTR VACS constants  }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 {$I sce_bacc_bstr_vacs_types}   { Include all BSTR VACS types      }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_SmiProxy}              { Include SMI Proxy    variables   }
 BSTR    : TBSTRRec;             { All BSTR VACS data...            }
 SectNum : Integer;              { Section number                   }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_SmiProxy}              { Include SMI Proxy    functions   }
 {$I sce_bacc_bstr_vacs_funcs}   { Include all BSTR VACS functions  }

 //
 // Vacuum sections pressure threshold: norm,warn,fail
 //
 function sect_pressure_threshold_norm:Real;
 begin
  case SectNum of
   1: sect_pressure_threshold_norm:=rGetTag(BSTR.VACS.SEC1.NORMPS.tag);
   2: sect_pressure_threshold_norm:=rGetTag(BSTR.VACS.SEC2.NORMPS.tag);
   3: sect_pressure_threshold_norm:=rGetTag(BSTR.VACS.SEC3.NORMPS.tag);
   4: sect_pressure_threshold_norm:=rGetTag(BSTR.VACS.SEC4.NORMPS.tag);
   5: sect_pressure_threshold_norm:=rGetTag(BSTR.VACS.SEC5.NORMPS.tag);
   6: sect_pressure_threshold_norm:=rGetTag(BSTR.VACS.SEC6.NORMPS.tag);
  end;
 end;
 function sect_pressure_threshold_warn:Real;
 begin
  case SectNum of
   1: sect_pressure_threshold_warn:=rGetTag(BSTR.VACS.SEC1.WARNPS.tag);
   2: sect_pressure_threshold_warn:=rGetTag(BSTR.VACS.SEC2.WARNPS.tag);
   3: sect_pressure_threshold_warn:=rGetTag(BSTR.VACS.SEC3.WARNPS.tag);
   4: sect_pressure_threshold_warn:=rGetTag(BSTR.VACS.SEC4.WARNPS.tag);
   5: sect_pressure_threshold_warn:=rGetTag(BSTR.VACS.SEC5.WARNPS.tag);
   6: sect_pressure_threshold_warn:=rGetTag(BSTR.VACS.SEC6.WARNPS.tag);
  end;
 end;
 function sect_pressure_threshold_fail:Real;
 begin
  case SectNum of
   1: sect_pressure_threshold_fail:=rGetTag(BSTR.VACS.SEC1.FAILPS.tag);
   2: sect_pressure_threshold_fail:=rGetTag(BSTR.VACS.SEC2.FAILPS.tag);
   3: sect_pressure_threshold_fail:=rGetTag(BSTR.VACS.SEC3.FAILPS.tag);
   4: sect_pressure_threshold_fail:=rGetTag(BSTR.VACS.SEC4.FAILPS.tag);
   5: sect_pressure_threshold_fail:=rGetTag(BSTR.VACS.SEC5.FAILPS.tag);
   6: sect_pressure_threshold_fail:=rGetTag(BSTR.VACS.SEC6.FAILPS.tag);
  end;
 end;
 //
 // Booster vacuum pressure sensing probes: PS1..PS6
 //
 function bstr_vacs_probe_ps1:Real;
 begin
  bstr_vacs_probe_ps1:=rGetTag(BSTR.VACS.SEC1.PS1.MBAR.tag);
 end;
 function bstr_vacs_probe_ps2:Real;
 begin
  bstr_vacs_probe_ps2:=rGetTag(BSTR.VACS.SEC2.PS2.MBAR.tag);
 end;
 function bstr_vacs_probe_ps3:Real;
 begin
  bstr_vacs_probe_ps3:=rGetTag(BSTR.VACS.SEC3.PS3.MBAR.tag);
 end;
 function bstr_vacs_probe_ps4:Real;
 begin
  bstr_vacs_probe_ps4:=rGetTag(BSTR.VACS.SEC4.PS4.MBAR.tag);
 end;
 function bstr_vacs_probe_ps5:Real;
 begin
  bstr_vacs_probe_ps5:=rGetTag(BSTR.VACS.SEC5.PS5.MBAR.tag);
 end;
 function bstr_vacs_probe_ps6:Real;
 begin
  bstr_vacs_probe_ps6:=rGetTag(BSTR.VACS.SEC6.PS6.MBAR.tag);
 end;
 function bstr_vacs_probe_ps(num:Integer):Real;
 var ps:Real;
 begin
  ps:=0;
  case num of
   1: ps:=rGetTag(BSTR.VACS.SEC1.PS1.MBAR.tag);
   2: ps:=rGetTag(BSTR.VACS.SEC2.PS2.MBAR.tag);
   3: ps:=rGetTag(BSTR.VACS.SEC3.PS3.MBAR.tag);
   4: ps:=rGetTag(BSTR.VACS.SEC4.PS4.MBAR.tag);
   5: ps:=rGetTag(BSTR.VACS.SEC5.PS5.MBAR.tag);
   6: ps:=rGetTag(BSTR.VACS.SEC6.PS6.MBAR.tag);
  end;
  bstr_vacs_probe_ps:=ps;
 end;

 //
 // Do when vacuum section[num] state is OFF.
 //
 procedure DO_WHEN_SECT_OFF(num:Integer);
 begin
  set_sect_valve_state(num,bt_OFF);
  set_sect_pumps_state(num,bt_OFF);
 end;
 //
 // Do when vacuum section[num] state is STANDBY.
 //
 procedure DO_WHEN_SECT_STANDBY(num:Integer);
 begin
 end;
 //
 // Do when vacuum section[num] state is MIXED.
 //
 procedure DO_WHEN_SECT_MIXED(num:Integer);
 begin
 end;
 //
 // Do when vacuum section[num] state is PUMPING.
 //
 procedure DO_WHEN_SECT_PUMPING(num:Integer);
 begin
  //
  // Fail and Warn threshold handle
  //
  if bstr_vacs_probe_ps(num)>sect_pressure_threshold_fail
  then begin
   set_sect_pumps_state(SectNum,bt_OFF);
   set_sect_valve_state(SectNum,bt_OFF);
   smi_terminate_action('ERROR');
  end else
  if bstr_vacs_probe_ps(num)>sect_pressure_threshold_warn
  then smi_terminate_action('WARNING');
 end;
 //
 // Do when vacuum section[num] state is READY.
 //
 procedure DO_WHEN_SECT_READY(num:Integer);
 begin
  //
  // Fail and Warn threshold handle
  //
  if bstr_vacs_probe_ps(num)>sect_pressure_threshold_fail
  then begin
   set_sect_pumps_state(SectNum,bt_OFF);
   set_sect_valve_state(SectNum,bt_OFF);
   smi_terminate_action('ERROR');
  end else
  if bstr_vacs_probe_ps(num)>sect_pressure_threshold_warn
  then smi_terminate_action('WARNING');
 end;
 //
 // Do when vacuum section[num] state is WARNING.
 //
 procedure DO_WHEN_SECT_WARNING(num:Integer);
 begin
  //
  // Fail and Warn threshold handle
  //
  if bstr_vacs_probe_ps(num)>sect_pressure_threshold_fail
  then begin
   set_sect_pumps_state(SectNum,bt_OFF);
   set_sect_valve_state(SectNum,bt_OFF);
   smi_terminate_action('ERROR');
  end;
  DevPostCmdLocal('@tooltip guid SMI/WARNING'+Str(num)+' preset stdWarning delay 15000 text "'+DevName+
                  ': Vacuum section '+Str(num)+': warning state!"');
 end;
 //
 // Do when vacuum section[num] state is ERROR.
 //
 procedure DO_WHEN_SECT_ERROR(num:Integer);
 begin
  set_sect_valve_state(num,bt_OFF);
  set_sect_pumps_state(num,bt_OFF);
  DevPostCmdLocal('@tooltip guid SMI/ERROR'+Str(num)+' preset stdError delay 15000 text "'+DevName+
                  ': Vacuum section '+Str(num)+': error state!"');
 end;
 //
 // Do when vacuum section[num] state is MANUAL.
 //
 procedure DO_WHEN_SECT_MANUAL(num:Integer);
 begin
 end;
 //
 // Do when vacuum section[num] state is DEAD.
 //
 procedure DO_WHEN_SECT_DEAD(num:Integer);
 begin
 end;

 //
 // Handle GO_STANDBY action
 //
 procedure ON_ACTION_GO_STANDBY(new_state:String);
 begin
  smi_terminate_action(new_state);
 end;
 //
 // Handle GO_MANUAL action
 //
 procedure ON_ACTION_GO_MANUAL(new_state:String);
 begin
  smi_terminate_action(new_state);
 end;
 //
 // Handle SWITCH_OFF action
 //
 procedure ON_ACTION_SWITCH_OFF(new_state:String);
 begin
  smi_terminate_action(new_state);
 end;
 //
 // Handle START_PUMP action
 //
 procedure ON_ACTION_START_PUMP(new_state:String);
 begin
  //
  // Norm threshold value validate
  //
  if bstr_vacs_probe_ps(SectNum)<sect_pressure_threshold_norm
  then set_sect_pumps_state(SectNum,bt_ON)
  else begin
   new_state:='';
   DevPostCmdLocal('@tooltip guid SMI/START_PUMP'+Str(SectNum)+' preset stdWarning delay 15000 text "'+DevName+
                   ': Vacuum section '+Str(SectNum)+': no pumping, vacuum above the norm threshold!"');
  end;
  smi_terminate_action(new_state);
 end;
 //
 // Handle STOP_PUMP action
 //
 procedure ON_ACTION_STOP_PUMP(new_state:String);
 begin
  set_sect_pumps_state(SectNum,bt_OFF);
  smi_terminate_action(new_state);
 end;
 //
 // Handle OPEN_SECTION action
 //
 procedure ON_ACTION_OPEN_SECTION(new_state:String);
 begin
  //
  // Norm threshold value validate
  //
  if bstr_vacs_probe_ps(SectNum)<sect_pressure_threshold_norm
  then set_sect_valve_state(SectNum,bt_ON)
  else begin
   new_state:='';
   DevPostCmdLocal('@tooltip guid SMI/OPEN_SECT'+Str(SectNum)+' preset stdWarning delay 15000 text "'+DevName+
                   ': Vacuum section '+Str(SectNum)+': no open section, vacuum above the norm threshold!"');
  end;
  smi_terminate_action(new_state);
 end;
 //
 // Handle CLOSE_SECTION action
 //
 procedure ON_ACTION_CLOSE_SECTION(new_state:String);
 begin
  set_sect_valve_state(SectNum,bt_OFF);
  smi_terminate_action(new_state);
 end;
 //
 // Handle RESET action
 //
 procedure ON_ACTION_RESET(new_state:String);
 begin
  if IsSectPump(SectNum)
  then if IsSectOpen(SectNum)
  then new_state:='READY'
  else new_state:='PUMPING';
  smi_terminate_action(new_state);
 end;

 //
 // SMI Proxy Initialization.
 //
 procedure InitTheProxy;
 var p:Integer;
 begin
  // Initialize tags & devices...
  TBSTRRec_Init(BSTR,ReadIni('tagVACS'));
  // Get Vacuum Section number
  p:=Pos('.SEC',UpCaseStr(DevName));
  if(p>0) then SectNum:=Val(Copy(DevName,p+4,1)) else SectNum:=0;
  if(SectNum<1) or (SectNum>6) then SectNum:=0;
  Success('SectNum = '+Str(SectNum));
 end;

 //
 // SMI Proxy Logic.
 //
 procedure SmiProxyLogic;
 var fsm,dom,obj,sta:Integer;
 begin
  //
  // Get Proxy FSM, Object, Domain, State.
  //
  fsm:=smi_proxy_fsm;
  dom:=smi_proxy_dom;
  obj:=smi_proxy_obj;
  sta:=fsm_get_state(obj);
  //
  // SMI Proxy BUSY operations.
  // SMI actions handler there.
  //
  if smi_proxy_handler_busy then begin
   //
   // SMI actions handler:
   //
   if smi_test_action('GO_STANDBY') then begin
    ON_ACTION_GO_STANDBY('STANDBY');
   end else
   if smi_test_action('GO_MANUAL') then begin
    ON_ACTION_GO_MANUAL('MANUAL');
   end else
   if smi_test_action('SWITCH_OFF') then begin
    ON_ACTION_SWITCH_OFF('OFF');
   end else
   if smi_test_action('START_PUMP') then begin
    ON_ACTION_START_PUMP('PUMPING');
   end else
   if smi_test_action('OPEN_SECTION') then begin
    ON_ACTION_OPEN_SECTION('READY');
   end else
   if smi_test_action('CLOSE_SECTION') then begin
    ON_ACTION_CLOSE_SECTION('PUMPING');
   end else
   if smi_test_action('STOP_PUMP') then begin
    ON_ACTION_STOP_PUMP('STANDBY');
   end else
   if smi_test_action('RESET') then begin
    ON_ACTION_RESET('STANDBY');
   end else
   begin // Unknown action came
    smi_terminate_action(smi_proxy_state_name);
    Problem('Unknown action came: '+smi_proxy_handler_action);
   end;
  end else
  //
  // SMI Proxy IDLE operations.
  // Do when actions completed.
  //
  if smi_proxy_handler_idle then begin
   //
   // SMI Proxy state handler.
   //
   if smi_test_state('OFF') then begin
    DO_WHEN_SECT_OFF(SectNum);
   end else
   if smi_test_state('STANDBY') then begin
    DO_WHEN_SECT_STANDBY(SectNum);
   end else
   if smi_test_state('MIXED') then begin
    DO_WHEN_SECT_MIXED(SectNum);
   end else
   if smi_test_state('PUMPING') then begin
    DO_WHEN_SECT_PUMPING(SectNum);
   end else
   if smi_test_state('READY') then begin
    DO_WHEN_SECT_READY(SectNum);
   end else
   if smi_test_state('WARNING') then begin
    DO_WHEN_SECT_WARNING(SectNum);
   end else
   if smi_test_state('ERROR') then begin
    DO_WHEN_SECT_ERROR(SectNum);
   end else
   if smi_test_state('MANUAL') then begin
    DO_WHEN_SECT_MANUAL(SectNum);
   end else
   if smi_test_state('DEAD') then begin
    DO_WHEN_SECT_DEAD(SectNum);
   end else
   Trouble('Unknown state '+fsm_name(fsm_get_state(smi_proxy_obj)));
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearSmiProxy;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('@StartupScript','@FinallyScript');
  StdIn_SetTimeouts(0,60000,0,3000);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitSmiProxy;
  InitTheProxy;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeSmiProxy;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  if ShouldPollSmiProxy then PollSmiProxy;
  SmiProxyLogic;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   {
   !!! Handle SMI Proxy by default handler !!!
   !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   }
   if smi_proxy_default_handler(Data,cmd,arg,cmdid) then begin
    if (Data<>'') then Success(smi_proxy_prompt+Data);
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
