 {
 ***********************************************************************
 Daq Pascal application program Template.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Demo ex1 ex2  - Evaluate 2 expressions, just for demo.
|********************************************************
| @DimTagUpdate  - Dim Tag Update.
| @DIMCMDMY arg - Dim My Command, arg = @cmd in base64 code
[]
 }
program i7017_drv;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {$I _con_NetRS485}
 {------------------------------}{ And add User defined constants:  }
 MaxCmdNum              = 13;     { Maximal count of commands         }
 cm_ReadValueAllChannel = 1;      
 cm_ReadParameters      = 2;      
 cm_ReadDataAllChannel  = 3;      
 cm_ReadVersion         = 4;      
 cm_ReadName            = 5;      
 cm_SetName             = 6;      
 cm_SetConfig           = 7;      
 cm_SetBaudrate         = 8;      
 cm_SetSuppHz           = 9;      
 cm_SetWorkMode         = 10;     
 cm_SetCheckSumm        = 11;     
 cm_SetFormatData       = 12; 
 do_RX        = 1;               { DO: RX                           }
 do_TX        = 2;               { DO: TX                           } 
 defTypeCode            = 8;      { Default Device Type              }
 defBaudRate            = 6;      { Default Baudrate                 }
 defDataFormat          = 0;      { Default Data Format               }
 le_req                 = '0D';   { Lineending for request to device }
 ai_POLLRATERX          = 1;      { DigitalOutput - Poll rate Rx     }
 ai_POLLRATETX          = 2;      { DigitalOutput - Poll rate Tx     }
 ai_POLLSUMMRX          = 5;      { DigitalOutput - Poll summ Rx     }
 ai_POLLSUMMTX          = 6;      { DigitalOutput - Poll summ Tx     }
 
type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {$I _var_NetRS485}
 {------------------------------}{ And add User defined variables:  }
 cmd_DimTagUpdate : Integer;     { System Command @DimTagUpdate     }
 cmd_DimCmdMy     : Integer;     { System Command @DIMCMDMY        }
 cmd_Demo           : Integer;    { Command @Demo                   }
 cmd_Edit           : Integer;    { Command @Edit                   }
 cmd_ParamName      : Integer;    { Command @PARAM.NAME             }
 cmd_ParamConfig    : Integer;    { Command @Param.Config           }
 cmd_ParamAddress   : Integer;    { Command @Param.Address          }
 cmd_ParamBaudrate  : Integer;    { Command @Param.Baudrate         }
 cmd_Poll           : Integer;
 cmd_ParamDataForm  : Integer;
 cmd_ParamFormatData: Integer;
 
 I7017              :record
  NewName            :  string;
  NewCfg             :  string;
  NAME               : TTagRef;   { Tag: Name of device                  }
  VERSION            : TTagRef;   { Tag: Firmware Version of device      }
  ADDRESS            : TTagRef;   { Tag: Address of device               }
  BAUDRATE           : TTagRef;   { Tag: Baudrate of device              }
  SuppHZ             : TTagRef;
  Workmode           : TTagRef;
  Aitype             : TTagRef;
  Dataform           : TTagRef;
  FormatData         : TTagRef;
  CheckSumm          : TTagRef;
  PollButton         : TTagRef;
  AI1                : TTagRef;
  AI2                : TTagRef;
  AI3                : TTagRef;
  AI4                : TTagRef;
  AI5                : TTagRef;
  AI6                : TTagRef;
  AI7                : TTagRef;
  AI8                : TTagRef;
  RX                 : TTagRef;
  TX                 : TTagRef;
  SERVMODE           : TTagRef;    { Is DIM Server Mode?              }

  RS485              : record
   DelayOnStart       : Integer;
   UnitId             : Integer;
   Port               : Integer;
   TimeOut            : Integer;
   Polling            : Integer;
   Deadline           : Integer;
   Ref                : Integer; { Reference for RS485Proxy              }
   cid                : Integer;
   tim                :    Real;
   uid                : Integer;
   Summ,                        { Poll summ counters               }
   Rate    : record             { Poll rate on last second         }
    Rx     : Integer;              { Rx poll summ/rate - receiver     }
    Tx     : Integer;              { Tx poll summ/rate - transmitter  }
   end;
    req                :record
     dat                :  String;
    end;
    ans                :record
     dat                :  String;
    end;
  end;
  CmdTab  :record
   Num           : Integer;      { Last sent command ID                       }
   CmdId         : array[1..MaxCmdNum] of Integer;     { Command ID           }
   Enabled       : array[1..MaxCmdNum] of Boolean;     { Enabled command      }
   Acronym       : array[1..MaxCmdNum] of String;      { Data for send        }
   Aitype        : array[1..MaxCmdNum] of string;
   NewData       : array[1..MaxCmdNum] of String;      {                      }
   Comment       : array[1..MaxCmdNum] of String;      { Comments of command  }
   Count         : Integer;
  end;
 end;
 
 cmd_RS485Reply      : Integer;     { RS485 commands:                 }
 cmd_RS485Refuse     : Integer;     {                                  }
 cmd_RS485Timeout    : Integer;     {                                  }
 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {$I _fun_NetRS485}
 {------------------------------}{ And add User defined functions:  }
 
 
 
 Procedure I7017_ClearStrings;
 var i:Integer;
 begin
  I7017.NewName:='';
  I7017.NewCfg:='';
  I7017.RS485.req.Dat:='';
  I7017.RS485.ans.Dat:='';
  for i:=1 to MaxCmdNum do begin
   I7017.CmdTab.Acronym[i]:='';
   I7017.CmdTab.Aitype[i]:='';
   I7017.CmdTab.NewData[i]:='';
   I7017.CmdTab.Comment[i]:='';
  end;
 end;
 {
 Clear Data
 }
 Procedure I7017_Clear;
 var i:Integer;
 begin
  I7017.CmdTab.Num:=0;
  I7017.RS485.UnitId:=0;
  for i:=1 to MaxCmdNum do begin
   I7017.CmdTab.Enabled[i]:=False;
   I7017.CmdTab.NewData[i]:='';
   I7017.CmdTab.CmdId[i]:=0;
  end;
 end;
 
  procedure ClearRS485Poll;
 begin
  I7017.RS485.cid:=0;
  I7017.RS485.ans.dat:='';
 end;
 
 function ValidateCmdNum(Num:Integer):Integer;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then ValidateCmdNum:=Num
  else ValidateCmdNum:=1;
 end;
 
 function IsEnabledCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsEnabledCmdNum:=(I7017.CmdTab.CmdId[Num]<>0) and I7017.CmdTab.Enabled[Num]
  else IsEnabledCmdNum:=False;
 end;
 
 procedure I7017_EnableCmdId(CmdId:Integer; Enabled:Boolean);
 var i:Integer;
 begin
  for i:=0 to I7017.CmdTab.Count-1 do
  if I7017.CmdTab.CmdId[i]=CmdId then I7017.CmdTab.Enabled[i]:=Enabled;
 end;
 
 function devTheProxy:Integer;
 begin
  devTheProxy:=devRS485Proxy; // otherwise use &ModbusProxy
 end;
 
 function IsPortOpened:Boolean;
 begin
  IsPortOpened:=(I7017.RS485.Port>0) and (devTheProxy<>0);
 end;
 
 function NextEnabledCmdNum(Num:Integer):Integer;
 var i:Integer;
 begin
  i:=0;
  while (i<MaxCmdNum) do begin
   Num:=ValidateCmdNum(Num+1);
   if IsEnabledCmdNum(Num)
   then i:=MaxCmdNum
   else i:=i+1;
  end;
  NextEnabledCmdNum:=Num;
 end;
 
  function IsValidCmdNum(Num:Integer):Boolean;
 begin
  IsValidCmdNum:=(1<=Num) and (Num<=MaxCmdNum);
 end;
 
 procedure AssignRS485Poll(ref,cid:Integer; tim:Real; port,uid:Integer; dat:String);
 begin
  I7017.RS485.ref:=ref;     I7017.RS485.cid:=cid;     I7017.RS485.tim:=tim;
  I7017.RS485.port:=port;   I7017.RS485.uid:=uid;     
 end;
 
  procedure I7017_FillTags(InitVal:Real);
 begin
  I7017.NAME.val          :=InitVal;
  I7017.VERSION.val       :=InitVal;
  I7017.Aitype.val        :=InitVal;
  I7017.ADDRESS.val       :=InitVal;
  I7017.BAUDRATE.val      :=InitVal;
  I7017.FORMATDATA.val    :=InitVal;
  I7017.PollButton.val    :=InitVal;
  I7017.AI1.val           :=InitVal;
  I7017.AI2.val           :=InitVal;
  I7017.AI3.val           :=InitVal;
  I7017.AI4.val           :=InitVal;
  I7017.AI5.val           :=InitVal;
  I7017.AI6.val           :=InitVal;
  I7017.AI7.val           :=InitVal;
  I7017.AI8.val           :=InitVal;
  I7017.RX.val            :=InitVal;
  I7017.TX.val            :=InitVal;
 end;
 
 procedure I7017_InitTags(Prefix:String; InitVal:Real);
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(I7017.NAME.tag       ,Prefix+'.NAME'       ,3);
   InitTag(I7017.VERSION.tag    ,Prefix+'.VERSION'    ,3);
   InitTag(I7017.Aitype.tag     ,Prefix+'.Aitype'     ,1);
   InitTag(I7017.ADDRESS.tag    ,Prefix+'.ADDRESS'    ,1);
   InitTag(I7017.BAUDRATE.tag   ,Prefix+'.BAUDRATE'   ,1);
   InitTag(I7017.FORMATDATA.tag ,Prefix+'.FORMATDATA' ,1);
   InitTag(I7017.PollButton.tag ,Prefix+'.POLLBUTTON'  ,1);
   InitTag(I7017.AI1.tag        ,Prefix+'.AI1'        ,2);
   InitTag(I7017.AI2.tag        ,Prefix+'.AI2'        ,2);
   InitTag(I7017.AI3.tag        ,Prefix+'.AI3'        ,2);
   InitTag(I7017.AI4.tag        ,Prefix+'.AI4'        ,2);
   InitTag(I7017.AI5.tag        ,Prefix+'.AI5'        ,2);
   InitTag(I7017.AI6.tag        ,Prefix+'.AI6'        ,2);
   InitTag(I7017.AI7.tag        ,Prefix+'.AI7'        ,2);
   InitTag(I7017.AI8.tag        ,Prefix+'.AI8'        ,2);
   InitTag(I7017.SERVMODE.tag   ,Prefix+'.SERVMODE'   ,1);
   InitTag(I7017.RX.tag         ,Prefix+'.RX',1);
   InitTag(I7017.TX.tag         ,Prefix+'.TX',1);
   I7017_FillTags(InitVal);
  end;
 end;
 
 Procedure I7017_Aitype;
 var Aitype:Integer;
 begin
  Aitype:=val('$'+copy(I7017.RS485.ans.dat, 4,2));
  if ((Aitype>=8) and (Aitype<=13)) then begin
   if Aitype=8 then begin  
     bNul(isettag(I7017.Aitype.tag,Aitype));
   end else
   if Aitype=9 then begin
    bNul(isettag(I7017.Aitype.tag,Aitype));
   end else
   if Aitype=10 then begin
    bNul(isettag(I7017.Aitype.tag,Aitype));
   end else
   if Aitype=11 then begin
    bNul(isettag(I7017.Aitype.tag,Aitype));
   end else
   if Aitype=12 then begin
    bNul(isettag(I7017.Aitype.tag,Aitype));
   end else
   if Aitype=13 then begin
    bNul(isettag(I7017.Aitype.tag,Aitype));
   end;
  end else Trouble('Incorrect value of Aitype')
 end;
 
 
 Procedure I7017_Baud;
 var Baud:Integer;
 begin
  Baud:=val('$'+copy(I7017.RS485.ans.dat, 6,2));
  if ((Baud>=3) and (Baud<=10)) then begin
   if Baud=3 then begin 
    bNul(isettag(I7017.Baudrate.tag,Baud));
   end else
   if Baud=4 then begin
    bNul(isettag(I7017.Baudrate.tag,Baud));
   end else
   if Baud=5 then begin
    bNul(isettag(I7017.Baudrate.tag,Baud));
   end else
   if Baud=6 then begin
    bNul(isettag(I7017.Baudrate.tag,Baud));
   end else
    bNul(isettag(I7017.Baudrate.tag,Baud));
   if Baud=8 then begin
    bNul(isettag(I7017.Baudrate.tag,Baud));
   end else
   if Baud=9 then begin
    bNul(isettag(I7017.Baudrate.tag,Baud));
   end else
   if Baud=10 then begin
    bNul(isettag(I7017.Baudrate.tag,Baud));
   end;
   bNul(isettag(I7017.Baudrate.tag,Baud));
  end else Trouble('Incorrect value of Baudrate');
 end;
 
 Procedure I7017_DataForm;
 var DataForm,WorkMode,CheckSumm,FormatData, SuppHz: Integer;
 begin
  DataForm:=val('$'+copy(I7017.RS485.ans.dat, 8,2));
  if (isbit(DataForm,0) and (not isbit(DataForm,1)))  then begin
   bNul(isettag(I7017.FORMATDATA.tag,1));
  end else
  if (isbit(DataForm,1) and (not isbit(DataForm,0))) then begin
   bNul(isettag(I7017.FORMATDATA.tag,2));
  end else
   bNul(isettag(I7017.FORMATDATA.tag,0));
  if isbit(DataForm,5) then begin
   bNul(isettag(I7017.WorkMode.tag,1));
  end else 
   bNul(isettag(I7017.WorkMode.tag,0));
  if isbit(DataForm,6) then begin
   bNul(isettag(I7017.CheckSumm.tag,1));
  end else
    bNul(isettag(I7017.CheckSumm.tag,0));
  if isbit(DataForm,7) then begin
   bNul(isettag(I7017.SuppHz.tag,1));
  end else 
   bNul(isettag(I7017.SuppHz.tag,0));
 end;
 
 procedure I7017_ValueAllChannel;
 var AI1, AI2, AI3, AI4, AI5, AI6 ,AI7, AI8: Real;
 begin
  AI1:=rval(copy(I7017.RS485.ans.dat, 1,7));
  bNul(rsettag(I7017.AI1.tag,AI1));
  AI2:=rval(copy(I7017.RS485.ans.dat, 8,7));
  bNul(rsettag(I7017.AI2.tag,AI2));
  AI3:=rval(copy(I7017.RS485.ans.dat, 15,7));
  bNul(rsettag(I7017.AI3.tag,AI3));
  AI4:=rval(copy(I7017.RS485.ans.dat, 22,7));
  bNul(rsettag(I7017.AI4.tag,AI4));
  AI5:=rval(copy(I7017.RS485.ans.dat, 29,7));
  bNul(rsettag(I7017.AI5.tag,AI5));
  AI6:=rval(copy(I7017.RS485.ans.dat, 36,7));
  bNul(rsettag(I7017.AI6.tag,AI6));
  AI7:=rval(copy(I7017.RS485.ans.dat, 43,7));
  bNul(rsettag(I7017.AI7.tag,AI7));
  AI8:=rval(copy(I7017.RS485.ans.dat, 50,7));
  bNul(rsettag(I7017.AI8.tag,AI8));
 end;

 procedure I7017_ReadVersion;
 var Vers: String;
 begin
  Vers:=copy(I7017.RS485.ans.dat, 4,20);
  bNul(ssettag(I7017.Version.tag,trim(Vers)));
  I7017.CmdTab.Enabled[cm_ReadVersion]:=false;
 end;
 
 Procedure I7017_ReadName;
 var Name: String;
 begin
  Name:=copy(I7017.RS485.ans.dat, 4,20);
  bNul(ssettag(I7017.Name.tag,trim(Name)));
  I7017.CmdTab.Enabled[cm_ReadName]:=false;
 end;

 Procedure I7017_Address;
 var address: Integer;
 begin
   Address:=strtointbase(copy(I7017.RS485.ans.dat,2,2),16,0);
 if Address>0 then begin
  if Address<=8 then begin
  bNul(isettag(I7017.ADDRESS.tag,Address));
  Writeln('I7017.Address.tag = '+str(igettag(I7017.ADDRESS.tag))); 
  I7017.CmdTab.Enabled[cm_ReadParameters]:=false;
   end else Trouble('Incorrect value of address');
  end else Trouble('Incorrect value of address');
 end;

   procedure InitCmdItem(CmdId :Integer; Enabled :Boolean; Acronym, NewData, Comment :String);
 begin
  if IsValidCmdNum(CmdId) then begin
   I7017.CmdTab.Enabled[CmdId]:=Enabled;
   I7017.CmdTab.CmdId[CmdId]:=CmdId; 
   Acronym:=copy(Acronym,1,1)+hexb(I7017.RS485.UnitId)+copy(Acronym,4,255);
   I7017.CmdTab.Acronym[CmdId]:=Acronym;
   I7017.CmdTab.NewData[CmdId]:=NewData;
   I7017.CmdTab.Comment[CmdId]:=Comment;
  end;
 end;
 
  procedure InitCmdTable;
 begin
  // Table of CommandId                   Enabled   COMMAND         NewData  Comment
  InitCmdItem(cm_ReadValueAllChannel,     False,     '#AA',          '',   'Read Value All Analog Inputs');
  InitCmdItem(cm_ReadDataAllChannel,      False,     '$AAA',         '',   'Read Data  All Analog Inputs');
  InitCmdItem(cm_ReadParameters,          True,     '$AA2',         '',   'Read Parameters'       );
  InitCmdItem(cm_ReadVersion,             True,     '$AAF',         '',   'Read Version');
  InitCmdItem(cm_ReadName,                True,     '$AAM',         '',   'Read Name');
  InitCmdItem(cm_SetName,                 False,    '~AAO',         '',   'Set Name');
  InitCmdItem(cm_SetConfig,               False,    '%AA',          '',   'Set Config');
  InitCmdItem(cm_SetBaudrate,             False,    '%AA',          '',   'Set Baudrate');
  InitCmdItem(cm_SetSuppHz,               False,    '%AA',          '',   'Set SuppHZ');
  InitCmdItem(cm_SetWorkMode,             False,    '%AA',          '',   'Set WorkMode');
  InitCmdItem(cm_SetCheckSumm,            False,    '%AA',          '',   'Set CheckSumm');
  InitCmdItem(cm_SetFormatData,           False,    '%AA',          '',   'Set Format Data'); 
 end;
   
 procedure ClearCmdTable;
 var Num:Integer;
 begin
  I7017.CmdTab.Num:=1;
  for Num:=1 to MaxCmdNum do InitCmdItem(Num,False,'','','');
 end;
 
 procedure ClearRS485Summ;
 begin
  I7017.RS485.Summ.Rx:=0;
  I7017.RS485.Summ.Tx:=0;
 end;
 //
 // Clear modbus poll rate counters.
 //
 procedure ClearRS485Rate;
 begin
  I7017.RS485.Rate.Rx:=0;
  I7017.RS485.Rate.Tx:=0;
 end;
 
  procedure IncSummRate(var summ,rate:Integer);
 begin
  summ:=summ+1; rate:=rate+1;
 end;

Procedure EnabledPoll;
 begin
  if iGetTag(I7017.PollButton.tag)>0 then begin
   I7017.CmdTab.Enabled[cm_ReadValueAllChannel]:=true;
  end else begin
   I7017.CmdTab.Enabled[cm_ReadValueAllChannel]:=false;
  end;
 end;
 
 { Разбор ответов от модуля }
 procedure I7017_OnCommand(cid:Integer);
 var address,msg,FirstSign,Baud,arg, DataForm, Aitype: String; UnitId: Integer;
 begin
  if cid=cm_ReadDataAllChannel then begin
  end else 
  if cid=cm_ReadValueAllChannel then begin
   if length(I7017.RS485.ans.dat)>0 then begin
    FirstSign:=copy(I7017.RS485.ans.dat,1,1);
    if FirstSign='>' then begin
     I7017.RS485.ans.dat:=copy(I7017.RS485.ans.dat,2,70);
     I7017_ValueAllChannel;
    end else
    Trouble('Incorrect answer');
   end;
   I7017.RS485.ans.dat:='';
  end else 
  if cid=cm_ReadParameters then begin
   I7017_Aitype;
   I7017_Baud;
   I7017_DataForm;
   I7017_Address;
   I7017.CmdTab.Enabled[cm_ReadParameters]:=false;
  end else 
  if cid=cm_SetName then begin
   FirstSign:=copy(I7017.RS485.ans.dat,1,1);   
   if FirstSign='!' then begin  
    Success('New Name:'+I7017.RS485.ans.dat);
    I7017.CmdTab.Enabled[cm_ReadName]:=true;
   end else begin Trouble('Неправильный ответ');
   end;
   I7017.CmdTab.Enabled[cm_SetName]:=False;
  end else
  if cid=cm_SetConfig then begin
   Address:=copy(I7017.RS485.ans.dat,2,2);
   bNul(isettag(I7017.ADDRESS.tag,val('$'+Address)));
   Writeln('New Address' + str(igettag(I7017.ADDRESS.tag)));
   I7017.RS485.UnitId:=IGettag(I7017.ADDRESS.tag);
   ClearCmdTable;
   InitCmdTable;
  end else
   if cid=cm_ReadVersion then begin
    I7017_ReadVersion;
   end else
   if cid=cm_ReadName then begin
    if length(I7017.RS485.ans.dat)<=9 then begin
     I7017_ReadName;
    end else Trouble('Incorrect length name');
   end else Trouble('Incorrect Command ID: '+str(cid));
  I7017.RS485.ans.dat:='';
 end;
 
 {
 Check answer from RS485Proxy
 }
 procedure I7017_OnReply(ref,cid,tim,port,uid:Integer; dat:String);
 var raw:String; p: integer;
 begin
  raw:=''; // Check is coming reply corresponded to sent request
  writeln(dat);
  if not IsValidCmdNum(cid)  then Trouble('Bad reply command '+Str(cid)) else
  if (port<>I7017.RS485.port) then Trouble('Bad reply port '+Str(port)) else
  if (uid<>I7017.RS485.UnitId) then Trouble('Bad reply unit id '+Str(uid)) else
  if (ref<>devTheProxy) then Trouble('Bad reply device '+RefInfo(ref,'Name')) else begin
   I7017.RS485.ans.dat:=Trim(dat);
   IncSummRate(I7017.RS485.Summ.Rx,I7017.RS485.Rate.Rx);
   p:=pos('$$',dat);
   I7017.RS485.ans.dat:=copy(dat,p+2); //Edit first sign for read
   I7017_OnCommand(cid);
  end;
 end;
 
  Procedure I7017_PrepareData(cid:Integer; var dat:String);
 begin
  dat:=I7017.CmdTab.Acronym[cid];
  if Length(I7017.CmdTab.NewData[cid])>0 then begin
   dat:=dat+I7017.CmdTab.NewData[cid];
   I7017.CmdTab.NewData[cid]:='';
  end;
  dat:=RS485_insert_le(dat,le_req);
 end;
 
 procedure I7017_Init;
 begin
  //
  // Read ini file variables
  //
 // I7017_InitTags(ReadIni('tagPrefix')) ;
  I7017.RS485.Port:=iValDef(ReadIni('RS485Port'),1); Success('RS485Port='+Str(I7017.RS485.Port));
  I7017.RS485.UnitId:=iValDef(ReadIni('RS485UnitId'),1); Success('RS485UnitId='+Str(I7017.RS485.UnitId));
  I7017.RS485.Timeout:=iValDef(ReadIni('RS485Timeout'),1000); Success('RRS485Timeout='+Str(I7017.RS485.Timeout));
  I7017.RS485.Deadline:=iValDef(ReadIni('RS485Deadline'),20000); Success('RS485Deadline='+Str(I7017.RS485.Deadline));
  I7017.RS485.DelayOnStart:=iValDef(ReadIni('DelayOnStart'),1000); Success('DelayOnStart='+Str(I7017.RS485.DelayOnStart));
  I7017.RS485.Polling:=iValDef(ReadIni('RS485Polling'),250); Success('RS485Polling='+Str(I7017.RS485.Polling));
  if IsRefDevice(RefFind('Device '+RS485Proxy)) then Success(RS485Proxy+' device found') else Trouble(RS485Proxy+' device not found!');
  I7017_InitTags(ReadIni('tagPrefix'),-MaxReal);
  InitCmdTable;
  I7017.CmdTab.Num:=1;
 end;
 
 Procedure I7017_Poll;
  procedure PollRS485Proxy(cid:Integer);
  var dev,ref,tot,port,uid:Integer; dat,address,Baud, DataForm, Aitype: String; 
   procedure Cleanup;
   begin
    dat:='';address:='';Baud:='';DataForm:='';Aitype:='';
   end;
  begin
   Cleanup;
   EnabledPoll; 
   if IsValidCmdNum(cid) then begin
    dev:=devTheProxy; I7017.RS485.cid:=cid; dat:=I7017.CmdTab.Acronym[cid]+I7017.CmdTab.NewData[cid];
    ref:=devMySelf; tot:=I7017.RS485.Timeout; port:=I7017.RS485.Port; uid:=I7017.RS485.UnitId;
    I7017_PrepareData(cid,dat);
    if DevSend(dev,RS485_proxy_poll('@RS485.Poll',ref,cid,tot,port,uid,dat))>0 then begin
      I7017.RS485.tim:=mSecNow;
      ViewExp('COM: '+RS485_proxy_nice('@RS485.Poll',ref,cid,tot,port,uid,dat,32));
      IncSummRate(I7017.RS485.Summ.Tx,I7017.RS485.Rate.Tx);
    end else begin
      Trouble('Fail to send command '+Str(cid));
      ClearRS485Poll;
    end;
   end else begin
    Trouble('Invalid command '+Str(cid));
    ClearRS485Poll;
   end;
    Cleanup;
  end;
 
 begin
  if IsPortOpened then begin
   if IsValidCmdNum(I7017.RS485.cid) then begin
    if (mSecNow>I7017.RS485.tim+I7017.RS485.Deadline) then begin
     Trouble('Deadline detected, repeat polling again...');
     PollRS485Proxy(I7017.RS485.cid);
    end;
   end else begin
    if (mSecNow>=I7017.RS485.tim+I7017.RS485.Polling) then begin
     I7017.CmdTab.Num:=NextEnabledCmdNum(I7017.CmdTab.Num);
      PollRS485Proxy(I7017.CmdTab.Num);
    end; //else Trouble('Fail to send command');
   end;
 //  end else Trouble('Command not valid');
  end else Trouble('Cannot open port');
 if SysTimer_Pulse(1000)>0 then begin
    UpdateDo(ai_POLLRATERX,time,I7017.RS485.Rate.Rx);
    bNul(isetTag(I7017.RX.tag,I7017.RS485.Rate.Rx));
    UpdateDo(ai_POLLRATETX,time,I7017.RS485.Rate.Tx);
    bNul(isetTag(I7017.TX.tag,I7017.RS485.Rate.Tx));
    UpdateDo(ai_POLLSUMMRX,time,I7017.RS485.Summ.Rx);
    UpdateDo(ai_POLLSUMMTX,time,I7017.RS485.Summ.Tx);
    ClearRS485Rate;
  end;
 end;
 
 procedure HoldCmdOpData(Num:Integer; NewData:String);
 begin
  I7017.CmdTab.Enabled[Num]:=not IsEmptyStr(NewData);
  I7017.CmdTab.NewData[Num]:=NewData;
 end;
 
 procedure SendTagCmd(tag:Integer; cmd,data:String; min,max:Real);
 var v:Real;
 begin
  if IsRefTag(tag) then
  if not IsEmptyStr(cmd) then
  if not IsEmptyStr(data) then
  if TypeTag(tag)<=2 then begin
   v:=rVal(data);
   if (v<min) then begin v:=min; data:=Str(min); end;
   if (v>max) then begin v:=max; data:=Str(max); end;
   if IsNaN(v) then Trouble('Invalid tag edit') else
   if TypeTag(tag)=1 then DevPostCmdLocal(cmd+' '+Str(Round(v))) else
   if TypeTag(tag)=2 then DevPostCmdLocal(cmd+' '+Trim(data));
  end else if TypeTag(tag)=3 then begin
   DevPostCmdLocal(cmd+' '+Trim(data));
  end;
 end;
 {
 GUI Handler to process user input...
 }
  Procedure DimPostCmd(cmd:String);
 begin
  if DIM_IsClientMode then Dim_GuiConsoleSend(DevName,cmd) else DevPostCmdLocal(cmd);
 end;
 procedure MenuBaudrateStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Скорость обмена"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('1200 кбит/с');
   //////////////////////////////////////////   
   n:=n+EditAddInputLn('2400 кбит/с');
   //////////////////////////////////////////   
   n:=n+EditAddInputLn('4800 кбит/с');
   //////////////////////////////////////////     
   n:=n+EditAddInputLn('9600 кбит/с');
   //////////////////////////////////////////     
   n:=n+EditAddInputLn('19200 кбит/с');
   //////////////////////////////////////////     
   n:=n+EditAddInputLn('38400 кбит/с');
   //////////////////////////////////////////     
   n:=n+EditAddInputLn('57600 кбит/с');
   //////////////////////////////////////////     
   n:=n+EditAddInputLn('115200 кбит/с');
   //////////////////////////////////////////
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_BAUDRATE'),Str(iGetTag(I7017.BAUDRATE.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 
//procedure MenuSuppHz;
//var n:Integer;
//begin
// if EditStateReady then begin
//  //////////////////////////////////////////
//  n:=0+EditAddOpening('Команда "Подавление частоты"');
//  n:=n+EditAddInputLn('Что выбираете:');
//  //////////////////////////////////////////
//  n:=n+EditAddInputLn('60 Hz');
//  //////////////////////////////////////////   
//  n:=n+EditAddInputLn('50 Hz');
//  ////////////////////////////////////////// 
//  //////////////////////////////////////////
//  n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
//  n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
//  //////////////////////////////////////////
//  n:=n+EditAddClosing('MenuList',EditGetUID('MENU_SUPPHZ'),Str(iGetTag(I7017.SuppHZ.tag)));
//  if (n>0) then Problem('Error initializing MenuList!');
// end else Problem('Cannot edit right now!');
//end;
 
  procedure MenuWorkMode;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Режим работы"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Normal speed WorkMode');
   //////////////////////////////////////////   
   n:=n+EditAddInputLn('Fast Speed WorkMode');
    //////////////////////////////////////////
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_WorkMode'),Str(iGetTag(I7017.WorkMode.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 
  procedure MenuCheckSumm;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Контроль суммы"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Запрещен');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Разрешен');
   ////////////////////////////////////////// 
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_CheckSumm'),Str(iGetTag(I7017.CheckSumm.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 
  procedure MenuFORMATDATA;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Формат данных"');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Технические единицы');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('В процентах от ПД');
   //////////////////////////////////////////
    n:=n+EditAddInputLn('В Дополнительном 16 коде');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_FORMATDATA'),Str(iGetTag(I7017.FORMATDATA.tag)));
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 
   procedure ClickBitXorLocal(tag,XorMask:Integer);
 begin
  if (ClickTag=tag) then begin
   bNul(iSetTagXor(tag,XorMask));
   bNul(Voice(snd_Click));
  end;
 end;
 {
 Xor bit on click (remote version).
 }
 procedure ClickTagXorRemote(tag,XorMask:Integer);
 begin
  if IsRefTag(tag) then
   if (ClickTag=tag) then begin
    DIM_GuiClickSend(DIM_GuiClickBuff+'NewValue='+Str(iXor(iGetTag(tag),XorMask)));
    bNul(Voice(snd_Click));
   end;
 end;
 
 procedure GUIHandler;
 var s:String; i,ClickCurve:Integer;
  procedure Cleanup;
  begin
   s:=''; ClickCurve:=0;
   DIM_GuiClickBuff:='';
  end;
 begin
  Cleanup;
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   //
   // Copy GUI click to DIM buffer for remote execution.
   //
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     if ClickIsLocal then begin
      if ClickTag<>0 then begin
       if ClickTag=I7017.NAME.tag then DevPostCmdLocal('@Edit NAME');
       if ClickTag=I7017.ADDRESS.tag then DevPostCmdLocal('@Edit ADDRESS');
       if ClickTag=I7017.POLLBUTTON.tag then begin       // Enable Poll
        if iGetTag(I7017.POLLBUTTON.tag)=0 then begin
         bNul(isettag(I7017.POLLBUTTON.tag,1));
         DevPostCmdLocal('@POLL 1'); 
        end else
        if iGetTag(I7017.POLLBUTTON.tag)=1 then begin
         bNul(isettag(I7017.POLLBUTTON.tag,0));
          DevPostCmdLocal('@POLL 0'); 
        end;
        bNul(Voice(snd_Click));
        end else
        if ClickTag=I7017.BAUDRATE.tag then begin // Menu baudrate
         bNul(Voice(snd_Click));
         MenuBaudrateStarter;
        end else
        if ClickTag=I7017.SuppHz.tag then begin // Menu baudrate
         bNul(Voice(snd_Click));
        // MenuSuppHz;
        end else
        if ClickTag=I7017.WorkMode.tag then begin // Menu baudrate
         bNul(Voice(snd_Click));
         MenuWorkMode;
        end else
        if ClickTag=I7017.CheckSumm.tag then begin // Menu baudrate
         bNul(Voice(snd_Click));
         MenuCheckSumm;
        end else
        if ClickTag=I7017.FORMATDATA.tag then begin // Menu baudrate
         bNul(Voice(snd_Click));
         MenuFORMATDATA;
        end;
       end;
      end;
       {
       Handle sensor clicks...
       }
       if IsSameText(ClickSensor,'HELP') then begin
        Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
        bNul(Voice(snd_Click));
       end;
       {
       Select Plot & Tab windows by curve...
       }
       ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
       if IsRefCurve(ClickCurve) then begin
        iNul(WinSelectByCurve(ClickCurve,ClickCurve));
        bNul(Voice(snd_Wheel));
       end;
       {
       Console commands: @url_encoded_sensor ...
       }
       DevSendCmdLocal(url_decode(ClickSensor));
       bNul(Voice(snd_Click));
       //
       // Handle remote console commands...
       //
       if ClickIsRemote then begin
        //
        // Show time difference.
        //
        if DebugFlagEnabled(dfDetails) then
        Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
        //
        // Handle remote console commands...
        //
        s:=Dim_GuiConsoleRecv(DevName,'');
        if LooksLikeCommand(s) then DevSendCmdLocal(s);
       end;
      end;
     end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   if CheckEditTag(I7017.NAME.tag,s)  then SendTagCmd(I7017.NAME.tag, '@PARAM.NAME', s,0,100);
   if CheckEditTag(I7017.ADDRESS.tag,s) then SendTagCmd(I7017.ADDRESS.tag,'@PARAM.ADDRESS',s,0,100);
   if EditTestResultName(EditGetUID('MENU_BAUDRATE')) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=Str(EditGetMenuListSelectedIndex);
     DevPostCmdLocal('@PARAM.BAUDRATE '+s);
    end;
    EditReset;
   end;
   
 //  if EditTestResultName(EditGetUID('MENU_SUPPHZ')) then begin
 //   if EditTestResultCode(mr_OK) then begin
 //    s:=Str(EditGetMenuListSelectedIndex);
 //    DevPostCmdLocal('@PARAM.SUPPHZ '+s);
 //   end;
 //   EditReset;
 //  end;
 //  
 //  if EditTestResultName(EditGetUID('MENU_CHECKSUMM')) then begin
 //   if EditTestResultCode(mr_OK) then begin
 //    s:=Str(EditGetMenuListSelectedIndex);
 //    DevPostCmdLocal('@PARAM.CHECKSUMM '+s);
 //   end;
 //   EditReset;
 //  end;
 //  
 //  if EditTestResultName(EditGetUID('MENU_WORKMODE')) then begin
 //   if EditTestResultCode(mr_OK) then begin
 //    s:=Str(EditGetMenuListSelectedIndex);
 //    DevPostCmdLocal('@PARAM.WORKMODE '+s);
 //   end;
 //   EditReset;
 //  end;
 //  
 //  if EditTestResultName(EditGetUID('MENU_FORMATDATA')) then begin
 //   if EditTestResultCode(mr_OK) then begin
 //    s:=Str(EditGetMenuListSelectedIndex);
 //    DevPostCmdLocal('@PARAM.FORMATDATA '+s);
 //   end;
 //   EditReset;
 //  end;
   
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  Cleanup;
 end;
 
  {
 DIM Update tag
 }
 procedure I7017_DIM_Update_tag;
 begin
  if DIM_IsServerMode then begin
   if SysTimer_Pulse(10000)>0 then I7017_FillTags(-MaxReal);
   if ShouldRefresh(I7017.NAME.val,HashIndexOf(sGetTag(I7017.NAME.tag),0,0))>0
   then DIM_UpdateTag(I7017.NAME.tag,'');
   if ShouldRefresh(I7017.VERSION.val,HashIndexOf(sGetTag(I7017.VERSION.tag),0,0))>0
   then DIM_UpdateTag(I7017.VERSION.tag,'');
   if ShouldRefresh(I7017.Aitype.val,iGetTag(I7017.Aitype.tag))>0
   then DIM_UpdateTag(I7017.Aitype.tag,'');
   if ShouldRefresh(I7017.ADDRESS.val,iGetTag(I7017.ADDRESS.tag))>0
   then DIM_UpdateTag(I7017.ADDRESS.tag,'');
   if ShouldRefresh(I7017.BAUDRATE.val,iGetTag(I7017.BAUDRATE.tag))>0
   then DIM_UpdateTag(I7017.BAUDRATE.tag,'');
   if ShouldRefresh(I7017.FORMATDATA.val,iGetTag(I7017.FORMATDATA.tag))>0
   then DIM_UpdateTag(I7017.FORMATDATA.tag,'');
   if ShouldRefresh(I7017.PollButton.val,iGetTag(I7017.PollButton.tag))>0
   then DIM_UpdateTag(I7017.PollButton.tag,'');
   if ShouldRefresh(I7017.AI1.val,rGetTag(I7017.AI1.tag))>0
   then DIM_UpdateTag(I7017.AI1.tag,'');
   if ShouldRefresh(I7017.AI2.val,rGetTag(I7017.AI2.tag))>0
   then DIM_UpdateTag(I7017.AI2.tag,'');
   if ShouldRefresh(I7017.AI3.val,rGetTag(I7017.AI3.tag))>0
   then DIM_UpdateTag(I7017.AI3.tag,'');
   if ShouldRefresh(I7017.AI4.val,rGetTag(I7017.AI4.tag))>0
   then DIM_UpdateTag(I7017.AI4.tag,'');
   if ShouldRefresh(I7017.AI5.val,rGetTag(I7017.AI5.tag))>0
   then DIM_UpdateTag(I7017.AI5.tag,'');
   if ShouldRefresh(I7017.AI6.val,rGetTag(I7017.AI6.tag))>0
   then DIM_UpdateTag(I7017.AI6.tag,'');
   if ShouldRefresh(I7017.AI7.val,rGetTag(I7017.AI7.tag))>0
   then DIM_UpdateTag(I7017.AI7.tag,'');
   if ShouldRefresh(I7017.AI8.val,rGetTag(I7017.AI8.tag))>0
   then DIM_UpdateTag(I7017.AI8.tag,'');
   if ShouldRefresh(I7017.RX.val,iGetTag(I7017.RX.tag))>0
   then DIM_UpdateTag(I7017.RX.tag,'');
   if ShouldRefresh(I7017.TX.val,iGetTag(I7017.TX.tag))>0
   then DIM_UpdateTag(I7017.TX.tag,'');
    if SysTimer_Pulse(1000)>0  then begin
   //DIM_UpdateTag(I7017.Name.tag,'');
   //DIM_UpdateTag(I7017.Version.tag,'');
   //DIM_UpdateTag(I7017.Baudrate.tag,'');
   //DIM_UpdateTag(I7017.ADDRESS.tag,'');
   //DIM_UpdateTag(I7017.PollButton.tag,'');
   //DIM_UpdateTag(I7017.RX.tag,'');
   //DIM_UpdateTag(I7017.TX.tag,'');
   //DIM_UpdateTag(I7017.FOCUSINCR.tag,'');
   //DIM_UpdateTag(I7017.FOCUSDECR.tag,'');
  end;
  end;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  I7017_ClearStrings;
  ClearNetRS485;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitNetRS485;
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  cmd_DimTagUpdate:=RegisterStdInCmd('@DimTagUpdate','');
  cmd_DimCmdMy    :=RegisterStdInCmd('@DIMCMDMY'   ,'');
  cmd_Demo:=RegisterStdInCmd('@Demo','');
  cmd_Edit:=RegisterStdInCmd('@Edit','');
  cmd_ParamName:=RegisterStdInCmd('@Param.Name','');
  cmd_ParamConfig:=RegisterStdInCmd('@Param.Config','');
  cmd_Poll:=RegisterStdInCmd('@Poll','');
  cmd_ParamAddress:=RegisterStdInCmd('@Param.Address','');
  cmd_ParamBaudrate:=RegisterStdInCmd('@Param.Baudrate','');
  cmd_ParamDataForm:=RegisterStdInCmd('@Param.DataForm','');
  if Val(ReadIni('CustomIniAutoLoad'))=1 then DevPostCmdLocal('@LoadIni');
  cmd_RS485Reply      :=RegisterStdInCmd('@RS485.Reply','');
  cmd_RS485Refuse     :=RegisterStdInCmd('@RS485.Refuse','');
  cmd_RS485Timeout    :=RegisterStdInCmd('@RS485.Timeout','');
   i7017_InitTags(ReadIni('tagPrefix'),-MaxReal);
  I7017_Init;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  I7017_Clear;
  FreeNetRS485;
  //ClearCmdTable;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  GUIHandler;
   if not DIM_IsClientMode then begin
  if mSecNow-FixmSecNow>I7017.RS485.DelayOnStart then begin
    I7017_Poll;
    I7017_DIM_Update_tag
   end else
  Writeln('Waiting');
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var s,cmd,arg,dat,par,NewAddress,cdm_arg_nocode,AiType,Baudrate,DataForm:String;cmdid,ref,cid,tim,port,poollButt,tag,uid,i:Integer;k, r:Real;
  procedure Cleanup;
  begin
   cmd:='';
   arg:='';
   dat:='';
   par:='';
  end;

 begin
  Cleanup;
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   if (cmdid = cmd_RS485Reply) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then I7017_OnReply(ref,cid,tim,port,uid,dat)
    else Trouble('Bad '+cmd+' format');
    ClearRS485Poll; Data:='';
   end else 
  
   if (cmdid = cmd_RS485Refuse) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Trouble(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,0))
    else Trouble(cmd+' '+arg);
     ClearRS485Poll; Data:='';
   end else
    
   if (cmdid = cmd_RS485Timeout) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Problem(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,64))
    else Trouble(cmd+' '+arg);
     ClearRS485Poll; Data:='';
   end else
   
   {
   @Demo 123 2*2
   }
   if (cmdid = cmd_Demo) then begin
    i:=iEvalDef(ExtractWord(1,arg),0);
    r:=rEvalDef(ExtractWord(2,arg),_NaN);
    { Success(cmd+'='+Str(i)+_Comma+Str(r)); }
    Data:='';
   end else
   {
   @Edit Parameters
   }
   if (cmdid = cmd_Edit) then begin
    if IsSameText(ExtractWord(1,arg),'NAME') then StartEditTagEx(I7017.NAME.tag,'Новое название модуля','');
    if IsSameText(ExtractWord(1,arg),'ADDRESS') then StartEditTagEx(I7017.ADDRESS.tag,'Новый адрес модуля','');
    Data:='';
   end else

   {
   @PARAM.NAME NEWNAME
   }
   if (cmdid = cmd_ParamName) then begin
    if not DIM_IsClientMode then begin
    HoldCmdOpData(cm_SetName,extractword(1,arg));
    Data:='';
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @PARAM.NAME '+arg);
    end;
    Data:='';
   end else
   {
   @POLL N
   }
   if (cmdid = cmd_Poll) then begin
   if not DIM_IsClientMode then begin
    poollButt:=val(extractword(1,arg));
    if poollButt>1 then poollButt:=1;
    if poollButt<0 then poollButt:=0;
    bNul(isettag(I7017.POLLBUTTON.tag,poollButt));
    I7017.CmdTab.Enabled[cm_ReadValueAllChannel]:=poollButt>0;
     end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @Poll '+arg);
    end;
   end else
   

   {
   @PARAM.CONFIG NNTTCCFF
   }
   if (cmdid = cmd_ParamConfig) then begin
   if not DIM_IsClientMode then begin
    if length(extractword(1,arg))=8 then begin
    
     HoldCmdOpData(cm_SetConfig,extractword(1,arg));
    end else Trouble('Unrecognize parametr in command @SetCfg');
   end else if DIM_IsClientMode then begin
    DevPostCmdLocal('@Remote @PARAM.CONFIG '+arg);
   end;
    Data:='';
   end else
   
    if (cmdid=cmd_DimTagUpdate) then begin
    if DIM_IsClientMode and not DIM_IsServerMode then begin
     tag:=FindTag(Trim(arg));
     if tag=I7017.RX.tag        then UpdateDo(do_RX,time,iGetTag(tag));
     if tag=I7017.TX.tag        then UpdateDo(do_TX,time,iGetTag(tag));
    end;
   end else
   {
   @DIMCMDMY
   }
   if (cmdid=cmd_DimCmdMy) then begin
    //декодируем из base64
    //cdm_arg_nocode:=base64_decode(arg);
    // Избавляемся от символ NUL (\x00).
    //cdm_arg_nocode:=Trim(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@Poll')      then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@PARAM.CONFIG') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@PARAM.NAME') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@PARAM.ADDRESS') then DevPostCmdLocal(cdm_arg_nocode);
    if IsSameText(ExtractWord(1,cdm_arg_nocode),'@PARAM.BAUDRATE') then DevPostCmdLocal(cdm_arg_nocode);
    Success('@DIMCMDMY='+cmd+' arg<'+cdm_arg_nocode+'>');
   end else
   {
   @PARAM.ADDRESS NN
   }
   if (cmdid = cmd_ParamAddress) then begin
    if not DIM_IsClientMode then begin
     NewAddress:=hexb(val(extractword(1,arg)));
     AiType:=hexb(igettag(I7017.AiType.tag));
     Baudrate:=hexb(igettag(I7017.BAUDRATE.tag));
     DataForm:=hexb(igettag(I7017.DATAFORM.tag));
     dat:=NewAddress+AiType+Baudrate+DataForm;
     DevSendCmdLocal('@PARAM.CONFIG '+dat);
     writeln('@PARAM.CONFIG '+dat);
    end else if DIM_IsClientMode then begin
    DevPostCmdLocal('@Remote @PARAM.ADDRESS '+arg);
   end;
     Data:='';
   end else
   //{
   //@PARAM.FORMATDATA 
   //}
   //if (cmdid = cmd_ParamFormatData)
   {
   @PARAM.BAUDRATE CC
   }
   if (cmdid = cmd_ParamBaudrate) then begin
    if not DIM_IsClientMode then begin
     // TODO Baudrate в допустимом диапазоне и является числом (extractword(1,arg))
     NewAddress:=hexb(igettag(I7017.address.tag));
     AiType:=hexb(igettag(I7017.AiType.tag));
     Baudrate:=hexb((val(extractword(1,arg)))+3);
     DataForm:=hexb(igettag(I7017.DATAFORM.tag));
     dat:=NewAddress+AiType+Baudrate+DataForm;
     
     DevSendCmdLocal('@PARAM.CONFIG '+dat);
     writeln('@PARAM.CONFIG '+dat);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @PARAM.BAUDRATE '+arg);
    end;
    Data:='';
   end else
  {
  @PARAM.DATAFORM FF
  }
   if (cmdid = cmd_ParamDataForm) then begin
    if not DIM_IsClientMode then begin
     NewAddress:=hexb(igettag(I7017.address.tag));
     AiType:=hexb(igettag(I7017.AiType.tag));
     Baudrate:=hexb(igettag(I7017.BAUDRATE.tag));
     DataForm:=hexb(val(extractword(1,arg)));
     dat:=NewAddress+AiType+Baudrate+DataForm;
     
     DevSendCmdLocal('@PARAM.CONFIG '+dat);
     writeln('@PARAM.CONFIG '+dat);
     end else if DIM_IsClientMode then begin
      DevPostCmdLocal('@Remote @PARAM.DATAFORM '+arg);
     end;
     Data:='';
   end else
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  Cleanup;
 end;

 // Александр Дмитриевич Тумкин 112

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
