 {
 Ранги
 0 -  1Г  -   0   0   0   (0)
 1 - 100М -   1   0   0   (1)
 2 -  1М  -   0   1   0   (2)
 3 - 100К -   0   0   1   (4)
 }
program amp_lim;
const
 MaxRange       = 3;
 sndClick       = 'НАЖАТО';
 sndError       = 'ОШИБКА';
 copy_init      = 1;
 copy_chk       = 2;
 range_init     = 3;
 range_chk      = 4;
 delay_init     = 5;
 delay_chk      = 6;
 do_nothing     = 7;
var
 b              : boolean;
 Ok             : boolean;
 errors         : integer;
 errorcode      : integer;
 MaxRangeNum    : integer; 
 tagCopyBt      : integer;
 tagSaveBt      : integer;
 tagRangeNum    : integer;
 tagRangeAuto   : integer;
 tagZeroAutoBt  : integer;
 tagZeroDelay   : integer;
 tagZero        : array [0..MaxRange] of integer;
 tagK           : array [0..MaxRange] of integer;
 tagINPUTX      : integer;
 tagWHOISX      : integer;
 i              : integer;
 j              : integer;
 r              : real;
 x              : real;
 y              : real;
 mode           : integer;
 fname          : string;
 fpath          : string;
 rflag          : integer;
 lastx          : real;
 swtime         : real;
 Delay1         : real;
 Delay2         : real;
 fixtime        : real;
 StartDelay     : real;
 MinLim         : array [0..MaxRange] of real;
 MaxLim         : array [0..MaxRange] of real;
 RangeTab       : array [0..MaxRange] of integer;
 PassCount      : integer;
 {
 Close and disconnect input dialog
 }
 procedure CloseINPUTX;
 begin
  b:=isettag(tagWHOISX,0);
  r:=devmsg('&'+nametag(tagINPUTX)+' ConstValue=0');
  r:=devmsg('&'+nametag(tagINPUTX)+' ConstName= ????');
  b:=winhide('CONSTGENERATOR: &'+nametag(tagINPUTX));
 end;
 {
 On sensor click connect and call input dialog
 }
 procedure CheckINPUTX(Sensor,Name:string);
 begin
  if clicksensor=Sensor then begin
   b:=voice(sndClick);
   CloseINPUTX;
   if typetag(clicktag)=1 then r:=igettag(clicktag) else
   if typetag(clicktag)=2 then r:=rgettag(clicktag) else r:=0;
   if (devmsg('&'+nametag(tagINPUTX)+' ConstName= '+Name)<>0) and
      (devmsg('&'+nametag(tagINPUTX)+' ConstValue='+str(r))<>0) and
      Action('&'+nametag(tagINPUTX))
   then begin
    b:=isettag(tagWHOISX,clicktag);
   end;
  end;
 end;
 {
 Change range
 }
 procedure SetRange(n:integer);
 begin
  if n<0 then n:=0;
  if n>MaxRangeNum then n:=MaxRangeNum;
  b:=isettag(tagRangeNum,n);
  b:=putdo(0,time,RangeTab[igettag(tagRangeNum)]);
  swtime:=secnow;
  rflag:=0;
  PassCount:=2;
 end;
 {
 Invert bits on sensor click
 }
 procedure ClickBitXor(Sen:string; tag,XorMask:integer);
 var b:boolean;
 begin
  if clicksensor=Sen then begin
   b:=voice(sndClick);
   b:=isettag(tag,ixor(igettag(tag),XorMask));
  end;
 end;
 {
 Handle RANGE sensor click
 }
 procedure ClickRange(Sen:string; n:integer);
 begin
  if clicksensor=Sen then begin
   if igettag(tagRangeAuto)=0 then begin
    b:=voice(sndClick);
    SetRange(n);
   end else begin
    b:=voice(sndError);
   end;
  end;
 end;
 {
 Fix error
 }
 procedure ErrorFound;
 begin
  errors:=errors+1;
 end;
 {
 Initialize and check tag
 }
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 On program START
 }
 if runcount=1 then begin
  {
  Clear some variables
  }
  fname:='';
  fpath:='';
  lastx:=0;
  rflag:=0;
  fixtime:=0;
  swtime:=_minusinf;
  PassCount:=0;
  {
  Initialize tags, read configuration
  }
  errors:=0;
  errorcode:=registererr('AMP_LIM.PAS');
  InitTag( tagCopyBt,     readini('TagCopyBt'),     1);
  InitTag( tagSaveBt,     readini('TagSaveBt'),     1);
  InitTag( tagRangeNum,   readini('TagRangeNum'),   1);
  InitTag( tagRangeAuto,  readini('TagRangeAuto'),  1);
  InitTag( tagZeroAutoBt, readini('TagZeroAutoBt'), 1);
  InitTag( tagZeroDelay,  readini('TagZeroDelay'),  2);
  InitTag( tagINPUTX,     readini('TagINPUTX'),     2);
  InitTag( tagWHOISX,     readini('TagWHOISX'),     1);



  for i:=0 to MaxRange do begin
   InitTag( tagZero[i],  readini('TagZero#'+str(i)), 2);
   InitTag( tagK[i],     readini('TagK#'+str(i)),    2);
   MaxLim[i]:=rval(readini('MaxRange#'+str(i)));
   MinLim[i]:=rval(readini('MinRange#'+str(i)));
   if isnan(MaxLim[i]) then errorfound;
   if isnan(MinLim[i]) then errorfound;
  end;
  Delay1:=rval(readini('Delay#1'));
  Delay2:=rval(readini('Delay#2'));
  if isnan(Delay1) then errorfound;
  if isnan(Delay2) then errorfound;
  MaxRangeNum:=val(readini('MaxRangeNum'));
  if MaxRangeNum<0 then MaxRangeNum:=0;
  if MaxRangeNum>MaxRange then MaxRangeNum:=MaxRange;
  RangeTab[0]:=0;
  RangeTab[1]:=1;
  RangeTab[2]:=2;
  RangeTab[3]:=4;
  SetRange(igettag(tagRangeNum));
  b:=isettag(tagZeroAutoBt,0);
  b:=isettag(tagCopyBt,0);
  b:=isettag(tagSaveBt,0);
  {
  Read & check file path
  }
  fpath:=readini('ZeroPath');
  fpath:=paramstr('DefaultPath '+fpath+' '+
                  paramstr('ExtractFilePath '+paramstr('DaqConfigFile')));
  fpath:=paramstr('FExpand '+fpath);
  if length(fpath)=0 then errorfound else
  if iand(getfattr(fpath),16)<>16 then errorfound;
  fname:=fpath+'\'+readini('ZeroName');
  {
  Read file of ADC zeros
  }
  for i:=0 to MaxRange do b:=rsettag(tagZero[i],0);
  if reset(fname)=0 then begin
   for i:=0 to MaxRangeNum do begin
    readln(r);
    if ioresult=0
    then b:=rsettag(tagZero[i],r)
    else b:=fixerror(errorcode);
   end;
   if reset('')<>0 then b:=fixerror(errorcode);
  end else b:=fixerror(errorcode);
  CloseINPUTX;
  {
  Is it Ok?
  }
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 On program STOP
 }
 if isinf(runcount) then begin
  fname:='';
  fpath:='';
  CloseINPUTX;
  b:=isettag(tagCopyBt,0);
  b:=isettag(tagSaveBt,0);
  b:=isettag(tagZeroAutoBt,0);
  SetRange(igettag(tagRangeNum));
 end else
 {
 On program POLLING loop
 }
 if Ok then begin
  {
  Process automatic zero calibration
  }
  if igettag(tagZeroAutoBt)<>0 then begin
   b:=isettag(tagZeroAutoBt,1+igettag(tagZeroAutoBt) mod 4);
   case mode of
    range_init:
     begin
      SetRange(igettag(tagRangeNum));
      mode:=delay_init;
     end; 
    delay_init:
     begin
      StartDelay:=secnow;
      mode:=delay_chk
     end;
    delay_chk:
     begin
      if (secnow-StartDelay)>rgettag(tagZeroDelay) then mode:=copy_init
     end;
    copy_init:
     begin
      b:=isettag(tagCopyBt,1);
      mode:=copy_chk;
     end;
    copy_chk:
     begin
      if igettag(tagCopyBt) = 0 then
      if igettag(tagRangeNum)=0 then begin
       b := isettag(tagZeroAutoBt,0);
       mode := do_nothing;
       b:=isettag(tagSaveBt,1);
      end else begin
       b:=isettag(tagRangeNum, igettag(tagRangeNum)-1);
       mode := range_init
      end;
     end;
    do_nothing: ;
   end;
  end;
  {
  }
  if secnow>swtime+Delay2 then begin
   x:=getai_xn(0);
   if x<>lastx then begin
    lastx:=x;
    y:=getai_yn(0);
    if igettag(tagRangeAuto)<>0 then begin
     if (abs(y)>abs(MaxLim[igettag(tagRangeNum)])) and 
        (igettag(tagRangeNum)<MaxRangeNum)
     then begin
      if rflag<>1 then begin
       rflag:=1;
       fixtime:=secnow;
      end;
     end else
     if (abs(y)<abs(MinLim[igettag(tagRangeNum)])) and
        (igettag(tagRangeNum)>0)
     then begin
      if rflag<>-1 then begin
       rflag:=-1;
       fixtime:=secnow;
      end;
     end else rflag:=0;
     if (rflag<>0) and (secnow>fixtime+Delay1)
     then SetRange(igettag(tagRangeNum)+rflag);
    end;
    {
    On COPY button click:
    }
    if igettag(tagCopyBt)=1 then begin
     CloseInputX;
     b:=rsettag(tagZero[igettag(tagRangeNum)],y);
     b:=isettag(tagSaveBt,1);
     b:=isettag(tagCopyBt,0);
    end;
    if PassCount>0 then PassCount:=PassCount-1 else PassCount:=0;
    if PassCount=0 then begin
     y:=y-rgettag(tagZero[igettag(tagRangeNum)]);
     b:=putao(0,x,y);
     b:=putao(1,x,y*rgettag(tagK[igettag(tagRangeNum)]));
    end;
   end;
  end;

  b:=putdo(0,x,RangeTab[igettag(tagRangeNum)]);
  {
  On Save button click
  }
  if igettag(tagSaveBt)<>0 then begin
   b:=isettag(tagSaveBt,0);
   b:=voice(sndClick);
   if fileexists(fname) then b:=fileerase(fname);
   if not fileexists(fname) then begin
    if rewrite(fname)=0 then begin
     for i:=0 to MaxRange do begin
      writeln(rgettag(tagZero[i]));
      if ioresult<>0 then b:=fixerror(errorcode);
     end;
    end else b:=fixerror(errorcode);
    if rewrite('')<>0 then b:=fixerror(errorcode);
   end else b:=fixerror(errorcode);
  end;
  {
  Отработка кнопок
  }
  if clickbutton=1 then begin
   {
   On ZeroAuto button click press button, switch off RangeAuto and set high range
   }
   if clicksensor=nametag(tagZeroAutoBt) then
   if igettag(clicktag)=0 then begin
    b:=isettag(tagZeroAutoBt,1);
    b:=isettag(tagRangeAuto,0);
    b:=isettag(tagRangeNum, MaxRangeNum);
    mode:=range_init;
   end;
   {
   On Copy button click press button
   }
   if clicksensor=nametag(tagCopyBt) then
   if igettag(tagCopyBt)=0 then b:=isettag(tagCopyBt,1);
   {
   On Save button click press button
   }
   if clicksensor=nametag(tagSaveBt) then
   if igettag(tagSaveBt)=0 then b:=isettag(tagSaveBt,1);
   {
   On RangeAuto click switch on/off
   }
   ClickBitXor(nametag(tagRangeAuto), clicktag, 1);
   {
   On Range.0..Range.3 button click change range
   }
   for i:=0 to MaxRangeNum do ClickRange(readini('SenRange'+str(i)),i);
   {
   On Zero.0..Zero.3 button click link INPUTX to edit zero
   }
   for i:=0 to MaxRangeNum do CheckINPUTX(nametag(tagZero[i]), 'НУЛЕВОЕ_СМЕЩЕНИЕ_'+str(i+1));
  end;
  {
  Коррекция данных из поля ввода
  Переписываем данные из тега поля ввода UH_INPUTX в тег, который
  ранее запомнили в теге UH_WHOISX по последнему щелчку мыши
  }
  j:=igettag(tagWHOISX);
  if typetag(j)=1 then b:=isettag(j,round(rgettag(tagINPUTX))) else
  if typetag(j)=2 then b:=rsettag(j,rgettag(tagINPUTX));
 end;
end.
