@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

chcp 65001

pushd "%~dp0\" && call :GuiLibDemoSize "%~n0.crc"
popd
goto :EOF

:GuiLibDemoSize
if "%~1" == "" goto :EOF
set crc=%~1
set /a posx=0
set /a posy=0
set /a ystp=48
set /a count=0
call :DeleteFile  "%crc%"
call :AddHeader > "%crc%"
call :SensorsGenerate
echo %count% sensors generated
echo Done.
Sleep 10
goto :EOF

:AddHeader
echo [Circuit]
echo GeneralMap = ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_1600_2000_4_silver.bmp
echo Hint = ДЕМО для GuiLib
echo Name = GuiLibDemo
echo []
echo [ConfigFileList]
echo ConfigFile = ~~\Resource\DaqSite\Default\Painter.crc
echo []
unix true
goto :EOF

:SensorsGenerate
set sensor_list=Home Open Save LoadIni SaveIni Navigator Tools Sound Smile Help Close Loupe Favorite Lock Key Calculator Erase Setting Console Flash FlashAlt Lightning LightningAlt Ok Cancel Snowflake
set sensor_list=%sensor_list% Menu Options ArrowCircCW ArrowCircCCW ArrowCW ArrowCCW ArrowUp ArrowDown ArrowLeft ArrowRight PowerOn
for %%i in ( %sensor_list% ) do (
 call :AddS %%i
 set /a posy=posy+%ystp%
 set /a posx=0
 echo %%i Ok
)
goto :EOF

:AddS
if "%~1" == "" goto :EOF
for /L %%j in (15,1,48) do call :AddSensor %~1 %%j >> "%crc%"
goto :EOF

:AddSensor
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
set "name=%~1" & shift
set /a numb=%~1 & shift
echo [SensorList]
echo Sensor = Cmd.%name%.%numb%
echo [Cmd.%name%.%numb%]
echo Pos = %posx%, %posy%
echo Painter(v) = [Painter(v).GuiLib.Cmd.%name%]
echo Painter(v) = (glBorderBevel=2)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_%numb%_%numb%_24_silver.bmp
echo Hint = Demo Cmd.%name%.%numb%
echo []
set /a posx=posx+%numb%
set /a count=count+1
unix true
goto :EOF

:DeleteFile
if "%~1" == "" goto :EOF
if exist "%~1" unix rm -f "%~1" 
unix true
goto :EOF

