 {
 ***********************************************************************
 Daq Pascal application program DemoPaint.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
|********************************************************
[]
 }
program DemoPaint;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagSignal1 : Integer;           { Signal tag                       }
 tagSignal2 : Integer;           { Signal tag                       }
 tagSignal3 : Integer;           { Signal tag                       }
 tagSignal4 : Integer;           { Signal tag                       }
 tagAlarm1  : Integer;           { Alarm level tag                  }
 tagAlarm2  : Integer;           { Alarm level tag                  }
 valAlarm1  : Real;              { Alarm level                      }
 valAlarm2  : Real;              { Alarm level                      }
 tagButton1 : Integer;           { Button tag                       }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  InitTag(tagAlarm1, 'Alarm1', 2);
  InitTag(tagAlarm2, 'Alarm2', 2);
  InitTag(tagSignal1,'Signal1',2);
  InitTag(tagSignal2,'Signal2',2);
  InitTag(tagSignal3,'Signal3',2);
  InitTag(tagSignal4,'Signal4',2);
  InitTag(tagButton1,'Button1',1);
  valAlarm1:=MaxReal;
  valAlarm2:=MaxReal;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 var t,v1,v2,v3,v4:Real;
 begin
  {
  Simulate signals...
  }
  t:=(mSecNow-FixmSecNow)/60000;
  v1:=100*(1+sin(2*pi*t))/2;
  v2:=100*(1+cos(2*pi*t))/2;
  v3:=100*(1+sin(2*pi*t*3))/2;
  v4:=100*(1+cos(2*pi*t*3))/2;
  bNul(rSetTag(tagSignal1,v1));
  bNul(rSetTag(tagSignal2,v2));
  bNul(rSetTag(tagSignal3,v3));
  bNul(rSetTag(tagSignal4,v4));
  {
  Update alarm1, alarm2...
  }
  if ShouldRefresh(valAlarm1,rGetTag(tagAlarm1))+
     ShouldRefresh(valAlarm2,rGetTag(tagAlarm2))>0
  then bNul(WinDraw('DemoPaint|Eval=(alarm1='+Str(valAlarm1)+')+(alarm2='+Str(valAlarm2)+')'));
  {
  Handle buttons...
  }
  if ClickButton=1 then begin
   Success('Click detected:'+EOL+ClickParams(''));
   if IsSameText(ClickSensor,'HELP') then begin
     Cron('@Browse '+DaqFileRef(AdaptFileName(ReadIni('[DAQ] HelpFile')),'.htm'));
     bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'Alarm1') then begin
    StartEditTag(tagAlarm1,'Отредактируйте Alarm1');
    bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'Alarm2') then begin
    StartEditTag(tagAlarm2,'Отредактируйте Alarm2');
    bNul(Voice(snd_Click));
   end;
   if IsSameText(ClickSensor,'Button1') then begin
    bNul(iSetTag(tagButton1,Ord(iGetTag(tagButton1)=0)));
    bNul(Voice(snd_Click));
   end;
  end;
  {
  Edit tags...
  }
  if EditState=ef_Done then begin
   CheckEditTagUpdate(tagAlarm1,0,100);
   CheckEditTagUpdate(tagAlarm2,0,100);
  end;
  if EditState=ef_Done then begin
   Problem('Unknown tag edition!');
   sNul(Edit(''));
  end;
  if iAnd(EditState,ef_ErrorFound)<>0 then begin
   Problem('Dialog error detected!');
   sNul(Edit(''));
  end;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
