{
[@Help]
|Command list: StdIn "@cmd=arg" or "@cmd arg"
|******************************************************
| @Help          - This help.
| @DebugFlags=n  - Set DebugFlags,1/2/4/8=!/:/>/< view.
| @Done file.bmp - handle refresh notification.
| @Fail file.bmp - handle failure notification.
|******************************************************
[]
}
program DemoPlot;
const
 dfTrouble         = 1;       { DebugFlags - Trouble             }
 dfSuccess         = 2;       { DebugFlags - Success             }
 dfViewExp         = 4;       { DebugFlags - ViewExp             }
 dfViewImp         = 8;       { DebugFlags - ViewImp             }
 snd_Click         = 'Click'; { Sound on button click            }
 snd_Fails         = 'Fails'; { Sound on operation failure       }
var
 s                 : String;  { Temporary                        }
 i                 : Integer; { Temporary                        }
 b                 : Boolean; { Temporary                        }
 Ok                : Boolean; { Program initialization is Ok?    }
 errors            : Integer; { Program error counter            }
 errorcode         : Integer; { Error code for this device       }
 fixmaxavail       : Integer; { String manager leak control      }
 DebugFlags        : Integer; { Debug bit flags                  }
 StdIn_Line        : String;  { Temporary                        }
 tagPlot1          : integer; { Tag to plot graph 1              }
 tagPlot2          : integer; { Tag to plot graph 2              }
 tagPlot3          : integer; { Tag to plot graph 3              }
 tagPlot4          : integer; { Tag to plot graph 4              }
 tagPlot5          : integer; { Tag to plot graph 5              }
 tagPlot6          : integer; { Tag to plot graph 6              }
 x,y,r,mn          : Real;    { Temporary                        }
 n,j               : Integer; { Temporary                        }
 nPlot1            : integer; { Counter of plot graph 1          }
 nPlot2            : integer; { Counter of plot graph 2          }
 nPlot3            : integer; { Counter of plot graph 3          }
 nPlot4            : integer; { Counter of plot graph 4          }
 nPlot5            : integer; { Counter of plot graph 5          }
 nPlot6            : integer; { Counter of plot graph 6          }
 PlotSendTime      : Real;    { PlotSend moment by mSecNow       }
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on problem.
 }
 procedure Problem(msg:String);
 begin
  if iAnd(DebugFlags,dfTrouble)<>0 then
  if Length(msg)>0 then Writeln(DevName+' ! '+msg);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|top=317|left=0|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Show help in device console and echo to Main console if AllowEcho.
 Help text should be placed in program comment is [@Help] section.
 First symbol of help block should be | and will be ignored.
 }
 procedure ShowHelp(AllowEcho:Boolean);
 var i,p,sect:Integer; b:Boolean;
 begin
  sect:=ReadIniSection(text_New,12,DaqFileRef(ReadIni('ProgramSource'),'.pas'),'[@Help]');
  for i:=0 to text_NumLn(sect)-1 do begin
   if Copy(text_GetLn(sect,i),1,1)='|' then p:=2 else p:=1;
   if AllowEcho then b:=echo(devname+' : '+Copy(text_GetLn(sect,i),p));
   Success(Copy(text_GetLn(sect,i),p));
  end;
  b:=text_Free(sect);
  if AllowEcho then b:=WinSelect(ParamStr('MainConsole'));
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 function GetDateTime(ms:Real):String;
 var s:String;
 begin
  s:='';
  s:=Str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=Str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=Str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=Str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=Str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=Str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
  GetDateTime:=s;
  s:='';
 end;
 {
 Find midnight time by given time, ms
 }
 function GetMidnight(ms:Real):Real;
 begin
  GetMidnight:=DateTime2Ms(Ms2Year(ms),Ms2Month(ms),Ms2Day(ms),0,0,0,0);
 end;
 {
 Send message to &PlotSrv server.
 }
 function PlotSend(msg:String):Integer;
 var dev:Integer;
 begin
  if Length(msg)>0 then dev:=RefFind('Device &PlotSrv') else dev:=0;
  if dev<>0 then PlotSend:=Round(DevSend(dev,msg)) else PlotSend:=0;
  PlotSendTime:=mSecNow;
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  StdIn_Line:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ)
  then Trouble('Could not init tag: '+name);
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var cmd,arg:String; b:Boolean; tag,ix,iy:Integer;
 begin
  if iAnd(DebugFlags,dfViewImp)<>0 then ViewImp('CON: '+Data);
  {
  "@cmd=arg" or "@cmd args" commands:
  }
  cmd:='';
  arg:='';
  if Length(Data)>0 then
  if Data[1]='@' then begin
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Pos(cmd,Data)+Length(cmd)+1);
   {}
   if IsSameText(cmd,'@Done') then begin
    // Reload sensor bitmap from file specified by arg
    // Assume that file name = tag name = sensor name
    tag:=FindTag(ExtractFileName(arg));
    if TypeTag(tag)=1 then begin
     b:=iSetTag(tag,Ord(FileExists(DaqFileRef(arg,''))));
     if iGetTag(tag)<>0 then b:=WinDraw('DemoPlot|Reload='+NameTag(tag));
     ix:=(Val(Copy(NameTag(tag),5))-1) mod 3;
     iy:=(Val(Copy(NameTag(tag),5))-1) div 3;
     b:=WinDraw('DemoPlot|Scroll=xmin+'+Str(ix)+'*(xmax-xmin)/2;'+
                                'ymin+'+Str(iy)+'*(ymax-ymin)');
     Success(cmd+'='+Str(iGetTag(tag))+', '+Str(mSecNow-PlotSendTime)+' ms');
    end else Problem(cmd+'=?, '+Str(mSecNow-PlotSendTime)+' ms');
    PlotSendTime:=0;
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@Fail') then begin
    // Reload sensor bitmap from file specified by arg
    // Bitmap set to default state (plot was failed)
    tag:=FindTag(ExtractFileName(arg));
    if TypeTag(tag)=1 then begin
     b:=iSetTag(tag,0);
     b:=FileCopy(DaqFileRef(AdaptFileName('..\Bitmaps\Plot0.bmp'),'')+' '+DaqFileRef(AdaptFileName(arg),''));
     Success(cmd+'='+Str(iGetTag(tag))+', '+Str(mSecNow-PlotSendTime)+' ms');
    end else Problem(cmd+'=?, '+Str(mSecNow-PlotSendTime)+' ms');
    PlotSendTime:=0;
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@Help') then begin
    ShowHelp(true);
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@DebugFlags') then begin
    if not IsNan(rVal(arg)) then DebugFlags:=Round(rVal(arg));
    Success(cmd+'='+Str(DebugFlags));
    Data:='';
   end;
   {}
   if Length(Data)>0 then begin
    Trouble(' Unrecognized command "'+Data+'".');
    Data:='';
   end;
  end;
  cmd:='';
  arg:='';
 end;
 {
 On start and on stop we should set bitmaps and tags to default state.
 }
 procedure DefaultBitmaps;
 begin
  b:=FileCopy(DaqFileRef(AdaptFileName('..\Bitmaps\Plot0.bmp'),'')+' '+DaqFileRef(AdaptFileName('..\Bitmaps\Plot1.bmp'),''));
  b:=FileCopy(DaqFileRef(AdaptFileName('..\Bitmaps\Plot0.bmp'),'')+' '+DaqFileRef(AdaptFileName('..\Bitmaps\Plot2.bmp'),''));
  b:=FileCopy(DaqFileRef(AdaptFileName('..\Bitmaps\Plot0.bmp'),'')+' '+DaqFileRef(AdaptFileName('..\Bitmaps\Plot3.bmp'),''));
  b:=FileCopy(DaqFileRef(AdaptFileName('..\Bitmaps\Plot0.bmp'),'')+' '+DaqFileRef(AdaptFileName('..\Bitmaps\Plot4.bmp'),''));
  b:=FileCopy(DaqFileRef(AdaptFileName('..\Bitmaps\Plot0.bmp'),'')+' '+DaqFileRef(AdaptFileName('..\Bitmaps\Plot5.bmp'),''));
  b:=FileCopy(DaqFileRef(AdaptFileName('..\Bitmaps\Plot0.bmp'),'')+' '+DaqFileRef(AdaptFileName('..\Bitmaps\Plot6.bmp'),''));
  b:=iSetTag(tagPlot1,0);
  b:=iSetTag(tagPlot2,0);
  b:=iSetTag(tagPlot3,0);
  b:=iSetTag(tagPlot4,0);
  b:=iSetTag(tagPlot5,0);
  b:=iSetTag(tagPlot6,0);
 end;
 {
 Print most of all ParamStr items.
 }
 procedure PrintMostParamStr;
  procedure Print(Param,Comment:String);
  begin
   Writeln(' ParamStr('''+Param+''') = "'+ParamStr(Param)+'" '+Comment);
  end;
 begin
  Print('0 ',' - Имя запущенной программы.');
  Print('1 ',' - 1 параметр командной строки.');
  Print('2 ',' - 2 параметр командной строки.');
  Print('3 ',' - 3 параметр командной строки.');
  Print('4 ',' - 4 параметр командной строки.');
  Print('5 ',' - 5 параметр командной строки.');
  Print('6 ',' - 6 параметр командной строки.');
  Print('7 ',' - 7 параметр командной строки.');
  Print('8 ',' - 8 параметр командной строки.');
  Print('9 ',' - 9 параметр командной строки.');
  Print('HomeDir',' - Домашний каталог программы.');
  Print('StartupPath',' - Стартовый каталог.');
  Print('TempPath',' - Каталог временных файлов программы.');
  Print('DaqConfigPath',' - Каталог основной конфигурации DAQ.');
  Print('DaqConfigFile',' - Файл основной конфигурации DAQ.');
  Print('DaqDataPath',' - Путь данных DAQ по умолчанию.');
  Print('DaqBackupFile',' - Файл сохранения временных данных.');
  Print('GetCurrDir',' - Текущий каталог программы.');
  Print('DeviceName',' - Имя устройства.');
  Print('DeviceFamily',' - Тип устройства.');
  Print('DeviceModel',' - Модель устройства.');
  Print('ProgName',' - Имя исполняемого файла программы.');
  Print('DaqProgram',' - Имя программы DAQ Pascal.');
  Print('UserName',' - Имя пользователя.');
  Print('ComputerName',' - Имя компьютера.');
  Print('HostName 0',' - Имя сервера.');
  Print('HostName 1',' - Сетевое имя сервера.');
  Print('UserDomain',' - Пользовательский домен.');
  Print('IpAddress',' - IP адрес компьютера.');
  Print('MacAddress',' - MAC адрес компьютера.');
  Print('ComPortList',' - Список COM портов.');
  Print('SYSTEM OS PLATFORM',' - Платформа операционной системы, например: 3x,9x,NT,??.');
  Print('SYSTEM OS VERSION',' - Версия операционной системы, например: 5.1.2600.');
  Print('SYSTEM OS SYSROOT',' - Каталог операционной системы, например: C:\WINDOWS.');
  Print('SYSTEM OS COMSPEC',' - Имя командного процессора, например: C:\WINDOWS\SYSTEM32\CMD.EXE.');
  Print('SYSTEM RAM TOTALPHYS',' - Общая физическая память в байтах.');
  Print('SYSTEM RAM AVAILPHYS',' - Свободная физическая память в байтах.');
  Print('SYSTEM RAM MEMORYLOAD',' - Занятая память в процентах.');
  Print('SYSTEM RAM TOTALVIRTUAL',' - Общая виртуальная память в байтах.');
  Print('SYSTEM RAM AVAILVIRTUAL',' - Свободная виртуальная память в байтах.');
  Print('SYSTEM RAM TOTALPAGEFILE',' - Общая память файла подкачки в байтах.');
  Print('SYSTEM RAM AVAILPAGEFILE',' - Свободная память файла подкачки в байтах.');
  Print('SYSTEM PROCESS ID',' - Идентификатор текущего процесса.');
  Print('SYSTEM PROCESS PARENTID',' - Идентификатор родительского процесса.');
  Print('SYSTEM PROCESS PARENTEXE',' - Исполняемый файл родительского процесса.');
  Print('SYSTEM PROCESS ALLOCMEMSIZE',' - Счетчик объема захваченной памяти, байт.');
  Print('SYSTEM PROCESS ALLOCMEMCOUNT',' - Счетчик числа блоков захваченной памяти.');
  Print('SYSTEM PROCESS GDIOBJECTS',' - Счетчик захваченных ресурсов GDI (картинки, кисти, фонты и т.д.).');
  Print('SYSTEM PROCESS USEROBJECTS',' - Счетчик захваченных ресурсов USER (окна, курсоры, меню и т.д.).');
  Print('SYSTEM PROCESS KERNELOBJECTS',' - Счетчик захваченных ресурсов KERNEL (файлы, потоки, мютексы и т.д.).');
  Print('SYSTEM PROCESS GDIOBJECTSQUOTA',' - Квота на число ресурсов GDI, которые можно захватить.');
  Print('SYSTEM PROCESS USEROBJECTSQUOTA',' - Квота на число ресурсов USER, которые можно захватить.');
  Print('SYSTEM PROCESS KERNELOBJECTSQUOTA',' - Квота на число ресурсов KERNEL, которые можно захватить.');
  Print('SYSTEM PROCESS TIMES',' - Времена процесса и потока (Creation,Exit,Kernel,User).');
  Print('SYSTEM METRICS SM_CMONITORS',' - Число доступных мониторов.');
  Print('SYSTEM METRICS SM_SAMEDISPLAYFORMAT',' - Флаг одинакового формата мониторов, если их несколько.');
  Print('SYSTEM METRICS SM_CXSCREEN',' - Ширина экрана в пикселях.');
  Print('SYSTEM METRICS SM_CYSCREEN',' - Высота экрана в пикселях.');
  Print('SYSTEM METRICS SM_CXFULLSCREEN',' - Ширина клиентской области в режиме "полного экрана" в пикселях.');
  Print('SYSTEM METRICS SM_CYFULLSCREEN',' - Высота клиентской области в режиме "полного экрана" в пикселях.');
  Print('SYSTEM METRICS SM_XVIRTUALSCREEN',' - Координата X Рабочего Стола в пикселях.');
  Print('SYSTEM METRICS SM_YVIRTUALSCREEN',' - Координата Y Рабочего Стола в пикселях.');
  Print('SYSTEM METRICS SM_CXVIRTUALSCREEN',' - Ширина Рабочего Стола в пикселях.');
  Print('SYSTEM METRICS SM_CYVIRTUALSCREEN',' - Высота Рабочего Стола в пикселях.');
  Print('SYSTEM METRICS SM_CXICON',' - Ширина нормальных "ярлыков".');
  Print('SYSTEM METRICS SM_CYICON',' - Высота нормальных "ярлыков".');
  Print('SYSTEM METRICS SM_CXSMICON',' - Ширина маленьких "ярлыков".');
  Print('SYSTEM METRICS SM_CYSMICON',' - Высота маленьких "ярлыков".');
  Print('SYSTEM METRICS SM_CXICONSPACING',' - Ширина ячейки при отображении "ярлыков" на Рабочем Столе.');
  Print('SYSTEM METRICS SM_CYICONSPACING',' - Высота ячейки при отображении "ярлыков" на Рабочем Столе.');
  Print('SYSTEM METRICS SM_CXMIN',' - Минимальная ширина окна.');
  Print('SYSTEM METRICS SM_CYMIN',' - Минимальная высота окна.');
  Print('SYSTEM METRICS SM_CXMINIMIZED',' - Стандартная ширина "минимизированного" окна.');
  Print('SYSTEM METRICS SM_CYMINIMIZED',' - Стандартная высота "минимизированного" окна.');
  Print('SYSTEM METRICS SM_CXMAXIMIZED',' - Стандартная ширина "максимизированного" окна.');
  Print('SYSTEM METRICS SM_CYMAXIMIZED',' - Стандартная высота "максимизированного" окна.');
  Print('SYSTEM METRICS SM_CXMINTRACK',' - Минимальная ширина "резиновой рамки" при изменении размера окна.');
  Print('SYSTEM METRICS SM_CYMINTRACK',' - Минимальная высота "резиновой рамки" при изменении размера окна.');
  Print('SYSTEM METRICS SM_CXMAXTRACK',' - Максимальная ширина "резиновой рамки" при изменении размера окна.');
  Print('SYSTEM METRICS SM_CYMAXTRACK',' - Максимальная высота "резиновой рамки" при изменении размера окна.');
  Print('SYSTEM METRICS SM_CYCAPTION',' - Высота нормального заголовка окна.');
  Print('SYSTEM METRICS SM_CYSMCAPTION',' - Высота маленького заголовка окна.');
  Print('SYSTEM METRICS SM_CXSIZE',' - Ширина нормальных кнопок на заголовке окна.');
  Print('SYSTEM METRICS SM_CYSIZE',' - Высота нормальных кнопок на заголовке окна.');
  Print('SYSTEM METRICS SM_CXSMSIZE',' - Ширина маленьких кнопок на заголовке окна.');
  Print('SYSTEM METRICS SM_CYSMSIZE',' - Высота маленьких кнопок на заголовке окна.');
  Print('SYSTEM METRICS SM_CYMENU',' - Высота нормальной строки меню.');
  Print('SYSTEM METRICS SM_CXMENUSIZE',' - Ширина кнопок в строке меню.');
  Print('SYSTEM METRICS SM_CYMENUSIZE',' - Высота кнопок в строке меню.');
  Print('SYSTEM METRICS SM_CXMENUCHECK',' - Ширина "флажка" отмеченного пункта меню.');
  Print('SYSTEM METRICS SM_CYMENUCHECK',' - Высота "флажка" отмеченного пункта меню.');
  Print('SYSTEM METRICS SM_MENUDROPALIGNMENT',' - Флаг выравнивания всплывающего меню 0:Left, 1:Right.');
  Print('SYSTEM METRICS SM_CXBORDER',' - Ширина рамки нормального окна.');
  Print('SYSTEM METRICS SM_CYBORDER',' - Высота рамки нормального окна.');
  Print('SYSTEM METRICS SM_CXFRAME',' - Ширина рамки окна, за которую можно "хватать" мышкой для изменения размеров.');
  Print('SYSTEM METRICS SM_CYFRAME',' - Высота рамки окна, за которую можно "хватать" мышкой для изменения размеров.');
  Print('SYSTEM METRICS SM_CXDLGFRAME',' - Ширина рамки диалогового окна.'); 
  Print('SYSTEM METRICS SM_CYDLGFRAME',' - Высота рамки диалогового окна.');
  Print('SYSTEM METRICS SM_CXEDGE',' - Ширина рамки объемного окна.');
  Print('SYSTEM METRICS SM_CYEDGE',' - Высота рамки объемного окна.');
  Print('SYSTEM METRICS SM_ARRANGE',' - флаги способа выравнивания окон при минимизации.');
  Print('SYSTEM METRICS SM_CXMINSPACING',' - ширина ячеек при выстраивании минимизированных окон.');
  Print('SYSTEM METRICS SM_CYMINSPACING',' - высота ячеек при выстраивании минимизированных окон.');
  Print('SYSTEM METRICS SM_CXHSCROLL',' - Ширина "стрелки" горизонтальной полосы прокрутки.');
  Print('SYSTEM METRICS SM_CYHSCROLL',' - Высота "стрелки" горизонтальной полосы прокрутки.');
  Print('SYSTEM METRICS SM_CXVSCROLL',' - Ширина "стрелки" вертикальной полосы прокрутки.');
  Print('SYSTEM METRICS SM_CYVSCROLL',' - Высота "стрелки" вертикальной полосы прокрутки.');
  Print('SYSTEM METRICS SM_CXHTHUMB',' - Ширина "движка" полосы прокрутки.');
  Print('SYSTEM METRICS SM_CYVTHUMB',' - Высота "движка" полосы прокрутки.');
  Print('SYSTEM METRICS SM_MOUSEPRESENT',' - Флаг наличия мыши, 0 или 1.');
  Print('SYSTEM METRICS SM_CMOUSEBUTTONS',' - Число доступных кнопок мыши или 0 если нет мыши.');
  Print('SYSTEM METRICS SM_MOUSEWHEELPRESENT',' - Флаг наличия "колесика" мыши, 0 или 1.');
  Print('SYSTEM METRICS SM_SWAPBUTTON',' - Флаг замены левой и правой кнопки мыши (для левшей).');
  Print('SYSTEM METRICS SM_CXCURSOR',' - Ширина стандартного курсора мыши.');
  Print('SYSTEM METRICS SM_CYCURSOR',' - Высота стандартного курсора мыши.');
  Print('SYSTEM METRICS SM_CXDOUBLECLK',' - максимальная ширина области для индикации "двойного щелчка" мыши.');
  Print('SYSTEM METRICS SM_CYDOUBLECLK',' - максимальная высота области для индикации "двойного щелчка" мыши.');
  Print('SYSTEM METRICS SM_CXDRAG',' - ширина минимальной области для перехода в режим "drag and drop".');
  Print('SYSTEM METRICS SM_CYDRAG',' - высота минимальной области для перехода в режим "drag and drop".');
  Print('SYSTEM METRICS SM_SECURE',' - Флаг наличия системы прав доступа, 0 или 1.');
  Print('SYSTEM METRICS SM_NETWORK',' - Флаг наличия сети, 0 или 1.');
  Print('SYSTEM METRICS SM_DEBUG',' - Флаг отладочной версии Windows.');
  Print('SYSTEM METRICS SM_CLEANBOOT',' - Флаг загрузки: 0="Normal", 1="Fail-safe", 2="Fail-safe with network".');
  Print('SYSTEM METRICS SM_SLOWMACHINE',' - Флаг "медленной" машины со "слабым" процессором, 0 или 1.');
  Print('SYSTEM METRICS SM_MIDEASTENABLED',' - Флаг поддержки восточных языков, 0 или 1.');
 end;
begin
 {
 Initialization actions on Start...
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=Val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  Success('Starting...');
  {
  Initialize tags...
  }
  InitTag(tagPlot1, 'Plot1', 1);
  InitTag(tagPlot2, 'Plot2', 1);
  InitTag(tagPlot3, 'Plot3', 1);
  InitTag(tagPlot4, 'Plot4', 1);
  InitTag(tagPlot5, 'Plot5', 1);
  InitTag(tagPlot6, 'Plot6', 1);
  PlotSendTime:=0;
  {
  Initialize window
  }
  DefaultBitmaps;
  b:=WinDraw('DAQ-СИСТЕМА|Top=0|Left=0|Options=-Left,-Top');
  b:=WinShow('DemoPlot') and WinSelect('DemoPlot');
  b:=WinDraw('DemoPlot|Top=0|Left=167|Width=550|Height=400|ToolBarHeight=2');
  b:=WinDraw('DemoPlot|Options=-Min,-Max,-Close,-VScroll,-HScroll,'+
                              '-Left,-Top,-Width,-Height,+ToolBar|Reload=All');
  PrintMostParamStr;
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop...
 }
 if isinf(runcount) then begin
  Success('Stop.');
  DefaultBitmaps;
  ClearStrings;
 end else
 {
 Actions on Poll...
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
  {
  Process editing...
  }
  if ClickButton=1 then begin
   //
   // Example 1: plot data curves from formula (lines+impulses).
   // GNUPLOT commands sends via PlotSend('@> cmd'+EOL).
   // Use @Clear as first command to clear previous plot.
   // Use @Timeout to set time limit for GNUPLOT execution.
   // Use @HomeDir to set directory where GNUPLOT should start.
   // Use @DoneMsg,@FailMsg for feedback if GNUPLOT run Ok or failed.
   // Use @! commands to execute filters after GNUPLOT work done.
   // Use @! unix gif2bmp to convert GIF to BMP (for sensor images).');
   // Use @> set encoding utf8 for national (Unicode) text.
   // Use @> set term gif, set output "file.gif" to plot in GIF.
   // Use @run job dat bat  as last command to run GNUPLOT with
   //          job file for GNUPLOT commands, dat file for data,
   //          bat file for filter  commands.
   // Note that you can separate GNUPLOT commands with semicolon
   // like 'cmd1; cmd 2; cmd 3', you also can continue long line
   // with backslash \ like:
   //  long line start \
   //  long line continue
   //
   //
   if ClickTag=tagPlot1 then begin
    b:=iSetTag(tagPlot1,0);
    b:=PlotSend('@Clear'+EOL
               +'@TimeOut 5000'+EOL
               +'@HomeDir '+AdaptFileName('..\Temp')+EOL
               +'@DoneMsg &DemoPlot @Done '+AdaptFileName('..\Bitmaps\plot1.bmp')+EOL
               +'@FailMsg &DemoPlot @Fail '+AdaptFileName('..\Bitmaps\plot1.bmp')+EOL
               +'@> set encoding utf8'+EOL
               +'@> set output "plot1.gif"'+EOL
               +'@> set terminal gif small size 300,200 font "PT Mono,8"'+EOL
               +'@> set title "График по формуле (impulses, lines)" font "PT Sans,10"'+EOL
               +'@> set xlabel "Время, секунд" font "PT Sans,12"'+EOL
               +'@> set ylabel "Значение, отн.ед." font "PT Serif,12"'+EOL
               +'@> plot [0:10] sin(x+'+StrFix(random(0,5),1,3)+')/sqrt(x) with impulses,\'+EOL
               +'@>             cos(x+'+StrFix(random(0,5),1,3)+')/sqrt(x) with lines lw 2 lc 3'+EOL
               +'@! unix gif2bmp plot1.gif '+AdaptFileName('..\bitmaps\plot1.bmp')+EOL
               +'@run plot1.job plot1.dat '+AdaptExeFileName('plot1.bat')+EOL)>0;
    nPlot1:=nPlot1+1;
    b:=Voice(snd_Click);
   end;
   //
   // Example 2: plot data curves with small size (<100).
   // Data sends directly via PlotSend('@# x y'+EOL)
   // To separate curves, use '@#'+EOL+'@#'+EOL separator
   // Use using nx:ny to set x and y columns.
   // Use index n to plot curve n=0,1,...
   // Use @> set grid to show gridlines.
   // Use @> set key on/off left/right top/bottom to set key pos.
   // Use @> plot "file1.dat" with index n using nx:ny with \
   //        lines/ponts/linespoints/dots/boxes/steps/histeps \
   //        lw w lc c pt p ps s ti "Curve Name", "file2.dat" ....
   //        w-line style, c-line color, p-point type, s-point size
   //
   if ClickTag=tagPlot2 then begin
    b:=iSetTag(tagPlot2,0);
    s:='';
    // Index 0 curve...
    n:=20;
    for i:=0 to n-1 do begin
     x:=10.0*i/n; if x=0 then y:=1 else y:=sin(x)/x; y:=y+random(-1,1)*0.05;
     s:=s+'@# '+Str(x)+' '+Str(y)+EOL;
    end;
    // Curve separator
    s:=s+'@#'+EOL+'@#'+EOL;
    //Index 1 curve...
    n:=50; r:=Random(0,5);
    for i:=0 to n-1 do begin
     x:=10.0*i/n; y:=sin(x+r)*x/5+random(-1,1)*0.05;
     s:=s+'@# '+Str(x)+' '+Str(y)+EOL;
    end;
    b:=PlotSend('@Clear'+EOL
               +'@TimeOut 5000'+EOL
               +'@HomeDir '+AdaptFileName('..\Temp')+EOL
               +'@DoneMsg &DemoPlot @Done '+AdaptFileName('..\Bitmaps\plot2.bmp')+EOL
               +'@FailMsg &DemoPlot @Fail '+AdaptFileName('..\Bitmaps\plot2.bmp')+EOL
               +'@> set encoding utf8'+EOL
               +'@> set output "plot2.gif"'+EOL
               +'@> set terminal gif small size 300,200 font "PT Sans,7"'+EOL
               +'@> set title "График по таблице (linespoints, boxes)" font "PT Sans,10"'+EOL
               +'@> set xlabel "Время, секунд" font "PT Sans,10"'+EOL
               +'@> set ylabel "Значение" font "PT Sans,10"'+EOL
               +'@> set grid; set key left top; set xrange [0:10]'+EOL
               +'@> plot "plot2.dat" index 0 using 1:2 with linespoints pt 13 ti "Кривая 1", \'+EOL
               +'@>      "plot2.dat" index 1 using 1:2 with boxes ti "Кривая 2"'+EOL
               +s+EOL
               +'@! unix gif2bmp plot2.gif '+AdaptFileName('..\Bitmaps\plot2.bmp')+EOL
               +'@run plot2.job plot2.dat '+AdaptExeFileName('plot2.bat')+EOL)>0;
    nPlot2:=nPlot2+1;
    b:=Voice(snd_Click);
   end;
   //
   // Example 3: plot data curves with big size (>100).
   // Data sends via PlotSend('@CurveList'+EOL)
   //
   if ClickTag=tagPlot3 then begin
    b:=iSetTag(tagPlot3,0);
    // Index 0 curve...
    b:=CrvDel(RefAo(0),1,CrvLen(RefAo(0)))>0;
    n:=10000;
    for i:=0 to n-1 do begin
     x:=10.0*i/n; if x=0 then y:=1 else y:=sin(x)/x; y:=y+random(-1,1)*0.05;
     b:=CrvIns(RefAo(0),MaxInt,x,y)>0;
    end;
    //Index 1 curve...
    b:=CrvDel(RefAo(1),1,CrvLen(RefAo(1)))>0;
    n:=20000;
    r:=Random(0,5);
    for i:=0 to n-1 do begin
     x:=10.0*i/n; y:=sin(x+r)*x/5+random(-1,1)*0.05;
     b:=CrvIns(RefAo(1),MaxInt,x,y)>0;
    end;
    b:=PlotSend('@Clear'+EOL
               +'@TimeOut 15000'+EOL
               +'@HomeDir '+AdaptFileName('..\Temp')+EOL
               +'@DoneMsg &DemoPlot @Done '+AdaptFileName('..\Bitmaps\plot3.bmp')+EOL
               +'@FailMsg &DemoPlot @Fail '+AdaptFileName('..\Bitmaps\plot3.bmp')+EOL
               +'@> set encoding utf8'+EOL
               +'@> set output "plot3.gif"'+EOL
               +'@> set terminal gif small size 300,200 font "PT Sans,6"'+EOL
               +'@> set title "График по большой таблице" font "PT Mono,9"'+EOL
               +'@> set xlabel "Время, секунд" font "PT Sans,10"'+EOL
               +'@> set ylabel "Значение" font "PT Mono,12"'+EOL
               +'@> set grid'+EOL
               +'@> set key left top'+EOL
               +'@> set xrange [0:10]'+EOL
               +'@> plot "plot3.dat" index 0 using 1:2 with lines lc 2'
                      +' ti "Кривая '+Str(CrvLen(RefAo(0)))+' точек", \'+EOL
               +'@>      "plot3.dat" index 1 using 1:2 with lines lc 3'
                      +' ti "Кривая '+Str(CrvLen(RefAo(1)))+' точек"'+EOL
               +'@CurveList '+CrvName(RefAo(0))+EOL
               +'@CurveList '+CrvName(RefAo(1))+EOL
               +'@! unix gif2bmp plot3.gif '+AdaptFileName('..\Bitmaps\plot3.bmp')+EOL
               +'@run plot3.job plot3.dat '+AdaptExeFileName('plot3.bat')+EOL)>0;
    nPlot3:=nPlot3+1;
    b:=Voice(snd_Click);
   end;
   //
   // Example 4: Demo Plot 3D surface.
   //
   if ClickTag=tagPlot4 then begin
    b:=iSetTag(tagPlot4,0);
    b:=PlotSend('@Clear'+EOL
               +'@TimeOut 5000'+EOL
               +'@HomeDir '+AdaptFileName('..\Temp')+EOL
               +'@DoneMsg &DemoPlot @Done '+AdaptFileName('..\Bitmaps\plot4.bmp')+EOL
               +'@FailMsg &DemoPlot @Fail '+AdaptFileName('..\Bitmaps\plot4.bmp')+EOL
               +'@> set encoding utf8'+EOL
               +'@> set output "plot4.gif"'+EOL
               +'@> set terminal gif tiny size 300,200 font "PT Mono,6"'+EOL
               +'@> set samples 20; set isosamples 20; set hidden3d'+EOL
               +'@> set title "Поверхность со скрытыми линиями" font "PT Mono,8"'+EOL
               +'@> set xrange [-3:3]; set yrange [-3:3]'+EOL
               +'@> splot sin(x*x + y*y) / (x*x + y*y)'+EOL
               +'@! unix gif2bmp plot4.gif '+AdaptFileName('..\Bitmaps\plot4.bmp')+EOL
               +'@run plot4.job plot4.dat '+AdaptExeFileName('plot4.bat')+EOL)>0;
    nPlot4:=nPlot4+1;
    b:=Voice(snd_Click);
   end;
   //
   // Example 5: plot data curves with native time on x axis.
   //
   if ClickTag=tagPlot5 then begin
    b:=iSetTag(tagPlot5,0);
    s:='';
    // Generate curves...
    n:=7; // Range in hours
    mn:=GetMidnight(mSecNow);
    for j:=0 to 13 do begin
     b:=CrvDel(RefAo(j),1,CrvLen(RefAo(j)))>0;
     for i:=0 to n-1 do begin
      x:=10.0*i/n; y:=(-cos(x)+j)*Ord(i>3);
      x:=mn+(i-n/2)*3600*1000;
      s:=s+'@# '+GetDateTime(x)+' '+Str(y)+EOL;
      x:=(x-TimeBase)/TimeUnits;
      b:=CrvIns(RefAo(j),MaxInt,x,y)>0;
     end;
     s:=s+'@#'+EOL+'@#'+EOL; // Curve separator
    end;
    if Odd(nPlot5) then begin
     s:='';
     for j:=0 to 13 do s:=s+'@CurveList '+CrvName(RefAo(j))+EOL;
     s:=s+'@XTime=Default'+EOL;
    end;
    b:=PlotSend('@Clear'+EOL
               +'@TimeOut 5000'+EOL
               +'@HomeDir '+AdaptFileName('..\Temp')+EOL
               +'@DoneMsg &DemoPlot @Done '+AdaptFileName('..\Bitmaps\plot5.bmp')+EOL
               +'@FailMsg &DemoPlot @Fail '+AdaptFileName('..\Bitmaps\plot5.bmp')+EOL
               +'@> set encoding utf8'+EOL
               +'@> set output "plot5.gif"'+EOL
               +'@> set terminal gif tiny size 300,200'+EOL
               +'@> set title "Цвета, стили и календарное время" font "PT Mono,10"'+EOL
               +'@> set xlabel "Время календарное" font "PT Sans,10"'+EOL
               +'@> set ylabel "Цвета lc и стили pt" font "PT Mono,9"'+EOL
               +'@> set xdata time; set timefmt "%Y.%m.%d-%H:%M:%S"'+EOL
               +'@> set format x "%d.%m\n%H:%M";'+EOL
               +'@> set xrange [ "'+GetDateTime(mn-n/2*3600*1000)
                             +'":"'+GetDateTime(mn+n/2*3600*1000)+'" ]'+EOL
               +'@> set grid; set key left top;'+EOL
               +'@> plot "plot5.dat" index 0  using 1:2 with lp lc 0  pt 0  ti "lc 0  pt 0", \'+EOL
               +'@>      "plot5.dat" index 1  using 1:2 with lp lc 1  pt 1  ti "lc 1  pt 1", \'+EOL
               +'@>      "plot5.dat" index 2  using 1:2 with lp lc 2  pt 2  ti "lc 2  pt 2", \'+EOL
               +'@>      "plot5.dat" index 3  using 1:2 with lp lc 3  pt 3  ti "lc 3  pt 3", \'+EOL
               +'@>      "plot5.dat" index 4  using 1:2 with lp lc 4  pt 4  ti "lc 4  pt 4", \'+EOL
               +'@>      "plot5.dat" index 5  using 1:2 with lp lc 5  pt 5  ti "lc 5  pt 5", \'+EOL
               +'@>      "plot5.dat" index 6  using 1:2 with lp lc 6  pt 6  ti "lc 6  pt 6", \'+EOL
               +'@>      "plot5.dat" index 7  using 1:2 with lp lc 7  pt 7  ti "lc 7  pt 7", \'+EOL
               +'@>      "plot5.dat" index 8  using 1:2 with lp lc 8  pt 8  ti "lc 8  pt 8", \'+EOL
               +'@>      "plot5.dat" index 9  using 1:2 with lp lc 9  pt 9  ti "lc 9  pt 9", \'+EOL
               +'@>      "plot5.dat" index 10 using 1:2 with lp lc 10 pt 10 ti "lc 10 pt 10", \'+EOL
               +'@>      "plot5.dat" index 11 using 1:2 with lp lc 11 pt 11 ti "lc 11 pt 11", \'+EOL
               +'@>      "plot5.dat" index 12 using 1:2 with lp lc 12 pt 12 ti "lc 12 pt 12", \'+EOL
               +'@>      "plot5.dat" index 13 using 1:2 with lp lc 13 pt 13 ti "lc 13 pt 13"  \'+EOL
               +s+EOL
               +'@! unix gif2bmp plot5.gif '+AdaptFileName('..\Bitmaps\plot5.bmp')+EOL
               +'@run plot5.job plot5.dat '+AdaptExeFileName('plot5.bat')+EOL)>0;
    nPlot5:=nPlot5+1;
    b:=Voice(snd_Click);
   end;
   //
   // Example 6: Interlocking torus.
   //
   if ClickTag=tagPlot6 then begin
    b:=iSetTag(tagPlot6,0);
    b:=PlotSend('@Clear'+EOL
               +'@TimeOut 5000'+EOL
               +'@HomeDir '+AdaptFileName('..\Temp')+EOL
               +'@DoneMsg &DemoPlot @Done '+AdaptFileName('..\Bitmaps\plot6.bmp')+EOL
               +'@FailMsg &DemoPlot @Fail '+AdaptFileName('..\Bitmaps\plot6.bmp')+EOL
               +'@> set encoding utf8'+EOL
               +'@> set output "plot6.gif"'+EOL
               +'@> set terminal gif tiny size 300,200 font "PT Mono,6"'+EOL
               +'@> set samples 20; set isosamples 20; set hidden3d'+EOL
               +'@> set title "Красивые вкусные бублики" font "PT Mono,14"'+EOL
               +'@> unset key; unset label 1; unset label 2'+EOL
               +'@> set parametric; set urange [-pi:pi]; set vrange [-pi:pi]'+EOL
               +'@> set isosamples 50,20; set view 60, 30, 1.1, 1.33; set pm3d depthorder'+EOL
               +'@> splot cos(u)+.4*cos(u)*cos(v),sin(u)+.4*sin(u)*cos(v),.4*sin(v)   with pm3d, \'+EOL
               +'@>       1+cos(u)+.4*cos(u)*cos(v),.4*sin(v),sin(u)+.4*sin(u)*cos(v) with pm3d'+EOL
               +'@! unix gif2bmp plot6.gif '+AdaptFileName('..\Bitmaps\plot6.bmp')+EOL
               +'@run plot6.job plot6.dat '+AdaptExeFileName('plot6.bat')+EOL)>0;
    nPlot6:=nPlot6+1;
    b:=Voice(snd_Click);
   end;
  end;
 end;
end.
