
//						
// INTRODUCTION
//    This is a simple RS-232 program for the standard Lambda Genesys power supply.
//    It opens a console window with a prompt to enter address and Baud rate.
//    It then sends any command string that is typed, followed by <CR>.
//    It displays any characters returned from the power supply.
//    Comments may be typed by starting the command with "//"
//		Author:   Walter Heyck, TDK-Lambda, Oct 18, 2010


using System;
using System.Collections.Generic;
using System.Text;
using System.IO;				// For file writing
using System.IO.Ports;
using System.Threading;			// For 'thread.sleep' delay method

namespace GEN_RS232_Console
{
	class Program
	{
		static void Main( string[ ] args )
		{
			string inputLine;	    // User message from console input
			string recv;		    // Received response from GEN, ex: "OK"
			string sExit = "X";	    // Comparitor for exiting loop
            string sComNum = "1";   // "COM1" is default port
			string sBaud = "9600";  // "9600" is default BAUD rate
			//Boolean noProblem = false;	// Used for 

			Console.WriteLine( "\n" );
			Console.WriteLine( "Genesys: RS-232 Console program v08." );
			Console.WriteLine( "-----  Enter \"X\" to exit.  ------" );
			Console.WriteLine( " " );

            Console.WriteLine("Enter COM Port number.");
            Console.Write(    "        (default \"COM1\") --> ");
			sComNum = Console.ReadLine();

			if (sComNum.Length == 0)
				sComNum = "1";			// default "COM1"

			Console.WriteLine("Enter BAUD rate.");
			Console.Write(    "        (default \"9600\") --> ");
			sBaud = Console.ReadLine();
			if (sBaud.Length == 0)
				sBaud = "9600";			// Default 9600 Baud
			Console.WriteLine(" ");

			SerialPort myPort = new SerialPort();

			myPort.PortName = "COM" + sComNum;
			myPort.BaudRate = Convert.ToInt16(sBaud);
			myPort.NewLine = "\r";
			myPort.ReadTimeout = 2000;		// Read TMO = 2.0 Sec

			myPort.Open( );

			// Open text file for writing
							//  FileStream(@"c:\temp\mcb.txt" , 
			FileStream tempFileStream = new FileStream("temp232.txt", FileMode.Create, FileAccess.Write);
			StreamWriter fileWriter = new StreamWriter( tempFileStream); 
			// Write to the file using StreamWriter class 
			fileWriter.BaseStream.Seek(0, SeekOrigin.End);
			fileWriter.WriteLine("GEN RS-232 Console Capture."); 
			fileWriter.WriteLine("{0} {1}", DateTime.Now.ToLongTimeString(), DateTime.Now.ToLongDateString()); 
			fileWriter.WriteLine("---------------------------");
			fileWriter.WriteLine("Opening:  COM:  {0}", sComNum);
			fileWriter.WriteLine("Opening:  BAUD: {0}", sBaud);
			fileWriter.Flush(); 

			while( true)
			{
				while ( myPort.BytesToRead != 0 )
				{
					Console.Write( "      **** Extra Chars: \"" );
					recv = myPort.ReadLine();
					Console.WriteLine(recv);
					Console.WriteLine( "\"" );

					fileWriter.WriteLine( "      **** Extra Chars: \"" );
					fileWriter.WriteLine( "{0}", recv);
					fileWriter.WriteLine( "\"" );

					Thread.Sleep( 100 );
				}
				
				Console.Write( "Send: " );

				inputLine = Console.ReadLine( );

				// Check if quitting program by typing "x" or "X"
				if ( string.Equals( inputLine.ToUpper( ), sExit ) )
					break;

				// Check if comment text: do not send down RS-232
				if (inputLine.IndexOf("//") >= 0)
					continue;

				inputLine.Trim();
				myPort.WriteLine( inputLine );		// Send RS-232.  Appends <CR> automatically
				fileWriter.WriteLine( "Send: {0}", inputLine );

				try
				{
					recv = myPort.ReadLine( );

					Console.Write( "    \\ " );
					Console.WriteLine( recv );
					fileWriter.Write( "    \\ " );
					fileWriter.WriteLine( recv );
				}
				catch (TimeoutException)
				{
					Console.WriteLine( "      **** TMO Error ** " );
					fileWriter.WriteLine("      **** TMO Error ** " );
				}
				Thread.Sleep( 100 );	// Wait for trailing response chars

			}  //End infinite While

			//if (myPort != null)
				myPort.Close( );

			fileWriter.WriteLine("Closing");
			fileWriter.Close();
			tempFileStream.Close();

			// Hold window open you you can examine it.
			Console.WriteLine( "\nPress <Enter> to close console and quit." );
			inputLine = Console.ReadLine( );
		}
	}
}
