 {
 Control driver for FC1300 devices.
 }
program FC1300_DRV;
const
 dfTrouble         = 1;       { DebugFlags - Trouble             }
 dfSuccess         = 2;       { DebugFlags - Success             }
 dfViewExp         = 4;       { DebugFlags - ViewExp             }
 dfViewImp         = 8;       { DebugFlags - ViewImp             }
var
 s                 : String;  { Temporary                        }
 i,n               : Integer; { Temporary                        }
 r                 : Real;    { Temporary                        }
 b                 : Boolean; { Temporary                        }
 Ok                : Boolean;
 errors            : Integer;
 errorcode         : Integer;
 DebugFlags        : Integer; { Debug bit flags                  }
 fixmaxavail       : Integer; { String manager leak control      }
 StdIn_Line        : String;  { Temporary variable               }
 winPlot           : String;  { Plot window                      }
 FC1300            : record   { All FC1300 related data          }
  Ans              : String;  { Answer                           }
  Buf              : String;  { Temporary buffer                 }
  Time             : Real;    { Time when sent last message      }
  State            : Integer;
  TimeOut          : Real;
 end;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Show/hide device console.
 }
 procedure OpenConsole(Mode:Integer);
 var b:Boolean;
  procedure ShowWin(WinName:String);
  begin
   b:=WinShow(WinName);
   b:=WinDraw(WinName+'|Top=0|Left=167|width=600|height=317');
   if Mode=1 then b:=WinSelect(WinName) else b:=WinHide(WinName);
  end;
 begin
  if Mode>0 then ShowWin(ParamStr('Console '+DevName))
 end;
 {
 Check I/O status.
 }
 function IoError:Boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var Data:string):boolean;
 begin
  Data:='';
  if not IoError then
  if not Eof then Readln(Data);
  if IoError then Data:='';
  StdIn_Readln:=Length(Data)>0;
 end;
 {
 Get string like 2006.09.21-00:12:30
 }
 function GetDateTime(ms:Real):String;
 var s:String;
 begin
  s:='';
  s:=Str(ms2sec(ms))+s;   while Length(s)<2  do s:='0'+s; s:=':'+s;
  s:=Str(ms2min(ms))+s;   while Length(s)<5  do s:='0'+s; s:=':'+s;
  s:=Str(ms2hour(ms))+s;  while Length(s)<8  do s:='0'+s; s:='-'+s;
  s:=Str(ms2day(ms))+s;   while Length(s)<11 do s:='0'+s; s:='.'+s;
  s:=Str(ms2month(ms))+s; while Length(s)<14 do s:='0'+s; s:='.'+s;
  s:=Str(ms2year(ms))+s;  while Length(s)<19 do s:='0'+s;
  GetDateTime:=s;
  s:='';
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  winPlot:='';
  StdIn_Line:='';
  FC1300.Ans:=''; FC1300.Buf:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Send data with CRLF delimeter to COM port.
 }
 procedure Com_Writeln(out:String);
 begin
  if Length(out)>0 then
  if ComSpace>Length(out)+2 then begin
   if ComWrite(out+CRLF)
   then ViewExp('COM: '+out)
   else Trouble('COM: '+out);
  end else begin
   Trouble('COM: FIFO OVERFLOW');
   b:=ComClear;
  end;
 end;
 {
 Read line from port with CR terminator and LF ignore.
 }
 function Com_Readln(var DataLine,TempBuff:String):Boolean;
 const MaxLeng = 1024;
 var i,p,L:Integer;
 begin
  DataLine:='';
  Com_Readln:=false;
  if ComCount>0 then begin
   L:=Length(TempBuff);
   p:=pos(chr(13),TempBuff);
   if p=0 then begin
    if L<MaxLeng then TempBuff:=TempBuff+ComRead(255);
    L:=Length(TempBuff);
   end;
   if L>0 then begin
    if p=0 then p:=Pos(chr(13),TempBuff);
    if p>0 then begin
     Com_Readln:=true;
     i:=1;
     while (i<p) and (TempBuff[i]=chr(10)) do i:=i+1;
     if i<p then DataLine:=Copy(TempBuff,i,p-i);
     i:=p+1;
     while i<=L do begin
      if TempBuff[i]=chr(10) then p:=i else i:=L;
      i:=i+1;
     end;
     TempBuff:=Copy(TempBuff,p+1);
    end else begin
     if Length(TempBuff)>=MaxLeng then begin
      Trouble('Received line is too long!');
      TempBuff:='';
     end;
    end;
   end;
  end;
 end;
 {
 Handle answer coming from FC1300
 +1: Answer received
  0: Waiting reply
 -1: Timeout found
 }
 function FC1300_Acquisition(Request:string; var Answer:string):Integer;
 begin
  FC1300_Acquisition:=0;
  if FC1300.Time=0 then begin
   Com_Writeln(Request);
   FC1300.Time:=msecnow;
  end else
  if msecnow>FC1300.Time+FC1300.TimeOut then begin
   Trouble('COM: TIMEOUT');
   FC1300_Acquisition:=-1;
   Com_Writeln('*RST');
   FC1300.Time:=0;
  end else
  if Com_Readln(FC1300.Ans,FC1300.Buf) then begin
   ViewExp('COM: '+FC1300.Ans);
   FC1300_Acquisition:=+1;
   Answer:=FC1300.Ans;
   FC1300.Time:=0;
  end;
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(Data:string);
 var cmd,arg:String; b:Boolean; tag:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  "@cmd=arg" or "@cmd args" commands:
  }
  cmd:='';
  arg:='';
  if Length(Data)>0 then
  if Data[1]='@' then begin
   cmd:=ExtractWord(1,Data);
   arg:=Copy(Data,Pos(cmd,Data)+Length(cmd)+1);
   {}
   if IsSameText(cmd,'@Help') then begin
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@DebugFlags') then begin
    if not IsNan(rVal(arg)) then DebugFlags:=Round(rVal(arg));
    Success(cmd+'='+Str(DebugFlags));
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@start') then begin
    FC1300.State:=1;
    FC1300.Time:=0;
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@stop') then begin
    FC1300.State:=0;
    FC1300.Time:=0;
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@loadsettings') then begin
    FC1300.State:=2;
    FC1300.Time:=0;
    Data:='';
   end;
   {}
   if IsSameText(cmd,'@checksettings') then begin
    FC1300.State:=3;
    FC1300.Time:=0;
    Data:='';
   end;
   {}
   if Length(Data)>0 then begin
    Trouble(' Unrecognized command "'+Data+'".');
    Data:='';
   end;
  end;
  cmd:='';
  arg:='';
 end;
begin
 {
 Initialization actions on Start
 }
 if runcount=1 then begin
  {
  Initialize errors...
  }
  errors:=0;
  errorcode:=registererr(devname);
  {
  Clear and initialize variables...
  }
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  OpenConsole(Val(ReadIni('OpenConsole')));
  Success('Start at '+GetDateTime(msecnow));
  {
  Initialize FC1300
  }
  FC1300.Time:=0;
  FC1300.State:=0;
  FC1300.TimeOut:=Val(ReadIni('FC1300TimeOut'));
  if FC1300.TimeOut=0 then FC1300.TimeOut:=1000;
  {
  Open Plot window
  }
  winPlot:=ReadIni('winPlot');
  if RefFind('Window '+winPlot)<>0 then begin
   b:=winShow(winPlot);
   b:=WinDraw(winPlot+'|Top=317|Left=0');
   b:=WinSelect(winPlot);
  end;
  {
  Open COM port
  }
  if not ComOpen(ReadIni('PortSection'))
  then Trouble('Could not open COM, stopped.')
  else b:=ComClear;
  b:=winshow(ParamStr('Console '+devname));
  {
  Is it Ok?
  }
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 {
 Finalization actions on Stop
 }
 if isinf(runcount) then begin
  Success('Stop.');
  ClearStrings;
 end else
 {
 Actions on Poll
 }
 if Ok then begin
  {
  Process standard input...
  }
  while StdIn_Readln(StdIn_Line) do StdIn_Process(StdIn_Line);
  {
  Autostart...
  }
  if RunCount=2 then begin
   b:=DevMsg(DevName+' @start'+CRLF)>0;
  end;
  {
  Data acquisition...
  }
  if FC1300.State=0 then begin
   while comcount>0 do s:=comread(255);
   s:='';
  end else
  if FC1300.State=1 then begin
   if FC1300_Acquisition(':READ?',s)=1 then b:=PutAo(0,time,rVal(s));
   s:='';
  end else
  if FC1300.State=2 then begin
   if FC1300_Acquisition('*RCL 1',s)=1 then; FC1300.State:=1;
   s:='';
  end else
  if FC1300.State=3 then begin
   if FC1300_Acquisition(':INP:IMP?',s)=1 then
   if s='+5.00000000E+01' then begin
    Success('Impedance configurate OK');
    FC1300.State:=4;
    s:='';
   end else
   if s='+1.00000000E+06' then begin
    Success('Impedance configurate NOT OK!');
    FC1300.State:=4;
    s:='';
   end;
  end else
  if FC1300.State=4 then begin
   if FC1300_Acquisition(':FREQ:ARM:STOP:TIM?',s)=1 then
   if s='+5.00000000E-01' then begin
    Success('Timer configurate OK');
    FC1300.State:=0;
    s:='';
   end else
   if (s='+1.00000000E-01')or(s='+1.00000000E+00')or(s='+1.00000000E+01') then begin
    Success('Timer configurate NOT OK!');
    FC1300.State:=0;
    s:='';
   end;
  end;
 end;
end.
