unit fmain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ActnList, uhistory;

type

  { TForm1 }

  TForm1 = class(TForm)
    actnUndo: TAction;
    actnRedo: TAction;
    actlMain: TActionList;
    bttnUndo: TButton;
    bttnRedo: TButton;
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure actnRedoExecute(Sender: TObject);
    procedure actnUndoExecute(Sender: TObject);   
    procedure actlMainUpdate(AAction: TBasicAction; var Handled: Boolean);
  private
    History: THistory;
  public

  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  History := THistory.Create(Memo1);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  History.Free;
end;

procedure TForm1.actnUndoExecute(Sender: TObject);
begin
  if History.CanUndo then History.Undo;
  Memo1.SetFocus;
end;

procedure TForm1.actnRedoExecute(Sender: TObject);
begin
  if History.CanRedo then History.Redo;
  Memo1.SetFocus;
end;
      
procedure TForm1.actlMainUpdate(AAction: TBasicAction; var Handled: Boolean);
begin
  actnUndo.Enabled := History.CanUndo;
  actnRedo.Enabled := History.CanRedo;
end;

end.

