////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2020-2023 Alexey Kuryakin kouriakine@mail.ru - LGPL license. //
////////////////////////////////////////////////////////////////////////////////

unit dpWindows; // Diesel Pascal Windows constants and functions.

interface

uses dpCmdArgs,dpSystem,dpSysUtils;

function ScreenHeight: Integer;
function ScreenWidth: Integer;
function ScreenDesktopTop: Integer;
function ScreenDesktopLeft: Integer;
function ScreenDesktopHeight: Integer;
function ScreenDesktopWidth: Integer;

const // GetSystemMetrics
  SM_CXSCREEN          = 0;
  SM_CYSCREEN          = 1;
  SM_CXVSCROLL         = 2;
  SM_CYHSCROLL         = 3;
  SM_CYCAPTION         = 4;
  SM_CXBORDER          = 5;
  SM_CYBORDER          = 6;
  SM_CXDLGFRAME        = 7;
  SM_CYDLGFRAME        = 8;
  SM_CYVTHUMB          = 9;
  SM_CXHTHUMB          = 10;
  SM_CXICON            = 11;
  SM_CYICON            = 12;
  SM_CXCURSOR          = 13;
  SM_CYCURSOR          = 14;
  SM_CYMENU            = 15;
  SM_CXFULLSCREEN      = $10;
  SM_CYFULLSCREEN      = 17;
  SM_CYKANJIWINDOW     = 18;
  SM_MOUSEPRESENT      = 19;
  SM_CYVSCROLL         = 20;
  SM_CXHSCROLL         = 21;
  SM_DEBUG             = 22;
  SM_SWAPBUTTON        = 23;
  SM_RESERVED1         = 24;
  SM_RESERVED2         = 25;
  SM_RESERVED3         = 26;
  SM_RESERVED4         = 27;
  SM_CXMIN             = 28;
  SM_CYMIN             = 29;
  SM_CXSIZE            = 30;
  SM_CYSIZE            = 31;
  SM_CXFRAME           = $20;
  SM_CYFRAME           = 33;
  SM_CXMINTRACK        = 34;
  SM_CYMINTRACK        = 35;
  SM_CXDOUBLECLK       = 36;
  SM_CYDOUBLECLK       = 37;
  SM_CXICONSPACING     = 38;
  SM_CYICONSPACING     = 39;
  SM_MENUDROPALIGNMENT = 40;
  SM_PENWINDOWS        = 41;
  SM_DBCSENABLED       = 42;
  SM_CMOUSEBUTTONS     = 43;
  SM_CXFIXEDFRAME      = SM_CXDLGFRAME; // win40 name change
  SM_CYFIXEDFRAME      = SM_CYDLGFRAME; // win40 name change
  SM_CXSIZEFRAME       = SM_CXFRAME;    // win40 name change
  SM_CYSIZEFRAME       = SM_CYFRAME;    // win40 name change
  SM_SECURE            = 44;
  SM_CXEDGE            = 45;
  SM_CYEDGE            = 46;
  SM_CXMINSPACING      = 47;
  SM_CYMINSPACING      = 48;
  SM_CXSMICON          = 49;
  SM_CYSMICON          = 50;
  SM_CYSMCAPTION       = 51;
  SM_CXSMSIZE          = 52;
  SM_CYSMSIZE          = 53;
  SM_CXMENUSIZE        = 54;
  SM_CYMENUSIZE        = 55;
  SM_ARRANGE           = 56;
  SM_CXMINIMIZED       = 57;
  SM_CYMINIMIZED       = 58;
  SM_CXMAXTRACK        = 59;
  SM_CYMAXTRACK        = 60;
  SM_CXMAXIMIZED       = 61;
  SM_CYMAXIMIZED       = 62;
  SM_NETWORK           = 63;
  SM_CLEANBOOT         = 67;
  SM_CXDRAG            = 68;
  SM_CYDRAG            = 69;
  SM_SHOWSOUNDS        = 70;
  SM_CXMENUCHECK       = 71;
  SM_CYMENUCHECK       = 72;
  SM_SLOWMACHINE       = 73;
  SM_MIDEASTENABLED    = 74;
  SM_MOUSEWHEELPRESENT = 75;
  SM_XVIRTUALSCREEN    = 76;
  SM_YVIRTUALSCREEN    = 77;
  SM_CXVIRTUALSCREEN   = 78;
  SM_CYVIRTUALSCREEN   = 79;
  SM_CMONITORS         = 80;
  SM_SAMEDISPLAYFORMAT = 81;
  SM_CMETRICS          = 83;

const // Window Messages
  WM_NULL              = $0000;
  WM_CREATE            = $0001;
  WM_DESTROY           = $0002;
  WM_MOVE              = $0003;
  WM_SIZE              = $0005;
  WM_ACTIVATE          = $0006;
  WM_SETFOCUS          = $0007;
  WM_KILLFOCUS         = $0008;
  WM_ENABLE            = $000A;
  WM_SETREDRAW         = $000B;
  WM_SETTEXT           = $000C;
  WM_GETTEXT           = $000D;
  WM_GETTEXTLENGTH     = $000E;
  WM_PAINT             = $000F;
  WM_CLOSE             = $0010;
  WM_QUERYENDSESSION   = $0011;
  WM_QUIT              = $0012;
  WM_QUERYOPEN         = $0013;
  WM_ERASEBKGND        = $0014;
  WM_SYSCOLORCHANGE    = $0015;
  WM_ENDSESSION        = $0016;
  WM_SYSTEMERROR       = $0017;
  WM_SHOWWINDOW        = $0018;
  WM_CTLCOLOR          = $0019;
  WM_WININICHANGE      = $001A;
  WM_SETTINGCHANGE     = WM_WININICHANGE;
  WM_DEVMODECHANGE     = $001B;
  WM_ACTIVATEAPP       = $001C;
  WM_FONTCHANGE        = $001D;
  WM_TIMECHANGE        = $001E;
  WM_CANCELMODE        = $001F;
  WM_SETCURSOR         = $0020;
  WM_MOUSEACTIVATE     = $0021;
  WM_CHILDACTIVATE     = $0022;
  WM_QUEUESYNC         = $0023;
  WM_GETMINMAXINFO     = $0024;
  WM_PAINTICON         = $0026;
  WM_ICONERASEBKGND    = $0027;
  WM_NEXTDLGCTL        = $0028;
  WM_SPOOLERSTATUS     = $002A;
  WM_DRAWITEM          = $002B;
  WM_MEASUREITEM       = $002C;
  WM_DELETEITEM        = $002D;
  WM_VKEYTOITEM        = $002E;
  WM_CHARTOITEM        = $002F;
  WM_SETFONT           = $0030;
  WM_GETFONT           = $0031;
  WM_SETHOTKEY         = $0032;
  WM_GETHOTKEY         = $0033;
  WM_QUERYDRAGICON     = $0037;
  WM_COMPAREITEM       = $0039;
  WM_GETOBJECT         = $003D;
  WM_COMPACTING        = $0041;
  WM_COMMNOTIFY        = $0044;    { obsolete in Win32}
  WM_WINDOWPOSCHANGING = $0046;
  WM_WINDOWPOSCHANGED  = $0047;
  WM_POWER             = $0048;
  WM_COPYDATA          = $004A;
  WM_CANCELJOURNAL     = $004B;
  WM_NOTIFY            = $004E;
  WM_INPUTLANGCHANGEREQUEST = $0050;
  WM_INPUTLANGCHANGE   = $0051;
  WM_TCARD             = $0052;
  WM_HELP              = $0053;
  WM_USERCHANGED       = $0054;
  WM_NOTIFYFORMAT      = $0055;
  WM_CONTEXTMENU       = $007B;
  WM_STYLECHANGING     = $007C;
  WM_STYLECHANGED      = $007D;
  WM_DISPLAYCHANGE     = $007E;
  WM_GETICON           = $007F;
  WM_SETICON           = $0080;
  WM_NCCREATE          = $0081;
  WM_NCDESTROY         = $0082;
  WM_NCCALCSIZE        = $0083;
  WM_NCHITTEST         = $0084;
  WM_NCPAINT           = $0085;
  WM_NCACTIVATE        = $0086;
  WM_GETDLGCODE        = $0087;
  WM_NCMOUSEMOVE       = $00A0;
  WM_NCLBUTTONDOWN     = $00A1;
  WM_NCLBUTTONUP       = $00A2;
  WM_NCLBUTTONDBLCLK   = $00A3;
  WM_NCRBUTTONDOWN     = $00A4;
  WM_NCRBUTTONUP       = $00A5;
  WM_NCRBUTTONDBLCLK   = $00A6;
  WM_NCMBUTTONDOWN     = $00A7;
  WM_NCMBUTTONUP       = $00A8;
  WM_NCMBUTTONDBLCLK   = $00A9;
  WM_KEYFIRST          = $0100;
  WM_KEYDOWN           = $0100;
  WM_KEYUP             = $0101;
  WM_CHAR              = $0102;
  WM_DEADCHAR          = $0103;
  WM_SYSKEYDOWN        = $0104;
  WM_SYSKEYUP          = $0105;
  WM_SYSCHAR           = $0106;
  WM_SYSDEADCHAR       = $0107;
  WM_KEYLAST           = $0108;
  WM_INITDIALOG        = $0110;
  WM_COMMAND           = $0111;
  WM_SYSCOMMAND        = $0112;
  WM_TIMER             = $0113;
  WM_HSCROLL           = $0114;
  WM_VSCROLL           = $0115;
  WM_INITMENU          = $0116;
  WM_INITMENUPOPUP     = $0117;
  WM_MENUSELECT        = $011F;
  WM_MENUCHAR          = $0120;
  WM_ENTERIDLE         = $0121;
  WM_MENURBUTTONUP     = $0122;
  WM_MENUDRAG          = $0123;
  WM_MENUGETOBJECT     = $0124;
  WM_UNINITMENUPOPUP   = $0125;
  WM_MENUCOMMAND       = $0126;
  WM_CHANGEUISTATE     = $0127;
  WM_UPDATEUISTATE     = $0128;
  WM_QUERYUISTATE      = $0129;
  WM_CTLCOLORMSGBOX    = $0132;
  WM_CTLCOLOREDIT      = $0133;
  WM_CTLCOLORLISTBOX   = $0134;
  WM_CTLCOLORBTN       = $0135;
  WM_CTLCOLORDLG       = $0136;
  WM_CTLCOLORSCROLLBAR = $0137;
  WM_CTLCOLORSTATIC    = $0138;
  WM_MOUSEFIRST        = $0200;
  WM_MOUSEMOVE         = $0200;
  WM_LBUTTONDOWN       = $0201;
  WM_LBUTTONUP         = $0202;
  WM_LBUTTONDBLCLK     = $0203;
  WM_RBUTTONDOWN       = $0204;
  WM_RBUTTONUP         = $0205;
  WM_RBUTTONDBLCLK     = $0206;
  WM_MBUTTONDOWN       = $0207;
  WM_MBUTTONUP         = $0208;
  WM_MBUTTONDBLCLK     = $0209;
  WM_MOUSEWHEEL        = $020A;
  WM_MOUSELAST         = $020A;
  WM_PARENTNOTIFY      = $0210;
  WM_ENTERMENULOOP     = $0211;
  WM_EXITMENULOOP      = $0212;
  WM_NEXTMENU          = $0213;
  WM_SIZING            = 532;
  WM_CAPTURECHANGED    = 533;
  WM_MOVING            = 534;
  WM_POWERBROADCAST    = 536;
  WM_DEVICECHANGE      = 537;
  WM_IME_STARTCOMPOSITION = $010D;
  WM_IME_ENDCOMPOSITION   = $010E;
  WM_IME_COMPOSITION      = $010F;
  WM_IME_KEYLAST          = $010F;
  WM_IME_SETCONTEXT       = $0281;
  WM_IME_NOTIFY           = $0282;
  WM_IME_CONTROL          = $0283;
  WM_IME_COMPOSITIONFULL  = $0284;
  WM_IME_SELECT           = $0285;
  WM_IME_CHAR             = $0286;
  WM_IME_REQUEST          = $0288;
  WM_IME_KEYDOWN          = $0290;
  WM_IME_KEYUP            = $0291;
  WM_MDICREATE         = $0220;
  WM_MDIDESTROY        = $0221;
  WM_MDIACTIVATE       = $0222;
  WM_MDIRESTORE        = $0223;
  WM_MDINEXT           = $0224;
  WM_MDIMAXIMIZE       = $0225;
  WM_MDITILE           = $0226;
  WM_MDICASCADE        = $0227;
  WM_MDIICONARRANGE    = $0228;
  WM_MDIGETACTIVE      = $0229;
  WM_MDISETMENU        = $0230;
  WM_ENTERSIZEMOVE     = $0231;
  WM_EXITSIZEMOVE      = $0232;
  WM_DROPFILES         = $0233;
  WM_MDIREFRESHMENU    = $0234;
  WM_MOUSEHOVER        = $02A1;
  WM_MOUSELEAVE        = $02A3;
  WM_CUT               = $0300;
  WM_COPY              = $0301;
  WM_PASTE             = $0302;
  WM_CLEAR             = $0303;
  WM_UNDO              = $0304;
  WM_RENDERFORMAT      = $0305;
  WM_RENDERALLFORMATS  = $0306;
  WM_DESTROYCLIPBOARD  = $0307;
  WM_DRAWCLIPBOARD     = $0308;
  WM_PAINTCLIPBOARD    = $0309;
  WM_VSCROLLCLIPBOARD  = $030A;
  WM_SIZECLIPBOARD     = $030B;
  WM_ASKCBFORMATNAME   = $030C;
  WM_CHANGECBCHAIN     = $030D;
  WM_HSCROLLCLIPBOARD  = $030E;
  WM_QUERYNEWPALETTE   = $030F;
  WM_PALETTEISCHANGING = $0310;
  WM_PALETTECHANGED    = $0311;
  WM_HOTKEY            = $0312;
  WM_PRINT             = 791;
  WM_PRINTCLIENT       = 792;
  WM_HANDHELDFIRST     = 856;
  WM_HANDHELDLAST      = 863;
  WM_PENWINFIRST       = $0380;
  WM_PENWINLAST        = $038F;
  WM_COALESCE_FIRST    = $0390;
  WM_COALESCE_LAST     = $039F;
  WM_DDE_FIRST         = $03E0;
  WM_DDE_INITIATE      = WM_DDE_FIRST + 0;
  WM_DDE_TERMINATE     = WM_DDE_FIRST + 1;
  WM_DDE_ADVISE        = WM_DDE_FIRST + 2;
  WM_DDE_UNADVISE      = WM_DDE_FIRST + 3;
  WM_DDE_ACK           = WM_DDE_FIRST + 4;
  WM_DDE_DATA          = WM_DDE_FIRST + 5;
  WM_DDE_REQUEST       = WM_DDE_FIRST + 6;
  WM_DDE_POKE          = WM_DDE_FIRST + 7;
  WM_DDE_EXECUTE       = WM_DDE_FIRST + 8;
  WM_DDE_LAST          = WM_DDE_FIRST + 8;
  WM_APP               = $8000;
  WM_USER              = $0400;

const // winerror.h values
  NO_ERROR = 0;
  ERROR_SUCCESS = 0;
  SEC_E_OK = $00000000;
  ERROR_INVALID_FUNCTION = 1;
  ERROR_FILE_NOT_FOUND = 2;
  ERROR_PATH_NOT_FOUND = 3;
  ERROR_TOO_MANY_OPEN_FILES = 4;
  ERROR_ACCESS_DENIED = 5;
  ERROR_INVALID_HANDLE = 6;
  ERROR_ARENA_TRASHED = 7;
  ERROR_NOT_ENOUGH_MEMORY = 8;
  ERROR_INVALID_BLOCK = 9;
  ERROR_BAD_ENVIRONMENT = 10;
  ERROR_BAD_FORMAT = 11;
  ERROR_INVALID_ACCESS = 12;
  ERROR_INVALID_DATA = 13;
  ERROR_OUTOFMEMORY = 14;
  ERROR_INVALID_DRIVE = 15;
  ERROR_CURRENT_DIRECTORY = 16;
  ERROR_NOT_SAME_DEVICE = 17;
  ERROR_NO_MORE_FILES = 18;
  ERROR_WRITE_PROTECT = 19;
  ERROR_BAD_UNIT = 20;
  ERROR_NOT_READY = 21;
  ERROR_BAD_COMMAND = 22;
  ERROR_CRC = 23;
  ERROR_BAD_LENGTH = 24;
  ERROR_SEEK = 25;
  ERROR_NOT_DOS_DISK = 26;
  ERROR_SECTOR_NOT_FOUND = 27;
  ERROR_OUT_OF_PAPER = 28;
  ERROR_WRITE_FAULT = 29;
  ERROR_READ_FAULT = 30;
  ERROR_GEN_FAILURE = 31;
  ERROR_SHARING_VIOLATION = 32;
  ERROR_LOCK_VIOLATION = 33;
  ERROR_WRONG_DISK = 34;
  ERROR_SHARING_BUFFER_EXCEEDED = 36;
  ERROR_HANDLE_EOF = 38;
  ERROR_HANDLE_DISK_FULL = 39;
  ERROR_NOT_SUPPORTED = 50;
  ERROR_REM_NOT_LIST = 51;
  ERROR_DUP_NAME = 52;
  ERROR_BAD_NETPATH = 53;
  ERROR_NETWORK_BUSY = 54;
  ERROR_DEV_NOT_EXIST = 55;
  ERROR_TOO_MANY_CMDS = 56;
  ERROR_ADAP_HDW_ERR = 57;
  ERROR_BAD_NET_RESP = 58;
  ERROR_UNEXP_NET_ERR = 59;
  ERROR_BAD_REM_ADAP = 60;
  ERROR_PRINTQ_FULL = 61;
  ERROR_NO_SPOOL_SPACE = 62;
  ERROR_PRINT_CANCELLED = 63;
  ERROR_NETNAME_DELETED = 64;
  ERROR_NETWORK_ACCESS_DENIED = 65;
  ERROR_BAD_DEV_TYPE = 66;
  ERROR_BAD_NET_NAME = 67;
  ERROR_TOO_MANY_NAMES = 68;
  ERROR_TOO_MANY_SESS = 69;
  ERROR_SHARING_PAUSED = 70;
  ERROR_REQ_NOT_ACCEP = 71;
  ERROR_REDIR_PAUSED = 72;
  ERROR_FILE_EXISTS = 80;
  ERROR_CANNOT_MAKE = 82;
  ERROR_FAIL_I24 = 83;
  ERROR_OUT_OF_STRUCTURES = 84;
  ERROR_ALREADY_ASSIGNED = 85;
  ERROR_INVALID_PASSWORD = 86;
  ERROR_INVALID_PARAMETER = 87;
  ERROR_NET_WRITE_FAULT = 88;
  ERROR_NO_PROC_SLOTS = 89;
  ERROR_TOO_MANY_SEMAPHORES = 100;
  ERROR_EXCL_SEM_ALREADY_OWNED = 101;
  ERROR_SEM_IS_SET = 102;
  ERROR_TOO_MANY_SEM_REQUESTS = 103;
  ERROR_INVALID_AT_INTERRUPT_TIME = 104;
  ERROR_SEM_OWNER_DIED = 105;
  ERROR_SEM_USER_LIMIT = 106;
  ERROR_DISK_CHANGE = 107;
  ERROR_DRIVE_LOCKED = 108;
  ERROR_BROKEN_PIPE = 109;
  ERROR_OPEN_FAILED = 110;
  ERROR_BUFFER_OVERFLOW = 111;
  ERROR_DISK_FULL = 112;
  ERROR_NO_MORE_SEARCH_HANDLES = 113;
  ERROR_INVALID_TARGET_HANDLE = 114;
  ERROR_INVALID_CATEGORY = 117;
  ERROR_INVALID_VERIFY_SWITCH = 118;
  ERROR_BAD_DRIVER_LEVEL = 119;
  ERROR_CALL_NOT_IMPLEMENTED = 120;
  ERROR_SEM_TIMEOUT = 121;
  ERROR_INSUFFICIENT_BUFFER = 122;
  ERROR_INVALID_NAME = 123;
  ERROR_INVALID_LEVEL = 124;
  ERROR_NO_VOLUME_LABEL = 125;
  ERROR_MOD_NOT_FOUND = 126;
  ERROR_PROC_NOT_FOUND = 127;
  ERROR_WAIT_NO_CHILDREN = 128;
  ERROR_CHILD_NOT_COMPLETE = 129;
  ERROR_DIRECT_ACCESS_HANDLE = 130;
  ERROR_NEGATIVE_SEEK = 131;
  ERROR_SEEK_ON_DEVICE = 132;
  ERROR_IS_JOIN_TARGET = 133;
  ERROR_IS_JOINED = 134;
  ERROR_IS_SUBSTED = 135;
  ERROR_NOT_JOINED = 136;
  ERROR_NOT_SUBSTED = 137;
  ERROR_JOIN_TO_JOIN = 138;
  ERROR_SUBST_TO_SUBST = 139;
  ERROR_JOIN_TO_SUBST = 140;
  ERROR_SUBST_TO_JOIN = 141;
  ERROR_BUSY_DRIVE = 142;
  ERROR_SAME_DRIVE = 143;
  ERROR_DIR_NOT_ROOT = 144;
  ERROR_DIR_NOT_EMPTY = 145;
  ERROR_IS_SUBST_PATH = 146;
  ERROR_IS_JOIN_PATH = 147;
  ERROR_PATH_BUSY = 148;
  ERROR_IS_SUBST_TARGET = 149;
  ERROR_SYSTEM_TRACE = 150;
  ERROR_INVALID_EVENT_COUNT = 151;
  ERROR_TOO_MANY_MUXWAITERS = 152;
  ERROR_INVALID_LIST_FORMAT = 153;
  ERROR_LABEL_TOO_LONG = 154;
  ERROR_TOO_MANY_TCBS = 155;
  ERROR_SIGNAL_REFUSED = 156;
  ERROR_DISCARDED = 157;
  ERROR_NOT_LOCKED = 158;
  ERROR_BAD_THREADID_ADDR = 159;
  ERROR_BAD_ARGUMENTS = 160;
  ERROR_BAD_PATHNAME = 161;
  ERROR_SIGNAL_PENDING = 162;
  ERROR_MAX_THRDS_REACHED = 164;
  ERROR_LOCK_FAILED = 167;
  ERROR_BUSY = 170;
  ERROR_CANCEL_VIOLATION = 173;
  ERROR_ATOMIC_LOCKS_NOT_SUPPORTED = 174;
  ERROR_INVALID_SEGMENT_NUMBER = 180;
  ERROR_INVALID_ORDINAL = 182;
  ERROR_ALREADY_EXISTS = 183;
  ERROR_INVALID_FLAG_NUMBER = 186;
  ERROR_SEM_NOT_FOUND = 187;
  ERROR_INVALID_STARTING_CODESEG = 188;
  ERROR_INVALID_STACKSEG = 189;
  ERROR_INVALID_MODULETYPE = 190;
  ERROR_INVALID_EXE_SIGNATURE = 191;
  ERROR_EXE_MARKED_INVALID = 192;
  ERROR_BAD_EXE_FORMAT = 193;
  ERROR_ITERATED_DATA_EXCEEDS_64k = 194;
  ERROR_INVALID_MINALLOCSIZE = 195;
  ERROR_DYNLINK_FROM_INVALID_RING = 196;
  ERROR_IOPL_NOT_ENABLED = 197;
  ERROR_INVALID_SEGDPL = 198;
  ERROR_AUTODATASEG_EXCEEDS_64k = 199;
  ERROR_RING2SEG_MUST_BE_MOVABLE = 200;
  ERROR_RELOC_CHAIN_XEEDS_SEGLIM = 201;
  ERROR_INFLOOP_IN_RELOC_CHAIN = 202;
  ERROR_ENVVAR_NOT_FOUND = 203;
  ERROR_NO_SIGNAL_SENT = 205;
  ERROR_FILENAME_EXCED_RANGE = 206;
  ERROR_RING2_STACK_IN_USE = 207;
  ERROR_META_EXPANSION_TOO_LONG = 208;
  ERROR_INVALID_SIGNAL_NUMBER = 209;
  ERROR_THREAD_1_INACTIVE = 210;
  ERROR_LOCKED = 212;
  ERROR_TOO_MANY_MODULES = 214;
  ERROR_NESTING_NOT_ALLOWED = 215;
  ERROR_EXE_MACHINE_TYPE_MISMATCH = 216;
  ERROR_EXE_CANNOT_MODIFY_SIGNED_BINARY = 217;
  ERROR_EXE_CANNOT_MODIFY_STRONG_SIGNED_BINARY = 218;
  ERROR_BAD_PIPE = 230;
  ERROR_PIPE_BUSY = 231;
  ERROR_NO_DATA = 232;
  ERROR_PIPE_NOT_CONNECTED = 233;
  ERROR_MORE_DATA = 234;
  ERROR_VC_DISCONNECTED = 240;
  ERROR_INVALID_EA_NAME = 254;
  ERROR_EA_LIST_INCONSISTENT = 255;
  WAIT_TIMEOUT = 258;
  ERROR_NO_MORE_ITEMS = 259;
  ERROR_CANNOT_COPY = 266;
  ERROR_DIRECTORY = 267;
  ERROR_EAS_DIDNT_FIT = 275;
  ERROR_EA_FILE_CORRUPT = 276;
  ERROR_EA_TABLE_FULL = 277;
  ERROR_INVALID_EA_HANDLE = 278;
  ERROR_EAS_NOT_SUPPORTED = 282;
  ERROR_NOT_OWNER = 288;
  ERROR_TOO_MANY_POSTS = 298;
  ERROR_PARTIAL_COPY = 299;
  ERROR_OPLOCK_NOT_GRANTED = 300;
  ERROR_INVALID_OPLOCK_PROTOCOL = 301;
  ERROR_DISK_TOO_FRAGMENTED = 302;
  ERROR_DELETE_PENDING = 303;
  ERROR_MR_MID_NOT_FOUND = 317;
  ERROR_SCOPE_NOT_FOUND = 318;
  ERROR_INVALID_ADDRESS = 487;
  ERROR_ARITHMETIC_OVERFLOW = 534;
  ERROR_PIPE_CONNECTED = 535;
  ERROR_PIPE_LISTENING = 536;
  ERROR_EA_ACCESS_DENIED = 994;
  ERROR_OPERATION_ABORTED = 995;
  ERROR_IO_INCOMPLETE = 996;
  ERROR_IO_PENDING = 997;
  ERROR_NOACCESS = 998;
  ERROR_SWAPERROR = 999;
  ERROR_STACK_OVERFLOW = 1001;
  ERROR_INVALID_MESSAGE = 1002;
  ERROR_CAN_NOT_COMPLETE = 1003;
  ERROR_INVALID_FLAGS = 1004;
  ERROR_UNRECOGNIZED_VOLUME = 1005;
  ERROR_FILE_INVALID = 1006;
  ERROR_FULLSCREEN_MODE = 1007;
  ERROR_NO_TOKEN = 1008;
  ERROR_BADDB = 1009;
  ERROR_BADKEY = 1010;
  ERROR_CANTOPEN = 1011;
  ERROR_CANTREAD = 1012;
  ERROR_CANTWRITE = 1013;
  ERROR_REGISTRY_RECOVERED = 1014;
  ERROR_REGISTRY_CORRUPT = 1015;
  ERROR_REGISTRY_IO_FAILED = 1016;
  ERROR_NOT_REGISTRY_FILE = 1017;
  ERROR_KEY_DELETED = 1018;
  ERROR_NO_LOG_SPACE = 1019;
  ERROR_KEY_HAS_CHILDREN = 1020;
  ERROR_CHILD_MUST_BE_VOLATILE = 1021;
  ERROR_NOTIFY_ENUM_DIR = 1022;
  ERROR_DEPENDENT_SERVICES_RUNNING = 1051;
  ERROR_INVALID_SERVICE_CONTROL = 1052;
  ERROR_SERVICE_REQUEST_TIMEOUT = 1053;
  ERROR_SERVICE_NO_THREAD = 1054;
  ERROR_SERVICE_DATABASE_LOCKED = 1055;
  ERROR_SERVICE_ALREADY_RUNNING = 1056;
  ERROR_INVALID_SERVICE_ACCOUNT = 1057;
  ERROR_SERVICE_DISABLED = 1058;
  ERROR_CIRCULAR_DEPENDENCY = 1059;
  ERROR_SERVICE_DOES_NOT_EXIST = 1060;
  ERROR_SERVICE_CANNOT_ACCEPT_CTRL = 1061;
  ERROR_SERVICE_NOT_ACTIVE = 1062;
  ERROR_FAILED_SERVICE_CONTROLLER_CONNECT = 1063;
  ERROR_EXCEPTION_IN_SERVICE = 1064;
  ERROR_DATABASE_DOES_NOT_EXIST = 1065;
  ERROR_SERVICE_SPECIFIC_ERROR = 1066;
  ERROR_PROCESS_ABORTED = 1067;
  ERROR_SERVICE_DEPENDENCY_FAIL = 1068;
  ERROR_SERVICE_LOGON_FAILED = 1069;
  ERROR_SERVICE_START_HANG = 1070;
  ERROR_INVALID_SERVICE_LOCK = 1071;
  ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
  ERROR_SERVICE_EXISTS = 1073;
  ERROR_ALREADY_RUNNING_LKG = 1074;
  ERROR_SERVICE_DEPENDENCY_DELETED = 1075;
  ERROR_BOOT_ALREADY_ACCEPTED = 1076;
  ERROR_SERVICE_NEVER_STARTED = 1077;
  ERROR_DUPLICATE_SERVICE_NAME = 1078;
  ERROR_DIFFERENT_SERVICE_ACCOUNT = 1079;
  ERROR_CANNOT_DETECT_DRIVER_FAILURE = 1080;
  ERROR_CANNOT_DETECT_PROCESS_ABORT = 1081;
  ERROR_NO_RECOVERY_PROGRAM = 1082;
  ERROR_SERVICE_NOT_IN_EXE = 1083;
  ERROR_NOT_SAFEBOOT_SERVICE = 1084;
  ERROR_END_OF_MEDIA = 1100;
  ERROR_FILEMARK_DETECTED = 1101;
  ERROR_BEGINNING_OF_MEDIA = 1102;
  ERROR_SETMARK_DETECTED = 1103;
  ERROR_NO_DATA_DETECTED = 1104;
  ERROR_PARTITION_FAILURE = 1105;
  ERROR_INVALID_BLOCK_LENGTH = 1106;
  ERROR_DEVICE_NOT_PARTITIONED = 1107;
  ERROR_UNABLE_TO_LOCK_MEDIA = 1108;
  ERROR_UNABLE_TO_UNLOAD_MEDIA = 1109;
  ERROR_MEDIA_CHANGED = 1110;
  ERROR_BUS_RESET = 1111;
  ERROR_NO_MEDIA_IN_DRIVE = 1112;
  ERROR_NO_UNICODE_TRANSLATION = 1113;
  ERROR_DLL_INIT_FAILED = 1114;
  ERROR_SHUTDOWN_IN_PROGRESS = 1115;
  ERROR_NO_SHUTDOWN_IN_PROGRESS = 1116;
  ERROR_IO_DEVICE = 1117;
  ERROR_SERIAL_NO_DEVICE = 1118;
  ERROR_IRQ_BUSY = 1119;
  ERROR_MORE_WRITES = 1120;
  ERROR_COUNTER_TIMEOUT = 1121;
  ERROR_FLOPPY_ID_MARK_NOT_FOUND = 1122;
  ERROR_FLOPPY_WRONG_CYLINDER = 1123;
  ERROR_FLOPPY_UNKNOWN_ERROR = 1124;
  ERROR_FLOPPY_BAD_REGISTERS = 1125;
  ERROR_DISK_RECALIBRATE_FAILED = 1126;
  ERROR_DISK_OPERATION_FAILED = 1127;
  ERROR_DISK_RESET_FAILED = 1128;
  ERROR_EOM_OVERFLOW = 1129;
  ERROR_NOT_ENOUGH_SERVER_MEMORY = 1130;
  ERROR_POSSIBLE_DEADLOCK = 1131;
  ERROR_MAPPED_ALIGNMENT = 1132;
  ERROR_SET_POWER_STATE_VETOED = 1140;
  ERROR_SET_POWER_STATE_FAILED = 1141;
  ERROR_TOO_MANY_LINKS = 1142;
  ERROR_OLD_WIN_VERSION = 1150;
  ERROR_APP_WRONG_OS = 1151;
  ERROR_SINGLE_INSTANCE_APP = 1152;
  ERROR_RMODE_APP = 1153;
  ERROR_INVALID_DLL = 1154;
  ERROR_NO_ASSOCIATION = 1155;
  ERROR_DDE_FAIL = 1156;
  ERROR_DLL_NOT_FOUND = 1157;
  ERROR_NO_MORE_USER_HANDLES = 1158;
  ERROR_MESSAGE_SYNC_ONLY = 1159;
  ERROR_SOURCE_ELEMENT_EMPTY = 1160;
  ERROR_DESTINATION_ELEMENT_FULL = 1161;
  ERROR_ILLEGAL_ELEMENT_ADDRESS = 1162;
  ERROR_MAGAZINE_NOT_PRESENT = 1163;
  ERROR_DEVICE_REINITIALIZATION_NEEDED = 1164;
  ERROR_DEVICE_REQUIRES_CLEANING = 1165;
  ERROR_DEVICE_DOOR_OPEN = 1166;
  ERROR_DEVICE_NOT_CONNECTED = 1167;
  ERROR_NOT_FOUND = 1168;
  ERROR_NO_MATCH = 1169;
  ERROR_SET_NOT_FOUND = 1170;
  ERROR_POINT_NOT_FOUND = 1171;
  ERROR_NO_TRACKING_SERVICE = 1172;
  ERROR_NO_VOLUME_ID = 1173;
  ERROR_UNABLE_TO_REMOVE_REPLACED = 1175;
  ERROR_UNABLE_TO_MOVE_REPLACEMENT = 1176;
  ERROR_UNABLE_TO_MOVE_REPLACEMENT_2 = 1177;
  ERROR_JOURNAL_DELETE_IN_PROGRESS = 1178;
  ERROR_JOURNAL_NOT_ACTIVE = 1179;
  ERROR_POTENTIAL_FILE_FOUND = 1180;
  ERROR_JOURNAL_ENTRY_DELETED = 1181;
  ERROR_BAD_DEVICE = 1200;
  ERROR_CONNECTION_UNAVAIL = 1201;
  ERROR_DEVICE_ALREADY_REMEMBERED = 1202;
  ERROR_NO_NET_OR_BAD_PATH = 1203;
  ERROR_BAD_PROVIDER = 1204;
  ERROR_CANNOT_OPEN_PROFILE = 1205;
  ERROR_BAD_PROFILE = 1206;
  ERROR_NOT_CONTAINER = 1207;
  ERROR_EXTENDED_ERROR = 1208;
  ERROR_INVALID_GROUPNAME = 1209;
  ERROR_INVALID_COMPUTERNAME = 1210;
  ERROR_INVALID_EVENTNAME = 1211;
  ERROR_INVALID_DOMAINNAME = 1212;
  ERROR_INVALID_SERVICENAME = 1213;
  ERROR_INVALID_NETNAME = 1214;
  ERROR_INVALID_SHARENAME = 1215;
  ERROR_INVALID_PASSWORDNAME = 1216;
  ERROR_INVALID_MESSAGENAME = 1217;
  ERROR_INVALID_MESSAGEDEST = 1218;
  ERROR_SESSION_CREDENTIAL_CONFLICT = 1219;
  ERROR_REMOTE_SESSION_LIMIT_EXCEEDED = 1220;
  ERROR_DUP_DOMAINNAME = 1221;
  ERROR_NO_NETWORK = 1222;
  ERROR_CANCELLED = 1223;
  ERROR_USER_MAPPED_FILE = 1224;
  ERROR_CONNECTION_REFUSED = 1225;
  ERROR_GRACEFUL_DISCONNECT = 1226;
  ERROR_ADDRESS_ALREADY_ASSOCIATED = 1227;
  ERROR_ADDRESS_NOT_ASSOCIATED = 1228;
  ERROR_CONNECTION_INVALID = 1229;
  ERROR_CONNECTION_ACTIVE = 1230;
  ERROR_NETWORK_UNREACHABLE = 1231;
  ERROR_HOST_UNREACHABLE = 1232;
  ERROR_PROTOCOL_UNREACHABLE = 1233;
  ERROR_PORT_UNREACHABLE = 1234;
  ERROR_REQUEST_ABORTED = 1235;
  ERROR_CONNECTION_ABORTED = 1236;
  ERROR_RETRY = 1237;
  ERROR_CONNECTION_COUNT_LIMIT = 1238;
  ERROR_LOGIN_TIME_RESTRICTION = 1239;
  ERROR_LOGIN_WKSTA_RESTRICTION = 1240;
  ERROR_INCORRECT_ADDRESS = 1241;
  ERROR_ALREADY_REGISTERED = 1242;
  ERROR_SERVICE_NOT_FOUND = 1243;
  ERROR_NOT_AUTHENTICATED = 1244;
  ERROR_NOT_LOGGED_ON = 1245;
  ERROR_CONTINUE = 1246;
  ERROR_ALREADY_INITIALIZED = 1247;
  ERROR_NO_MORE_DEVICES = 1248;
  ERROR_NO_SUCH_SITE = 1249;
  ERROR_DOMAIN_CONTROLLER_EXISTS = 1250;
  ERROR_ONLY_IF_CONNECTED = 1251;
  ERROR_OVERRIDE_NOCHANGES = 1252;
  ERROR_BAD_USER_PROFILE = 1253;
  ERROR_NOT_SUPPORTED_ON_SBS = 1254;
  ERROR_SERVER_SHUTDOWN_IN_PROGRESS = 1255;
  ERROR_HOST_DOWN = 1256;
  ERROR_NON_ACCOUNT_SID = 1257;
  ERROR_NON_DOMAIN_SID = 1258;
  ERROR_APPHELP_BLOCK = 1259;
  ERROR_ACCESS_DISABLED_BY_POLICY = 1260;
  ERROR_REG_NAT_CONSUMPTION = 1261;
  ERROR_CSCSHARE_OFFLINE = 1262;
  ERROR_PKINIT_FAILURE = 1263;
  ERROR_SMARTCARD_SUBSYSTEM_FAILURE = 1264;
  ERROR_DOWNGRADE_DETECTED = 1265;
  ERROR_MACHINE_LOCKED = 1271;
  ERROR_CALLBACK_SUPPLIED_INVALID_DATA = 1273;
  ERROR_SYNC_FOREGROUND_REFRESH_REQUIRED = 1274;
  ERROR_DRIVER_BLOCKED = 1275;
  ERROR_INVALID_IMPORT_OF_NON_DLL = 1276;
  ERROR_ACCESS_DISABLED_WEBBLADE = 1277;
  ERROR_ACCESS_DISABLED_WEBBLADE_TAMPER = 1278;
  ERROR_RECOVERY_FAILURE = 1279;
  ERROR_ALREADY_FIBER = 1280;
  ERROR_ALREADY_THREAD = 1281;
  ERROR_STACK_BUFFER_OVERRUN = 1282;
  ERROR_PARAMETER_QUOTA_EXCEEDED = 1283;
  ERROR_DEBUGGER_INACTIVE = 1284;
  ERROR_DELAY_LOAD_FAILED = 1285;
  ERROR_VDM_DISALLOWED = 1286;
  ERROR_UNIDENTIFIED_ERROR = 1287;
  ERROR_NOT_ALL_ASSIGNED = 1300;
  ERROR_SOME_NOT_MAPPED = 1301;
  ERROR_NO_QUOTAS_FOR_ACCOUNT = 1302;
  ERROR_LOCAL_USER_SESSION_KEY = 1303;
  ERROR_NULL_LM_PASSWORD = 1304;
  ERROR_UNKNOWN_REVISION = 1305;
  ERROR_REVISION_MISMATCH = 1306;
  ERROR_INVALID_OWNER = 1307;
  ERROR_INVALID_PRIMARY_GROUP = 1308;
  ERROR_NO_IMPERSONATION_TOKEN = 1309;
  ERROR_CANT_DISABLE_MANDATORY = 1310;
  ERROR_NO_LOGON_SERVERS = 1311;
  ERROR_NO_SUCH_LOGON_SESSION = 1312;
  ERROR_NO_SUCH_PRIVILEGE = 1313;
  ERROR_PRIVILEGE_NOT_HELD = 1314;
  ERROR_INVALID_ACCOUNT_NAME = 1315;
  ERROR_USER_EXISTS = 1316;
  ERROR_NO_SUCH_USER = 1317;
  ERROR_GROUP_EXISTS = 1318;
  ERROR_NO_SUCH_GROUP = 1319;
  ERROR_MEMBER_IN_GROUP = 1320;
  ERROR_MEMBER_NOT_IN_GROUP = 1321;
  ERROR_LAST_ADMIN = 1322;
  ERROR_WRONG_PASSWORD = 1323;
  ERROR_ILL_FORMED_PASSWORD = 1324;
  ERROR_PASSWORD_RESTRICTION = 1325;
  ERROR_LOGON_FAILURE = 1326;
  ERROR_ACCOUNT_RESTRICTION = 1327;
  ERROR_INVALID_LOGON_HOURS = 1328;
  ERROR_INVALID_WORKSTATION = 1329;
  ERROR_PASSWORD_EXPIRED = 1330;
  ERROR_ACCOUNT_DISABLED = 1331;
  ERROR_NONE_MAPPED = 1332;
  ERROR_TOO_MANY_LUIDS_REQUESTED = 1333;
  ERROR_LUIDS_EXHAUSTED = 1334;
  ERROR_INVALID_SUB_AUTHORITY = 1335;
  ERROR_INVALID_ACL = 1336;
  ERROR_INVALID_SID = 1337;
  ERROR_INVALID_SECURITY_DESCR = 1338;
  ERROR_BAD_INHERITANCE_ACL = 1340;
  ERROR_SERVER_DISABLED = 1341;
  ERROR_SERVER_NOT_DISABLED = 1342;
  ERROR_INVALID_ID_AUTHORITY = 1343;
  ERROR_ALLOTTED_SPACE_EXCEEDED = 1344;
  ERROR_INVALID_GROUP_ATTRIBUTES = 1345;
  ERROR_BAD_IMPERSONATION_LEVEL = 1346;
  ERROR_CANT_OPEN_ANONYMOUS = 1347;
  ERROR_BAD_VALIDATION_CLASS = 1348;
  ERROR_BAD_TOKEN_TYPE = 1349;
  ERROR_NO_SECURITY_ON_OBJECT = 1350;
  ERROR_CANT_ACCESS_DOMAIN_INFO = 1351;
  ERROR_INVALID_SERVER_STATE = 1352;
  ERROR_INVALID_DOMAIN_STATE = 1353;
  ERROR_INVALID_DOMAIN_ROLE = 1354;
  ERROR_NO_SUCH_DOMAIN = 1355;
  ERROR_DOMAIN_EXISTS = 1356;
  ERROR_DOMAIN_LIMIT_EXCEEDED = 1357;
  ERROR_INTERNAL_DB_CORRUPTION = 1358;
  ERROR_INTERNAL_ERROR = 1359;
  ERROR_GENERIC_NOT_MAPPED = 1360;
  ERROR_BAD_DESCRIPTOR_FORMAT = 1361;
  ERROR_NOT_LOGON_PROCESS = 1362;
  ERROR_LOGON_SESSION_EXISTS = 1363;
  ERROR_NO_SUCH_PACKAGE = 1364;
  ERROR_BAD_LOGON_SESSION_STATE = 1365;
  ERROR_LOGON_SESSION_COLLISION = 1366;
  ERROR_INVALID_LOGON_TYPE = 1367;
  ERROR_CANNOT_IMPERSONATE = 1368;
  ERROR_RXACT_INVALID_STATE = 1369;
  ERROR_RXACT_COMMIT_FAILURE = 1370;
  ERROR_SPECIAL_ACCOUNT = 1371;
  ERROR_SPECIAL_GROUP = 1372;
  ERROR_SPECIAL_USER = 1373;
  ERROR_MEMBERS_PRIMARY_GROUP = 1374;
  ERROR_TOKEN_ALREADY_IN_USE = 1375;
  ERROR_NO_SUCH_ALIAS = 1376;
  ERROR_MEMBER_NOT_IN_ALIAS = 1377;
  ERROR_MEMBER_IN_ALIAS = 1378;
  ERROR_ALIAS_EXISTS = 1379;
  ERROR_LOGON_NOT_GRANTED = 1380;
  ERROR_TOO_MANY_SECRETS = 1381;
  ERROR_SECRET_TOO_LONG = 1382;
  ERROR_INTERNAL_DB_ERROR = 1383;
  ERROR_TOO_MANY_CONTEXT_IDS = 1384;
  ERROR_LOGON_TYPE_NOT_GRANTED = 1385;
  ERROR_NT_CROSS_ENCRYPTION_REQUIRED = 1386;
  ERROR_NO_SUCH_MEMBER = 1387;
  ERROR_INVALID_MEMBER = 1388;
  ERROR_TOO_MANY_SIDS = 1389;
  ERROR_LM_CROSS_ENCRYPTION_REQUIRED = 1390;
  ERROR_NO_INHERITANCE = 1391;
  ERROR_FILE_CORRUPT = 1392;
  ERROR_DISK_CORRUPT = 1393;
  ERROR_NO_USER_SESSION_KEY = 1394;
  ERROR_LICENSE_QUOTA_EXCEEDED = 1395;
  ERROR_WRONG_TARGET_NAME = 1396;
  ERROR_MUTUAL_AUTH_FAILED = 1397;
  ERROR_TIME_SKEW = 1398;
  ERROR_CURRENT_DOMAIN_NOT_ALLOWED = 1399;
  ERROR_INVALID_WINDOW_HANDLE = 1400;
  ERROR_INVALID_MENU_HANDLE = 1401;
  ERROR_INVALID_CURSOR_HANDLE = 1402;
  ERROR_INVALID_ACCEL_HANDLE = 1403;
  ERROR_INVALID_HOOK_HANDLE = 1404;
  ERROR_INVALID_DWP_HANDLE = 1405;
  ERROR_TLW_WITH_WSCHILD = 1406;
  ERROR_CANNOT_FIND_WND_CLASS = 1407;
  ERROR_WINDOW_OF_OTHER_THREAD = 1408;
  ERROR_HOTKEY_ALREADY_REGISTERED = 1409;
  ERROR_CLASS_ALREADY_EXISTS = 1410;
  ERROR_CLASS_DOES_NOT_EXIST = 1411;
  ERROR_CLASS_HAS_WINDOWS = 1412;
  ERROR_INVALID_INDEX = 1413;
  ERROR_INVALID_ICON_HANDLE = 1414;
  ERROR_PRIVATE_DIALOG_INDEX = 1415;
  ERROR_LISTBOX_ID_NOT_FOUND = 1416;
  ERROR_NO_WILDCARD_CHARACTERS = 1417;
  ERROR_CLIPBOARD_NOT_OPEN = 1418;
  ERROR_HOTKEY_NOT_REGISTERED = 1419;
  ERROR_WINDOW_NOT_DIALOG = 1420;
  ERROR_CONTROL_ID_NOT_FOUND = 1421;
  ERROR_INVALID_COMBOBOX_MESSAGE = 1422;
  ERROR_WINDOW_NOT_COMBOBOX = 1423;
  ERROR_INVALID_EDIT_HEIGHT = 1424;
  ERROR_DC_NOT_FOUND = 1425;
  ERROR_INVALID_HOOK_FILTER = 1426;
  ERROR_INVALID_FILTER_PROC = 1427;
  ERROR_HOOK_NEEDS_HMOD = 1428;
  ERROR_GLOBAL_ONLY_HOOK = 1429;
  ERROR_JOURNAL_HOOK_SET = 1430;
  ERROR_HOOK_NOT_INSTALLED = 1431;
  ERROR_INVALID_LB_MESSAGE = 1432;
  ERROR_SETCOUNT_ON_BAD_LB = 1433;
  ERROR_LB_WITHOUT_TABSTOPS = 1434;
  ERROR_DESTROY_OBJECT_OF_OTHER_THREAD = 1435;
  ERROR_CHILD_WINDOW_MENU = 1436;
  ERROR_NO_SYSTEM_MENU = 1437;
  ERROR_INVALID_MSGBOX_STYLE = 1438;
  ERROR_INVALID_SPI_VALUE = 1439;
  ERROR_SCREEN_ALREADY_LOCKED = 1440;
  ERROR_HWNDS_HAVE_DIFF_PARENT = 1441;
  ERROR_NOT_CHILD_WINDOW = 1442;
  ERROR_INVALID_GW_COMMAND = 1443;
  ERROR_INVALID_THREAD_ID = 1444;
  ERROR_NON_MDICHILD_WINDOW = 1445;
  ERROR_POPUP_ALREADY_ACTIVE = 1446;
  ERROR_NO_SCROLLBARS = 1447;
  ERROR_INVALID_SCROLLBAR_RANGE = 1448;
  ERROR_INVALID_SHOWWIN_COMMAND = 1449;
  ERROR_NO_SYSTEM_RESOURCES = 1450;
  ERROR_NONPAGED_SYSTEM_RESOURCES = 1451;
  ERROR_PAGED_SYSTEM_RESOURCES = 1452;
  ERROR_WORKING_SET_QUOTA = 1453;
  ERROR_PAGEFILE_QUOTA = 1454;
  ERROR_COMMITMENT_LIMIT = 1455;
  ERROR_MENU_ITEM_NOT_FOUND = 1456;
  ERROR_INVALID_KEYBOARD_HANDLE = 1457;
  ERROR_HOOK_TYPE_NOT_ALLOWED = 1458;
  ERROR_REQUIRES_INTERACTIVE_WINDOWSTATION = 1459;
  ERROR_TIMEOUT = 1460;
  ERROR_INVALID_MONITOR_HANDLE = 1461;
  ERROR_INCORRECT_SIZE = 1462;
  ERROR_EVENTLOG_FILE_CORRUPT = 1500;
  ERROR_EVENTLOG_CANT_START = 1501;
  ERROR_LOG_FILE_FULL = 1502;
  ERROR_EVENTLOG_FILE_CHANGED = 1503;
  ERROR_INSTALL_SERVICE_FAILURE = 1601;
  ERROR_INSTALL_USEREXIT = 1602;
  ERROR_INSTALL_FAILURE = 1603;
  ERROR_INSTALL_SUSPEND = 1604;
  ERROR_UNKNOWN_PRODUCT = 1605;
  ERROR_UNKNOWN_FEATURE = 1606;
  ERROR_UNKNOWN_COMPONENT = 1607;
  ERROR_UNKNOWN_PROPERTY = 1608;
  ERROR_INVALID_HANDLE_STATE = 1609;
  ERROR_BAD_CONFIGURATION = 1610;
  ERROR_INDEX_ABSENT = 1611;
  ERROR_INSTALL_SOURCE_ABSENT = 1612;
  ERROR_INSTALL_PACKAGE_VERSION = 1613;
  ERROR_PRODUCT_UNINSTALLED = 1614;
  ERROR_BAD_QUERY_SYNTAX = 1615;
  ERROR_INVALID_FIELD = 1616;
  ERROR_DEVICE_REMOVED = 1617;
  ERROR_INSTALL_ALREADY_RUNNING = 1618;
  ERROR_INSTALL_PACKAGE_OPEN_FAILED = 1619;
  ERROR_INSTALL_PACKAGE_INVALID = 1620;
  ERROR_INSTALL_UI_FAILURE = 1621;
  ERROR_INSTALL_LOG_FAILURE = 1622;
  ERROR_INSTALL_LANGUAGE_UNSUPPORTED = 1623;
  ERROR_INSTALL_TRANSFORM_FAILURE = 1624;
  ERROR_INSTALL_PACKAGE_REJECTED = 1625;
  ERROR_FUNCTION_NOT_CALLED = 1626;
  ERROR_FUNCTION_FAILED = 1627;
  ERROR_INVALID_TABLE = 1628;
  ERROR_DATATYPE_MISMATCH = 1629;
  ERROR_UNSUPPORTED_TYPE = 1630;
  ERROR_CREATE_FAILED = 1631;
  ERROR_INSTALL_TEMP_UNWRITABLE = 1632;
  ERROR_INSTALL_PLATFORM_UNSUPPORTED = 1633;
  ERROR_INSTALL_NOTUSED = 1634;
  ERROR_PATCH_PACKAGE_OPEN_FAILED = 1635;
  ERROR_PATCH_PACKAGE_INVALID = 1636;
  ERROR_PATCH_PACKAGE_UNSUPPORTED = 1637;
  ERROR_PRODUCT_VERSION = 1638;
  ERROR_INVALID_COMMAND_LINE = 1639;
  ERROR_INSTALL_REMOTE_DISALLOWED = 1640;
  ERROR_SUCCESS_REBOOT_INITIATED = 1641;
  ERROR_PATCH_TARGET_NOT_FOUND = 1642;
  ERROR_PATCH_PACKAGE_REJECTED = 1643;
  ERROR_INSTALL_TRANSFORM_REJECTED = 1644;
  ERROR_INSTALL_REMOTE_PROHIBITED = 1645;
  RPC_S_INVALID_STRING_BINDING = 1700;
  RPC_S_WRONG_KIND_OF_BINDING = 1701;
  RPC_S_INVALID_BINDING = 1702;
  RPC_S_PROTSEQ_NOT_SUPPORTED = 1703;
  RPC_S_INVALID_RPC_PROTSEQ = 1704;
  RPC_S_INVALID_STRING_UUID = 1705;
  RPC_S_INVALID_ENDPOINT_FORMAT = 1706;
  RPC_S_INVALID_NET_ADDR = 1707;
  RPC_S_NO_ENDPOINT_FOUND = 1708;
  RPC_S_INVALID_TIMEOUT = 1709;
  RPC_S_OBJECT_NOT_FOUND = 1710;
  RPC_S_ALREADY_REGISTERED = 1711;
  RPC_S_TYPE_ALREADY_REGISTERED = 1712;
  RPC_S_ALREADY_LISTENING = 1713;
  RPC_S_NO_PROTSEQS_REGISTERED = 1714;
  RPC_S_NOT_LISTENING = 1715;
  RPC_S_UNKNOWN_MGR_TYPE = 1716;
  RPC_S_UNKNOWN_IF = 1717;
  RPC_S_NO_BINDINGS = 1718;
  RPC_S_NO_PROTSEQS = 1719;
  RPC_S_CANT_CREATE_ENDPOINT = 1720;
  RPC_S_OUT_OF_RESOURCES = 1721;
  RPC_S_SERVER_UNAVAILABLE = 1722;
  RPC_S_SERVER_TOO_BUSY = 1723;
  RPC_S_INVALID_NETWORK_OPTIONS = 1724;
  RPC_S_NO_CALL_ACTIVE = 1725;
  RPC_S_CALL_FAILED = 1726;
  RPC_S_CALL_FAILED_DNE = 1727;
  RPC_S_PROTOCOL_ERROR = 1728;
  RPC_S_UNSUPPORTED_TRANS_SYN = 1730;
  RPC_S_UNSUPPORTED_TYPE = 1732;
  RPC_S_INVALID_TAG = 1733;
  RPC_S_INVALID_BOUND = 1734;
  RPC_S_NO_ENTRY_NAME = 1735;
  RPC_S_INVALID_NAME_SYNTAX = 1736;
  RPC_S_UNSUPPORTED_NAME_SYNTAX = 1737;
  RPC_S_UUID_NO_ADDRESS = 1739;
  RPC_S_DUPLICATE_ENDPOINT = 1740;
  RPC_S_UNKNOWN_AUTHN_TYPE = 1741;
  RPC_S_MAX_CALLS_TOO_SMALL = 1742;
  RPC_S_STRING_TOO_LONG = 1743;
  RPC_S_PROTSEQ_NOT_FOUND = 1744;
  RPC_S_PROCNUM_OUT_OF_RANGE = 1745;
  RPC_S_BINDING_HAS_NO_AUTH = 1746;
  RPC_S_UNKNOWN_AUTHN_SERVICE = 1747;
  RPC_S_UNKNOWN_AUTHN_LEVEL = 1748;
  RPC_S_INVALID_AUTH_IDENTITY = 1749;
  RPC_S_UNKNOWN_AUTHZ_SERVICE = 1750;
  EPT_S_INVALID_ENTRY = 1751;
  EPT_S_CANT_PERFORM_OP = 1752;
  EPT_S_NOT_REGISTERED = 1753;
  RPC_S_NOTHING_TO_EXPORT = 1754;
  RPC_S_INCOMPLETE_NAME = 1755;
  RPC_S_INVALID_VERS_OPTION = 1756;
  RPC_S_NO_MORE_MEMBERS = 1757;
  RPC_S_NOT_ALL_OBJS_UNEXPORTED = 1758;
  RPC_S_INTERFACE_NOT_FOUND = 1759;
  RPC_S_ENTRY_ALREADY_EXISTS = 1760;
  RPC_S_ENTRY_NOT_FOUND = 1761;
  RPC_S_NAME_SERVICE_UNAVAILABLE = 1762;
  RPC_S_INVALID_NAF_ID = 1763;
  RPC_S_CANNOT_SUPPORT = 1764;
  RPC_S_NO_CONTEXT_AVAILABLE = 1765;
  RPC_S_INTERNAL_ERROR = 1766;
  RPC_S_ZERO_DIVIDE = 1767;
  RPC_S_ADDRESS_ERROR = 1768;
  RPC_S_FP_DIV_ZERO = 1769;
  RPC_S_FP_UNDERFLOW = 1770;
  RPC_S_FP_OVERFLOW = 1771;
  RPC_X_NO_MORE_ENTRIES = 1772;
  RPC_X_SS_CHAR_TRANS_OPEN_FAIL = 1773;
  RPC_X_SS_CHAR_TRANS_SHORT_FILE = 1774;
  RPC_X_SS_IN_NULL_CONTEXT = 1775;
  RPC_X_SS_CONTEXT_DAMAGED = 1777;
  RPC_X_SS_HANDLES_MISMATCH = 1778;
  RPC_X_SS_CANNOT_GET_CALL_HANDLE = 1779;
  RPC_X_NULL_REF_POINTER = 1780;
  RPC_X_ENUM_VALUE_OUT_OF_RANGE = 1781;
  RPC_X_BYTE_COUNT_TOO_SMALL = 1782;
  RPC_X_BAD_STUB_DATA = 1783;
  ERROR_INVALID_USER_BUFFER = 1784;
  ERROR_UNRECOGNIZED_MEDIA = 1785;
  ERROR_NO_TRUST_LSA_SECRET = 1786;
  ERROR_NO_TRUST_SAM_ACCOUNT = 1787;
  ERROR_TRUSTED_DOMAIN_FAILURE = 1788;
  ERROR_TRUSTED_RELATIONSHIP_FAILURE = 1789;
  ERROR_TRUST_FAILURE = 1790;
  RPC_S_CALL_IN_PROGRESS = 1791;
  ERROR_NETLOGON_NOT_STARTED = 1792;
  ERROR_ACCOUNT_EXPIRED = 1793;
  ERROR_REDIRECTOR_HAS_OPEN_HANDLES = 1794;
  ERROR_PRINTER_DRIVER_ALREADY_INSTALLED = 1795;
  ERROR_UNKNOWN_PORT = 1796;
  ERROR_UNKNOWN_PRINTER_DRIVER = 1797;
  ERROR_UNKNOWN_PRINTPROCESSOR = 1798;
  ERROR_INVALID_SEPARATOR_FILE = 1799;
  ERROR_INVALID_PRIORITY = 1800;
  ERROR_INVALID_PRINTER_NAME = 1801;
  ERROR_PRINTER_ALREADY_EXISTS = 1802;
  ERROR_INVALID_PRINTER_COMMAND = 1803;
  ERROR_INVALID_DATATYPE = 1804;
  ERROR_INVALID_ENVIRONMENT = 1805;
  RPC_S_NO_MORE_BINDINGS = 1806;
  ERROR_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT = 1807;
  ERROR_NOLOGON_WORKSTATION_TRUST_ACCOUNT = 1808;
  ERROR_NOLOGON_SERVER_TRUST_ACCOUNT = 1809;
  ERROR_DOMAIN_TRUST_INCONSISTENT = 1810;
  ERROR_SERVER_HAS_OPEN_HANDLES = 1811;
  ERROR_RESOURCE_DATA_NOT_FOUND = 1812;
  ERROR_RESOURCE_TYPE_NOT_FOUND = 1813;
  ERROR_RESOURCE_NAME_NOT_FOUND = 1814;
  ERROR_RESOURCE_LANG_NOT_FOUND = 1815;
  ERROR_NOT_ENOUGH_QUOTA = 1816;
  RPC_S_NO_INTERFACES = 1817;
  RPC_S_CALL_CANCELLED = 1818;
  RPC_S_BINDING_INCOMPLETE = 1819;
  RPC_S_COMM_FAILURE = 1820;
  RPC_S_UNSUPPORTED_AUTHN_LEVEL = 1821;
  RPC_S_NO_PRINC_NAME = 1822;
  RPC_S_NOT_RPC_ERROR = 1823;
  RPC_S_UUID_LOCAL_ONLY = 1824;
  RPC_S_SEC_PKG_ERROR = 1825;
  RPC_S_NOT_CANCELLED = 1826;
  RPC_X_INVALID_ES_ACTION = 1827;
  RPC_X_WRONG_ES_VERSION = 1828;
  RPC_X_WRONG_STUB_VERSION = 1829;
  RPC_X_INVALID_PIPE_OBJECT = 1830;
  RPC_X_WRONG_PIPE_ORDER = 1831;
  RPC_X_WRONG_PIPE_VERSION = 1832;
  RPC_S_GROUP_MEMBER_NOT_FOUND = 1898;
  EPT_S_CANT_CREATE = 1899;
  RPC_S_INVALID_OBJECT = 1900;
  ERROR_INVALID_TIME = 1901;
  ERROR_INVALID_FORM_NAME = 1902;
  ERROR_INVALID_FORM_SIZE = 1903;
  ERROR_ALREADY_WAITING = 1904;
  ERROR_PRINTER_DELETED = 1905;
  ERROR_INVALID_PRINTER_STATE = 1906;
  ERROR_PASSWORD_MUST_CHANGE = 1907;
  ERROR_DOMAIN_CONTROLLER_NOT_FOUND = 1908;
  ERROR_ACCOUNT_LOCKED_OUT = 1909;
  OR_INVALID_OXID = 1910;
  OR_INVALID_OID = 1911;
  OR_INVALID_SET = 1912;
  RPC_S_SEND_INCOMPLETE = 1913;
  RPC_S_INVALID_ASYNC_HANDLE = 1914;
  RPC_S_INVALID_ASYNC_CALL = 1915;
  RPC_X_PIPE_CLOSED = 1916;
  RPC_X_PIPE_DISCIPLINE_ERROR = 1917;
  RPC_X_PIPE_EMPTY = 1918;
  ERROR_NO_SITENAME = 1919;
  ERROR_CANT_ACCESS_FILE = 1920;
  ERROR_CANT_RESOLVE_FILENAME = 1921;
  RPC_S_ENTRY_TYPE_MISMATCH = 1922;
  RPC_S_NOT_ALL_OBJS_EXPORTED = 1923;
  RPC_S_INTERFACE_NOT_EXPORTED = 1924;
  RPC_S_PROFILE_NOT_ADDED = 1925;
  RPC_S_PRF_ELT_NOT_ADDED = 1926;
  RPC_S_PRF_ELT_NOT_REMOVED = 1927;
  RPC_S_GRP_ELT_NOT_ADDED = 1928;
  RPC_S_GRP_ELT_NOT_REMOVED = 1929;
  ERROR_KM_DRIVER_BLOCKED = 1930;
  ERROR_CONTEXT_EXPIRED = 1931;
  ERROR_PER_USER_TRUST_QUOTA_EXCEEDED = 1932;
  ERROR_ALL_USER_TRUST_QUOTA_EXCEEDED = 1933;
  ERROR_USER_DELETE_TRUST_QUOTA_EXCEEDED = 1934;
  ERROR_AUTHENTICATION_FIREWALL_FAILED = 1935;
  ERROR_REMOTE_PRINT_CONNECTIONS_BLOCKED = 1936;
  ERROR_INVALID_PIXEL_FORMAT = 2000;
  ERROR_BAD_DRIVER = 2001;
  ERROR_INVALID_WINDOW_STYLE = 2002;
  ERROR_METAFILE_NOT_SUPPORTED = 2003;
  ERROR_TRANSFORM_NOT_SUPPORTED = 2004;
  ERROR_CLIPPING_NOT_SUPPORTED = 2005;
  ERROR_INVALID_CMM = 2010;
  ERROR_INVALID_PROFILE = 2011;
  ERROR_TAG_NOT_FOUND = 2012;
  ERROR_TAG_NOT_PRESENT = 2013;
  ERROR_DUPLICATE_TAG = 2014;
  ERROR_PROFILE_NOT_ASSOCIATED_WITH_DEVICE = 2015;
  ERROR_PROFILE_NOT_FOUND = 2016;
  ERROR_INVALID_COLORSPACE = 2017;
  ERROR_ICM_NOT_ENABLED = 2018;
  ERROR_DELETING_ICM_XFORM = 2019;
  ERROR_INVALID_TRANSFORM = 2020;
  ERROR_COLORSPACE_MISMATCH = 2021;
  ERROR_INVALID_COLORINDEX = 2022;
  ERROR_CONNECTED_OTHER_PASSWORD = 2108;
  ERROR_CONNECTED_OTHER_PASSWORD_DEFAULT = 2109;
  ERROR_BAD_USERNAME = 2202;
  ERROR_NOT_CONNECTED = 2250;
  ERROR_OPEN_FILES = 2401;
  ERROR_ACTIVE_CONNECTIONS = 2402;
  ERROR_DEVICE_IN_USE = 2404;
  ERROR_UNKNOWN_PRINT_MONITOR = 3000;
  ERROR_PRINTER_DRIVER_IN_USE = 3001;
  ERROR_SPOOL_FILE_NOT_FOUND = 3002;
  ERROR_SPL_NO_STARTDOC = 3003;
  ERROR_SPL_NO_ADDJOB = 3004;
  ERROR_PRINT_PROCESSOR_ALREADY_INSTALLED = 3005;
  ERROR_PRINT_MONITOR_ALREADY_INSTALLED = 3006;
  ERROR_INVALID_PRINT_MONITOR = 3007;
  ERROR_PRINT_MONITOR_IN_USE = 3008;
  ERROR_PRINTER_HAS_JOBS_QUEUED = 3009;
  ERROR_SUCCESS_REBOOT_REQUIRED = 3010;
  ERROR_SUCCESS_RESTART_REQUIRED = 3011;
  ERROR_PRINTER_NOT_FOUND = 3012;
  ERROR_PRINTER_DRIVER_WARNED = 3013;
  ERROR_PRINTER_DRIVER_BLOCKED = 3014;
  ERROR_WINS_INTERNAL = 4000;
  ERROR_CAN_NOT_DEL_LOCAL_WINS = 4001;
  ERROR_STATIC_INIT = 4002;
  ERROR_INC_BACKUP = 4003;
  ERROR_FULL_BACKUP = 4004;
  ERROR_REC_NON_EXISTENT = 4005;
  ERROR_RPL_NOT_ALLOWED = 4006;
  ERROR_DHCP_ADDRESS_CONFLICT = 4100;
  ERROR_WMI_GUID_NOT_FOUND = 4200;
  ERROR_WMI_INSTANCE_NOT_FOUND = 4201;
  ERROR_WMI_ITEMID_NOT_FOUND = 4202;
  ERROR_WMI_TRY_AGAIN = 4203;
  ERROR_WMI_DP_NOT_FOUND = 4204;
  ERROR_WMI_UNRESOLVED_INSTANCE_REF = 4205;
  ERROR_WMI_ALREADY_ENABLED = 4206;
  ERROR_WMI_GUID_DISCONNECTED = 4207;
  ERROR_WMI_SERVER_UNAVAILABLE = 4208;
  ERROR_WMI_DP_FAILED = 4209;
  ERROR_WMI_INVALID_MOF = 4210;
  ERROR_WMI_INVALID_REGINFO = 4211;
  ERROR_WMI_ALREADY_DISABLED = 4212;
  ERROR_WMI_READ_ONLY = 4213;
  ERROR_WMI_SET_FAILURE = 4214;
  ERROR_INVALID_MEDIA = 4300;
  ERROR_INVALID_LIBRARY = 4301;
  ERROR_INVALID_MEDIA_POOL = 4302;
  ERROR_DRIVE_MEDIA_MISMATCH = 4303;
  ERROR_MEDIA_OFFLINE = 4304;
  ERROR_LIBRARY_OFFLINE = 4305;
  ERROR_EMPTY = 4306;
  ERROR_NOT_EMPTY = 4307;
  ERROR_MEDIA_UNAVAILABLE = 4308;
  ERROR_RESOURCE_DISABLED = 4309;
  ERROR_INVALID_CLEANER = 4310;
  ERROR_UNABLE_TO_CLEAN = 4311;
  ERROR_OBJECT_NOT_FOUND = 4312;
  ERROR_DATABASE_FAILURE = 4313;
  ERROR_DATABASE_FULL = 4314;
  ERROR_MEDIA_INCOMPATIBLE = 4315;
  ERROR_RESOURCE_NOT_PRESENT = 4316;
  ERROR_INVALID_OPERATION = 4317;
  ERROR_MEDIA_NOT_AVAILABLE = 4318;
  ERROR_DEVICE_NOT_AVAILABLE = 4319;
  ERROR_REQUEST_REFUSED = 4320;
  ERROR_INVALID_DRIVE_OBJECT = 4321;
  ERROR_LIBRARY_FULL = 4322;
  ERROR_MEDIUM_NOT_ACCESSIBLE = 4323;
  ERROR_UNABLE_TO_LOAD_MEDIUM = 4324;
  ERROR_UNABLE_TO_INVENTORY_DRIVE = 4325;
  ERROR_UNABLE_TO_INVENTORY_SLOT = 4326;
  ERROR_UNABLE_TO_INVENTORY_TRANSPORT = 4327;
  ERROR_TRANSPORT_FULL = 4328;
  ERROR_CONTROLLING_IEPORT = 4329;
  ERROR_UNABLE_TO_EJECT_MOUNTED_MEDIA = 4330;
  ERROR_CLEANER_SLOT_SET = 4331;
  ERROR_CLEANER_SLOT_NOT_SET = 4332;
  ERROR_CLEANER_CARTRIDGE_SPENT = 4333;
  ERROR_UNEXPECTED_OMID = 4334;
  ERROR_CANT_DELETE_LAST_ITEM = 4335;
  ERROR_MESSAGE_EXCEEDS_MAX_SIZE = 4336;
  ERROR_VOLUME_CONTAINS_SYS_FILES = 4337;
  ERROR_INDIGENOUS_TYPE = 4338;
  ERROR_NO_SUPPORTING_DRIVES = 4339;
  ERROR_CLEANER_CARTRIDGE_INSTALLED = 4340;
  ERROR_IEPORT_FULL = 4341;
  ERROR_FILE_OFFLINE = 4350;
  ERROR_REMOTE_STORAGE_NOT_ACTIVE = 4351;
  ERROR_REMOTE_STORAGE_MEDIA_ERROR = 4352;
  ERROR_NOT_A_REPARSE_POINT = 4390;
  ERROR_REPARSE_ATTRIBUTE_CONFLICT = 4391;
  ERROR_INVALID_REPARSE_DATA = 4392;
  ERROR_REPARSE_TAG_INVALID = 4393;
  ERROR_REPARSE_TAG_MISMATCH = 4394;
  ERROR_VOLUME_NOT_SIS_ENABLED = 4500;
  ERROR_DEPENDENT_RESOURCE_EXISTS = 5001;
  ERROR_DEPENDENCY_NOT_FOUND = 5002;
  ERROR_DEPENDENCY_ALREADY_EXISTS = 5003;
  ERROR_RESOURCE_NOT_ONLINE = 5004;
  ERROR_HOST_NODE_NOT_AVAILABLE = 5005;
  ERROR_RESOURCE_NOT_AVAILABLE = 5006;
  ERROR_RESOURCE_NOT_FOUND = 5007;
  ERROR_SHUTDOWN_CLUSTER = 5008;
  ERROR_CANT_EVICT_ACTIVE_NODE = 5009;
  ERROR_OBJECT_ALREADY_EXISTS = 5010;
  ERROR_OBJECT_IN_LIST = 5011;
  ERROR_GROUP_NOT_AVAILABLE = 5012;
  ERROR_GROUP_NOT_FOUND = 5013;
  ERROR_GROUP_NOT_ONLINE = 5014;
  ERROR_HOST_NODE_NOT_RESOURCE_OWNER = 5015;
  ERROR_HOST_NODE_NOT_GROUP_OWNER = 5016;
  ERROR_RESMON_CREATE_FAILED = 5017;
  ERROR_RESMON_ONLINE_FAILED = 5018;
  ERROR_RESOURCE_ONLINE = 5019;
  ERROR_QUORUM_RESOURCE = 5020;
  ERROR_NOT_QUORUM_CAPABLE = 5021;
  ERROR_CLUSTER_SHUTTING_DOWN = 5022;
  ERROR_INVALID_STATE = 5023;
  ERROR_RESOURCE_PROPERTIES_STORED = 5024;
  ERROR_NOT_QUORUM_CLASS = 5025;
  ERROR_CORE_RESOURCE = 5026;
  ERROR_QUORUM_RESOURCE_ONLINE_FAILED = 5027;
  ERROR_QUORUMLOG_OPEN_FAILED = 5028;
  ERROR_CLUSTERLOG_CORRUPT = 5029;
  ERROR_CLUSTERLOG_RECORD_EXCEEDS_MAXSIZE = 5030;
  ERROR_CLUSTERLOG_EXCEEDS_MAXSIZE = 5031;
  ERROR_CLUSTERLOG_CHKPOINT_NOT_FOUND = 5032;
  ERROR_CLUSTERLOG_NOT_ENOUGH_SPACE = 5033;
  ERROR_QUORUM_OWNER_ALIVE = 5034;
  ERROR_NETWORK_NOT_AVAILABLE = 5035;
  ERROR_NODE_NOT_AVAILABLE = 5036;
  ERROR_ALL_NODES_NOT_AVAILABLE = 5037;
  ERROR_RESOURCE_FAILED = 5038;
  ERROR_CLUSTER_INVALID_NODE = 5039;
  ERROR_CLUSTER_NODE_EXISTS = 5040;
  ERROR_CLUSTER_JOIN_IN_PROGRESS = 5041;
  ERROR_CLUSTER_NODE_NOT_FOUND = 5042;
  ERROR_CLUSTER_LOCAL_NODE_NOT_FOUND = 5043;
  ERROR_CLUSTER_NETWORK_EXISTS = 5044;
  ERROR_CLUSTER_NETWORK_NOT_FOUND = 5045;
  ERROR_CLUSTER_NETINTERFACE_EXISTS = 5046;
  ERROR_CLUSTER_NETINTERFACE_NOT_FOUND = 5047;
  ERROR_CLUSTER_INVALID_REQUEST = 5048;
  ERROR_CLUSTER_INVALID_NETWORK_PROVIDER = 5049;
  ERROR_CLUSTER_NODE_DOWN = 5050;
  ERROR_CLUSTER_NODE_UNREACHABLE = 5051;
  ERROR_CLUSTER_NODE_NOT_MEMBER = 5052;
  ERROR_CLUSTER_JOIN_NOT_IN_PROGRESS = 5053;
  ERROR_CLUSTER_INVALID_NETWORK = 5054;
  ERROR_CLUSTER_NODE_UP = 5056;
  ERROR_CLUSTER_IPADDR_IN_USE = 5057;
  ERROR_CLUSTER_NODE_NOT_PAUSED = 5058;
  ERROR_CLUSTER_NO_SECURITY_CONTEXT = 5059;
  ERROR_CLUSTER_NETWORK_NOT_INTERNAL = 5060;
  ERROR_CLUSTER_NODE_ALREADY_UP = 5061;
  ERROR_CLUSTER_NODE_ALREADY_DOWN = 5062;
  ERROR_CLUSTER_NETWORK_ALREADY_ONLINE = 5063;
  ERROR_CLUSTER_NETWORK_ALREADY_OFFLINE = 5064;
  ERROR_CLUSTER_NODE_ALREADY_MEMBER = 5065;
  ERROR_CLUSTER_LAST_INTERNAL_NETWORK = 5066;
  ERROR_CLUSTER_NETWORK_HAS_DEPENDENTS = 5067;
  ERROR_INVALID_OPERATION_ON_QUORUM = 5068;
  ERROR_DEPENDENCY_NOT_ALLOWED = 5069;
  ERROR_CLUSTER_NODE_PAUSED = 5070;
  ERROR_NODE_CANT_HOST_RESOURCE = 5071;
  ERROR_CLUSTER_NODE_NOT_READY = 5072;
  ERROR_CLUSTER_NODE_SHUTTING_DOWN = 5073;
  ERROR_CLUSTER_JOIN_ABORTED = 5074;
  ERROR_CLUSTER_INCOMPATIBLE_VERSIONS = 5075;
  ERROR_CLUSTER_MAXNUM_OF_RESOURCES_EXCEEDED = 5076;
  ERROR_CLUSTER_SYSTEM_CONFIG_CHANGED = 5077;
  ERROR_CLUSTER_RESOURCE_TYPE_NOT_FOUND = 5078;
  ERROR_CLUSTER_RESTYPE_NOT_SUPPORTED = 5079;
  ERROR_CLUSTER_RESNAME_NOT_FOUND = 5080;
  ERROR_CLUSTER_NO_RPC_PACKAGES_REGISTERED = 5081;
  ERROR_CLUSTER_OWNER_NOT_IN_PREFLIST = 5082;
  ERROR_CLUSTER_DATABASE_SEQMISMATCH = 5083;
  ERROR_RESMON_INVALID_STATE = 5084;
  ERROR_CLUSTER_GUM_NOT_LOCKER = 5085;
  ERROR_QUORUM_DISK_NOT_FOUND = 5086;
  ERROR_DATABASE_BACKUP_CORRUPT = 5087;
  ERROR_CLUSTER_NODE_ALREADY_HAS_DFS_ROOT = 5088;
  ERROR_RESOURCE_PROPERTY_UNCHANGEABLE = 5089;
  ERROR_CLUSTER_MEMBERSHIP_INVALID_STATE = 5890;
  ERROR_CLUSTER_QUORUMLOG_NOT_FOUND = 5891;
  ERROR_CLUSTER_MEMBERSHIP_HALT = 5892;
  ERROR_CLUSTER_INSTANCE_ID_MISMATCH = 5893;
  ERROR_CLUSTER_NETWORK_NOT_FOUND_FOR_IP = 5894;
  ERROR_CLUSTER_PROPERTY_DATA_TYPE_MISMATCH = 5895;
  ERROR_CLUSTER_EVICT_WITHOUT_CLEANUP = 5896;
  ERROR_CLUSTER_PARAMETER_MISMATCH = 5897;
  ERROR_NODE_CANNOT_BE_CLUSTERED = 5898;
  ERROR_CLUSTER_WRONG_OS_VERSION = 5899;
  ERROR_CLUSTER_CANT_CREATE_DUP_CLUSTER_NAME = 5900;
  ERROR_CLUSCFG_ALREADY_COMMITTED = 5901;
  ERROR_CLUSCFG_ROLLBACK_FAILED = 5902;
  ERROR_CLUSCFG_SYSTEM_DISK_DRIVE_LETTER_CONFLICT = 5903;
  ERROR_CLUSTER_OLD_VERSION = 5904;
  ERROR_CLUSTER_MISMATCHED_COMPUTER_ACCT_NAME = 5905;
  ERROR_ENCRYPTION_FAILED = 6000;
  ERROR_DECRYPTION_FAILED = 6001;
  ERROR_FILE_ENCRYPTED = 6002;
  ERROR_NO_RECOVERY_POLICY = 6003;
  ERROR_NO_EFS = 6004;
  ERROR_WRONG_EFS = 6005;
  ERROR_NO_USER_KEYS = 6006;
  ERROR_FILE_NOT_ENCRYPTED = 6007;
  ERROR_NOT_EXPORT_FORMAT = 6008;
  ERROR_FILE_READ_ONLY = 6009;
  ERROR_DIR_EFS_DISALLOWED = 6010;
  ERROR_EFS_SERVER_NOT_TRUSTED = 6011;
  ERROR_BAD_RECOVERY_POLICY = 6012;
  ERROR_EFS_ALG_BLOB_TOO_BIG = 6013;
  ERROR_VOLUME_NOT_SUPPORT_EFS = 6014;
  ERROR_EFS_DISABLED = 6015;
  ERROR_EFS_VERSION_NOT_SUPPORT = 6016;
  ERROR_NO_BROWSER_SERVERS_FOUND = 6118;
  SCHED_E_SERVICE_NOT_LOCALSYSTEM = 6200;
  ERROR_CTX_WINSTATION_NAME_INVALID = 7001;
  ERROR_CTX_INVALID_PD = 7002;
  ERROR_CTX_PD_NOT_FOUND = 7003;
  ERROR_CTX_WD_NOT_FOUND = 7004;
  ERROR_CTX_CANNOT_MAKE_EVENTLOG_ENTRY = 7005;
  ERROR_CTX_SERVICE_NAME_COLLISION = 7006;
  ERROR_CTX_CLOSE_PENDING = 7007;
  ERROR_CTX_NO_OUTBUF = 7008;
  ERROR_CTX_MODEM_INF_NOT_FOUND = 7009;
  ERROR_CTX_INVALID_MODEMNAME = 7010;
  ERROR_CTX_MODEM_RESPONSE_ERROR = 7011;
  ERROR_CTX_MODEM_RESPONSE_TIMEOUT = 7012;
  ERROR_CTX_MODEM_RESPONSE_NO_CARRIER = 7013;
  ERROR_CTX_MODEM_RESPONSE_NO_DIALTONE = 7014;
  ERROR_CTX_MODEM_RESPONSE_BUSY = 7015;
  ERROR_CTX_MODEM_RESPONSE_VOICE = 7016;
  ERROR_CTX_TD_ERROR = 7017;
  ERROR_CTX_WINSTATION_NOT_FOUND = 7022;
  ERROR_CTX_WINSTATION_ALREADY_EXISTS = 7023;
  ERROR_CTX_WINSTATION_BUSY = 7024;
  ERROR_CTX_BAD_VIDEO_MODE = 7025;
  ERROR_CTX_GRAPHICS_INVALID = 7035;
  ERROR_CTX_LOGON_DISABLED = 7037;
  ERROR_CTX_NOT_CONSOLE = 7038;
  ERROR_CTX_CLIENT_QUERY_TIMEOUT = 7040;
  ERROR_CTX_CONSOLE_DISCONNECT = 7041;
  ERROR_CTX_CONSOLE_CONNECT = 7042;
  ERROR_CTX_SHADOW_DENIED = 7044;
  ERROR_CTX_WINSTATION_ACCESS_DENIED = 7045;
  ERROR_CTX_INVALID_WD = 7049;
  ERROR_CTX_SHADOW_INVALID = 7050;
  ERROR_CTX_SHADOW_DISABLED = 7051;
  ERROR_CTX_CLIENT_LICENSE_IN_USE = 7052;
  ERROR_CTX_CLIENT_LICENSE_NOT_SET = 7053;
  ERROR_CTX_LICENSE_NOT_AVAILABLE = 7054;
  ERROR_CTX_LICENSE_CLIENT_INVALID = 7055;
  ERROR_CTX_LICENSE_EXPIRED = 7056;
  ERROR_CTX_SHADOW_NOT_RUNNING = 7057;
  ERROR_CTX_SHADOW_ENDED_BY_MODE_CHANGE = 7058;
  ERROR_ACTIVATION_COUNT_EXCEEDED = 7059;
  FRS_ERR_INVALID_API_SEQUENCE = 8001;
  FRS_ERR_STARTING_SERVICE = 8002;
  FRS_ERR_STOPPING_SERVICE = 8003;
  FRS_ERR_INTERNAL_API = 8004;
  FRS_ERR_INTERNAL = 8005;
  FRS_ERR_SERVICE_COMM = 8006;
  FRS_ERR_INSUFFICIENT_PRIV = 8007;
  FRS_ERR_AUTHENTICATION = 8008;
  FRS_ERR_PARENT_INSUFFICIENT_PRIV = 8009;
  FRS_ERR_PARENT_AUTHENTICATION = 8010;
  FRS_ERR_CHILD_TO_PARENT_COMM = 8011;
  FRS_ERR_PARENT_TO_CHILD_COMM = 8012;
  FRS_ERR_SYSVOL_POPULATE = 8013;
  FRS_ERR_SYSVOL_POPULATE_TIMEOUT = 8014;
  FRS_ERR_SYSVOL_IS_BUSY = 8015;
  FRS_ERR_SYSVOL_DEMOTE = 8016;
  FRS_ERR_INVALID_SERVICE_PARAMETER = 8017;
  DS_S_SUCCESS = NO_ERROR;
  ERROR_DS_NOT_INSTALLED = 8200;
  ERROR_DS_MEMBERSHIP_EVALUATED_LOCALLY = 8201;
  ERROR_DS_NO_ATTRIBUTE_OR_VALUE = 8202;
  ERROR_DS_INVALID_ATTRIBUTE_SYNTAX = 8203;
  ERROR_DS_ATTRIBUTE_TYPE_UNDEFINED = 8204;
  ERROR_DS_ATTRIBUTE_OR_VALUE_EXISTS = 8205;
  ERROR_DS_BUSY = 8206;
  ERROR_DS_UNAVAILABLE = 8207;
  ERROR_DS_NO_RIDS_ALLOCATED = 8208;
  ERROR_DS_NO_MORE_RIDS = 8209;
  ERROR_DS_INCORRECT_ROLE_OWNER = 8210;
  ERROR_DS_RIDMGR_INIT_ERROR = 8211;
  ERROR_DS_OBJ_CLASS_VIOLATION = 8212;
  ERROR_DS_CANT_ON_NON_LEAF = 8213;
  ERROR_DS_CANT_ON_RDN = 8214;
  ERROR_DS_CANT_MOD_OBJ_CLASS = 8215;
  ERROR_DS_CROSS_DOM_MOVE_ERROR = 8216;
  ERROR_DS_GC_NOT_AVAILABLE = 8217;
  ERROR_SHARED_POLICY = 8218;
  ERROR_POLICY_OBJECT_NOT_FOUND = 8219;
  ERROR_POLICY_ONLY_IN_DS = 8220;
  ERROR_PROMOTION_ACTIVE = 8221;
  ERROR_NO_PROMOTION_ACTIVE = 8222;
  ERROR_DS_OPERATIONS_ERROR = 8224;
  ERROR_DS_PROTOCOL_ERROR = 8225;
  ERROR_DS_TIMELIMIT_EXCEEDED = 8226;
  ERROR_DS_SIZELIMIT_EXCEEDED = 8227;
  ERROR_DS_ADMIN_LIMIT_EXCEEDED = 8228;
  ERROR_DS_COMPARE_FALSE = 8229;
  ERROR_DS_COMPARE_TRUE = 8230;
  ERROR_DS_AUTH_METHOD_NOT_SUPPORTED = 8231;
  ERROR_DS_STRONG_AUTH_REQUIRED = 8232;
  ERROR_DS_INAPPROPRIATE_AUTH = 8233;
  ERROR_DS_AUTH_UNKNOWN = 8234;
  ERROR_DS_REFERRAL = 8235;
  ERROR_DS_UNAVAILABLE_CRIT_EXTENSION = 8236;
  ERROR_DS_CONFIDENTIALITY_REQUIRED = 8237;
  ERROR_DS_INAPPROPRIATE_MATCHING = 8238;
  ERROR_DS_CONSTRAINT_VIOLATION = 8239;
  ERROR_DS_NO_SUCH_OBJECT = 8240;
  ERROR_DS_ALIAS_PROBLEM = 8241;
  ERROR_DS_INVALID_DN_SYNTAX = 8242;
  ERROR_DS_IS_LEAF = 8243;
  ERROR_DS_ALIAS_DEREF_PROBLEM = 8244;
  ERROR_DS_UNWILLING_TO_PERFORM = 8245;
  ERROR_DS_LOOP_DETECT = 8246;
  ERROR_DS_NAMING_VIOLATION = 8247;
  ERROR_DS_OBJECT_RESULTS_TOO_LARGE = 8248;
  ERROR_DS_AFFECTS_MULTIPLE_DSAS = 8249;
  ERROR_DS_SERVER_DOWN = 8250;
  ERROR_DS_LOCAL_ERROR = 8251;
  ERROR_DS_ENCODING_ERROR = 8252;
  ERROR_DS_DECODING_ERROR = 8253;
  ERROR_DS_FILTER_UNKNOWN = 8254;
  ERROR_DS_PARAM_ERROR = 8255;
  ERROR_DS_NOT_SUPPORTED = 8256;
  ERROR_DS_NO_RESULTS_RETURNED = 8257;
  ERROR_DS_CONTROL_NOT_FOUND = 8258;
  ERROR_DS_CLIENT_LOOP = 8259;
  ERROR_DS_REFERRAL_LIMIT_EXCEEDED = 8260;
  ERROR_DS_SORT_CONTROL_MISSING = 8261;
  ERROR_DS_OFFSET_RANGE_ERROR = 8262;
  ERROR_DS_ROOT_MUST_BE_NC = 8301;
  ERROR_DS_ADD_REPLICA_INHIBITED = 8302;
  ERROR_DS_ATT_NOT_DEF_IN_SCHEMA = 8303;
  ERROR_DS_MAX_OBJ_SIZE_EXCEEDED = 8304;
  ERROR_DS_OBJ_STRING_NAME_EXISTS = 8305;
  ERROR_DS_NO_RDN_DEFINED_IN_SCHEMA = 8306;
  ERROR_DS_RDN_DOESNT_MATCH_SCHEMA = 8307;
  ERROR_DS_NO_REQUESTED_ATTS_FOUND = 8308;
  ERROR_DS_USER_BUFFER_TO_SMALL = 8309;
  ERROR_DS_ATT_IS_NOT_ON_OBJ = 8310;
  ERROR_DS_ILLEGAL_MOD_OPERATION = 8311;
  ERROR_DS_OBJ_TOO_LARGE = 8312;
  ERROR_DS_BAD_INSTANCE_TYPE = 8313;
  ERROR_DS_MASTERDSA_REQUIRED = 8314;
  ERROR_DS_OBJECT_CLASS_REQUIRED = 8315;
  ERROR_DS_MISSING_REQUIRED_ATT = 8316;
  ERROR_DS_ATT_NOT_DEF_FOR_CLASS = 8317;
  ERROR_DS_ATT_ALREADY_EXISTS = 8318;
  ERROR_DS_CANT_ADD_ATT_VALUES = 8320;
  ERROR_DS_SINGLE_VALUE_CONSTRAINT = 8321;
  ERROR_DS_RANGE_CONSTRAINT = 8322;
  ERROR_DS_ATT_VAL_ALREADY_EXISTS = 8323;
  ERROR_DS_CANT_REM_MISSING_ATT = 8324;
  ERROR_DS_CANT_REM_MISSING_ATT_VAL = 8325;
  ERROR_DS_ROOT_CANT_BE_SUBREF = 8326;
  ERROR_DS_NO_CHAINING = 8327;
  ERROR_DS_NO_CHAINED_EVAL = 8328;
  ERROR_DS_NO_PARENT_OBJECT = 8329;
  ERROR_DS_PARENT_IS_AN_ALIAS = 8330;
  ERROR_DS_CANT_MIX_MASTER_AND_REPS = 8331;
  ERROR_DS_CHILDREN_EXIST = 8332;
  ERROR_DS_OBJ_NOT_FOUND = 8333;
  ERROR_DS_ALIASED_OBJ_MISSING = 8334;
  ERROR_DS_BAD_NAME_SYNTAX = 8335;
  ERROR_DS_ALIAS_POINTS_TO_ALIAS = 8336;
  ERROR_DS_CANT_DEREF_ALIAS = 8337;
  ERROR_DS_OUT_OF_SCOPE = 8338;
  ERROR_DS_OBJECT_BEING_REMOVED = 8339;
  ERROR_DS_CANT_DELETE_DSA_OBJ = 8340;
  ERROR_DS_GENERIC_ERROR = 8341;
  ERROR_DS_DSA_MUST_BE_INT_MASTER = 8342;
  ERROR_DS_CLASS_NOT_DSA = 8343;
  ERROR_DS_INSUFF_ACCESS_RIGHTS = 8344;
  ERROR_DS_ILLEGAL_SUPERIOR = 8345;
  ERROR_DS_ATTRIBUTE_OWNED_BY_SAM = 8346;
  ERROR_DS_NAME_TOO_MANY_PARTS = 8347;
  ERROR_DS_NAME_TOO_LONG = 8348;
  ERROR_DS_NAME_VALUE_TOO_LONG = 8349;
  ERROR_DS_NAME_UNPARSEABLE = 8350;
  ERROR_DS_NAME_TYPE_UNKNOWN = 8351;
  ERROR_DS_NOT_AN_OBJECT = 8352;
  ERROR_DS_SEC_DESC_TOO_SHORT = 8353;
  ERROR_DS_SEC_DESC_INVALID = 8354;
  ERROR_DS_NO_DELETED_NAME = 8355;
  ERROR_DS_SUBREF_MUST_HAVE_PARENT = 8356;
  ERROR_DS_NCNAME_MUST_BE_NC = 8357;
  ERROR_DS_CANT_ADD_SYSTEM_ONLY = 8358;
  ERROR_DS_CLASS_MUST_BE_CONCRETE = 8359;
  ERROR_DS_INVALID_DMD = 8360;
  ERROR_DS_OBJ_GUID_EXISTS = 8361;
  ERROR_DS_NOT_ON_BACKLINK = 8362;
  ERROR_DS_NO_CROSSREF_FOR_NC = 8363;
  ERROR_DS_SHUTTING_DOWN = 8364;
  ERROR_DS_UNKNOWN_OPERATION = 8365;
  ERROR_DS_INVALID_ROLE_OWNER = 8366;
  ERROR_DS_COULDNT_CONTACT_FSMO = 8367;
  ERROR_DS_CROSS_NC_DN_RENAME = 8368;
  ERROR_DS_CANT_MOD_SYSTEM_ONLY = 8369;
  ERROR_DS_REPLICATOR_ONLY = 8370;
  ERROR_DS_OBJ_CLASS_NOT_DEFINED = 8371;
  ERROR_DS_OBJ_CLASS_NOT_SUBCLASS = 8372;
  ERROR_DS_NAME_REFERENCE_INVALID = 8373;
  ERROR_DS_CROSS_REF_EXISTS = 8374;
  ERROR_DS_CANT_DEL_MASTER_CROSSREF = 8375;
  ERROR_DS_SUBTREE_NOTIFY_NOT_NC_HEAD = 8376;
  ERROR_DS_NOTIFY_FILTER_TOO_COMPLEX = 8377;
  ERROR_DS_DUP_RDN = 8378;
  ERROR_DS_DUP_OID = 8379;
  ERROR_DS_DUP_MAPI_ID = 8380;
  ERROR_DS_DUP_SCHEMA_ID_GUID = 8381;
  ERROR_DS_DUP_LDAP_DISPLAY_NAME = 8382;
  ERROR_DS_SEMANTIC_ATT_TEST = 8383;
  ERROR_DS_SYNTAX_MISMATCH = 8384;
  ERROR_DS_EXISTS_IN_MUST_HAVE = 8385;
  ERROR_DS_EXISTS_IN_MAY_HAVE = 8386;
  ERROR_DS_NONEXISTENT_MAY_HAVE = 8387;
  ERROR_DS_NONEXISTENT_MUST_HAVE = 8388;
  ERROR_DS_AUX_CLS_TEST_FAIL = 8389;
  ERROR_DS_NONEXISTENT_POSS_SUP = 8390;
  ERROR_DS_SUB_CLS_TEST_FAIL = 8391;
  ERROR_DS_BAD_RDN_ATT_ID_SYNTAX = 8392;
  ERROR_DS_EXISTS_IN_AUX_CLS = 8393;
  ERROR_DS_EXISTS_IN_SUB_CLS = 8394;
  ERROR_DS_EXISTS_IN_POSS_SUP = 8395;
  ERROR_DS_RECALCSCHEMA_FAILED = 8396;
  ERROR_DS_TREE_DELETE_NOT_FINISHED = 8397;
  ERROR_DS_CANT_DELETE = 8398;
  ERROR_DS_ATT_SCHEMA_REQ_ID = 8399;
  ERROR_DS_BAD_ATT_SCHEMA_SYNTAX = 8400;
  ERROR_DS_CANT_CACHE_ATT = 8401;
  ERROR_DS_CANT_CACHE_CLASS = 8402;
  ERROR_DS_CANT_REMOVE_ATT_CACHE = 8403;
  ERROR_DS_CANT_REMOVE_CLASS_CACHE = 8404;
  ERROR_DS_CANT_RETRIEVE_DN = 8405;
  ERROR_DS_MISSING_SUPREF = 8406;
  ERROR_DS_CANT_RETRIEVE_INSTANCE = 8407;
  ERROR_DS_CODE_INCONSISTENCY = 8408;
  ERROR_DS_DATABASE_ERROR = 8409;
  ERROR_DS_GOVERNSID_MISSING = 8410;
  ERROR_DS_MISSING_EXPECTED_ATT = 8411;
  ERROR_DS_NCNAME_MISSING_CR_REF = 8412;
  ERROR_DS_SECURITY_CHECKING_ERROR = 8413;
  ERROR_DS_SCHEMA_NOT_LOADED = 8414;
  ERROR_DS_SCHEMA_ALLOC_FAILED = 8415;
  ERROR_DS_ATT_SCHEMA_REQ_SYNTAX = 8416;
  ERROR_DS_GCVERIFY_ERROR = 8417;
  ERROR_DS_DRA_SCHEMA_MISMATCH = 8418;
  ERROR_DS_CANT_FIND_DSA_OBJ = 8419;
  ERROR_DS_CANT_FIND_EXPECTED_NC = 8420;
  ERROR_DS_CANT_FIND_NC_IN_CACHE = 8421;
  ERROR_DS_CANT_RETRIEVE_CHILD = 8422;
  ERROR_DS_SECURITY_ILLEGAL_MODIFY = 8423;
  ERROR_DS_CANT_REPLACE_HIDDEN_REC = 8424;
  ERROR_DS_BAD_HIERARCHY_FILE = 8425;
  ERROR_DS_BUILD_HIERARCHY_TABLE_FAILED = 8426;
  ERROR_DS_CONFIG_PARAM_MISSING = 8427;
  ERROR_DS_COUNTING_AB_INDICES_FAILED = 8428;
  ERROR_DS_HIERARCHY_TABLE_MALLOC_FAILED = 8429;
  ERROR_DS_INTERNAL_FAILURE = 8430;
  ERROR_DS_UNKNOWN_ERROR = 8431;
  ERROR_DS_ROOT_REQUIRES_CLASS_TOP = 8432;
  ERROR_DS_REFUSING_FSMO_ROLES = 8433;
  ERROR_DS_MISSING_FSMO_SETTINGS = 8434;
  ERROR_DS_UNABLE_TO_SURRENDER_ROLES = 8435;
  ERROR_DS_DRA_GENERIC = 8436;
  ERROR_DS_DRA_INVALID_PARAMETER = 8437;
  ERROR_DS_DRA_BUSY = 8438;
  ERROR_DS_DRA_BAD_DN = 8439;
  ERROR_DS_DRA_BAD_NC = 8440;
  ERROR_DS_DRA_DN_EXISTS = 8441;
  ERROR_DS_DRA_INTERNAL_ERROR = 8442;
  ERROR_DS_DRA_INCONSISTENT_DIT = 8443;
  ERROR_DS_DRA_CONNECTION_FAILED = 8444;
  ERROR_DS_DRA_BAD_INSTANCE_TYPE = 8445;
  ERROR_DS_DRA_OUT_OF_MEM = 8446;
  ERROR_DS_DRA_MAIL_PROBLEM = 8447;
  ERROR_DS_DRA_REF_ALREADY_EXISTS = 8448;
  ERROR_DS_DRA_REF_NOT_FOUND = 8449;
  ERROR_DS_DRA_OBJ_IS_REP_SOURCE = 8450;
  ERROR_DS_DRA_DB_ERROR = 8451;
  ERROR_DS_DRA_NO_REPLICA = 8452;
  ERROR_DS_DRA_ACCESS_DENIED = 8453;
  ERROR_DS_DRA_NOT_SUPPORTED = 8454;
  ERROR_DS_DRA_RPC_CANCELLED = 8455;
  ERROR_DS_DRA_SOURCE_DISABLED = 8456;
  ERROR_DS_DRA_SINK_DISABLED = 8457;
  ERROR_DS_DRA_NAME_COLLISION = 8458;
  ERROR_DS_DRA_SOURCE_REINSTALLED = 8459;
  ERROR_DS_DRA_MISSING_PARENT = 8460;
  ERROR_DS_DRA_PREEMPTED = 8461;
  ERROR_DS_DRA_ABANDON_SYNC = 8462;
  ERROR_DS_DRA_SHUTDOWN = 8463;
  ERROR_DS_DRA_INCOMPATIBLE_PARTIAL_SET = 8464;
  ERROR_DS_DRA_SOURCE_IS_PARTIAL_REPLICA = 8465;
  ERROR_DS_DRA_EXTN_CONNECTION_FAILED = 8466;
  ERROR_DS_INSTALL_SCHEMA_MISMATCH = 8467;
  ERROR_DS_DUP_LINK_ID = 8468;
  ERROR_DS_NAME_ERROR_RESOLVING = 8469;
  ERROR_DS_NAME_ERROR_NOT_FOUND = 8470;
  ERROR_DS_NAME_ERROR_NOT_UNIQUE = 8471;
  ERROR_DS_NAME_ERROR_NO_MAPPING = 8472;
  ERROR_DS_NAME_ERROR_DOMAIN_ONLY = 8473;
  ERROR_DS_NAME_ERROR_NO_SYNTACTICAL_MAPPING = 8474;
  ERROR_DS_CONSTRUCTED_ATT_MOD = 8475;
  ERROR_DS_WRONG_OM_OBJ_CLASS = 8476;
  ERROR_DS_DRA_REPL_PENDING = 8477;
  ERROR_DS_DS_REQUIRED = 8478;
  ERROR_DS_INVALID_LDAP_DISPLAY_NAME = 8479;
  ERROR_DS_NON_BASE_SEARCH = 8480;
  ERROR_DS_CANT_RETRIEVE_ATTS = 8481;
  ERROR_DS_BACKLINK_WITHOUT_LINK = 8482;
  ERROR_DS_EPOCH_MISMATCH = 8483;
  ERROR_DS_SRC_NAME_MISMATCH = 8484;
  ERROR_DS_SRC_AND_DST_NC_IDENTICAL = 8485;
  ERROR_DS_DST_NC_MISMATCH = 8486;
  ERROR_DS_NOT_AUTHORITIVE_FOR_DST_NC = 8487;
  ERROR_DS_SRC_GUID_MISMATCH = 8488;
  ERROR_DS_CANT_MOVE_DELETED_OBJECT = 8489;
  ERROR_DS_PDC_OPERATION_IN_PROGRESS = 8490;
  ERROR_DS_CROSS_DOMAIN_CLEANUP_REQD = 8491;
  ERROR_DS_ILLEGAL_XDOM_MOVE_OPERATION = 8492;
  ERROR_DS_CANT_WITH_ACCT_GROUP_MEMBERSHPS = 8493;
  ERROR_DS_NC_MUST_HAVE_NC_PARENT = 8494;
  ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE = 8495;
  ERROR_DS_DST_DOMAIN_NOT_NATIVE = 8496;
  ERROR_DS_MISSING_INFRASTRUCTURE_CONTAINER = 8497;
  ERROR_DS_CANT_MOVE_ACCOUNT_GROUP = 8498;
  ERROR_DS_CANT_MOVE_RESOURCE_GROUP = 8499;
  ERROR_DS_INVALID_SEARCH_FLAG = 8500;
  ERROR_DS_NO_TREE_DELETE_ABOVE_NC = 8501;
  ERROR_DS_COULDNT_LOCK_TREE_FOR_DELETE = 8502;
  ERROR_DS_COULDNT_IDENTIFY_OBJECTS_FOR_TREE_DELETE = 8503;
  ERROR_DS_SAM_INIT_FAILURE = 8504;
  ERROR_DS_SENSITIVE_GROUP_VIOLATION = 8505;
  ERROR_DS_CANT_MOD_PRIMARYGROUPID = 8506;
  ERROR_DS_ILLEGAL_BASE_SCHEMA_MOD = 8507;
  ERROR_DS_NONSAFE_SCHEMA_CHANGE = 8508;
  ERROR_DS_SCHEMA_UPDATE_DISALLOWED = 8509;
  ERROR_DS_CANT_CREATE_UNDER_SCHEMA = 8510;
  ERROR_DS_INSTALL_NO_SRC_SCH_VERSION = 8511;
  ERROR_DS_INSTALL_NO_SCH_VERSION_IN_INIFILE = 8512;
  ERROR_DS_INVALID_GROUP_TYPE = 8513;
  ERROR_DS_NO_NEST_GLOBALGROUP_IN_MIXEDDOMAIN = 8514;
  ERROR_DS_NO_NEST_LOCALGROUP_IN_MIXEDDOMAIN = 8515;
  ERROR_DS_GLOBAL_CANT_HAVE_LOCAL_MEMBER = 8516;
  ERROR_DS_GLOBAL_CANT_HAVE_UNIVERSAL_MEMBER = 8517;
  ERROR_DS_UNIVERSAL_CANT_HAVE_LOCAL_MEMBER = 8518;
  ERROR_DS_GLOBAL_CANT_HAVE_CROSSDOMAIN_MEMBER = 8519;
  ERROR_DS_LOCAL_CANT_HAVE_CROSSDOMAIN_LOCAL_MEMBER = 8520;
  ERROR_DS_HAVE_PRIMARY_MEMBERS = 8521;
  ERROR_DS_STRING_SD_CONVERSION_FAILED = 8522;
  ERROR_DS_NAMING_MASTER_GC = 8523;
  ERROR_DS_DNS_LOOKUP_FAILURE = 8524;
  ERROR_DS_COULDNT_UPDATE_SPNS = 8525;
  ERROR_DS_CANT_RETRIEVE_SD = 8526;
  ERROR_DS_KEY_NOT_UNIQUE = 8527;
  ERROR_DS_WRONG_LINKED_ATT_SYNTAX = 8528;
  ERROR_DS_SAM_NEED_BOOTKEY_PASSWORD = 8529;
  ERROR_DS_SAM_NEED_BOOTKEY_FLOPPY = 8530;
  ERROR_DS_CANT_START = 8531;
  ERROR_DS_INIT_FAILURE = 8532;
  ERROR_DS_NO_PKT_PRIVACY_ON_CONNECTION = 8533;
  ERROR_DS_SOURCE_DOMAIN_IN_FOREST = 8534;
  ERROR_DS_DESTINATION_DOMAIN_NOT_IN_FOREST = 8535;
  ERROR_DS_DESTINATION_AUDITING_NOT_ENABLED = 8536;
  ERROR_DS_CANT_FIND_DC_FOR_SRC_DOMAIN = 8537;
  ERROR_DS_SRC_OBJ_NOT_GROUP_OR_USER = 8538;
  ERROR_DS_SRC_SID_EXISTS_IN_FOREST = 8539;
  ERROR_DS_SRC_AND_DST_OBJECT_CLASS_MISMATCH = 8540;
  ERROR_SAM_INIT_FAILURE = 8541;
  ERROR_DS_DRA_SCHEMA_INFO_SHIP = 8542;
  ERROR_DS_DRA_SCHEMA_CONFLICT = 8543;
  ERROR_DS_DRA_EARLIER_SCHEMA_CONFLICT = 8544;
  ERROR_DS_DRA_OBJ_NC_MISMATCH = 8545;
  ERROR_DS_NC_STILL_HAS_DSAS = 8546;
  ERROR_DS_GC_REQUIRED = 8547;
  ERROR_DS_LOCAL_MEMBER_OF_LOCAL_ONLY = 8548;
  ERROR_DS_NO_FPO_IN_UNIVERSAL_GROUPS = 8549;
  ERROR_DS_CANT_ADD_TO_GC = 8550;
  ERROR_DS_NO_CHECKPOINT_WITH_PDC = 8551;
  ERROR_DS_SOURCE_AUDITING_NOT_ENABLED = 8552;
  ERROR_DS_CANT_CREATE_IN_NONDOMAIN_NC = 8553;
  ERROR_DS_INVALID_NAME_FOR_SPN = 8554;
  ERROR_DS_FILTER_USES_CONTRUCTED_ATTRS = 8555;
  ERROR_DS_UNICODEPWD_NOT_IN_QUOTES = 8556;
  ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED = 8557;
  ERROR_DS_MUST_BE_RUN_ON_DST_DC = 8558;
  ERROR_DS_SRC_DC_MUST_BE_SP4_OR_GREATER = 8559;
  ERROR_DS_CANT_TREE_DELETE_CRITICAL_OBJ = 8560;
  ERROR_DS_INIT_FAILURE_CONSOLE = 8561;
  ERROR_DS_SAM_INIT_FAILURE_CONSOLE = 8562;
  ERROR_DS_FOREST_VERSION_TOO_HIGH = 8563;
  ERROR_DS_DOMAIN_VERSION_TOO_HIGH = 8564;
  ERROR_DS_FOREST_VERSION_TOO_LOW = 8565;
  ERROR_DS_DOMAIN_VERSION_TOO_LOW = 8566;
  ERROR_DS_INCOMPATIBLE_VERSION = 8567;
  ERROR_DS_LOW_DSA_VERSION = 8568;
  ERROR_DS_NO_BEHAVIOR_VERSION_IN_MIXEDDOMAIN = 8569;
  ERROR_DS_NOT_SUPPORTED_SORT_ORDER = 8570;
  ERROR_DS_NAME_NOT_UNIQUE = 8571;
  ERROR_DS_MACHINE_ACCOUNT_CREATED_PRENT4 = 8572;
  ERROR_DS_OUT_OF_VERSION_STORE = 8573;
  ERROR_DS_INCOMPATIBLE_CONTROLS_USED = 8574;
  ERROR_DS_NO_REF_DOMAIN = 8575;
  ERROR_DS_RESERVED_LINK_ID = 8576;
  ERROR_DS_LINK_ID_NOT_AVAILABLE = 8577;
  ERROR_DS_AG_CANT_HAVE_UNIVERSAL_MEMBER = 8578;
  ERROR_DS_MODIFYDN_DISALLOWED_BY_INSTANCE_TYPE = 8579;
  ERROR_DS_NO_OBJECT_MOVE_IN_SCHEMA_NC = 8580;
  ERROR_DS_MODIFYDN_DISALLOWED_BY_FLAG = 8581;
  ERROR_DS_MODIFYDN_WRONG_GRANDPARENT = 8582;
  ERROR_DS_NAME_ERROR_TRUST_REFERRAL = 8583;
  ERROR_NOT_SUPPORTED_ON_STANDARD_SERVER = 8584;
  ERROR_DS_CANT_ACCESS_REMOTE_PART_OF_AD = 8585;
  ERROR_DS_CR_IMPOSSIBLE_TO_VALIDATE_V2 = 8586;
  ERROR_DS_THREAD_LIMIT_EXCEEDED = 8587;
  ERROR_DS_NOT_CLOSEST = 8588;
  ERROR_DS_CANT_DERIVE_SPN_WITHOUT_SERVER_REF = 8589;
  ERROR_DS_SINGLE_USER_MODE_FAILED = 8590;
  ERROR_DS_NTDSCRIPT_SYNTAX_ERROR = 8591;
  ERROR_DS_NTDSCRIPT_PROCESS_ERROR = 8592;
  ERROR_DS_DIFFERENT_REPL_EPOCHS = 8593;
  ERROR_DS_DRS_EXTENSIONS_CHANGED = 8594;
  ERROR_DS_REPLICA_SET_CHANGE_NOT_ALLOWED_ON_DISABLED_CR = 8595;
  ERROR_DS_NO_MSDS_INTID = 8596;
  ERROR_DS_DUP_MSDS_INTID = 8597;
  ERROR_DS_EXISTS_IN_RDNATTID = 8598;
  ERROR_DS_AUTHORIZATION_FAILED = 8599;
  ERROR_DS_INVALID_SCRIPT = 8600;
  ERROR_DS_REMOTE_CROSSREF_OP_FAILED = 8601;
  ERROR_DS_CROSS_REF_BUSY = 8602;
  ERROR_DS_CANT_DERIVE_SPN_FOR_DELETED_DOMAIN = 8603;
  ERROR_DS_CANT_DEMOTE_WITH_WRITEABLE_NC = 8604;
  ERROR_DS_DUPLICATE_ID_FOUND = 8605;
  ERROR_DS_INSUFFICIENT_ATTR_TO_CREATE_OBJECT = 8606;
  ERROR_DS_GROUP_CONVERSION_ERROR = 8607;
  ERROR_DS_CANT_MOVE_APP_BASIC_GROUP = 8608;
  ERROR_DS_CANT_MOVE_APP_QUERY_GROUP = 8609;
  ERROR_DS_ROLE_NOT_VERIFIED = 8610;
  ERROR_DS_WKO_CONTAINER_CANNOT_BE_SPECIAL = 8611;
  ERROR_DS_DOMAIN_RENAME_IN_PROGRESS = 8612;
  ERROR_DS_EXISTING_AD_CHILD_NC = 8613;
  ERROR_DS_REPL_LIFETIME_EXCEEDED = 8614;
  ERROR_DS_DISALLOWED_IN_SYSTEM_CONTAINER = 8615;
  ERROR_DS_LDAP_SEND_QUEUE_FULL = 8616;
  ERROR_DS_DRA_OUT_SCHEDULE_WINDOW = 8617;
  DNS_ERROR_RESPONSE_CODES_BASE = 9000;
  DNS_ERROR_RCODE_NO_ERROR = 0;
  DNS_ERROR_MASK = $00002328;
  DNS_ERROR_RCODE_FORMAT_ERROR = 9001;
  DNS_ERROR_RCODE_SERVER_FAILURE = 9002;
  DNS_ERROR_RCODE_NAME_ERROR = 9003;
  DNS_ERROR_RCODE_NOT_IMPLEMENTED = 9004;
  DNS_ERROR_RCODE_REFUSED = 9005;
  DNS_ERROR_RCODE_YXDOMAIN = 9006;
  DNS_ERROR_RCODE_YXRRSET = 9007;
  DNS_ERROR_RCODE_NXRRSET = 9008;
  DNS_ERROR_RCODE_NOTAUTH = 9009;
  DNS_ERROR_RCODE_NOTZONE = 9010;
  DNS_ERROR_RCODE_BADSIG = 9016;
  DNS_ERROR_RCODE_BADKEY = 9017;
  DNS_ERROR_RCODE_BADTIME = 9018;
  DNS_ERROR_RCODE_LAST = DNS_ERROR_RCODE_BADTIME;
  DNS_ERROR_PACKET_FMT_BASE = 9500;
  DNS_INFO_NO_RECORDS = 9501;
  DNS_ERROR_BAD_PACKET = 9502;
  DNS_ERROR_NO_PACKET = 9503;
  DNS_ERROR_RCODE = 9504;
  DNS_ERROR_UNSECURE_PACKET = 9505;
  DNS_STATUS_PACKET_UNSECURE = DNS_ERROR_UNSECURE_PACKET;
  DNS_ERROR_NO_MEMORY = ERROR_OUTOFMEMORY;
  DNS_ERROR_INVALID_NAME = ERROR_INVALID_NAME;
  DNS_ERROR_INVALID_DATA = ERROR_INVALID_DATA;
  DNS_ERROR_GENERAL_API_BASE = 9550;
  DNS_ERROR_INVALID_TYPE = 9551;
  DNS_ERROR_INVALID_IP_ADDRESS = 9552;
  DNS_ERROR_INVALID_PROPERTY = 9553;
  DNS_ERROR_TRY_AGAIN_LATER = 9554;
  DNS_ERROR_NOT_UNIQUE = 9555;
  DNS_ERROR_NON_RFC_NAME = 9556;
  DNS_STATUS_FQDN = 9557;
  DNS_STATUS_DOTTED_NAME = 9558;
  DNS_STATUS_SINGLE_PART_NAME = 9559;
  DNS_ERROR_INVALID_NAME_CHAR = 9560;
  DNS_ERROR_NUMERIC_NAME = 9561;
  DNS_ERROR_NOT_ALLOWED_ON_ROOT_SERVER = 9562;
  DNS_ERROR_NOT_ALLOWED_UNDER_DELEGATION = 9563;
  DNS_ERROR_CANNOT_FIND_ROOT_HINTS = 9564;
  DNS_ERROR_INCONSISTENT_ROOT_HINTS = 9565;
  DNS_ERROR_ZONE_BASE = 9600;
  DNS_ERROR_ZONE_DOES_NOT_EXIST = 9601;
  DNS_ERROR_NO_ZONE_INFO = 9602;
  DNS_ERROR_INVALID_ZONE_OPERATION = 9603;
  DNS_ERROR_ZONE_CONFIGURATION_ERROR = 9604;
  DNS_ERROR_ZONE_HAS_NO_SOA_RECORD = 9605;
  DNS_ERROR_ZONE_HAS_NO_NS_RECORDS = 9606;
  DNS_ERROR_ZONE_LOCKED = 9607;
  DNS_ERROR_ZONE_CREATION_FAILED = 9608;
  DNS_ERROR_ZONE_ALREADY_EXISTS = 9609;
  DNS_ERROR_AUTOZONE_ALREADY_EXISTS = 9610;
  DNS_ERROR_INVALID_ZONE_TYPE = 9611;
  DNS_ERROR_SECONDARY_REQUIRES_MASTER_IP = 9612;
  DNS_ERROR_ZONE_NOT_SECONDARY = 9613;
  DNS_ERROR_NEED_SECONDARY_ADDRESSES = 9614;
  DNS_ERROR_WINS_INIT_FAILED = 9615;
  DNS_ERROR_NEED_WINS_SERVERS = 9616;
  DNS_ERROR_NBSTAT_INIT_FAILED = 9617;
  DNS_ERROR_SOA_DELETE_INVALID = 9618;
  DNS_ERROR_FORWARDER_ALREADY_EXISTS = 9619;
  DNS_ERROR_ZONE_REQUIRES_MASTER_IP = 9620;
  DNS_ERROR_ZONE_IS_SHUTDOWN = 9621;
  DNS_ERROR_DATAFILE_BASE = 9650;
  DNS_ERROR_PRIMARY_REQUIRES_DATAFILE = 9651;
  DNS_ERROR_INVALID_DATAFILE_NAME = 9652;
  DNS_ERROR_DATAFILE_OPEN_FAILURE = 9653;
  DNS_ERROR_FILE_WRITEBACK_FAILED = 9654;
  DNS_ERROR_DATAFILE_PARSING = 9655;
  DNS_ERROR_DATABASE_BASE = 9700;
  DNS_ERROR_RECORD_DOES_NOT_EXIST = 9701;
  DNS_ERROR_RECORD_FORMAT = 9702;
  DNS_ERROR_NODE_CREATION_FAILED = 9703;
  DNS_ERROR_UNKNOWN_RECORD_TYPE = 9704;
  DNS_ERROR_RECORD_TIMED_OUT = 9705;
  DNS_ERROR_NAME_NOT_IN_ZONE = 9706;
  DNS_ERROR_CNAME_LOOP = 9707;
  DNS_ERROR_NODE_IS_CNAME = 9708;
  DNS_ERROR_CNAME_COLLISION = 9709;
  DNS_ERROR_RECORD_ONLY_AT_ZONE_ROOT = 9710;
  DNS_ERROR_RECORD_ALREADY_EXISTS = 9711;
  DNS_ERROR_SECONDARY_DATA = 9712;
  DNS_ERROR_NO_CREATE_CACHE_DATA = 9713;
  DNS_ERROR_NAME_DOES_NOT_EXIST = 9714;
  DNS_WARNING_PTR_CREATE_FAILED = 9715;
  DNS_WARNING_DOMAIN_UNDELETED = 9716;
  DNS_ERROR_DS_UNAVAILABLE = 9717;
  DNS_ERROR_DS_ZONE_ALREADY_EXISTS = 9718;
  DNS_ERROR_NO_BOOTFILE_IF_DS_ZONE = 9719;
  DNS_ERROR_OPERATION_BASE = 9750;
  DNS_INFO_AXFR_COMPLETE = 9751;
  DNS_ERROR_AXFR = 9752;
  DNS_INFO_ADDED_LOCAL_WINS = 9753;
  DNS_ERROR_SECURE_BASE = 9800;
  DNS_STATUS_CONTINUE_NEEDED = 9801;
  DNS_ERROR_SETUP_BASE = 9850;
  DNS_ERROR_NO_TCPIP = 9851;
  DNS_ERROR_NO_DNS_SERVERS = 9852;
  DNS_ERROR_DP_BASE = 9900;
  DNS_ERROR_DP_DOES_NOT_EXIST = 9901;
  DNS_ERROR_DP_ALREADY_EXISTS = 9902;
  DNS_ERROR_DP_NOT_ENLISTED = 9903;
  DNS_ERROR_DP_ALREADY_ENLISTED = 9904;
  DNS_ERROR_DP_NOT_AVAILABLE = 9905;
  DNS_ERROR_DP_FSMO_ERROR = 9906;
  WSABASEERR = 10000;
  WSAEINTR = 10004;
  WSAEBADF = 10009;
  WSAEACCES = 10013;
  WSAEFAULT = 10014;
  WSAEINVAL = 10022;
  WSAEMFILE = 10024;
  WSAEWOULDBLOCK = 10035;
  WSAEINPROGRESS = 10036;
  WSAEALREADY = 10037;
  WSAENOTSOCK = 10038;
  WSAEDESTADDRREQ = 10039;
  WSAEMSGSIZE = 10040;
  WSAEPROTOTYPE = 10041;
  WSAENOPROTOOPT = 10042;
  WSAEPROTONOSUPPORT = 10043;
  WSAESOCKTNOSUPPORT = 10044;
  WSAEOPNOTSUPP = 10045;
  WSAEPFNOSUPPORT = 10046;
  WSAEAFNOSUPPORT = 10047;
  WSAEADDRINUSE = 10048;
  WSAEADDRNOTAVAIL = 10049;
  WSAENETDOWN = 10050;
  WSAENETUNREACH = 10051;
  WSAENETRESET = 10052;
  WSAECONNABORTED = 10053;
  WSAECONNRESET = 10054;
  WSAENOBUFS = 10055;
  WSAEISCONN = 10056;
  WSAENOTCONN = 10057;
  WSAESHUTDOWN = 10058;
  WSAETOOMANYREFS = 10059;
  WSAETIMEDOUT = 10060;
  WSAECONNREFUSED = 10061;
  WSAELOOP = 10062;
  WSAENAMETOOLONG = 10063;
  WSAEHOSTDOWN = 10064;
  WSAEHOSTUNREACH = 10065;
  WSAENOTEMPTY = 10066;
  WSAEPROCLIM = 10067;
  WSAEUSERS = 10068;
  WSAEDQUOT = 10069;
  WSAESTALE = 10070;
  WSAEREMOTE = 10071;
  WSASYSNOTREADY = 10091;
  WSAVERNOTSUPPORTED = 10092;
  WSANOTINITIALISED = 10093;
  WSAEDISCON = 10101;
  WSAENOMORE = 10102;
  WSAECANCELLED = 10103;
  WSAEINVALIDPROCTABLE = 10104;
  WSAEINVALIDPROVIDER = 10105;
  WSAEPROVIDERFAILEDINIT = 10106;
  WSASYSCALLFAILURE = 10107;
  WSASERVICE_NOT_FOUND = 10108;
  WSATYPE_NOT_FOUND = 10109;
  WSA_E_NO_MORE = 10110;
  WSA_E_CANCELLED = 10111;
  WSAEREFUSED = 10112;
  WSAHOST_NOT_FOUND = 11001;
  WSATRY_AGAIN = 11002;
  WSANO_RECOVERY = 11003;
  WSANO_DATA = 11004;
  WSA_QOS_RECEIVERS = 11005;
  WSA_QOS_SENDERS = 11006;
  WSA_QOS_NO_SENDERS = 11007;
  WSA_QOS_NO_RECEIVERS = 11008;
  WSA_QOS_REQUEST_CONFIRMED = 11009;
  WSA_QOS_ADMISSION_FAILURE = 11010;
  WSA_QOS_POLICY_FAILURE = 11011;
  WSA_QOS_BAD_STYLE = 11012;
  WSA_QOS_BAD_OBJECT = 11013;
  WSA_QOS_TRAFFIC_CTRL_ERROR = 11014;
  WSA_QOS_GENERIC_ERROR = 11015;
  WSA_QOS_ESERVICETYPE = 11016;
  WSA_QOS_EFLOWSPEC = 11017;
  WSA_QOS_EPROVSPECBUF = 11018;
  WSA_QOS_EFILTERSTYLE = 11019;
  WSA_QOS_EFILTERTYPE = 11020;
  WSA_QOS_EFILTERCOUNT = 11021;
  WSA_QOS_EOBJLENGTH = 11022;
  WSA_QOS_EFLOWCOUNT = 11023;
  WSA_QOS_EUNKNOWNPSOBJ = 11024;
  WSA_QOS_EPOLICYOBJ = 11025;
  WSA_QOS_EFLOWDESC = 11026;
  WSA_QOS_EPSFLOWSPEC = 11027;
  WSA_QOS_EPSFILTERSPEC = 11028;
  WSA_QOS_ESDMODEOBJ = 11029;
  WSA_QOS_ESHAPERATEOBJ = 11030;
  WSA_QOS_RESERVED_PETYPE = 11031;
  ERROR_SXS_SECTION_NOT_FOUND = 14000;
  ERROR_SXS_CANT_GEN_ACTCTX = 14001;
  ERROR_SXS_INVALID_ACTCTXDATA_FORMAT = 14002;
  ERROR_SXS_ASSEMBLY_NOT_FOUND = 14003;
  ERROR_SXS_MANIFEST_FORMAT_ERROR = 14004;
  ERROR_SXS_MANIFEST_PARSE_ERROR = 14005;
  ERROR_SXS_ACTIVATION_CONTEXT_DISABLED = 14006;
  ERROR_SXS_KEY_NOT_FOUND = 14007;
  ERROR_SXS_VERSION_CONFLICT = 14008;
  ERROR_SXS_WRONG_SECTION_TYPE = 14009;
  ERROR_SXS_THREAD_QUERIES_DISABLED = 14010;
  ERROR_SXS_PROCESS_DEFAULT_ALREADY_SET = 14011;
  ERROR_SXS_UNKNOWN_ENCODING_GROUP = 14012;
  ERROR_SXS_UNKNOWN_ENCODING = 14013;
  ERROR_SXS_INVALID_XML_NAMESPACE_URI = 14014;
  ERROR_SXS_ROOT_MANIFEST_DEPENDENCY_NOT_INSTALLED = 14015;
  ERROR_SXS_LEAF_MANIFEST_DEPENDENCY_NOT_INSTALLED = 14016;
  ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE = 14017;
  ERROR_SXS_MANIFEST_MISSING_REQUIRED_DEFAULT_NAMESPACE = 14018;
  ERROR_SXS_MANIFEST_INVALID_REQUIRED_DEFAULT_NAMESPACE = 14019;
  ERROR_SXS_PRIVATE_MANIFEST_CROSS_PATH_WITH_REPARSE_POINT = 14020;
  ERROR_SXS_DUPLICATE_DLL_NAME = 14021;
  ERROR_SXS_DUPLICATE_WINDOWCLASS_NAME = 14022;
  ERROR_SXS_DUPLICATE_CLSID = 14023;
  ERROR_SXS_DUPLICATE_IID = 14024;
  ERROR_SXS_DUPLICATE_TLBID = 14025;
  ERROR_SXS_DUPLICATE_PROGID = 14026;
  ERROR_SXS_DUPLICATE_ASSEMBLY_NAME = 14027;
  ERROR_SXS_FILE_HASH_MISMATCH = 14028;
  ERROR_SXS_POLICY_PARSE_ERROR = 14029;
  ERROR_SXS_XML_E_MISSINGQUOTE = 14030;
  ERROR_SXS_XML_E_COMMENTSYNTAX = 14031;
  ERROR_SXS_XML_E_BADSTARTNAMECHAR = 14032;
  ERROR_SXS_XML_E_BADNAMECHAR = 14033;
  ERROR_SXS_XML_E_BADCHARINSTRING = 14034;
  ERROR_SXS_XML_E_XMLDECLSYNTAX = 14035;
  ERROR_SXS_XML_E_BADCHARDATA = 14036;
  ERROR_SXS_XML_E_MISSINGWHITESPACE = 14037;
  ERROR_SXS_XML_E_EXPECTINGTAGEND = 14038;
  ERROR_SXS_XML_E_MISSINGSEMICOLON = 14039;
  ERROR_SXS_XML_E_UNBALANCEDPAREN = 14040;
  ERROR_SXS_XML_E_INTERNALERROR = 14041;
  ERROR_SXS_XML_E_UNEXPECTED_WHITESPACE = 14042;
  ERROR_SXS_XML_E_INCOMPLETE_ENCODING = 14043;
  ERROR_SXS_XML_E_MISSING_PAREN = 14044;
  ERROR_SXS_XML_E_EXPECTINGCLOSEQUOTE = 14045;
  ERROR_SXS_XML_E_MULTIPLE_COLONS = 14046;
  ERROR_SXS_XML_E_INVALID_DECIMAL = 14047;
  ERROR_SXS_XML_E_INVALID_HEXIDECIMAL = 14048;
  ERROR_SXS_XML_E_INVALID_UNICODE = 14049;
  ERROR_SXS_XML_E_WHITESPACEORQUESTIONMARK = 14050;
  ERROR_SXS_XML_E_UNEXPECTEDENDTAG = 14051;
  ERROR_SXS_XML_E_UNCLOSEDTAG = 14052;
  ERROR_SXS_XML_E_DUPLICATEATTRIBUTE = 14053;
  ERROR_SXS_XML_E_MULTIPLEROOTS = 14054;
  ERROR_SXS_XML_E_INVALIDATROOTLEVEL = 14055;
  ERROR_SXS_XML_E_BADXMLDECL = 14056;
  ERROR_SXS_XML_E_MISSINGROOT = 14057;
  ERROR_SXS_XML_E_UNEXPECTEDEOF = 14058;
  ERROR_SXS_XML_E_BADPEREFINSUBSET = 14059;
  ERROR_SXS_XML_E_UNCLOSEDSTARTTAG = 14060;
  ERROR_SXS_XML_E_UNCLOSEDENDTAG = 14061;
  ERROR_SXS_XML_E_UNCLOSEDSTRING = 14062;
  ERROR_SXS_XML_E_UNCLOSEDCOMMENT = 14063;
  ERROR_SXS_XML_E_UNCLOSEDDECL = 14064;
  ERROR_SXS_XML_E_UNCLOSEDCDATA = 14065;
  ERROR_SXS_XML_E_RESERVEDNAMESPACE = 14066;
  ERROR_SXS_XML_E_INVALIDENCODING = 14067;
  ERROR_SXS_XML_E_INVALIDSWITCH = 14068;
  ERROR_SXS_XML_E_BADXMLCASE = 14069;
  ERROR_SXS_XML_E_INVALID_STANDALONE = 14070;
  ERROR_SXS_XML_E_UNEXPECTED_STANDALONE = 14071;
  ERROR_SXS_XML_E_INVALID_VERSION = 14072;
  ERROR_SXS_XML_E_MISSINGEQUALS = 14073;
  ERROR_SXS_PROTECTION_RECOVERY_FAILED = 14074;
  ERROR_SXS_PROTECTION_PUBLIC_KEY_TOO_SHORT = 14075;
  ERROR_SXS_PROTECTION_CATALOG_NOT_VALID = 14076;
  ERROR_SXS_UNTRANSLATABLE_HRESULT = 14077;
  ERROR_SXS_PROTECTION_CATALOG_FILE_MISSING = 14078;
  ERROR_SXS_MISSING_ASSEMBLY_IDENTITY_ATTRIBUTE = 14079;
  ERROR_SXS_INVALID_ASSEMBLY_IDENTITY_ATTRIBUTE_NAME = 14080;
  ERROR_IPSEC_QM_POLICY_EXISTS = 13000;
  ERROR_IPSEC_QM_POLICY_NOT_FOUND = 13001;
  ERROR_IPSEC_QM_POLICY_IN_USE = 13002;
  ERROR_IPSEC_MM_POLICY_EXISTS = 13003;
  ERROR_IPSEC_MM_POLICY_NOT_FOUND = 13004;
  ERROR_IPSEC_MM_POLICY_IN_USE = 13005;
  ERROR_IPSEC_MM_FILTER_EXISTS = 13006;
  ERROR_IPSEC_MM_FILTER_NOT_FOUND = 13007;
  ERROR_IPSEC_TRANSPORT_FILTER_EXISTS = 13008;
  ERROR_IPSEC_TRANSPORT_FILTER_NOT_FOUND = 13009;
  ERROR_IPSEC_MM_AUTH_EXISTS = 13010;
  ERROR_IPSEC_MM_AUTH_NOT_FOUND = 13011;
  ERROR_IPSEC_MM_AUTH_IN_USE = 13012;
  ERROR_IPSEC_DEFAULT_MM_POLICY_NOT_FOUND = 13013;
  ERROR_IPSEC_DEFAULT_MM_AUTH_NOT_FOUND = 13014;
  ERROR_IPSEC_DEFAULT_QM_POLICY_NOT_FOUND = 13015;
  ERROR_IPSEC_TUNNEL_FILTER_EXISTS = 13016;
  ERROR_IPSEC_TUNNEL_FILTER_NOT_FOUND = 13017;
  ERROR_IPSEC_MM_FILTER_PENDING_DELETION = 13018;
  ERROR_IPSEC_TRANSPORT_FILTER_PENDING_DELETION = 13019;
  ERROR_IPSEC_TUNNEL_FILTER_PENDING_DELETION = 13020;
  ERROR_IPSEC_MM_POLICY_PENDING_DELETION = 13021;
  ERROR_IPSEC_MM_AUTH_PENDING_DELETION = 13022;
  ERROR_IPSEC_QM_POLICY_PENDING_DELETION = 13023;
  WARNING_IPSEC_MM_POLICY_PRUNED = 13024;
  WARNING_IPSEC_QM_POLICY_PRUNED = 13025;
  ERROR_IPSEC_IKE_NEG_STATUS_BEGIN = 13800;
  ERROR_IPSEC_IKE_AUTH_FAIL = 13801;
  ERROR_IPSEC_IKE_ATTRIB_FAIL = 13802;
  ERROR_IPSEC_IKE_NEGOTIATION_PENDING = 13803;
  ERROR_IPSEC_IKE_GENERAL_PROCESSING_ERROR = 13804;
  ERROR_IPSEC_IKE_TIMED_OUT = 13805;
  ERROR_IPSEC_IKE_NO_CERT = 13806;
  ERROR_IPSEC_IKE_SA_DELETED = 13807;
  ERROR_IPSEC_IKE_SA_REAPED = 13808;
  ERROR_IPSEC_IKE_MM_ACQUIRE_DROP = 13809;
  ERROR_IPSEC_IKE_QM_ACQUIRE_DROP = 13810;
  ERROR_IPSEC_IKE_QUEUE_DROP_MM = 13811;
  ERROR_IPSEC_IKE_QUEUE_DROP_NO_MM = 13812;
  ERROR_IPSEC_IKE_DROP_NO_RESPONSE = 13813;
  ERROR_IPSEC_IKE_MM_DELAY_DROP = 13814;
  ERROR_IPSEC_IKE_QM_DELAY_DROP = 13815;
  ERROR_IPSEC_IKE_ERROR = 13816;
  ERROR_IPSEC_IKE_CRL_FAILED = 13817;
  ERROR_IPSEC_IKE_INVALID_KEY_USAGE = 13818;
  ERROR_IPSEC_IKE_INVALID_CERT_TYPE = 13819;
  ERROR_IPSEC_IKE_NO_PRIVATE_KEY = 13820;
  ERROR_IPSEC_IKE_DH_FAIL = 13822;
  ERROR_IPSEC_IKE_INVALID_HEADER = 13824;
  ERROR_IPSEC_IKE_NO_POLICY = 13825;
  ERROR_IPSEC_IKE_INVALID_SIGNATURE = 13826;
  ERROR_IPSEC_IKE_KERBEROS_ERROR = 13827;
  ERROR_IPSEC_IKE_NO_PUBLIC_KEY = 13828;
  ERROR_IPSEC_IKE_PROCESS_ERR = 13829;
  ERROR_IPSEC_IKE_PROCESS_ERR_SA = 13830;
  ERROR_IPSEC_IKE_PROCESS_ERR_PROP = 13831;
  ERROR_IPSEC_IKE_PROCESS_ERR_TRANS = 13832;
  ERROR_IPSEC_IKE_PROCESS_ERR_KE = 13833;
  ERROR_IPSEC_IKE_PROCESS_ERR_ID = 13834;
  ERROR_IPSEC_IKE_PROCESS_ERR_CERT = 13835;
  ERROR_IPSEC_IKE_PROCESS_ERR_CERT_REQ = 13836;
  ERROR_IPSEC_IKE_PROCESS_ERR_HASH = 13837;
  ERROR_IPSEC_IKE_PROCESS_ERR_SIG = 13838;
  ERROR_IPSEC_IKE_PROCESS_ERR_NONCE = 13839;
  ERROR_IPSEC_IKE_PROCESS_ERR_NOTIFY = 13840;
  ERROR_IPSEC_IKE_PROCESS_ERR_DELETE = 13841;
  ERROR_IPSEC_IKE_PROCESS_ERR_VENDOR = 13842;
  ERROR_IPSEC_IKE_INVALID_PAYLOAD = 13843;
  ERROR_IPSEC_IKE_LOAD_SOFT_SA = 13844;
  ERROR_IPSEC_IKE_SOFT_SA_TORN_DOWN = 13845;
  ERROR_IPSEC_IKE_INVALID_COOKIE = 13846;
  ERROR_IPSEC_IKE_NO_PEER_CERT = 13847;
  ERROR_IPSEC_IKE_PEER_CRL_FAILED = 13848;
  ERROR_IPSEC_IKE_POLICY_CHANGE = 13849;
  ERROR_IPSEC_IKE_NO_MM_POLICY = 13850;
  ERROR_IPSEC_IKE_NOTCBPRIV = 13851;
  ERROR_IPSEC_IKE_SECLOADFAIL = 13852;
  ERROR_IPSEC_IKE_FAILSSPINIT = 13853;
  ERROR_IPSEC_IKE_FAILQUERYSSP = 13854;
  ERROR_IPSEC_IKE_SRVACQFAIL = 13855;
  ERROR_IPSEC_IKE_SRVQUERYCRED = 13856;
  ERROR_IPSEC_IKE_GETSPIFAIL = 13857;
  ERROR_IPSEC_IKE_INVALID_FILTER = 13858;
  ERROR_IPSEC_IKE_OUT_OF_MEMORY = 13859;
  ERROR_IPSEC_IKE_ADD_UPDATE_KEY_FAILED = 13860;
  ERROR_IPSEC_IKE_INVALID_POLICY = 13861;
  ERROR_IPSEC_IKE_UNKNOWN_DOI = 13862;
  ERROR_IPSEC_IKE_INVALID_SITUATION = 13863;
  ERROR_IPSEC_IKE_DH_FAILURE = 13864;
  ERROR_IPSEC_IKE_INVALID_GROUP = 13865;
  ERROR_IPSEC_IKE_ENCRYPT = 13866;
  ERROR_IPSEC_IKE_DECRYPT = 13867;
  ERROR_IPSEC_IKE_POLICY_MATCH = 13868;
  ERROR_IPSEC_IKE_UNSUPPORTED_ID = 13869;
  ERROR_IPSEC_IKE_INVALID_HASH = 13870;
  ERROR_IPSEC_IKE_INVALID_HASH_ALG = 13871;
  ERROR_IPSEC_IKE_INVALID_HASH_SIZE = 13872;
  ERROR_IPSEC_IKE_INVALID_ENCRYPT_ALG = 13873;
  ERROR_IPSEC_IKE_INVALID_AUTH_ALG = 13874;
  ERROR_IPSEC_IKE_INVALID_SIG = 13875;
  ERROR_IPSEC_IKE_LOAD_FAILED = 13876;
  ERROR_IPSEC_IKE_RPC_DELETE = 13877;
  ERROR_IPSEC_IKE_BENIGN_REINIT = 13878;
  ERROR_IPSEC_IKE_INVALID_RESPONDER_LIFETIME_NOTIFY = 13879;
  ERROR_IPSEC_IKE_INVALID_CERT_KEYLEN = 13881;
  ERROR_IPSEC_IKE_MM_LIMIT = 13882;
  ERROR_IPSEC_IKE_NEGOTIATION_DISABLED = 13883;
  ERROR_IPSEC_IKE_NEG_STATUS_END = 13884;
  SEVERITY_SUCCESS = 0;
  SEVERITY_ERROR = 1;
  NOERROR = 0;
  E_UNEXPECTED = $8000FFFF;
  E_NOTIMPL = $80004001;
  E_OUTOFMEMORY = $8007000E;
  E_INVALIDARG = $80070057;
  E_NOINTERFACE = $80004002;
  E_POINTER = $80004003;
  E_HANDLE = $80070006;
  E_ABORT = $80004004;
  E_FAIL = $80004005;
  E_ACCESSDENIED = $80070005;
  E_PENDING = $8000000A;
  CO_E_INIT_TLS = $80004006;
  CO_E_INIT_SHARED_ALLOCATOR = $80004007;
  CO_E_INIT_MEMORY_ALLOCATOR = $80004008;
  CO_E_INIT_CLASS_CACHE = $80004009;
  CO_E_INIT_RPC_CHANNEL = $8000400A;
  CO_E_INIT_TLS_SET_CHANNEL_CONTROL = $8000400B;
  CO_E_INIT_TLS_CHANNEL_CONTROL = $8000400C;
  CO_E_INIT_UNACCEPTED_USER_ALLOCATOR = $8000400D;
  CO_E_INIT_SCM_MUTEX_EXISTS = $8000400E;
  CO_E_INIT_SCM_FILE_MAPPING_EXISTS = $8000400F;
  CO_E_INIT_SCM_MAP_VIEW_OF_FILE = $80004010;
  CO_E_INIT_SCM_EXEC_FAILURE = $80004011;
  CO_E_INIT_ONLY_SINGLE_THREADED = $80004012;
  CO_E_CANT_REMOTE = $80004013;
  CO_E_BAD_SERVER_NAME = $80004014;
  CO_E_WRONG_SERVER_IDENTITY = $80004015;
  CO_E_OLE1DDE_DISABLED = $80004016;
  CO_E_RUNAS_SYNTAX = $80004017;
  CO_E_CREATEPROCESS_FAILURE = $80004018;
  CO_E_RUNAS_CREATEPROCESS_FAILURE = $80004019;
  CO_E_RUNAS_LOGON_FAILURE = $8000401A;
  CO_E_LAUNCH_PERMSSION_DENIED = $8000401B;
  CO_E_START_SERVICE_FAILURE = $8000401C;
  CO_E_REMOTE_COMMUNICATION_FAILURE = $8000401D;
  CO_E_SERVER_START_TIMEOUT = $8000401E;
  CO_E_CLSREG_INCONSISTENT = $8000401F;
  CO_E_IIDREG_INCONSISTENT = $80004020;
  CO_E_NOT_SUPPORTED = $80004021;
  CO_E_RELOAD_DLL = $80004022;
  CO_E_MSI_ERROR = $80004023;
  CO_E_ATTEMPT_TO_CREATE_OUTSIDE_CLIENT_CONTEXT = $80004024;
  CO_E_SERVER_PAUSED = $80004025;
  CO_E_SERVER_NOT_PAUSED = $80004026;
  CO_E_CLASS_DISABLED = $80004027;
  CO_E_CLRNOTAVAILABLE = $80004028;
  CO_E_ASYNC_WORK_REJECTED = $80004029;
  CO_E_SERVER_INIT_TIMEOUT = $8000402A;
  CO_E_NO_SECCTX_IN_ACTIVATE = $8000402B;
  CO_E_TRACKER_CONFIG = $80004030;
  CO_E_THREADPOOL_CONFIG = $80004031;
  CO_E_SXS_CONFIG = $80004032;
  CO_E_MALFORMED_SPN = $80004033;
  S_OK = $00000000;
  S_FALSE = $00000001;
  OLE_E_FIRST = $80040000;
  OLE_E_LAST = $800400FF;
  OLE_S_FIRST = $00040000;
  OLE_S_LAST = $000400FF;
  OLE_E_OLEVERB = $80040000;
  OLE_E_ADVF = $80040001;
  OLE_E_ENUM_NOMORE = $80040002;
  OLE_E_ADVISENOTSUPPORTED = $80040003;
  OLE_E_NOCONNECTION = $80040004;
  OLE_E_NOTRUNNING = $80040005;
  OLE_E_NOCACHE = $80040006;
  OLE_E_BLANK = $80040007;
  OLE_E_CLASSDIFF = $80040008;
  OLE_E_CANT_GETMONIKER = $80040009;
  OLE_E_CANT_BINDTOSOURCE = $8004000A;
  OLE_E_STATIC = $8004000B;
  OLE_E_PROMPTSAVECANCELLED = $8004000C;
  OLE_E_INVALIDRECT = $8004000D;
  OLE_E_WRONGCOMPOBJ = $8004000E;
  OLE_E_INVALIDHWND = $8004000F;
  OLE_E_NOT_INPLACEACTIVE = $80040010;
  OLE_E_CANTCONVERT = $80040011;
  OLE_E_NOSTORAGE = $80040012;
  DV_E_FORMATETC = $80040064;
  DV_E_DVTARGETDEVICE = $80040065;
  DV_E_STGMEDIUM = $80040066;
  DV_E_STATDATA = $80040067;
  DV_E_LINDEX = $80040068;
  DV_E_TYMED = $80040069;
  DV_E_CLIPFORMAT = $8004006A;
  DV_E_DVASPECT = $8004006B;
  DV_E_DVTARGETDEVICE_SIZE = $8004006C;
  DV_E_NOIVIEWOBJECT = $8004006D;
  DRAGDROP_E_FIRST = $80040100;
  DRAGDROP_E_LAST = $8004010F;
  DRAGDROP_S_FIRST = $00040100;
  DRAGDROP_S_LAST = $0004010F;
  DRAGDROP_E_NOTREGISTERED = $80040100;
  DRAGDROP_E_ALREADYREGISTERED = $80040101;
  DRAGDROP_E_INVALIDHWND = $80040102;
  CLASSFACTORY_E_FIRST = $80040110;
  CLASSFACTORY_E_LAST = $8004011F;
  CLASSFACTORY_S_FIRST = $00040110;
  CLASSFACTORY_S_LAST = $0004011F;
  CLASS_E_NOAGGREGATION = $80040110;
  CLASS_E_CLASSNOTAVAILABLE = $80040111;
  CLASS_E_NOTLICENSED = $80040112;
  MARSHAL_E_FIRST = $80040120;
  MARSHAL_E_LAST = $8004012F;
  MARSHAL_S_FIRST = $00040120;
  MARSHAL_S_LAST = $0004012F;
  DATA_E_FIRST = $80040130;
  DATA_E_LAST = $8004013F;
  DATA_S_FIRST = $00040130;
  DATA_S_LAST = $0004013F;
  VIEW_E_FIRST = $80040140;
  VIEW_E_LAST = $8004014F;
  VIEW_S_FIRST = $00040140;
  VIEW_S_LAST = $0004014F;
  VIEW_E_DRAW = $80040140;
  REGDB_E_FIRST = $80040150;
  REGDB_E_LAST = $8004015F;
  REGDB_S_FIRST = $00040150;
  REGDB_S_LAST = $0004015F;
  REGDB_E_READREGDB = $80040150;
  REGDB_E_WRITEREGDB = $80040151;
  REGDB_E_KEYMISSING = $80040152;
  REGDB_E_INVALIDVALUE = $80040153;
  REGDB_E_CLASSNOTREG = $80040154;
  REGDB_E_IIDNOTREG = $80040155;
  REGDB_E_BADTHREADINGMODEL = $80040156;
  CAT_E_FIRST = $80040160;
  CAT_E_LAST = $80040161;
  CAT_E_CATIDNOEXIST = $80040160;
  CAT_E_NODESCRIPTION = $80040161;
  CS_E_FIRST = $80040164;
  CS_E_LAST = $8004016F;
  CS_E_PACKAGE_NOTFOUND = $80040164;
  CS_E_NOT_DELETABLE = $80040165;
  CS_E_CLASS_NOTFOUND = $80040166;
  CS_E_INVALID_VERSION = $80040167;
  CS_E_NO_CLASSSTORE = $80040168;
  CS_E_OBJECT_NOTFOUND = $80040169;
  CS_E_OBJECT_ALREADY_EXISTS = $8004016A;
  CS_E_INVALID_PATH = $8004016B;
  CS_E_NETWORK_ERROR = $8004016C;
  CS_E_ADMIN_LIMIT_EXCEEDED = $8004016D;
  CS_E_SCHEMA_MISMATCH = $8004016E;
  CS_E_INTERNAL_ERROR = $8004016F;
  CACHE_E_FIRST = $80040170;
  CACHE_E_LAST = $8004017F;
  CACHE_S_FIRST = $00040170;
  CACHE_S_LAST = $0004017F;
  CACHE_E_NOCACHE_UPDATED = $80040170;
  OLEOBJ_E_FIRST = $80040180;
  OLEOBJ_E_LAST = $8004018F;
  OLEOBJ_S_FIRST = $00040180;
  OLEOBJ_S_LAST = $0004018F;
  OLEOBJ_E_NOVERBS = $80040180;
  OLEOBJ_E_INVALIDVERB = $80040181;
  CLIENTSITE_E_FIRST = $80040190;
  CLIENTSITE_E_LAST = $8004019F;
  CLIENTSITE_S_FIRST = $00040190;
  CLIENTSITE_S_LAST = $0004019F;
  INPLACE_E_NOTUNDOABLE = $800401A0;
  INPLACE_E_NOTOOLSPACE = $800401A1;
  INPLACE_E_FIRST = $800401A0;
  INPLACE_E_LAST = $800401AF;
  INPLACE_S_FIRST = $000401A0;
  INPLACE_S_LAST = $000401AF;
  ENUM_E_FIRST = $800401B0;
  ENUM_E_LAST = $800401BF;
  ENUM_S_FIRST = $000401B0;
  ENUM_S_LAST = $000401BF;
  CONVERT10_E_FIRST = $800401C0;
  CONVERT10_E_LAST = $800401CF;
  CONVERT10_S_FIRST = $000401C0;
  CONVERT10_S_LAST = $000401CF;
  CONVERT10_E_OLESTREAM_GET = $800401C0;
  CONVERT10_E_OLESTREAM_PUT = $800401C1;
  CONVERT10_E_OLESTREAM_FMT = $800401C2;
  CONVERT10_E_OLESTREAM_BITMAP_TO_DIB = $800401C3;
  CONVERT10_E_STG_FMT = $800401C4;
  CONVERT10_E_STG_NO_STD_STREAM = $800401C5;
  CONVERT10_E_STG_DIB_TO_BITMAP = $800401C6;
  CLIPBRD_E_FIRST = $800401D0;
  CLIPBRD_E_LAST = $800401DF;
  CLIPBRD_S_FIRST = $000401D0;
  CLIPBRD_S_LAST = $000401DF;
  CLIPBRD_E_CANT_OPEN = $800401D0;
  CLIPBRD_E_CANT_EMPTY = $800401D1;
  CLIPBRD_E_CANT_SET = $800401D2;
  CLIPBRD_E_BAD_DATA = $800401D3;
  CLIPBRD_E_CANT_CLOSE = $800401D4;
  MK_E_FIRST = $800401E0;
  MK_E_LAST = $800401EF;
  MK_S_FIRST = $000401E0;
  MK_S_LAST = $000401EF;
  MK_E_CONNECTMANUALLY = $800401E0;
  MK_E_EXCEEDEDDEADLINE = $800401E1;
  MK_E_NEEDGENERIC = $800401E2;
  MK_E_UNAVAILABLE = $800401E3;
  MK_E_SYNTAX = $800401E4;
  MK_E_NOOBJECT = $800401E5;
  MK_E_INVALIDEXTENSION = $800401E6;
  MK_E_INTERMEDIATEINTERFACENOTSUPPORTED = $800401E7;
  MK_E_NOTBINDABLE = $800401E8;
  MK_E_NOTBOUND = $800401E9;
  MK_E_CANTOPENFILE = $800401EA;
  MK_E_MUSTBOTHERUSER = $800401EB;
  MK_E_NOINVERSE = $800401EC;
  MK_E_NOSTORAGE = $800401ED;
  MK_E_NOPREFIX = $800401EE;
  MK_E_ENUMERATION_FAILED = $800401EF;
  CO_E_FIRST = $800401F0;
  CO_E_LAST = $800401FF;
  CO_S_FIRST = $000401F0;
  CO_S_LAST = $000401FF;
  CO_E_NOTINITIALIZED = $800401F0;
  CO_E_ALREADYINITIALIZED = $800401F1;
  CO_E_CANTDETERMINECLASS = $800401F2;
  CO_E_CLASSSTRING = $800401F3;
  CO_E_IIDSTRING = $800401F4;
  CO_E_APPNOTFOUND = $800401F5;
  CO_E_APPSINGLEUSE = $800401F6;
  CO_E_ERRORINAPP = $800401F7;
  CO_E_DLLNOTFOUND = $800401F8;
  CO_E_ERRORINDLL = $800401F9;
  CO_E_WRONGOSFORAPP = $800401FA;
  CO_E_OBJNOTREG = $800401FB;
  CO_E_OBJISREG = $800401FC;
  CO_E_OBJNOTCONNECTED = $800401FD;
  CO_E_APPDIDNTREG = $800401FE;
  CO_E_RELEASED = $800401FF;
  EVENT_E_FIRST = $80040200;
  EVENT_E_LAST = $8004021F;
  EVENT_S_FIRST = $00040200;
  EVENT_S_LAST = $0004021F;
  EVENT_S_SOME_SUBSCRIBERS_FAILED = $00040200;
  EVENT_E_ALL_SUBSCRIBERS_FAILED = $80040201;
  EVENT_S_NOSUBSCRIBERS = $00040202;
  EVENT_E_QUERYSYNTAX = $80040203;
  EVENT_E_QUERYFIELD = $80040204;
  EVENT_E_INTERNALEXCEPTION = $80040205;
  EVENT_E_INTERNALERROR = $80040206;
  EVENT_E_INVALID_PER_USER_SID = $80040207;
  EVENT_E_USER_EXCEPTION = $80040208;
  EVENT_E_TOO_MANY_METHODS = $80040209;
  EVENT_E_MISSING_EVENTCLASS = $8004020A;
  EVENT_E_NOT_ALL_REMOVED = $8004020B;
  EVENT_E_COMPLUS_NOT_INSTALLED = $8004020C;
  EVENT_E_CANT_MODIFY_OR_DELETE_UNCONFIGURED_OBJECT = $8004020D;
  EVENT_E_CANT_MODIFY_OR_DELETE_CONFIGURED_OBJECT = $8004020E;
  EVENT_E_INVALID_EVENT_CLASS_PARTITION = $8004020F;
  EVENT_E_PER_USER_SID_NOT_LOGGED_ON = $80040210;
  XACT_E_FIRST = $8004D000;
  XACT_E_LAST = $8004D029;
  XACT_S_FIRST = $0004D000;
  XACT_S_LAST = $0004D010;
  XACT_E_ALREADYOTHERSINGLEPHASE = $8004D000;
  XACT_E_CANTRETAIN = $8004D001;
  XACT_E_COMMITFAILED = $8004D002;
  XACT_E_COMMITPREVENTED = $8004D003;
  XACT_E_HEURISTICABORT = $8004D004;
  XACT_E_HEURISTICCOMMIT = $8004D005;
  XACT_E_HEURISTICDAMAGE = $8004D006;
  XACT_E_HEURISTICDANGER = $8004D007;
  XACT_E_ISOLATIONLEVEL = $8004D008;
  XACT_E_NOASYNC = $8004D009;
  XACT_E_NOENLIST = $8004D00A;
  XACT_E_NOISORETAIN = $8004D00B;
  XACT_E_NORESOURCE = $8004D00C;
  XACT_E_NOTCURRENT = $8004D00D;
  XACT_E_NOTRANSACTION = $8004D00E;
  XACT_E_NOTSUPPORTED = $8004D00F;
  XACT_E_UNKNOWNRMGRID = $8004D010;
  XACT_E_WRONGSTATE = $8004D011;
  XACT_E_WRONGUOW = $8004D012;
  XACT_E_XTIONEXISTS = $8004D013;
  XACT_E_NOIMPORTOBJECT = $8004D014;
  XACT_E_INVALIDCOOKIE = $8004D015;
  XACT_E_INDOUBT = $8004D016;
  XACT_E_NOTIMEOUT = $8004D017;
  XACT_E_ALREADYINPROGRESS = $8004D018;
  XACT_E_ABORTED = $8004D019;
  XACT_E_LOGFULL = $8004D01A;
  XACT_E_TMNOTAVAILABLE = $8004D01B;
  XACT_E_CONNECTION_DOWN = $8004D01C;
  XACT_E_CONNECTION_DENIED = $8004D01D;
  XACT_E_REENLISTTIMEOUT = $8004D01E;
  XACT_E_TIP_CONNECT_FAILED = $8004D01F;
  XACT_E_TIP_PROTOCOL_ERROR = $8004D020;
  XACT_E_TIP_PULL_FAILED = $8004D021;
  XACT_E_DEST_TMNOTAVAILABLE = $8004D022;
  XACT_E_TIP_DISABLED = $8004D023;
  XACT_E_NETWORK_TX_DISABLED = $8004D024;
  XACT_E_PARTNER_NETWORK_TX_DISABLED = $8004D025;
  XACT_E_XA_TX_DISABLED = $8004D026;
  XACT_E_UNABLE_TO_READ_DTC_CONFIG = $8004D027;
  XACT_E_UNABLE_TO_LOAD_DTC_PROXY = $8004D028;
  XACT_E_ABORTING = $8004D029;
  XACT_E_CLERKNOTFOUND = $8004D080;
  XACT_E_CLERKEXISTS = $8004D081;
  XACT_E_RECOVERYINPROGRESS = $8004D082;
  XACT_E_TRANSACTIONCLOSED = $8004D083;
  XACT_E_INVALIDLSN = $8004D084;
  XACT_E_REPLAYREQUEST = $8004D085;
  XACT_S_ASYNC = $0004D000;
  XACT_S_DEFECT = $0004D001;
  XACT_S_READONLY = $0004D002;
  XACT_S_SOMENORETAIN = $0004D003;
  XACT_S_OKINFORM = $0004D004;
  XACT_S_MADECHANGESCONTENT = $0004D005;
  XACT_S_MADECHANGESINFORM = $0004D006;
  XACT_S_ALLNORETAIN = $0004D007;
  XACT_S_ABORTING = $0004D008;
  XACT_S_SINGLEPHASE = $0004D009;
  XACT_S_LOCALLY_OK = $0004D00A;
  XACT_S_LASTRESOURCEMANAGER = $0004D010;
  CONTEXT_E_FIRST = $8004E000;
  CONTEXT_E_LAST = $8004E02F;
  CONTEXT_S_FIRST = $0004E000;
  CONTEXT_S_LAST = $0004E02F;
  CONTEXT_E_ABORTED = $8004E002;
  CONTEXT_E_ABORTING = $8004E003;
  CONTEXT_E_NOCONTEXT = $8004E004;
  CONTEXT_E_WOULD_DEADLOCK = $8004E005;
  CONTEXT_E_SYNCH_TIMEOUT = $8004E006;
  CONTEXT_E_OLDREF = $8004E007;
  CONTEXT_E_ROLENOTFOUND = $8004E00C;
  CONTEXT_E_TMNOTAVAILABLE = $8004E00F;
  CO_E_ACTIVATIONFAILED = $8004E021;
  CO_E_ACTIVATIONFAILED_EVENTLOGGED = $8004E022;
  CO_E_ACTIVATIONFAILED_CATALOGERROR = $8004E023;
  CO_E_ACTIVATIONFAILED_TIMEOUT = $8004E024;
  CO_E_INITIALIZATIONFAILED = $8004E025;
  CONTEXT_E_NOJIT = $8004E026;
  CONTEXT_E_NOTRANSACTION = $8004E027;
  CO_E_THREADINGMODEL_CHANGED = $8004E028;
  CO_E_NOIISINTRINSICS = $8004E029;
  CO_E_NOCOOKIES = $8004E02A;
  CO_E_DBERROR = $8004E02B;
  CO_E_NOTPOOLED = $8004E02C;
  CO_E_NOTCONSTRUCTED = $8004E02D;
  CO_E_NOSYNCHRONIZATION = $8004E02E;
  CO_E_ISOLEVELMISMATCH = $8004E02F;
  OLE_S_USEREG = $00040000;
  OLE_S_STATIC = $00040001;
  OLE_S_MAC_CLIPFORMAT = $00040002;
  DRAGDROP_S_DROP = $00040100;
  DRAGDROP_S_CANCEL = $00040101;
  DRAGDROP_S_USEDEFAULTCURSORS = $00040102;
  DATA_S_SAMEFORMATETC = $00040130;
  VIEW_S_ALREADY_FROZEN = $00040140;
  CACHE_S_FORMATETC_NOTSUPPORTED = $00040170;
  CACHE_S_SAMECACHE = $00040171;
  CACHE_S_SOMECACHES_NOTUPDATED = $00040172;
  OLEOBJ_S_INVALIDVERB = $00040180;
  OLEOBJ_S_CANNOT_DOVERB_NOW = $00040181;
  OLEOBJ_S_INVALIDHWND = $00040182;
  INPLACE_S_TRUNCATED = $000401A0;
  CONVERT10_S_NO_PRESENTATION = $000401C0;
  MK_S_REDUCED_TO_SELF = $000401E2;
  MK_S_ME = $000401E4;
  MK_S_HIM = $000401E5;
  MK_S_US = $000401E6;
  MK_S_MONIKERALREADYREGISTERED = $000401E7;
  SCHED_S_TASK_READY = $00041300;
  SCHED_S_TASK_RUNNING = $00041301;
  SCHED_S_TASK_DISABLED = $00041302;
  SCHED_S_TASK_HAS_NOT_RUN = $00041303;
  SCHED_S_TASK_NO_MORE_RUNS = $00041304;
  SCHED_S_TASK_NOT_SCHEDULED = $00041305;
  SCHED_S_TASK_TERMINATED = $00041306;
  SCHED_S_TASK_NO_VALID_TRIGGERS = $00041307;
  SCHED_S_EVENT_TRIGGER = $00041308;
  SCHED_E_TRIGGER_NOT_FOUND = $80041309;
  SCHED_E_TASK_NOT_READY = $8004130A;
  SCHED_E_TASK_NOT_RUNNING = $8004130B;
  SCHED_E_SERVICE_NOT_INSTALLED = $8004130C;
  SCHED_E_CANNOT_OPEN_TASK = $8004130D;
  SCHED_E_INVALID_TASK = $8004130E;
  SCHED_E_ACCOUNT_INFORMATION_NOT_SET = $8004130F;
  SCHED_E_ACCOUNT_NAME_NOT_FOUND = $80041310;
  SCHED_E_ACCOUNT_DBASE_CORRUPT = $80041311;
  SCHED_E_NO_SECURITY_SERVICES = $80041312;
  SCHED_E_UNKNOWN_OBJECT_VERSION = $80041313;
  SCHED_E_UNSUPPORTED_ACCOUNT_OPTION = $80041314;
  SCHED_E_SERVICE_NOT_RUNNING = $80041315;
  CO_E_CLASS_CREATE_FAILED = $80080001;
  CO_E_SCM_ERROR = $80080002;
  CO_E_SCM_RPC_FAILURE = $80080003;
  CO_E_BAD_PATH = $80080004;
  CO_E_SERVER_EXEC_FAILURE = $80080005;
  CO_E_OBJSRV_RPC_FAILURE = $80080006;
  MK_E_NO_NORMALIZED = $80080007;
  CO_E_SERVER_STOPPING = $80080008;
  MEM_E_INVALID_ROOT = $80080009;
  MEM_E_INVALID_LINK = $80080010;
  MEM_E_INVALID_SIZE = $80080011;
  CO_S_NOTALLINTERFACES = $00080012;
  CO_S_MACHINENAMENOTFOUND = $00080013;
  DISP_E_UNKNOWNINTERFACE = $80020001;
  DISP_E_MEMBERNOTFOUND = $80020003;
  DISP_E_PARAMNOTFOUND = $80020004;
  DISP_E_TYPEMISMATCH = $80020005;
  DISP_E_UNKNOWNNAME = $80020006;
  DISP_E_NONAMEDARGS = $80020007;
  DISP_E_BADVARTYPE = $80020008;
  DISP_E_EXCEPTION = $80020009;
  DISP_E_OVERFLOW = $8002000A;
  DISP_E_BADINDEX = $8002000B;
  DISP_E_UNKNOWNLCID = $8002000C;
  DISP_E_ARRAYISLOCKED = $8002000D;
  DISP_E_BADPARAMCOUNT = $8002000E;
  DISP_E_PARAMNOTOPTIONAL = $8002000F;
  DISP_E_BADCALLEE = $80020010;
  DISP_E_NOTACOLLECTION = $80020011;
  DISP_E_DIVBYZERO = $80020012;
  DISP_E_BUFFERTOOSMALL = $80020013;
  TYPE_E_BUFFERTOOSMALL = $80028016;
  TYPE_E_FIELDNOTFOUND = $80028017;
  TYPE_E_INVDATAREAD = $80028018;
  TYPE_E_UNSUPFORMAT = $80028019;
  TYPE_E_REGISTRYACCESS = $8002801C;
  TYPE_E_LIBNOTREGISTERED = $8002801D;
  TYPE_E_UNDEFINEDTYPE = $80028027;
  TYPE_E_QUALIFIEDNAMEDISALLOWED = $80028028;
  TYPE_E_INVALIDSTATE = $80028029;
  TYPE_E_WRONGTYPEKIND = $8002802A;
  TYPE_E_ELEMENTNOTFOUND = $8002802B;
  TYPE_E_AMBIGUOUSNAME = $8002802C;
  TYPE_E_NAMECONFLICT = $8002802D;
  TYPE_E_UNKNOWNLCID = $8002802E;
  TYPE_E_DLLFUNCTIONNOTFOUND = $8002802F;
  TYPE_E_BADMODULEKIND = $800288BD;
  TYPE_E_SIZETOOBIG = $800288C5;
  TYPE_E_DUPLICATEID = $800288C6;
  TYPE_E_INVALIDID = $800288CF;
  TYPE_E_TYPEMISMATCH = $80028CA0;
  TYPE_E_OUTOFBOUNDS = $80028CA1;
  TYPE_E_IOERROR = $80028CA2;
  TYPE_E_CANTCREATETMPFILE = $80028CA3;
  TYPE_E_CANTLOADLIBRARY = $80029C4A;
  TYPE_E_INCONSISTENTPROPFUNCS = $80029C83;
  TYPE_E_CIRCULARTYPE = $80029C84;
  STG_E_INVALIDFUNCTION = $80030001;
  STG_E_FILENOTFOUND = $80030002;
  STG_E_PATHNOTFOUND = $80030003;
  STG_E_TOOMANYOPENFILES = $80030004;
  STG_E_ACCESSDENIED = $80030005;
  STG_E_INVALIDHANDLE = $80030006;
  STG_E_INSUFFICIENTMEMORY = $80030008;
  STG_E_INVALIDPOINTER = $80030009;
  STG_E_NOMOREFILES = $80030012;
  STG_E_DISKISWRITEPROTECTED = $80030013;
  STG_E_SEEKERROR = $80030019;
  STG_E_WRITEFAULT = $8003001D;
  STG_E_READFAULT = $8003001E;
  STG_E_SHAREVIOLATION = $80030020;
  STG_E_LOCKVIOLATION = $80030021;
  STG_E_FILEALREADYEXISTS = $80030050;
  STG_E_INVALIDPARAMETER = $80030057;
  STG_E_MEDIUMFULL = $80030070;
  STG_E_PROPSETMISMATCHED = $800300F0;
  STG_E_ABNORMALAPIEXIT = $800300FA;
  STG_E_INVALIDHEADER = $800300FB;
  STG_E_INVALIDNAME = $800300FC;
  STG_E_UNKNOWN = $800300FD;
  STG_E_UNIMPLEMENTEDFUNCTION = $800300FE;
  STG_E_INVALIDFLAG = $800300FF;
  STG_E_INUSE = $80030100;
  STG_E_NOTCURRENT = $80030101;
  STG_E_REVERTED = $80030102;
  STG_E_CANTSAVE = $80030103;
  STG_E_OLDFORMAT = $80030104;
  STG_E_OLDDLL = $80030105;
  STG_E_SHAREREQUIRED = $80030106;
  STG_E_NOTFILEBASEDSTORAGE = $80030107;
  STG_E_EXTANTMARSHALLINGS = $80030108;
  STG_E_DOCFILECORRUPT = $80030109;
  STG_E_BADBASEADDRESS = $80030110;
  STG_E_DOCFILETOOLARGE = $80030111;
  STG_E_NOTSIMPLEFORMAT = $80030112;
  STG_E_INCOMPLETE = $80030201;
  STG_E_TERMINATED = $80030202;
  STG_S_CONVERTED = $00030200;
  STG_S_BLOCK = $00030201;
  STG_S_RETRYNOW = $00030202;
  STG_S_MONITORING = $00030203;
  STG_S_MULTIPLEOPENS = $00030204;
  STG_S_CONSOLIDATIONFAILED = $00030205;
  STG_S_CANNOTCONSOLIDATE = $00030206;
  STG_E_STATUS_COPY_PROTECTION_FAILURE = $80030305;
  STG_E_CSS_AUTHENTICATION_FAILURE = $80030306;
  STG_E_CSS_KEY_NOT_PRESENT = $80030307;
  STG_E_CSS_KEY_NOT_ESTABLISHED = $80030308;
  STG_E_CSS_SCRAMBLED_SECTOR = $80030309;
  STG_E_CSS_REGION_MISMATCH = $8003030A;
  STG_E_RESETS_EXHAUSTED = $8003030B;
  RPC_E_CALL_REJECTED = $80010001;
  RPC_E_CALL_CANCELED = $80010002;
  RPC_E_CANTPOST_INSENDCALL = $80010003;
  RPC_E_CANTCALLOUT_INASYNCCALL = $80010004;
  RPC_E_CANTCALLOUT_INEXTERNALCALL = $80010005;
  RPC_E_CONNECTION_TERMINATED = $80010006;
  RPC_E_SERVER_DIED = $80010007;
  RPC_E_CLIENT_DIED = $80010008;
  RPC_E_INVALID_DATAPACKET = $80010009;
  RPC_E_CANTTRANSMIT_CALL = $8001000A;
  RPC_E_CLIENT_CANTMARSHAL_DATA = $8001000B;
  RPC_E_CLIENT_CANTUNMARSHAL_DATA = $8001000C;
  RPC_E_SERVER_CANTMARSHAL_DATA = $8001000D;
  RPC_E_SERVER_CANTUNMARSHAL_DATA = $8001000E;
  RPC_E_INVALID_DATA = $8001000F;
  RPC_E_INVALID_PARAMETER = $80010010;
  RPC_E_CANTCALLOUT_AGAIN = $80010011;
  RPC_E_SERVER_DIED_DNE = $80010012;
  RPC_E_SYS_CALL_FAILED = $80010100;
  RPC_E_OUT_OF_RESOURCES = $80010101;
  RPC_E_ATTEMPTED_MULTITHREAD = $80010102;
  RPC_E_NOT_REGISTERED = $80010103;
  RPC_E_FAULT = $80010104;
  RPC_E_SERVERFAULT = $80010105;
  RPC_E_CHANGED_MODE = $80010106;
  RPC_E_INVALIDMETHOD = $80010107;
  RPC_E_DISCONNECTED = $80010108;
  RPC_E_RETRY = $80010109;
  RPC_E_SERVERCALL_RETRYLATER = $8001010A;
  RPC_E_SERVERCALL_REJECTED = $8001010B;
  RPC_E_INVALID_CALLDATA = $8001010C;
  RPC_E_CANTCALLOUT_ININPUTSYNCCALL = $8001010D;
  RPC_E_WRONG_THREAD = $8001010E;
  RPC_E_THREAD_NOT_INIT = $8001010F;
  RPC_E_VERSION_MISMATCH = $80010110;
  RPC_E_INVALID_HEADER = $80010111;
  RPC_E_INVALID_EXTENSION = $80010112;
  RPC_E_INVALID_IPID = $80010113;
  RPC_E_INVALID_OBJECT = $80010114;
  RPC_S_CALLPENDING = $80010115;
  RPC_S_WAITONTIMER = $80010116;
  RPC_E_CALL_COMPLETE = $80010117;
  RPC_E_UNSECURE_CALL = $80010118;
  RPC_E_TOO_LATE = $80010119;
  RPC_E_NO_GOOD_SECURITY_PACKAGES = $8001011A;
  RPC_E_ACCESS_DENIED = $8001011B;
  RPC_E_REMOTE_DISABLED = $8001011C;
  RPC_E_INVALID_OBJREF = $8001011D;
  RPC_E_NO_CONTEXT = $8001011E;
  RPC_E_TIMEOUT = $8001011F;
  RPC_E_NO_SYNC = $80010120;
  RPC_E_FULLSIC_REQUIRED = $80010121;
  RPC_E_INVALID_STD_NAME = $80010122;
  CO_E_FAILEDTOIMPERSONATE = $80010123;
  CO_E_FAILEDTOGETSECCTX = $80010124;
  CO_E_FAILEDTOOPENTHREADTOKEN = $80010125;
  CO_E_FAILEDTOGETTOKENINFO = $80010126;
  CO_E_TRUSTEEDOESNTMATCHCLIENT = $80010127;
  CO_E_FAILEDTOQUERYCLIENTBLANKET = $80010128;
  CO_E_FAILEDTOSETDACL = $80010129;
  CO_E_ACCESSCHECKFAILED = $8001012A;
  CO_E_NETACCESSAPIFAILED = $8001012B;
  CO_E_WRONGTRUSTEENAMESYNTAX = $8001012C;
  CO_E_INVALIDSID = $8001012D;
  CO_E_CONVERSIONFAILED = $8001012E;
  CO_E_NOMATCHINGSIDFOUND = $8001012F;
  CO_E_LOOKUPACCSIDFAILED = $80010130;
  CO_E_NOMATCHINGNAMEFOUND = $80010131;
  CO_E_LOOKUPACCNAMEFAILED = $80010132;
  CO_E_SETSERLHNDLFAILED = $80010133;
  CO_E_FAILEDTOGETWINDIR = $80010134;
  CO_E_PATHTOOLONG = $80010135;
  CO_E_FAILEDTOGENUUID = $80010136;
  CO_E_FAILEDTOCREATEFILE = $80010137;
  CO_E_FAILEDTOCLOSEHANDLE = $80010138;
  CO_E_EXCEEDSYSACLLIMIT = $80010139;
  CO_E_ACESINWRONGORDER = $8001013A;
  CO_E_INCOMPATIBLESTREAMVERSION = $8001013B;
  CO_E_FAILEDTOOPENPROCESSTOKEN = $8001013C;
  CO_E_DECODEFAILED = $8001013D;
  CO_E_ACNOTINITIALIZED = $8001013F;
  CO_E_CANCEL_DISABLED = $80010140;
  RPC_E_UNEXPECTED = $8001FFFF;
  ERROR_AUDITING_DISABLED = $C0090001;
  ERROR_ALL_SIDS_FILTERED = $C0090002;
  NTE_BAD_UID = $80090001;
  NTE_BAD_HASH = $80090002;
  NTE_BAD_KEY = $80090003;
  NTE_BAD_LEN = $80090004;
  NTE_BAD_DATA = $80090005;
  NTE_BAD_SIGNATURE = $80090006;
  NTE_BAD_VER = $80090007;
  NTE_BAD_ALGID = $80090008;
  NTE_BAD_FLAGS = $80090009;
  NTE_BAD_TYPE = $8009000A;
  NTE_BAD_KEY_STATE = $8009000B;
  NTE_BAD_HASH_STATE = $8009000C;
  NTE_NO_KEY = $8009000D;
  NTE_NO_MEMORY = $8009000E;
  NTE_EXISTS = $8009000F;
  NTE_PERM = $80090010;
  NTE_NOT_FOUND = $80090011;
  NTE_DOUBLE_ENCRYPT = $80090012;
  NTE_BAD_PROVIDER = $80090013;
  NTE_BAD_PROV_TYPE = $80090014;
  NTE_BAD_PUBLIC_KEY = $80090015;
  NTE_BAD_KEYSET = $80090016;
  NTE_PROV_TYPE_NOT_DEF = $80090017;
  NTE_PROV_TYPE_ENTRY_BAD = $80090018;
  NTE_KEYSET_NOT_DEF = $80090019;
  NTE_KEYSET_ENTRY_BAD = $8009001A;
  NTE_PROV_TYPE_NO_MATCH = $8009001B;
  NTE_SIGNATURE_FILE_BAD = $8009001C;
  NTE_PROVIDER_DLL_FAIL = $8009001D;
  NTE_PROV_DLL_NOT_FOUND = $8009001E;
  NTE_BAD_KEYSET_PARAM = $8009001F;
  NTE_FAIL = $80090020;
  NTE_SYS_ERR = $80090021;
  NTE_SILENT_CONTEXT = $80090022;
  NTE_TOKEN_KEYSET_STORAGE_FULL = $80090023;
  NTE_TEMPORARY_PROFILE = $80090024;
  NTE_FIXEDPARAMETER = $80090025;
  SEC_E_INSUFFICIENT_MEMORY = $80090300;
  SEC_E_INVALID_HANDLE = $80090301;
  SEC_E_UNSUPPORTED_FUNCTION = $80090302;
  SEC_E_TARGET_UNKNOWN = $80090303;
  SEC_E_INTERNAL_ERROR = $80090304;
  SEC_E_SECPKG_NOT_FOUND = $80090305;
  SEC_E_NOT_OWNER = $80090306;
  SEC_E_CANNOT_INSTALL = $80090307;
  SEC_E_INVALID_TOKEN = $80090308;
  SEC_E_CANNOT_PACK = $80090309;
  SEC_E_QOP_NOT_SUPPORTED = $8009030A;
  SEC_E_NO_IMPERSONATION = $8009030B;
  SEC_E_LOGON_DENIED = $8009030C;
  SEC_E_UNKNOWN_CREDENTIALS = $8009030D;
  SEC_E_NO_CREDENTIALS = $8009030E;
  SEC_E_MESSAGE_ALTERED = $8009030F;
  SEC_E_OUT_OF_SEQUENCE = $80090310;
  SEC_E_NO_AUTHENTICATING_AUTHORITY = $80090311;
  SEC_I_CONTINUE_NEEDED = $00090312;
  SEC_I_COMPLETE_NEEDED = $00090313;
  SEC_I_COMPLETE_AND_CONTINUE = $00090314;
  SEC_I_LOCAL_LOGON = $00090315;
  SEC_E_BAD_PKGID = $80090316;
  SEC_E_CONTEXT_EXPIRED = $80090317;
  SEC_I_CONTEXT_EXPIRED = $00090317;
  SEC_E_INCOMPLETE_MESSAGE = $80090318;
  SEC_E_INCOMPLETE_CREDENTIALS = $80090320;
  SEC_E_BUFFER_TOO_SMALL = $80090321;
  SEC_I_INCOMPLETE_CREDENTIALS = $00090320;
  SEC_I_RENEGOTIATE = $00090321;
  SEC_E_WRONG_PRINCIPAL = $80090322;
  SEC_I_NO_LSA_CONTEXT = $00090323;
  SEC_E_TIME_SKEW = $80090324;
  SEC_E_UNTRUSTED_ROOT = $80090325;
  SEC_E_ILLEGAL_MESSAGE = $80090326;
  SEC_E_CERT_UNKNOWN = $80090327;
  SEC_E_CERT_EXPIRED = $80090328;
  SEC_E_ENCRYPT_FAILURE = $80090329;
  SEC_E_DECRYPT_FAILURE = $80090330;
  SEC_E_ALGORITHM_MISMATCH = $80090331;
  SEC_E_SECURITY_QOS_FAILED = $80090332;
  SEC_E_UNFINISHED_CONTEXT_DELETED = $80090333;
  SEC_E_NO_TGT_REPLY = $80090334;
  SEC_E_NO_IP_ADDRESSES = $80090335;
  SEC_E_WRONG_CREDENTIAL_HANDLE = $80090336;
  SEC_E_CRYPTO_SYSTEM_INVALID = $80090337;
  SEC_E_MAX_REFERRALS_EXCEEDED = $80090338;
  SEC_E_MUST_BE_KDC = $80090339;
  SEC_E_STRONG_CRYPTO_NOT_SUPPORTED = $8009033A;
  SEC_E_TOO_MANY_PRINCIPALS = $8009033B;
  SEC_E_NO_PA_DATA = $8009033C;
  SEC_E_PKINIT_NAME_MISMATCH = $8009033D;
  SEC_E_SMARTCARD_LOGON_REQUIRED = $8009033E;
  SEC_E_SHUTDOWN_IN_PROGRESS = $8009033F;
  SEC_E_KDC_INVALID_REQUEST = $80090340;
  SEC_E_KDC_UNABLE_TO_REFER = $80090341;
  SEC_E_KDC_UNKNOWN_ETYPE = $80090342;
  SEC_E_UNSUPPORTED_PREAUTH = $80090343;
  SEC_E_DELEGATION_REQUIRED = $80090345;
  SEC_E_BAD_BINDINGS = $80090346;
  SEC_E_MULTIPLE_ACCOUNTS = $80090347;
  SEC_E_NO_KERB_KEY = $80090348;
  SEC_E_CERT_WRONG_USAGE = $80090349;
  SEC_E_DOWNGRADE_DETECTED = $80090350;
  SEC_E_SMARTCARD_CERT_REVOKED = $80090351;
  SEC_E_ISSUING_CA_UNTRUSTED = $80090352;
  SEC_E_REVOCATION_OFFLINE_C = $80090353;
  SEC_E_PKINIT_CLIENT_FAILURE = $80090354;
  SEC_E_SMARTCARD_CERT_EXPIRED = $80090355;
  SEC_E_NO_S4U_PROT_SUPPORT = $80090356;
  SEC_E_CROSSREALM_DELEGATION_FAILURE = $80090357;
  SEC_E_REVOCATION_OFFLINE_KDC = $80090358;
  SEC_E_ISSUING_CA_UNTRUSTED_KDC = $80090359;
  SEC_E_KDC_CERT_EXPIRED = $8009035A;
  SEC_E_KDC_CERT_REVOKED = $8009035B;
  SEC_E_NO_SPM = SEC_E_INTERNAL_ERROR;
  SEC_E_NOT_SUPPORTED = SEC_E_UNSUPPORTED_FUNCTION;
  CRYPT_E_MSG_ERROR = $80091001;
  CRYPT_E_UNKNOWN_ALGO = $80091002;
  CRYPT_E_OID_FORMAT = $80091003;
  CRYPT_E_INVALID_MSG_TYPE = $80091004;
  CRYPT_E_UNEXPECTED_ENCODING = $80091005;
  CRYPT_E_AUTH_ATTR_MISSING = $80091006;
  CRYPT_E_HASH_VALUE = $80091007;
  CRYPT_E_INVALID_INDEX = $80091008;
  CRYPT_E_ALREADY_DECRYPTED = $80091009;
  CRYPT_E_NOT_DECRYPTED = $8009100A;
  CRYPT_E_RECIPIENT_NOT_FOUND = $8009100B;
  CRYPT_E_CONTROL_TYPE = $8009100C;
  CRYPT_E_ISSUER_SERIALNUMBER = $8009100D;
  CRYPT_E_SIGNER_NOT_FOUND = $8009100E;
  CRYPT_E_ATTRIBUTES_MISSING = $8009100F;
  CRYPT_E_STREAM_MSG_NOT_READY = $80091010;
  CRYPT_E_STREAM_INSUFFICIENT_DATA = $80091011;
  CRYPT_I_NEW_PROTECTION_REQUIRED = $00091012;
  CRYPT_E_BAD_LEN = $80092001;
  CRYPT_E_BAD_ENCODE = $80092002;
  CRYPT_E_FILE_ERROR = $80092003;
  CRYPT_E_NOT_FOUND = $80092004;
  CRYPT_E_EXISTS = $80092005;
  CRYPT_E_NO_PROVIDER = $80092006;
  CRYPT_E_SELF_SIGNED = $80092007;
  CRYPT_E_DELETED_PREV = $80092008;
  CRYPT_E_NO_MATCH = $80092009;
  CRYPT_E_UNEXPECTED_MSG_TYPE = $8009200A;
  CRYPT_E_NO_KEY_PROPERTY = $8009200B;
  CRYPT_E_NO_DECRYPT_CERT = $8009200C;
  CRYPT_E_BAD_MSG = $8009200D;
  CRYPT_E_NO_SIGNER = $8009200E;
  CRYPT_E_PENDING_CLOSE = $8009200F;
  CRYPT_E_REVOKED = $80092010;
  CRYPT_E_NO_REVOCATION_DLL = $80092011;
  CRYPT_E_NO_REVOCATION_CHECK = $80092012;
  CRYPT_E_REVOCATION_OFFLINE = $80092013;
  CRYPT_E_NOT_IN_REVOCATION_DATABASE = $80092014;
  CRYPT_E_INVALID_NUMERIC_STRING = $80092020;
  CRYPT_E_INVALID_PRINTABLE_STRING = $80092021;
  CRYPT_E_INVALID_IA5_STRING = $80092022;
  CRYPT_E_INVALID_X500_STRING = $80092023;
  CRYPT_E_NOT_CHAR_STRING = $80092024;
  CRYPT_E_FILERESIZED = $80092025;
  CRYPT_E_SECURITY_SETTINGS = $80092026;
  CRYPT_E_NO_VERIFY_USAGE_DLL = $80092027;
  CRYPT_E_NO_VERIFY_USAGE_CHECK = $80092028;
  CRYPT_E_VERIFY_USAGE_OFFLINE = $80092029;
  CRYPT_E_NOT_IN_CTL = $8009202A;
  CRYPT_E_NO_TRUSTED_SIGNER = $8009202B;
  CRYPT_E_MISSING_PUBKEY_PARA = $8009202C;
  CRYPT_E_OSS_ERROR = $80093000;
  OSS_MORE_BUF = $80093001;
  OSS_NEGATIVE_UINTEGER = $80093002;
  OSS_PDU_RANGE = $80093003;
  OSS_MORE_INPUT = $80093004;
  OSS_DATA_ERROR = $80093005;
  OSS_BAD_ARG = $80093006;
  OSS_BAD_VERSION = $80093007;
  OSS_OUT_MEMORY = $80093008;
  OSS_PDU_MISMATCH = $80093009;
  OSS_LIMITED = $8009300A;
  OSS_BAD_PTR = $8009300B;
  OSS_BAD_TIME = $8009300C;
  OSS_INDEFINITE_NOT_SUPPORTED = $8009300D;
  OSS_MEM_ERROR = $8009300E;
  OSS_BAD_TABLE = $8009300F;
  OSS_TOO_LONG = $80093010;
  OSS_CONSTRAINT_VIOLATED = $80093011;
  OSS_FATAL_ERROR = $80093012;
  OSS_ACCESS_SERIALIZATION_ERROR = $80093013;
  OSS_NULL_TBL = $80093014;
  OSS_NULL_FCN = $80093015;
  OSS_BAD_ENCRULES = $80093016;
  OSS_UNAVAIL_ENCRULES = $80093017;
  OSS_CANT_OPEN_TRACE_WINDOW = $80093018;
  OSS_UNIMPLEMENTED = $80093019;
  OSS_OID_DLL_NOT_LINKED = $8009301A;
  OSS_CANT_OPEN_TRACE_FILE = $8009301B;
  OSS_TRACE_FILE_ALREADY_OPEN = $8009301C;
  OSS_TABLE_MISMATCH = $8009301D;
  OSS_TYPE_NOT_SUPPORTED = $8009301E;
  OSS_REAL_DLL_NOT_LINKED = $8009301F;
  OSS_REAL_CODE_NOT_LINKED = $80093020;
  OSS_OUT_OF_RANGE = $80093021;
  OSS_COPIER_DLL_NOT_LINKED = $80093022;
  OSS_CONSTRAINT_DLL_NOT_LINKED = $80093023;
  OSS_COMPARATOR_DLL_NOT_LINKED = $80093024;
  OSS_COMPARATOR_CODE_NOT_LINKED = $80093025;
  OSS_MEM_MGR_DLL_NOT_LINKED = $80093026;
  OSS_PDV_DLL_NOT_LINKED = $80093027;
  OSS_PDV_CODE_NOT_LINKED = $80093028;
  OSS_API_DLL_NOT_LINKED = $80093029;
  OSS_BERDER_DLL_NOT_LINKED = $8009302A;
  OSS_PER_DLL_NOT_LINKED = $8009302B;
  OSS_OPEN_TYPE_ERROR = $8009302C;
  OSS_MUTEX_NOT_CREATED = $8009302D;
  OSS_CANT_CLOSE_TRACE_FILE = $8009302E;
  CRYPT_E_ASN1_ERROR = $80093100;
  CRYPT_E_ASN1_INTERNAL = $80093101;
  CRYPT_E_ASN1_EOD = $80093102;
  CRYPT_E_ASN1_CORRUPT = $80093103;
  CRYPT_E_ASN1_LARGE = $80093104;
  CRYPT_E_ASN1_CONSTRAINT = $80093105;
  CRYPT_E_ASN1_MEMORY = $80093106;
  CRYPT_E_ASN1_OVERFLOW = $80093107;
  CRYPT_E_ASN1_BADPDU = $80093108;
  CRYPT_E_ASN1_BADARGS = $80093109;
  CRYPT_E_ASN1_BADREAL = $8009310A;
  CRYPT_E_ASN1_BADTAG = $8009310B;
  CRYPT_E_ASN1_CHOICE = $8009310C;
  CRYPT_E_ASN1_RULE = $8009310D;
  CRYPT_E_ASN1_UTF8 = $8009310E;
  CRYPT_E_ASN1_PDU_TYPE = $80093133;
  CRYPT_E_ASN1_NYI = $80093134;
  CRYPT_E_ASN1_EXTENDED = $80093201;
  CRYPT_E_ASN1_NOEOD = $80093202;
  CERTSRV_E_BAD_REQUESTSUBJECT = $80094001;
  CERTSRV_E_NO_REQUEST = $80094002;
  CERTSRV_E_BAD_REQUESTSTATUS = $80094003;
  CERTSRV_E_PROPERTY_EMPTY = $80094004;
  CERTSRV_E_INVALID_CA_CERTIFICATE = $80094005;
  CERTSRV_E_SERVER_SUSPENDED = $80094006;
  CERTSRV_E_ENCODING_LENGTH = $80094007;
  CERTSRV_E_ROLECONFLICT = $80094008;
  CERTSRV_E_RESTRICTEDOFFICER = $80094009;
  CERTSRV_E_KEY_ARCHIVAL_NOT_CONFIGURED = $8009400A;
  CERTSRV_E_NO_VALID_KRA = $8009400B;
  CERTSRV_E_BAD_REQUEST_KEY_ARCHIVAL = $8009400C;
  CERTSRV_E_NO_CAADMIN_DEFINED = $8009400D;
  CERTSRV_E_BAD_RENEWAL_CERT_ATTRIBUTE = $8009400E;
  CERTSRV_E_NO_DB_SESSIONS = $8009400F;
  CERTSRV_E_ALIGNMENT_FAULT = $80094010;
  CERTSRV_E_ENROLL_DENIED = $80094011;
  CERTSRV_E_TEMPLATE_DENIED = $80094012;
  CERTSRV_E_DOWNLEVEL_DC_SSL_OR_UPGRADE = $80094013;
  CERTSRV_E_UNSUPPORTED_CERT_TYPE = $80094800;
  CERTSRV_E_NO_CERT_TYPE = $80094801;
  CERTSRV_E_TEMPLATE_CONFLICT = $80094802;
  CERTSRV_E_SUBJECT_ALT_NAME_REQUIRED = $80094803;
  CERTSRV_E_ARCHIVED_KEY_REQUIRED = $80094804;
  CERTSRV_E_SMIME_REQUIRED = $80094805;
  CERTSRV_E_BAD_RENEWAL_SUBJECT = $80094806;
  CERTSRV_E_BAD_TEMPLATE_VERSION = $80094807;
  CERTSRV_E_TEMPLATE_POLICY_REQUIRED = $80094808;
  CERTSRV_E_SIGNATURE_POLICY_REQUIRED = $80094809;
  CERTSRV_E_SIGNATURE_COUNT = $8009480A;
  CERTSRV_E_SIGNATURE_REJECTED = $8009480B;
  CERTSRV_E_ISSUANCE_POLICY_REQUIRED = $8009480C;
  CERTSRV_E_SUBJECT_UPN_REQUIRED = $8009480D;
  CERTSRV_E_SUBJECT_DIRECTORY_GUID_REQUIRED = $8009480E;
  CERTSRV_E_SUBJECT_DNS_REQUIRED = $8009480F;
  CERTSRV_E_ARCHIVED_KEY_UNEXPECTED = $80094810;
  CERTSRV_E_KEY_LENGTH = $80094811;
  CERTSRV_E_SUBJECT_EMAIL_REQUIRED = $80094812;
  CERTSRV_E_UNKNOWN_CERT_TYPE = $80094813;
  CERTSRV_E_CERT_TYPE_OVERLAP = $80094814;
  XENROLL_E_KEY_NOT_EXPORTABLE = $80095000;
  XENROLL_E_CANNOT_ADD_ROOT_CERT = $80095001;
  XENROLL_E_RESPONSE_KA_HASH_NOT_FOUND = $80095002;
  XENROLL_E_RESPONSE_UNEXPECTED_KA_HASH = $80095003;
  XENROLL_E_RESPONSE_KA_HASH_MISMATCH = $80095004;
  XENROLL_E_KEYSPEC_SMIME_MISMATCH = $80095005;
  TRUST_E_SYSTEM_ERROR = $80096001;
  TRUST_E_NO_SIGNER_CERT = $80096002;
  TRUST_E_COUNTER_SIGNER = $80096003;
  TRUST_E_CERT_SIGNATURE = $80096004;
  TRUST_E_TIME_STAMP = $80096005;
  TRUST_E_BAD_DIGEST = $80096010;
  TRUST_E_BASIC_CONSTRAINTS = $80096019;
  TRUST_E_FINANCIAL_CRITERIA = $8009601E;
  MSSIPOTF_E_OUTOFMEMRANGE = $80097001;
  MSSIPOTF_E_CANTGETOBJECT = $80097002;
  MSSIPOTF_E_NOHEADTABLE = $80097003;
  MSSIPOTF_E_BAD_MAGICNUMBER = $80097004;
  MSSIPOTF_E_BAD_OFFSET_TABLE = $80097005;
  MSSIPOTF_E_TABLE_TAGORDER = $80097006;
  MSSIPOTF_E_TABLE_LONGWORD = $80097007;
  MSSIPOTF_E_BAD_FIRST_TABLE_PLACEMENT = $80097008;
  MSSIPOTF_E_TABLES_OVERLAP = $80097009;
  MSSIPOTF_E_TABLE_PADBYTES = $8009700A;
  MSSIPOTF_E_FILETOOSMALL = $8009700B;
  MSSIPOTF_E_TABLE_CHECKSUM = $8009700C;
  MSSIPOTF_E_FILE_CHECKSUM = $8009700D;
  MSSIPOTF_E_FAILED_POLICY = $80097010;
  MSSIPOTF_E_FAILED_HINTS_CHECK = $80097011;
  MSSIPOTF_E_NOT_OPENTYPE = $80097012;
  MSSIPOTF_E_FILE = $80097013;
  MSSIPOTF_E_CRYPT = $80097014;
  MSSIPOTF_E_BADVERSION = $80097015;
  MSSIPOTF_E_DSIG_STRUCTURE = $80097016;
  MSSIPOTF_E_PCONST_CHECK = $80097017;
  MSSIPOTF_E_STRUCTURE = $80097018;
  NTE_OP_OK = 0;
  TRUST_E_PROVIDER_UNKNOWN = $800B0001;
  TRUST_E_ACTION_UNKNOWN = $800B0002;
  TRUST_E_SUBJECT_FORM_UNKNOWN = $800B0003;
  TRUST_E_SUBJECT_NOT_TRUSTED = $800B0004;
  DIGSIG_E_ENCODE = $800B0005;
  DIGSIG_E_DECODE = $800B0006;
  DIGSIG_E_EXTENSIBILITY = $800B0007;
  DIGSIG_E_CRYPTO = $800B0008;
  PERSIST_E_SIZEDEFINITE = $800B0009;
  PERSIST_E_SIZEINDEFINITE = $800B000A;
  PERSIST_E_NOTSELFSIZING = $800B000B;
  TRUST_E_NOSIGNATURE = $800B0100;
  CERT_E_EXPIRED = $800B0101;
  CERT_E_VALIDITYPERIODNESTING = $800B0102;
  CERT_E_ROLE = $800B0103;
  CERT_E_PATHLENCONST = $800B0104;
  CERT_E_CRITICAL = $800B0105;
  CERT_E_PURPOSE = $800B0106;
  CERT_E_ISSUERCHAINING = $800B0107;
  CERT_E_MALFORMED = $800B0108;
  CERT_E_UNTRUSTEDROOT = $800B0109;
  CERT_E_CHAINING = $800B010A;
  TRUST_E_FAIL = $800B010B;
  CERT_E_REVOKED = $800B010C;
  CERT_E_UNTRUSTEDTESTROOT = $800B010D;
  CERT_E_REVOCATION_FAILURE = $800B010E;
  CERT_E_CN_NO_MATCH = $800B010F;
  CERT_E_WRONG_USAGE = $800B0110;
  TRUST_E_EXPLICIT_DISTRUST = $800B0111;
  CERT_E_UNTRUSTEDCA = $800B0112;
  CERT_E_INVALID_POLICY = $800B0113;
  CERT_E_INVALID_NAME = $800B0114;
  SPAPI_E_EXPECTED_SECTION_NAME = $800F0000;
  SPAPI_E_BAD_SECTION_NAME_LINE = $800F0001;
  SPAPI_E_SECTION_NAME_TOO_LONG = $800F0002;
  SPAPI_E_GENERAL_SYNTAX = $800F0003;
  SPAPI_E_WRONG_INF_STYLE = $800F0100;
  SPAPI_E_SECTION_NOT_FOUND = $800F0101;
  SPAPI_E_LINE_NOT_FOUND = $800F0102;
  SPAPI_E_NO_BACKUP = $800F0103;
  SPAPI_E_NO_ASSOCIATED_CLASS = $800F0200;
  SPAPI_E_CLASS_MISMATCH = $800F0201;
  SPAPI_E_DUPLICATE_FOUND = $800F0202;
  SPAPI_E_NO_DRIVER_SELECTED = $800F0203;
  SPAPI_E_KEY_DOES_NOT_EXIST = $800F0204;
  SPAPI_E_INVALID_DEVINST_NAME = $800F0205;
  SPAPI_E_INVALID_CLASS = $800F0206;
  SPAPI_E_DEVINST_ALREADY_EXISTS = $800F0207;
  SPAPI_E_DEVINFO_NOT_REGISTERED = $800F0208;
  SPAPI_E_INVALID_REG_PROPERTY = $800F0209;
  SPAPI_E_NO_INF = $800F020A;
  SPAPI_E_NO_SUCH_DEVINST = $800F020B;
  SPAPI_E_CANT_LOAD_CLASS_ICON = $800F020C;
  SPAPI_E_INVALID_CLASS_INSTALLER = $800F020D;
  SPAPI_E_DI_DO_DEFAULT = $800F020E;
  SPAPI_E_DI_NOFILECOPY = $800F020F;
  SPAPI_E_INVALID_HWPROFILE = $800F0210;
  SPAPI_E_NO_DEVICE_SELECTED = $800F0211;
  SPAPI_E_DEVINFO_LIST_LOCKED = $800F0212;
  SPAPI_E_DEVINFO_DATA_LOCKED = $800F0213;
  SPAPI_E_DI_BAD_PATH = $800F0214;
  SPAPI_E_NO_CLASSINSTALL_PARAMS = $800F0215;
  SPAPI_E_FILEQUEUE_LOCKED = $800F0216;
  SPAPI_E_BAD_SERVICE_INSTALLSECT = $800F0217;
  SPAPI_E_NO_CLASS_DRIVER_LIST = $800F0218;
  SPAPI_E_NO_ASSOCIATED_SERVICE = $800F0219;
  SPAPI_E_NO_DEFAULT_DEVICE_INTERFACE = $800F021A;
  SPAPI_E_DEVICE_INTERFACE_ACTIVE = $800F021B;
  SPAPI_E_DEVICE_INTERFACE_REMOVED = $800F021C;
  SPAPI_E_BAD_INTERFACE_INSTALLSECT = $800F021D;
  SPAPI_E_NO_SUCH_INTERFACE_CLASS = $800F021E;
  SPAPI_E_INVALID_REFERENCE_STRING = $800F021F;
  SPAPI_E_INVALID_MACHINENAME = $800F0220;
  SPAPI_E_REMOTE_COMM_FAILURE = $800F0221;
  SPAPI_E_MACHINE_UNAVAILABLE = $800F0222;
  SPAPI_E_NO_CONFIGMGR_SERVICES = $800F0223;
  SPAPI_E_INVALID_PROPPAGE_PROVIDER = $800F0224;
  SPAPI_E_NO_SUCH_DEVICE_INTERFACE = $800F0225;
  SPAPI_E_DI_POSTPROCESSING_REQUIRED = $800F0226;
  SPAPI_E_INVALID_COINSTALLER = $800F0227;
  SPAPI_E_NO_COMPAT_DRIVERS = $800F0228;
  SPAPI_E_NO_DEVICE_ICON = $800F0229;
  SPAPI_E_INVALID_INF_LOGCONFIG = $800F022A;
  SPAPI_E_DI_DONT_INSTALL = $800F022B;
  SPAPI_E_INVALID_FILTER_DRIVER = $800F022C;
  SPAPI_E_NON_WINDOWS_NT_DRIVER = $800F022D;
  SPAPI_E_NON_WINDOWS_DRIVER = $800F022E;
  SPAPI_E_NO_CATALOG_FOR_OEM_INF = $800F022F;
  SPAPI_E_DEVINSTALL_QUEUE_NONNATIVE = $800F0230;
  SPAPI_E_NOT_DISABLEABLE = $800F0231;
  SPAPI_E_CANT_REMOVE_DEVINST = $800F0232;
  SPAPI_E_INVALID_TARGET = $800F0233;
  SPAPI_E_DRIVER_NONNATIVE = $800F0234;
  SPAPI_E_IN_WOW64 = $800F0235;
  SPAPI_E_SET_SYSTEM_RESTORE_POINT = $800F0236;
  SPAPI_E_INCORRECTLY_COPIED_INF = $800F0237;
  SPAPI_E_SCE_DISABLED = $800F0238;
  SPAPI_E_UNKNOWN_EXCEPTION = $800F0239;
  SPAPI_E_PNP_REGISTRY_ERROR = $800F023A;
  SPAPI_E_REMOTE_REQUEST_UNSUPPORTED = $800F023B;
  SPAPI_E_NOT_AN_INSTALLED_OEM_INF = $800F023C;
  SPAPI_E_INF_IN_USE_BY_DEVICES = $800F023D;
  SPAPI_E_DI_FUNCTION_OBSOLETE = $800F023E;
  SPAPI_E_NO_AUTHENTICODE_CATALOG = $800F023F;
  SPAPI_E_AUTHENTICODE_DISALLOWED = $800F0240;
  SPAPI_E_AUTHENTICODE_TRUSTED_PUBLISHER = $800F0241;
  SPAPI_E_AUTHENTICODE_TRUST_NOT_ESTABLISHED = $800F0242;
  SPAPI_E_AUTHENTICODE_PUBLISHER_NOT_TRUSTED = $800F0243;
  SPAPI_E_SIGNATURE_OSATTRIBUTE_MISMATCH = $800F0244;
  SPAPI_E_ONLY_VALIDATE_VIA_AUTHENTICODE = $800F0245;
  SPAPI_E_UNRECOVERABLE_STACK_OVERFLOW = $800F0300;
  SPAPI_E_ERROR_NOT_INSTALLED = $800F1000;
  SCARD_S_SUCCESS = 0;
  SCARD_F_INTERNAL_ERROR = $80100001;
  SCARD_E_CANCELLED = $80100002;
  SCARD_E_INVALID_HANDLE = $80100003;
  SCARD_E_INVALID_PARAMETER = $80100004;
  SCARD_E_INVALID_TARGET = $80100005;
  SCARD_E_NO_MEMORY = $80100006;
  SCARD_F_WAITED_TOO_LONG = $80100007;
  SCARD_E_INSUFFICIENT_BUFFER = $80100008;
  SCARD_E_UNKNOWN_READER = $80100009;
  SCARD_E_TIMEOUT = $8010000A;
  SCARD_E_SHARING_VIOLATION = $8010000B;
  SCARD_E_NO_SMARTCARD = $8010000C;
  SCARD_E_UNKNOWN_CARD = $8010000D;
  SCARD_E_CANT_DISPOSE = $8010000E;
  SCARD_E_PROTO_MISMATCH = $8010000F;
  SCARD_E_NOT_READY = $80100010;
  SCARD_E_INVALID_VALUE = $80100011;
  SCARD_E_SYSTEM_CANCELLED = $80100012;
  SCARD_F_COMM_ERROR = $80100013;
  SCARD_F_UNKNOWN_ERROR = $80100014;
  SCARD_E_INVALID_ATR = $80100015;
  SCARD_E_NOT_TRANSACTED = $80100016;
  SCARD_E_READER_UNAVAILABLE = $80100017;
  SCARD_P_SHUTDOWN = $80100018;
  SCARD_E_PCI_TOO_SMALL = $80100019;
  SCARD_E_READER_UNSUPPORTED = $8010001A;
  SCARD_E_DUPLICATE_READER = $8010001B;
  SCARD_E_CARD_UNSUPPORTED = $8010001C;
  SCARD_E_NO_SERVICE = $8010001D;
  SCARD_E_SERVICE_STOPPED = $8010001E;
  SCARD_E_UNEXPECTED = $8010001F;
  SCARD_E_ICC_INSTALLATION = $80100020;
  SCARD_E_ICC_CREATEORDER = $80100021;
  SCARD_E_UNSUPPORTED_FEATURE = $80100022;
  SCARD_E_DIR_NOT_FOUND = $80100023;
  SCARD_E_FILE_NOT_FOUND = $80100024;
  SCARD_E_NO_DIR = $80100025;
  SCARD_E_NO_FILE = $80100026;
  SCARD_E_NO_ACCESS = $80100027;
  SCARD_E_WRITE_TOO_MANY = $80100028;
  SCARD_E_BAD_SEEK = $80100029;
  SCARD_E_INVALID_CHV = $8010002A;
  SCARD_E_UNKNOWN_RES_MNG = $8010002B;
  SCARD_E_NO_SUCH_CERTIFICATE = $8010002C;
  SCARD_E_CERTIFICATE_UNAVAILABLE = $8010002D;
  SCARD_E_NO_READERS_AVAILABLE = $8010002E;
  SCARD_E_COMM_DATA_LOST = $8010002F;
  SCARD_E_NO_KEY_CONTAINER = $80100030;
  SCARD_E_SERVER_TOO_BUSY = $80100031;
  SCARD_W_UNSUPPORTED_CARD = $80100065;
  SCARD_W_UNRESPONSIVE_CARD = $80100066;
  SCARD_W_UNPOWERED_CARD = $80100067;
  SCARD_W_RESET_CARD = $80100068;
  SCARD_W_REMOVED_CARD = $80100069;
  SCARD_W_SECURITY_VIOLATION = $8010006A;
  SCARD_W_WRONG_CHV = $8010006B;
  SCARD_W_CHV_BLOCKED = $8010006C;
  SCARD_W_EOF = $8010006D;
  SCARD_W_CANCELLED_BY_USER = $8010006E;
  SCARD_W_CARD_NOT_AUTHENTICATED = $8010006F;
  COMADMIN_E_OBJECTERRORS = $80110401;
  COMADMIN_E_OBJECTINVALID = $80110402;
  COMADMIN_E_KEYMISSING = $80110403;
  COMADMIN_E_ALREADYINSTALLED = $80110404;
  COMADMIN_E_APP_FILE_WRITEFAIL = $80110407;
  COMADMIN_E_APP_FILE_READFAIL = $80110408;
  COMADMIN_E_APP_FILE_VERSION = $80110409;
  COMADMIN_E_BADPATH = $8011040A;
  COMADMIN_E_APPLICATIONEXISTS = $8011040B;
  COMADMIN_E_ROLEEXISTS = $8011040C;
  COMADMIN_E_CANTCOPYFILE = $8011040D;
  COMADMIN_E_NOUSER = $8011040F;
  COMADMIN_E_INVALIDUSERIDS = $80110410;
  COMADMIN_E_NOREGISTRYCLSID = $80110411;
  COMADMIN_E_BADREGISTRYPROGID = $80110412;
  COMADMIN_E_AUTHENTICATIONLEVEL = $80110413;
  COMADMIN_E_USERPASSWDNOTVALID = $80110414;
  COMADMIN_E_CLSIDORIIDMISMATCH = $80110418;
  COMADMIN_E_REMOTEINTERFACE = $80110419;
  COMADMIN_E_DLLREGISTERSERVER = $8011041A;
  COMADMIN_E_NOSERVERSHARE = $8011041B;
  COMADMIN_E_DLLLOADFAILED = $8011041D;
  COMADMIN_E_BADREGISTRYLIBID = $8011041E;
  COMADMIN_E_APPDIRNOTFOUND = $8011041F;
  COMADMIN_E_REGISTRARFAILED = $80110423;
  COMADMIN_E_COMPFILE_DOESNOTEXIST = $80110424;
  COMADMIN_E_COMPFILE_LOADDLLFAIL = $80110425;
  COMADMIN_E_COMPFILE_GETCLASSOBJ = $80110426;
  COMADMIN_E_COMPFILE_CLASSNOTAVAIL = $80110427;
  COMADMIN_E_COMPFILE_BADTLB = $80110428;
  COMADMIN_E_COMPFILE_NOTINSTALLABLE = $80110429;
  COMADMIN_E_NOTCHANGEABLE = $8011042A;
  COMADMIN_E_NOTDELETEABLE = $8011042B;
  COMADMIN_E_SESSION = $8011042C;
  COMADMIN_E_COMP_MOVE_LOCKED = $8011042D;
  COMADMIN_E_COMP_MOVE_BAD_DEST = $8011042E;
  COMADMIN_E_REGISTERTLB = $80110430;
  COMADMIN_E_SYSTEMAPP = $80110433;
  COMADMIN_E_COMPFILE_NOREGISTRAR = $80110434;
  COMADMIN_E_COREQCOMPINSTALLED = $80110435;
  COMADMIN_E_SERVICENOTINSTALLED = $80110436;
  COMADMIN_E_PROPERTYSAVEFAILED = $80110437;
  COMADMIN_E_OBJECTEXISTS = $80110438;
  COMADMIN_E_COMPONENTEXISTS = $80110439;
  COMADMIN_E_REGFILE_CORRUPT = $8011043B;
  COMADMIN_E_PROPERTY_OVERFLOW = $8011043C;
  COMADMIN_E_NOTINREGISTRY = $8011043E;
  COMADMIN_E_OBJECTNOTPOOLABLE = $8011043F;
  COMADMIN_E_APPLID_MATCHES_CLSID = $80110446;
  COMADMIN_E_ROLE_DOES_NOT_EXIST = $80110447;
  COMADMIN_E_START_APP_NEEDS_COMPONENTS = $80110448;
  COMADMIN_E_REQUIRES_DIFFERENT_PLATFORM = $80110449;
  COMADMIN_E_CAN_NOT_EXPORT_APP_PROXY = $8011044A;
  COMADMIN_E_CAN_NOT_START_APP = $8011044B;
  COMADMIN_E_CAN_NOT_EXPORT_SYS_APP = $8011044C;
  COMADMIN_E_CANT_SUBSCRIBE_TO_COMPONENT = $8011044D;
  COMADMIN_E_EVENTCLASS_CANT_BE_SUBSCRIBER = $8011044E;
  COMADMIN_E_LIB_APP_PROXY_INCOMPATIBLE = $8011044F;
  COMADMIN_E_BASE_PARTITION_ONLY = $80110450;
  COMADMIN_E_START_APP_DISABLED = $80110451;
  COMADMIN_E_CAT_DUPLICATE_PARTITION_NAME = $80110457;
  COMADMIN_E_CAT_INVALID_PARTITION_NAME = $80110458;
  COMADMIN_E_CAT_PARTITION_IN_USE = $80110459;
  COMADMIN_E_FILE_PARTITION_DUPLICATE_FILES = $8011045A;
  COMADMIN_E_CAT_IMPORTED_COMPONENTS_NOT_ALLOWED = $8011045B;
  COMADMIN_E_AMBIGUOUS_APPLICATION_NAME = $8011045C;
  COMADMIN_E_AMBIGUOUS_PARTITION_NAME = $8011045D;
  COMADMIN_E_REGDB_NOTINITIALIZED = $80110472;
  COMADMIN_E_REGDB_NOTOPEN = $80110473;
  COMADMIN_E_REGDB_SYSTEMERR = $80110474;
  COMADMIN_E_REGDB_ALREADYRUNNING = $80110475;
  COMADMIN_E_MIG_VERSIONNOTSUPPORTED = $80110480;
  COMADMIN_E_MIG_SCHEMANOTFOUND = $80110481;
  COMADMIN_E_CAT_BITNESSMISMATCH = $80110482;
  COMADMIN_E_CAT_UNACCEPTABLEBITNESS = $80110483;
  COMADMIN_E_CAT_WRONGAPPBITNESS = $80110484;
  COMADMIN_E_CAT_PAUSE_RESUME_NOT_SUPPORTED = $80110485;
  COMADMIN_E_CAT_SERVERFAULT = $80110486;
  COMQC_E_APPLICATION_NOT_QUEUED = $80110600;
  COMQC_E_NO_QUEUEABLE_INTERFACES = $80110601;
  COMQC_E_QUEUING_SERVICE_NOT_AVAILABLE = $80110602;
  COMQC_E_NO_IPERSISTSTREAM = $80110603;
  COMQC_E_BAD_MESSAGE = $80110604;
  COMQC_E_UNAUTHENTICATED = $80110605;
  COMQC_E_UNTRUSTED_ENQUEUER = $80110606;
  MSDTC_E_DUPLICATE_RESOURCE = $80110701;
  COMADMIN_E_OBJECT_PARENT_MISSING = $80110808;
  COMADMIN_E_OBJECT_DOES_NOT_EXIST = $80110809;
  COMADMIN_E_APP_NOT_RUNNING = $8011080A;
  COMADMIN_E_INVALID_PARTITION = $8011080B;
  COMADMIN_E_SVCAPP_NOT_POOLABLE_OR_RECYCLABLE = $8011080D;
  COMADMIN_E_USER_IN_SET = $8011080E;
  COMADMIN_E_CANTRECYCLELIBRARYAPPS = $8011080F;
  COMADMIN_E_CANTRECYCLESERVICEAPPS = $80110811;
  COMADMIN_E_PROCESSALREADYRECYCLED = $80110812;
  COMADMIN_E_PAUSEDPROCESSMAYNOTBERECYCLED = $80110813;
  COMADMIN_E_CANTMAKEINPROCSERVICE = $80110814;
  COMADMIN_E_PROGIDINUSEBYCLSID = $80110815;
  COMADMIN_E_DEFAULT_PARTITION_NOT_IN_SET = $80110816;
  COMADMIN_E_RECYCLEDPROCESSMAYNOTBEPAUSED = $80110817;
  COMADMIN_E_PARTITION_ACCESSDENIED = $80110818;
  COMADMIN_E_PARTITION_MSI_ONLY = $80110819;
  COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_1_0_FORMAT = $8011081A;
  COMADMIN_E_LEGACYCOMPS_NOT_ALLOWED_IN_NONBASE_PARTITIONS = $8011081B;
  COMADMIN_E_COMP_MOVE_SOURCE = $8011081C;
  COMADMIN_E_COMP_MOVE_DEST = $8011081D;
  COMADMIN_E_COMP_MOVE_PRIVATE = $8011081E;
  COMADMIN_E_BASEPARTITION_REQUIRED_IN_SET = $8011081F;
  COMADMIN_E_CANNOT_ALIAS_EVENTCLASS = $80110820;
  COMADMIN_E_PRIVATE_ACCESSDENIED = $80110821;
  COMADMIN_E_SAFERINVALID = $80110822;
  COMADMIN_E_REGISTRY_ACCESSDENIED = $80110823;
  COMADMIN_E_PARTITIONS_DISABLED = $80110824;
  FACILITY_WINDOWSUPDATE = 36;
  FACILITY_WINDOWS_CE = 24;
  FACILITY_WINDOWS = 8;
  FACILITY_URT = 19;
  FACILITY_UMI = 22;
  FACILITY_SXS = 23;
  FACILITY_STORAGE = 3;
  FACILITY_STATE_MANAGEMENT = 34;
  FACILITY_SSPI = 9;
  FACILITY_SCARD = 16;
  FACILITY_SETUPAPI = 15;
  FACILITY_SECURITY = 9;
  FACILITY_RPC = 1;
  FACILITY_WIN32 = 7;
  FACILITY_CONTROL = 10;
  FACILITY_NULL = 0;
  FACILITY_METADIRECTORY = 35;
  FACILITY_MSMQ = 14;
  FACILITY_MEDIASERVER = 13;
  FACILITY_INTERNET = 12;
  FACILITY_ITF = 4;
  FACILITY_HTTP = 25;
  FACILITY_DPLAY = 21;
  FACILITY_DISPATCH = 2;
  FACILITY_DIRECTORYSERVICE = 37;
  FACILITY_CONFIGURATION = 33;
  FACILITY_COMPLUS = 17;
  FACILITY_CERT = 11;
  FACILITY_BACKGROUNDCOPY = 32;
  FACILITY_ACS = 20;
  FACILITY_AAF = 18;

function Succeeded(Res: LongInt): Boolean;
function Failed(Res: LongInt): Boolean;
function ResultCode(Res: LongInt): Integer;
function ResultFacility(Res: LongInt): Integer;
function ResultSeverity(Res: LongInt): Integer;
function MakeResult(Severity, Facility, Code: Integer): LongInt;

const // Known handle values.
  INVALID_HANDLE_VALUE = $FFFFFFFF;
  INVALID_FILE_SIZE    = $FFFFFFFF;
  STD_INPUT_HANDLE     = $FFFFFFF6;
  STD_OUTPUT_HANDLE    = $FFFFFFF5;
  STD_ERROR_HANDLE     = $FFFFFFF4;

const // dwCreationFlag values
  DEBUG_PROCESS               = $00000001;
  DEBUG_ONLY_THIS_PROCESS     = $00000002;
  CREATE_SUSPENDED            = $00000004;
  DETACHED_PROCESS            = $00000008;
  CREATE_NEW_CONSOLE          = $00000010;
  NORMAL_PRIORITY_CLASS       = $00000020;
  IDLE_PRIORITY_CLASS         = $00000040;
  HIGH_PRIORITY_CLASS         = $00000080;
  REALTIME_PRIORITY_CLASS     = $00000100;
  CREATE_NEW_PROCESS_GROUP    = $00000200;
  CREATE_UNICODE_ENVIRONMENT  = $00000400;
  CREATE_SEPARATE_WOW_VDM     = $00000800;
  CREATE_SHARED_WOW_VDM       = $00001000;
  CREATE_FORCEDOS             = $00002000;
  BELOW_NORMAL_PRIORITY_CLASS = $00004000;
  ABOVE_NORMAL_PRIORITY_CLASS = $00008000;
  CREATE_DEFAULT_ERROR_MODE   = $04000000;
  CREATE_NO_WINDOW            = $08000000;
  PROFILE_USER                = $10000000;
  PROFILE_KERNEL              = $20000000;
  PROFILE_SERVER              = $40000000;
  LOWER_PRIORITY_CLASS        = $00004000; // Not defined in Windows.pas
  HIGHER_PRIORITY_CLASS       = $00008000; // Not defined in Windows.pas

function GetPriorityClassLevel(aPriorityClass:DWORD):Integer;
function GetPriorityClassName(aPriorityClass:DWORD):String;
function GetPriorityClassByLevel(aLevel:Integer):DWORD;
function GetPriorityClassByName(aName:String):DWORD;

const
  SYNCHRONIZE               = $00100000;
  STANDARD_RIGHTS_REQUIRED  = $000F0000;
  EVENT_MODIFY_STATE        = $0002;
  MUTANT_QUERY_STATE        = $0001;
  PROCESS_TERMINATE         = $0001;
  PROCESS_CREATE_THREAD     = $0002;
  PROCESS_VM_OPERATION      = $0008;
  PROCESS_VM_READ           = $0010;
  PROCESS_VM_WRITE          = $0020;
  PROCESS_DUP_HANDLE        = $0040;
  PROCESS_CREATE_PROCESS    = $0080;
  PROCESS_SET_QUOTA         = $0100;
  PROCESS_SET_INFORMATION   = $0200;
  PROCESS_QUERY_INFORMATION = $0400;
  PROCESS_ALL_ACCESS        = $001F0FFF; // STANDARD_RIGHTS_REQUIRED or SYNCHRONIZE or $FFF

function GetPidAffinityMask(Pid:Cardinal):DWORD;

 // ShellExecute() and ShellExecuteEx() error codes
const // regular WinExec() codes
  SE_ERR_FNF              = 2;       { file not found }
  SE_ERR_PNF              = 3;       { path not found }
  SE_ERR_ACCESSDENIED     = 5;       { access denied }
  SE_ERR_OOM              = 8;       { out of memory }
  SE_ERR_DLLNOTFOUND      = 32;      { DLL not found }
const // error values for ShellExecute() beyond the regular WinExec() codes
  SE_ERR_SHARE            = 26;
  SE_ERR_ASSOCINCOMPLETE  = 27;
  SE_ERR_DDETIMEOUT       = 28;
  SE_ERR_DDEFAIL          = 29;
  SE_ERR_DDEBUSY          = 30;
  SE_ERR_NOASSOC          = 31;

const // ShellExecute() and ShellExecuteEx() flags
  SEE_MASK_CLASSNAME      = $00000001; // Note CLASSKEY overrides CLASSNAME
  SEE_MASK_CLASSKEY       = $00000003;
  SEE_MASK_IDLIST         = $00000004; // Note INVOKEIDLIST overrides IDLIST
  SEE_MASK_INVOKEIDLIST   = $0000000c;
  SEE_MASK_ICON           = $00000010;
  SEE_MASK_HOTKEY         = $00000020;
  SEE_MASK_NOCLOSEPROCESS = $00000040;
  SEE_MASK_CONNECTNETDRV  = $00000080;
  SEE_MASK_NOASYNC        = $00000100;
  SEE_MASK_FLAG_DDEWAIT   = $00000100;
  SEE_MASK_DOENVSUBST     = $00000200;
  SEE_MASK_FLAG_NO_UI     = $00000400;
  SEE_MASK_UNICODE        = $00010000;
  SEE_MASK_NO_CONSOLE     = $00008000;
  SEE_MASK_ASYNCOK        = $00100000;

const // Window field offsets for GetWindowLong
  GWL_WNDPROC             = -4;
  GWL_HINSTANCE           = -6;
  GWL_HWNDPARENT          = -8;
  GWL_STYLE               = -16;
  GWL_EXSTYLE             = -20;
  GWL_USERDATA            = -21;
  GWL_ID                  = -12;

const // Extended Window Styles
  WS_EX_DLGMODALFRAME     = 1;
  WS_EX_NOPARENTNOTIFY    = 4;
  WS_EX_TOPMOST           = 8;
  WS_EX_ACCEPTFILES       = $10;
  WS_EX_TRANSPARENT       = $20;
  WS_EX_MDICHILD          = $40;
  WS_EX_TOOLWINDOW        = $80;
  WS_EX_WINDOWEDGE        = $100;
  WS_EX_CLIENTEDGE        = $200;
  WS_EX_CONTEXTHELP       = $400;
  WS_EX_RIGHT             = $1000;
  WS_EX_LEFT              = 0;
  WS_EX_RTLREADING        = $2000;
  WS_EX_LTRREADING        = 0;
  WS_EX_LEFTSCROLLBAR     = $4000;
  WS_EX_RIGHTSCROLLBAR    = 0;
  WS_EX_CONTROLPARENT     = $10000;
  WS_EX_STATICEDGE        = $20000;
  WS_EX_APPWINDOW         = $40000;
  WS_EX_OVERLAPPEDWINDOW  = (WS_EX_WINDOWEDGE or WS_EX_CLIENTEDGE);
  WS_EX_PALETTEWINDOW     = (WS_EX_WINDOWEDGE or WS_EX_TOOLWINDOW or WS_EX_TOPMOST);

const
  STATUS_WAIT_0                   = $00000000;
  STATUS_ABANDONED_WAIT_0         = $00000080;
  STATUS_USER_APC                 = $000000C0;
  STATUS_TIMEOUT                  = $00000102;
  STATUS_PENDING                  = $00000103;
  STATUS_SEGMENT_NOTIFICATION     = $40000005;
  STATUS_GUARD_PAGE_VIOLATION     = DWORD($80000001);
  STATUS_DATATYPE_MISALIGNMENT    = DWORD($80000002);
  STATUS_BREAKPOINT               = DWORD($80000003);
  STATUS_SINGLE_STEP              = DWORD($80000004);
  STATUS_ACCESS_VIOLATION         = DWORD($C0000005);
  STATUS_IN_PAGE_ERROR            = DWORD($C0000006);
  STATUS_INVALID_HANDLE           = DWORD($C0000008);
  STATUS_NO_MEMORY                = DWORD($C0000017);
  STATUS_ILLEGAL_INSTRUCTION      = DWORD($C000001D);
  STATUS_NONCONTINUABLE_EXCEPTION = DWORD($C0000025);
  STATUS_INVALID_DISPOSITION      = DWORD($C0000026);
  STATUS_ARRAY_BOUNDS_EXCEEDED    = DWORD($C000008C);
  STATUS_FLOAT_DENORMAL_OPERAND   = DWORD($C000008D);
  STATUS_FLOAT_DIVIDE_BY_ZERO     = DWORD($C000008E);
  STATUS_FLOAT_INEXACT_RESULT     = DWORD($C000008F);
  STATUS_FLOAT_INVALID_OPERATION  = DWORD($C0000090);
  STATUS_FLOAT_OVERFLOW           = DWORD($C0000091);
  STATUS_FLOAT_STACK_CHECK        = DWORD($C0000092);
  STATUS_FLOAT_UNDERFLOW          = DWORD($C0000093);
  STATUS_INTEGER_DIVIDE_BY_ZERO   = DWORD($C0000094);
  STATUS_INTEGER_OVERFLOW         = DWORD($C0000095);
  STATUS_PRIVILEGED_INSTRUCTION   = DWORD($C0000096);
  STATUS_STACK_OVERFLOW           = DWORD($C00000FD);
  STATUS_CONTROL_C_EXIT           = DWORD($C000013A);

const
  MAXIMUM_WAIT_OBJECTS = 64;

const
  WAIT_FAILED                     = DWORD($FFFFFFFF);
  WAIT_OBJECT_0                   = ((STATUS_WAIT_0 ) + 0 );
  WAIT_ABANDONED                  = ((STATUS_ABANDONED_WAIT_0 ) + 0 );
  WAIT_ABANDONED_0                = ((STATUS_ABANDONED_WAIT_0 ) + 0 );
  WAIT_TIMEOUT                    = STATUS_TIMEOUT;
  WAIT_IO_COMPLETION              = STATUS_USER_APC;
  STILL_ACTIVE                    = STATUS_PENDING;
  EXCEPTION_ACCESS_VIOLATION      = STATUS_ACCESS_VIOLATION;
  EXCEPTION_DATATYPE_MISALIGNMENT = STATUS_DATATYPE_MISALIGNMENT;
  EXCEPTION_BREAKPOINT            = STATUS_BREAKPOINT;
  EXCEPTION_SINGLE_STEP           = STATUS_SINGLE_STEP;
  EXCEPTION_ARRAY_BOUNDS_EXCEEDED = STATUS_ARRAY_BOUNDS_EXCEEDED;
  EXCEPTION_FLT_DENORMAL_OPERAND  = STATUS_FLOAT_DENORMAL_OPERAND;
  EXCEPTION_FLT_DIVIDE_BY_ZERO    = STATUS_FLOAT_DIVIDE_BY_ZERO;
  EXCEPTION_FLT_INEXACT_RESULT    = STATUS_FLOAT_INEXACT_RESULT;
  EXCEPTION_FLT_INVALID_OPERATION = STATUS_FLOAT_INVALID_OPERATION;
  EXCEPTION_FLT_OVERFLOW          = STATUS_FLOAT_OVERFLOW;
  EXCEPTION_FLT_STACK_CHECK       = STATUS_FLOAT_STACK_CHECK;
  EXCEPTION_FLT_UNDERFLOW         = STATUS_FLOAT_UNDERFLOW;
  EXCEPTION_INT_DIVIDE_BY_ZERO    = STATUS_INTEGER_DIVIDE_BY_ZERO;
  EXCEPTION_INT_OVERFLOW          = STATUS_INTEGER_OVERFLOW;
  EXCEPTION_PRIV_INSTRUCTION      = STATUS_PRIVILEGED_INSTRUCTION;
  EXCEPTION_IN_PAGE_ERROR         = STATUS_IN_PAGE_ERROR;
  EXCEPTION_ILLEGAL_INSTRUCTION   = STATUS_ILLEGAL_INSTRUCTION;
  EXCEPTION_NONCONTINUABLE_EXCEPTION = STATUS_NONCONTINUABLE_EXCEPTION;
  EXCEPTION_STACK_OVERFLOW        = STATUS_STACK_OVERFLOW;
  EXCEPTION_INVALID_DISPOSITION   = STATUS_INVALID_DISPOSITION;
  EXCEPTION_GUARD_PAGE            = STATUS_GUARD_PAGE_VIOLATION;
  EXCEPTION_INVALID_HANDLE        = STATUS_INVALID_HANDLE;
  CONTROL_C_EXIT                  = STATUS_CONTROL_C_EXIT;

var UseWinApiSystemMetrics : Boolean = true;

implementation

uses dpLinux;

function ScreenHeight: Integer;
begin
 if IsWindows and UseWinApiSystemMetrics
 then Result := GetSystemMetrics(SM_CYSCREEN)
 else Result := Screen.Height;
end;

function ScreenWidth: Integer;
begin
 if IsWindows and UseWinApiSystemMetrics
 then Result := GetSystemMetrics(SM_CXSCREEN)
 else Result := Screen.Width;
end;

function ScreenDesktopTop: Integer;
begin
 if IsWindows and UseWinApiSystemMetrics
 then Result := GetSystemMetrics(SM_YVIRTUALSCREEN)
 else Result := Screen.DesktopTop;
end;

function ScreenDesktopLeft: Integer;
begin
 if IsWindows and UseWinApiSystemMetrics
 then Result := GetSystemMetrics(SM_XVIRTUALSCREEN)
 else Result := Screen.DesktopLeft;
end;

function ScreenDesktopHeight: Integer;
begin
 if IsWindows and UseWinApiSystemMetrics
 then Result := GetSystemMetrics(SM_CYVIRTUALSCREEN)
 else Result := Screen.DesktopHeight;
end;

function ScreenDesktopWidth: Integer;
begin
 if IsWindows and UseWinApiSystemMetrics
 then Result := GetSystemMetrics(SM_CXVIRTUALSCREEN)
 else Result := Screen.DesktopWidth;
end;

function Succeeded(Res: LongInt): Boolean;
begin
  Result := Res and $80000000 = 0;
end;

function Failed(Res: LongInt): Boolean;
begin
  Result := Res and $80000000 <> 0;
end;

function ResultCode(Res: LongInt): Integer;
begin
  Result := Res and $0000FFFF;
end;

function ResultFacility(Res: LongInt): Integer;
begin
  Result := (Res shr 16) and $00001FFF;
end;

function ResultSeverity(Res: LongInt): Integer;
begin
  Result := Res shr 31;
end;

function MakeResult(Severity, Facility, Code: Integer): LongInt;
begin
  Result := (Severity shl 31) or (Facility shl 16) or Code;
end;

function GetPriorityClassLevel(aPriorityClass:DWORD):Integer;
begin
 case aPriorityClass of
  IDLE_PRIORITY_CLASS:     Result:=4;
  LOWER_PRIORITY_CLASS:    Result:=6;
  NORMAL_PRIORITY_CLASS:   Result:=8;
  HIGHER_PRIORITY_CLASS:   Result:=10;
  HIGH_PRIORITY_CLASS:     Result:=13;
  REALTIME_PRIORITY_CLASS: Result:=24;
  else                     Result:=0;
 end;
end;

function GetPriorityClassName(aPriorityClass:DWORD):String;
begin
 case aPriorityClass of
  IDLE_PRIORITY_CLASS:     Result:='Idle';
  LOWER_PRIORITY_CLASS:    Result:='Lower';
  NORMAL_PRIORITY_CLASS:   Result:='Normal';
  HIGHER_PRIORITY_CLASS:   Result:='Higher';
  HIGH_PRIORITY_CLASS:     Result:='High';
  REALTIME_PRIORITY_CLASS: Result:='RealTime';
  else                     Result:='';
 end;
end;

function GetPriorityClassByLevel(aLevel:Integer):DWORD;
begin
 case aLevel of
  4:   Result:=IDLE_PRIORITY_CLASS;
  6:   Result:=LOWER_PRIORITY_CLASS;
  8:   Result:=NORMAL_PRIORITY_CLASS;
  10:  Result:=HIGHER_PRIORITY_CLASS;
  13:  Result:=HIGH_PRIORITY_CLASS;
  24:  Result:=REALTIME_PRIORITY_CLASS;
  else Result:=0;
 end;
end;

function GetPriorityClassByName(aName:String):DWORD;
const list1='Idle,Lower,Normal,Higher,High,RealTime';
const list2='4,6,8,10,13,24';
var i:Integer;
begin
 Result:=0;
 aName:=Trim(aName);
 if (aName='') then Exit;
 if TryStrToInt(aName,i) then Result:=GetPriorityClassByLevel(i) else
 for i:=1 to WordCount(list1,',') do begin
  if SameText(aName,ExtractWord(i,list1,','))
  then Result:=GetPriorityClassByLevel(StrToIntDef(ExtractWord(i,list2,','),0));
  if (Result<>0) then Exit;
 end;
end;

function GetPidAffinityMask(Pid:Cardinal):DWORD;
var hProcess:THandle; cmd,s:String; p,c:Integer;
begin
 Result:=0;
 if (Pid=0) then Pid:=GetProcessId;
 try
  if IsWindows then begin
   hProcess:=WinApi.OpenProcess(PROCESS_QUERY_INFORMATION,false,Pid);
   if (hProcess<>0) then
   try
    Result:=WinApi.GetProcessAffinityMask(hProcess);
   finally
    WinApi.CloseHandle(hProcess);
   end;
  end else
  if IsUnix then begin
   // /proc/PID/status, Cpus_allowed
   s:=read_proc_pid_file(pid,'status');
   if not IsEmptyStr(s) then begin
    s:=StringReplace(s,':','=',rfReplaceAll);
    s:=Trim(CookieScan(s,'Cpus_allowed',0));
    if (s<>'') then begin
     Result:=StrToIntDef('$'+s,0);
     Exit;
    end;
   end;
   // read `taskset -p PID` output after marker :
   if FileExists(file_which('taskset')) then begin
    cmd:='taskset -p '+IntToStr(Pid);
    s:=Trim(execute_command_as_text(cmd,p,c));
    s:=Trim(ExtractWord(2,s,':'));
    Result:=StrToIntDef('$'+s,0);
   end;
  end;
 except
  on E:Exception do BugReport(E,Application,'GetPidAffinityMask');
 end;
end;

end.
