@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion

rem Usage: _ROOT_HIST_1D.bat file.dat
rem Prepare environment for call ROOT
rem Then call ROOT, wait and show GIF

:CheckArguments
if "%~1" == "" goto :EOF

call :ShowProgressBar

:Prepare_logFile
set logFile=%~dpn1.log
call :DeleteFile "!logFile!"

:Prepare_datFile
set datFile=%~1

:Prepare_gifFile
set gifFile=%~dpn1.gif
call :DeleteFile "!gifFile!"

:Greetings
echo !Date!-!Time!:       | unix tee -a "!logFile!"
echo Command: "%~f0"      | unix tee -a "!logFile!"
echo Argument: "%~1"      | unix tee -a "!logFile!"
echo StartDir: "!cd!"     | unix tee -a "!logFile!"
echo logFile: "!logFile!" | unix tee -a "!logFile!"
echo datFile: "!datFile!" | unix tee -a "!logFile!"
echo gifFile: "!gifFile!" | unix tee -a "!logFile!"

:Main
for %%i in ("%~dp0.") do (
 echo HomeDir: "%%~fi" | unix tee -a "!logFile!"
 pushd "%%~fi" && (
  echo WorkDir: "!cd!" | unix tee -a "!logFile!"
  call :ExecuteRoot
  call :WaitForFile "!gifFile!" 5
  if exist "!gifFile!" (
   rem gifFile exists, SUCCESS.
   call :ViewFile "!gifFile!"
   unix sleep 1
   call :ShowReportOnSuccess
   call :DeleteFile "!datFile!"
  ) else (
   rem gifFile is not ready, ERROR.
   call :ShowReportOnError
   call :DeleteFile "!datFile!"
  )
 ) & popd
)
call :HideProgressBar
goto :EOF

:ExecuteRoot
rem Execute ROOT data analysis.
rem Uses datFile,gifFile,logFile
SetLocal EnableExtensions EnableDelayedExpansion
rem Repalce \ to / as need for ROOT file names
set datFile=%datFile:\=/%
set gifFile=%gifFile:\=/%
rem Or just another version
rem call :Win2Unix datFile "!datFile!"
rem call :Win2Unix gifFile "!gifFile!"
echo datFile: "!datFile!" | unix tee -a "!logFile!"
echo gifFile: "!gifFile!" | unix tee -a "!logFile!"
echo.                     | unix tee -a "!logFile!"
echo Now execute ROOT ... | unix tee -a "!logFile!"
unix root -l -b -x -q %~n0.C 2>&1 | unix tee -a "!logFile!"
echo.                     | unix tee -a "!logFile!"
EndLocal
goto :EOF

:DeleteFile
rem Usage: call :DeleteFile "filename"
rem Check if file exists and delete file.
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
unix rm -f "%~1"
goto :EOF

:ViewFile
rem Usage: call :ViewFile "filename"
rem Check if file exists and delete file.
if "%~1" == "" goto :EOF
if not exist "%~1" goto :EOF
unix start "View %~1" imagine "%~1"
goto :EOF

:Win2Unix
rem Usage: call :Win2Unix datFile "!datFile!"
rem Convert datFile from Windows\ to /Unix file name convention
if "%~1" == "" goto :EOF
set %~1=
if "%~2" == "" goto :EOF
for /F %%x in ('unix echo %~2 ^| unix gsar -F -s\ -r/') do set %~1=%%x
goto :EOF

:WaitForFile
rem Usage: call :WaitForFile FileName TimeoutSec
rem Wait until file exist or timeout
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if exist "%~1" goto :EOF
SetLocal
set /a n=%~2 & if "!n!" GTR "0" ( unix sleep 1 & set /a n=!n!-1 & call :WaitForFile "%~1" !n! )
EndLocal
goto :EOF

:ShowProgressBar
unix saferun wbusy "CRW-DAQ: Wait for %~n0..." "%~n0 is running, please wait..." /marquee
goto :EOF

:HideProgressBar
unix saferun wbusy "CRW-DAQ: Wait for %~n0..." /stop /sound
goto :EOF

:ShowReportOnSuccess
echo.                 | unix tee -a "!logFile!"
echo Result: SUCCESS. | unix tee -a "!logFile!"
echo.                 | unix tee -a "!logFile!"
unix speak "Success."
if exist "!logFile!" start "View !logFile!" unix cat "!logFile!" ^& waitkey 60 "" "Press any key to continue..."
unix printf "@echo Data analysis done (_ROOT_HIST_1D) - SUCCESS.\n@open !logFile!\n@tty close 0" | unix u2d | unix send2crwdaq 
goto :EOF

:ShowReportOnError
echo.               | unix tee -a "!logFile!"
echo Result: ERROR. | unix tee -a "!logFile!"
echo.               | unix tee -a "!logFile!"
unix speak "Failure."
if exist "!datFile!" start "View !datFile!" unix head -n 20 "!datFile!" ^& waitkey 60 "" "Press any key to continue..."
unix sleep 1
if exist "!logFile!" start "View !logFile!" unix cat "!logFile!" ^& waitkey 60 "" "Press any key to continue..."
unix sleep 1
unix wprompt "Error^!" "Could not process !datFile!" Ok 1:10 x
unix printf "@echo Data analysis done (_ROOT_HIST_1D) - FAILS.\n@open !logFile!\n@tty close 0" | unix u2d | send2crwdaq 
goto :EOF
