{***********************************************************
 Вычисление числа PI по формуле Фабриса Беллара.
 Стандартные типы FreePascal.
 ***********************************************************}
{$mode objfpc}
program pi_bel;
Uses SysUtils, DateUtils, Math;

Var
  pi_bellard: Extended;
  m1, m2, m3, m4, m5, m6, m7, m8: Extended;
  startt, endt: TDateTime;
  k: longword;

Begin
  pi_bellard := 0.0;
  startt:=Now;
  
  For k:=0 To 20000000 Do
  Begin
    Try
      m1 := Power(-1.0, k)/Power(2.0, (10.0*k));
    except
    end;
    m2 := -(Power(2.0, 5.0)/(4.0*k + 1.0));
    m3 := 1.0/(4.0*k + 3.0);
    m4 := Power(2.0, 8.0)/(10.0*k + 1.0);
    m5 := Power(2.0, 6.0)/(10.0*k + 3.0);
    m6 := (2.0 * 2.0)/(10.0*k + 5.0);
    m7 := (2.0 * 2.0)/(10.0*k + 7.0);
    m8 := 1.0/(10.0*k + 9);
    
    pi_bellard := pi_bellard + m1 * (m2 - m3 + m4 - m5 - m6 - m7 + m8);
  end;
  pi_bellard := pi_bellard * 1.0/Power(2.0, 6.0);

  endt := Now;

  WriteLn(pi_bellard:37:35);
  WriteLn('Время: ', SecondsBetween(endt, startt), ' секунд');
  WriteLn('3,14159265358979323846264338327950288');

end.
