﻿{*******************************************************
 Вычисление последовательности простых чисел.
 Вычисляет последовательность простых чисел (включая 
 единицу), не превосходящих заданного натурального N, 
 используя алглоритм, имеющий название 
 "решето Эратосфена".
 Переделка под современный Паскаль - Вадим Исаев, 2018
********************************************************}
program pa12i_p;

uses
SysUtils, Math;

// Входные параметры:
//	- N - предельное значение до которого ищутся простые числа;
//	- IP - масств, куда помещаются простые числа.
procedure PA12I(N : Integer; var IP : Array of Integer);
var
  I,J,K : Integer;
  S : Double;

begin
  IP[0] := 1;
  IP[1] := 2;
  IP[2] := 3;
  
  if ( N > 3 ) then
  begin
    K := 3;
    J := 3;
    while ( K<=N ) do
    begin
      I := 2;
      S := Sqrt(K);
      While 1=1 Do
      Begin
        Inc(I);
        if ( IP[I-1] > S ) then 
        begin
          IP[J-1] := K;
          Inc(J);
          Break;          
        end
        Else
          if ( K div IP[I-1]*IP[I-1] <> K ) then 
            Continue
          else
            Break;
      end;
    inc(K,2);
    end;
    
  end;
end;

Var
  m: array[0..30] of integer;
  i: integer;

begin
  pa12i(100, m);
  i:=0;
  While m[i]<>0 Do
  begin
    writeln(m[i]);
    Inc(i);
  end;
end.
