/*
 * Decompiled with CFR 0.152.
 */
package dim;

import dim.DataEncoder;
import dim.DimDataOffsets;
import dim.DimServer;
import dim.DimServiceUpdateHandler;
import dim.Format;
import dim.Memory;
import dim.MutableMemory;
import dim.Server;
import dim.Sizeof;
import java.util.Date;

public class DimService
extends MutableMemory
implements DataEncoder,
DimServiceUpdateHandler {
    int service_id;
    String service_name;
    int published;
    int curr_size;
    String format;
    Format itsFormat;
    DimDataOffsets items;

    public DimService(String theServiceName) {
        this.published = 0;
        this.service_name = theServiceName;
        this.curr_size = 0;
        this.format = "";
        this.items = new DimDataOffsets();
    }

    public DimService() {
        this.published = 0;
        this.service_name = "";
        this.curr_size = 0;
        this.format = "";
        this.items = new DimDataOffsets();
    }

    public String getFormatStr() {
        return this.format;
    }

    public void setName(String theServiceName) {
        this.service_name = theServiceName;
    }

    public DimService(String theServiceName, boolean theData) {
        this.service_name = theServiceName;
        this.setSize(1);
        this.copyBoolean(theData);
        this.service_id = Server.addService(theServiceName, "C", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, byte theData) {
        this.service_name = theServiceName;
        this.setSize(1);
        this.copyByte(theData);
        this.service_id = Server.addService(theServiceName, "C", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, short theData) {
        this.service_name = theServiceName;
        this.setSize(2);
        this.copyShort(theData);
        this.service_id = Server.addService(theServiceName, "S", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, int theData) {
        this.service_name = theServiceName;
        this.setSize(4);
        this.copyInt(theData);
        this.service_id = Server.addService(theServiceName, "I", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, float theData) {
        this.service_name = theServiceName;
        this.setSize(4);
        this.copyFloat(theData);
        this.service_id = Server.addService(theServiceName, "F", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, double theData) {
        this.service_name = theServiceName;
        this.setSize(8);
        this.copyDouble(theData);
        this.service_id = Server.addService(theServiceName, "D", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, long theData) {
        this.service_name = theServiceName;
        this.setSize(8);
        this.copyLong(theData);
        this.service_id = Server.addService(theServiceName, "X", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, String theData) {
        this.service_name = theServiceName;
        this.setSize(theData.length() + 1);
        this.copyString(theData);
        this.service_id = Server.addService(theServiceName, "C", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, boolean[] theData) {
        this.service_name = theServiceName;
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromBooleanArray(theData, 0, size);
        this.service_id = Server.addService(theServiceName, "C", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, byte[] theData) {
        this.service_name = theServiceName;
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromByteArray(theData, 0, size);
        this.service_id = Server.addService(theServiceName, "C", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, short[] theData) {
        this.service_name = theServiceName;
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromShortArray(theData, 0, size / 2);
        this.service_id = Server.addService(theServiceName, "S", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, int[] theData) {
        this.service_name = theServiceName;
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromIntArray(theData, 0, size / 4);
        this.service_id = Server.addService(theServiceName, "I", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, float[] theData) {
        this.service_name = theServiceName;
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromFloatArray(theData, 0, size / 4);
        this.service_id = Server.addService(theServiceName, "F", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, double[] theData) {
        this.service_name = theServiceName;
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromDoubleArray(theData, 0, size / 8);
        this.service_id = Server.addService(theServiceName, "D", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, long[] theData) {
        this.service_name = theServiceName;
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromLongArray(theData, 0, size / 8);
        this.service_id = Server.addService(theServiceName, "X", this);
        this.published = 1;
        this.itsFormat = null;
    }

    public DimService(String theServiceName, DimService src) {
        this.service_name = theServiceName;
        int size = src.getDataSize();
        this.setSize(size);
        this.copyFromMemory(src);
        this.service_id = Server.addService(theServiceName, src.getFormatStr(), this);
        this.published = 1;
        this.itsFormat = null;
    }

    public void finalize() {
        this.removeService();
    }

    public void removeService() {
        if (this.service_id != 0) {
            Server.removeService(this.service_id);
        }
    }

    public Memory encodeData() {
        this.serviceUpdateHandler();
        return this;
    }

    public void updateService(String theData) {
        this.setSize(theData.length() + 1);
        this.copyString(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(boolean theData) {
        this.setSize(1);
        this.copyBoolean(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(byte theData) {
        this.setSize(1);
        this.copyByte(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(short theData) {
        this.setSize(2);
        this.copyShort(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(int theData) {
        this.setSize(4);
        this.copyInt(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(float theData) {
        this.setSize(4);
        this.copyFloat(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(double theData) {
        this.setSize(8);
        this.copyDouble(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(long theData) {
        this.setSize(8);
        this.copyLong(theData);
        Server.updateService(this.service_id);
    }

    public void updateService(boolean[] theData) {
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromBooleanArray(theData, 0, size);
        Server.updateService(this.service_id);
    }

    public void updateService(byte[] theData) {
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromByteArray(theData, 0, size);
        Server.updateService(this.service_id);
    }

    public void updateService(short[] theData) {
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromShortArray(theData, 0, size / 2);
        Server.updateService(this.service_id);
    }

    public void updateService(int[] theData) {
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromIntArray(theData, 0, size / 4);
        Server.updateService(this.service_id);
    }

    public void updateService(float[] theData) {
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromFloatArray(theData, 0, size / 4);
        Server.updateService(this.service_id);
    }

    public void updateService(double[] theData) {
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromDoubleArray(theData, 0, size / 8);
        Server.updateService(this.service_id);
    }

    public void updateService(long[] theData) {
        int size = Sizeof.sizeof(theData);
        this.setSize(size);
        this.copyFromLongArray(theData, 0, size / 8);
        Server.updateService(this.service_id);
    }

    public void updateService(DimService src) {
        int size = src.getDataSize();
        this.setSize(size);
        this.copyFromMemory(src);
        Server.updateService(this.service_id);
    }

    int do_setup_format(int offset, char type, int num) {
        if (this.published == 0) {
            if (this.items.findOffset(offset) != -1) {
                return 1;
            }
            this.items.addOffset(offset, type, num);
            if (this.format != "") {
                if (this.format.lastIndexOf(58) < this.format.lastIndexOf(59)) {
                    char last = this.format.charAt(this.format.length() - 1);
                    if (last != type) {
                        System.out.println("JDIM: Dynamic Item must be at the end");
                        return 0;
                    }
                    return 1;
                }
                this.format = String.valueOf(this.format) + ";";
            }
            this.format = String.valueOf(this.format) + type;
            if (num != 0) {
                this.format = String.valueOf(this.format) + ":" + num;
            }
            return 1;
        }
        int index = this.items.findOffset(offset);
        if (index == -1) {
            if (type == 'C' && num == 0) {
                return 1;
            }
            System.out.println("JDIM: Offset " + offset + " not found ");
            return 0;
        }
        char ntype = this.items.getType(index);
        int nnum = this.items.getSize(index);
        if (ntype != type) {
            System.out.println("JDIM: Expected " + ntype + " found " + type);
            return 0;
        }
        if (nnum != num && nnum != 0 && num != 0) {
            System.out.println("JDIM: Expected " + nnum + " items, found " + num);
        }
        if (nnum == 0) {
            return 1;
        }
        return nnum;
    }

    public int do_setup_data(char type, int len, int size, int offset) {
        int new_offset = offset;
        if (offset == -1) {
            new_offset = this.curr_size;
            this.curr_size += size;
            this.setSize(this.curr_size);
        } else if (type == 'C' && len == 0) {
            this.curr_size = this.getAllocatedSize();
            if (offset + size > this.curr_size) {
                this.setSize(offset + size);
            }
        }
        if (this.do_setup_format(new_offset, type, len) == 0) {
            return -1;
        }
        this.setDataStoreOffset(new_offset);
        return new_offset;
    }

    public int setBoolean(boolean theData) {
        int offset = this.do_setup_data('C', 1, 1, -1);
        if (offset != -1) {
            this.copyBoolean(theData);
        }
        return offset;
    }

    public int setBoolean(boolean theData, int theOffset) {
        int offset = this.do_setup_data('C', 1, 1, theOffset);
        if (offset != -1) {
            this.copyBoolean(theData);
        }
        return offset;
    }

    public int setByte(byte theData) {
        int offset = this.do_setup_data('C', 1, 1, -1);
        if (offset != -1) {
            this.copyByte(theData);
        }
        return offset;
    }

    public int setByte(byte theData, int theOffset) {
        int offset = this.do_setup_data('C', 1, 1, theOffset);
        if (offset != -1) {
            this.copyByte(theData);
        }
        return offset;
    }

    public int setShort(short theData) {
        int offset = this.do_setup_data('S', 1, 2, -1);
        if (offset != -1) {
            this.copyShort(theData);
        }
        return offset;
    }

    public int setShort(short theData, int theOffset) {
        int offset = this.do_setup_data('S', 1, 2, theOffset);
        if (offset != -1) {
            this.copyShort(theData);
        }
        return offset;
    }

    public int setInt(int theData) {
        int offset = this.do_setup_data('I', 1, 4, -1);
        if (offset != -1) {
            this.copyInt(theData);
        }
        return offset;
    }

    public int setInt(int theData, int theOffset) {
        int offset = this.do_setup_data('I', 1, 4, theOffset);
        if (offset != -1) {
            this.copyInt(theData);
        }
        return offset;
    }

    public int setFloat(float theData) {
        int offset = this.do_setup_data('F', 1, 4, -1);
        if (offset != -1) {
            this.copyFloat(theData);
        }
        return offset;
    }

    public int setFloat(float theData, int theOffset) {
        int offset = this.do_setup_data('F', 1, 4, theOffset);
        if (offset != -1) {
            this.copyFloat(theData);
        }
        return offset;
    }

    public int setDouble(double theData) {
        int offset = this.do_setup_data('D', 1, 8, -1);
        if (offset != -1) {
            this.copyDouble(theData);
        }
        return offset;
    }

    public int setDouble(double theData, int theOffset) {
        int offset = this.do_setup_data('D', 1, 8, theOffset);
        if (offset != -1) {
            this.copyDouble(theData);
        }
        return offset;
    }

    public int setLong(long theData) {
        int offset = this.do_setup_data('X', 1, 8, -1);
        if (offset != -1) {
            this.copyLong(theData);
        }
        return offset;
    }

    public int setLong(long theData, int theOffset) {
        int offset = this.do_setup_data('X', 1, 8, theOffset);
        if (offset != -1) {
            this.copyLong(theData);
        }
        return offset;
    }

    public int setString(int max_size, String theData) {
        int offset = this.do_setup_data('C', max_size, max_size, -1);
        if (offset != -1) {
            this.copyString(theData);
        }
        return offset;
    }

    public int setString(String theData) {
        int offset = this.do_setup_data('C', 0, theData.length() + 1, -1);
        if (offset != -1) {
            this.copyString(theData);
        }
        return offset;
    }

    public int setString(String theData, int theOffset) {
        int offset = this.do_setup_data('C', 0, theData.length() + 1, theOffset);
        if (offset != -1) {
            this.copyString(theData);
        }
        return offset;
    }

    public int setBooleanArray(boolean[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size;
        int offset = this.do_setup_data('C', len, size, -1);
        if (offset != -1) {
            this.copyFromBooleanArray(theData);
        }
        return offset;
    }

    public int setBooleanArray(boolean[] theData, int theOffset) {
        int size = Sizeof.sizeof(theData);
        int len = size;
        int offset = this.do_setup_data('C', len, size, theOffset);
        if (offset != -1) {
            this.copyFromBooleanArray(theData);
        }
        return offset;
    }

    public int setByteArray(byte[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size;
        int offset = this.do_setup_data('C', len, size, -1);
        if (offset != -1) {
            this.copyFromByteArray(theData);
        }
        return offset;
    }

    public int setByteArray(byte[] theData, int theOffset) {
        int size = Sizeof.sizeof(theData);
        int len = size;
        int offset = this.do_setup_data('C', len, size, theOffset);
        if (offset != -1) {
            this.copyFromByteArray(theData);
        }
        return offset;
    }

    public int setShortArray(short[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 2;
        int offset = this.do_setup_data('S', len, size, -1);
        if (offset != -1) {
            this.copyFromShortArray(theData);
        }
        return offset;
    }

    public int setShortArray(short[] theData, int theOffset) {
        int size = Sizeof.sizeof(theData);
        int len = size / 2;
        int offset = this.do_setup_data('S', len, size, theOffset);
        if (offset != -1) {
            this.copyFromShortArray(theData);
        }
        return offset;
    }

    public int setIntArray(int[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 4;
        int offset = this.do_setup_data('I', len, size, -1);
        if (offset != -1) {
            this.copyFromIntArray(theData);
        }
        return offset;
    }

    public int setIntArray(int[] theData, int theOffset) {
        int size = Sizeof.sizeof(theData);
        int len = size / 4;
        int offset = this.do_setup_data('I', len, size, theOffset);
        if (offset != -1) {
            this.copyFromIntArray(theData);
        }
        return offset;
    }

    public int setFloatArray(float[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 4;
        int offset = this.do_setup_data('F', len, size, -1);
        if (offset != -1) {
            this.copyFromFloatArray(theData);
        }
        return offset;
    }

    public int setFloatArray(float[] theData, int theOffset) {
        int size = Sizeof.sizeof(theData);
        int len = size / 4;
        int offset = this.do_setup_data('F', len, size, theOffset);
        if (offset != -1) {
            this.copyFromFloatArray(theData);
        }
        return offset;
    }

    public int setDoubleArray(double[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 8;
        int offset = this.do_setup_data('D', len, size, -1);
        if (offset != -1) {
            this.copyFromDoubleArray(theData);
        }
        return offset;
    }

    public int setDoubleArray(double[] theData, int theOffset) {
        int size = Sizeof.sizeof(theData);
        int len = size / 8;
        int offset = this.do_setup_data('D', len, size, theOffset);
        if (offset != -1) {
            this.copyFromDoubleArray(theData);
        }
        return offset;
    }

    public int setLongArray(long[] theData) {
        int size = Sizeof.sizeof(theData);
        int len = size / 8;
        int offset = this.do_setup_data('X', len, size, -1);
        if (offset != -1) {
            this.copyFromLongArray(theData);
        }
        return offset;
    }

    public int setLongArray(long[] theData, int theOffset) {
        int size = Sizeof.sizeof(theData);
        int len = size / 8;
        int offset = this.do_setup_data('X', len, size, theOffset);
        if (offset != -1) {
            this.copyFromLongArray(theData);
        }
        return offset;
    }

    public int setStringArray(String[] theData) {
        int size = 0;
        int len = theData.length;
        int i = 0;
        while (i < len) {
            size += theData[i].length() + 1;
            ++i;
        }
        int offset = this.do_setup_data('C', 0, size, -1);
        if (offset != -1) {
            i = 0;
            while (i < len) {
                this.copyString(theData[i]);
                ++i;
            }
        }
        return offset;
    }

    public int setStringArray(String[] theData, int theOffset) {
        int size = 0;
        int len = theData.length;
        int i = 0;
        while (i < len) {
            size += theData[i].length() + 1;
            ++i;
        }
        int offset = this.do_setup_data('C', 0, size, theOffset);
        if (offset != -1) {
            i = 0;
            while (i < len) {
                this.copyString(theData[i]);
                ++i;
            }
        }
        return offset;
    }

    public void updateService() {
        if (this.published == 0) {
            this.itsFormat = new Format(this.format, 1);
            this.service_id = Server.addService(this.service_name, this.itsFormat.getFormat(), this);
            this.published = 1;
        } else {
            if (this.itsFormat != null) {
                this.itsFormat.reset();
            }
            Server.updateService(this.service_id);
        }
        this.curr_size = 0;
    }

    public void selectiveUpdateService() {
        int client_id = DimServer.getClientId();
        Server.selectiveUpdateService(this.service_id, client_id);
    }

    public void selectiveUpdateService(int[] client_ids) {
        Server.selectiveUpdateService(this.service_id, client_ids);
    }

    public void selectiveUpdateService(int client_id) {
        Server.selectiveUpdateService(this.service_id, client_id);
    }

    public static native void setQuality(int var0, int var1);

    public static native void setTimestamp(int var0, int var1, int var2);

    public void setQuality(int quality) {
        DimService.setQuality(this.service_id, quality);
    }

    public void setTimestamp(Date tstamp) {
        long total = tstamp.getTime();
        long aux = total % 1000L;
        int millisecs = (int)aux;
        aux = total / 1000L;
        int secs = (int)aux;
        DimService.setTimestamp(this.service_id, secs, millisecs);
    }

    public void serviceUpdateHandler() {
    }
}

