unit testef;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, math,
 _crw_alloc, _crw_ef, _crw_zm, _crw_fpu;

procedure Test_ef;

implementation

procedure Test_ef;
const n=10;
var x,m:extended; i,e:integer; v1,v2:array[0..n-1] of double;
begin
 writeln('Test of Elementary Functions unit.');
 writeln('MaxIntSingle   =',MaxIntSingle:24:3);
 writeln('MaxIntDouble   =',MaxIntDouble:24:3);
 writeln('MaxIntExtended =',MaxIntExtended:24:3);
 writeln('fscale(1,3)    =',fscale(1,3):24:3);
 x:=pi;
 fxtract(x,m,e);
 writeln('fxtract(',x:7:5,',m,e): m=',m:7:5,', e=',e);
 writeln('fbitcompress(x,8)=',fbitcompress(x,8));
 writeln('frelcompress(x,1e4)',frelcompress(x,1e4));
 writeln('fabscompress(x,1e3)',fabscompress(x,1e3));
 writeln('sgn(-2.0)=',sgn(-2.0),', sgn(+2.0)=',sgn(+2.0));
 writeln('sign(-2.0)=',sign(-2.0),', sign(+2.0)=',sign(+2.0));
 writeln('sgn(0)=',sgn(0),', sign(0)=',sign(0));
 writeln('gamma(6)=',gamma(6):11:4);
 writeln('Press a key to continue...');
 //readln;
 randomize;
 for i:=0 to n-1 do begin
  v1[i]:=random;
  v2[i]:=random;
  writeln(v1[i]:7:5,' ',v2[i]:7:5);
 end;
 writeln('ScalarProduct =',ScalarProduct(v1,v2,n):7:5);
 writeln('CumulativeSum =',CumulativeSum(v1,n):7:5);
 writeln('IndexOfMax    =',IndexOfMax(v1,n):7);
 writeln('IndexOfMin    =',IndexOfMin(v1,n):7);
 writeln('ValueOfMax    =',ValueOfMax(v1,n):7:5);
 writeln('ValueOfMin    =',ValueOfMin(v1,n):7:5);
 writeln('Test of Elementary Functions unit ends.');
end;

end.
