﻿---

<b id="toc" class="big memo">Содержание</b>
<a href="crwlib.chm" class="bold memo">CHM</a>
<a href="manual/index.html" class="bold memo">Справка</a>
<a href="manual/index-8.html" class="bold memo">Глоссарий</a>
<a href="manual/index-9.html" class="bold memo">Дерево Классов</a>
<a href="manual/_crw_crwapi/index.html" class="bold memo">CrwApi</a>

[[toc]]

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

# crwlib - библиотека кодов для пакета CRW-DAQ и других проектов

> Здесь приводятся сведения по библиотеке **[crwlib](./)**,
  являющейся частью пакета **[crwdaq](../crwdaq/index.htm)**.
  Имеется **[справка](manual/index.html)** и **[chm](crwlib.chm)**.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Путеводитель по библиотеке crwlib

<a href="crwlib.chm" class="bold memo">CHM</a> - Справка в формате **CHM**

<a href="manual/index.html" class="big bold memo">Справка</a> - список всех доступных **Модулей*  

<a href="manual/index-8.html" class="big bold memo">Глоссарий</a> - список всех доступных **Идентификаторов**  

<a href="manual/index-9.html" class="big bold memo">Дерево Классов</a> - список всех доступных **Классов** в порядке наследования  

<a href="manual/_crw_crwapi/index.html" class="big bold memo">CrwApi</a> - интерфейс для подключения **[плагинов](../crwdaq/resource/manual/crwdaq-plugin.htm)**  

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Назначение библиотеки crwlib

Библиотека **[crwlib](./)** - это пакет или **[набор](./)** кодов (в основном на языке **Free Pascal**)
для пакета **[crwdaq](../crwdaq/index.htm)** и других (сопутствующих) проектов
команды разработчиков **[DaqGroup](mailto:daqgroup@mail.ru)**.

Используя пакет **crwlib**, Вы автоматически принимаете
лицензионное **[соглашение](license.htm)**
на его использование и распространение.  
Либо Вы должны отказаться от его использования.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Правила использования crwlib

Библиотека **crwlib** должна использоваться по определенным правилам.

1. Во все модули **crwlib**, **crwkit** и **crwdaq** сразу после объявления модуля
   включается файл **общих определений** - **[_crw_sysdef.inc](_crw_sysdef.inc)**.  
   Это можно сделать директивой компилятора **`{$I _crw_sysdef.inc}`**.
   Смотрите, например, файл **[_crw_alloc.pas](_crw_alloc.pas)**.
   Использование включаемого файла вместо явного определения режимов компиляции
   позволяет централизовать управление проектом - все определения можно изменить
   в одном файле.

2. Сразу после **общих определений** недо включить **декларацию режима совместимости**.  
   Обычно для этого включается файл **[_crw_sysmode.inc](_crw_sysmode.inc)**.
   Это можно сделать директивой компилятора **`{$I _crw_sysmode.inc}`**.
   Смотрите, например, файл **[_crw_alloc.pas](_crw_alloc.pas)**.
   Использование включаемого файла вместо явного определения режимов компиляции
   позволяет централизовать управление проектом - все определения можно изменить
   в одном файле.

3. Первым выражением после **uses** всегда **должно** идти включение файла **[_crw_uses_first.inc](_crw_uses_first.inc)**.  
   Файл **`_crw_uses_first`** включает модуль **[_crw_sharemem.pas](_crw_sharemem.pas)** менеджера общей памяти, идущий **первым в списке**.  
   Это гарантирует инициализацию менеджера памяти до того, как начнется выделение динамической памяти.  
   Поскольку пакет **crwdaq** и другие проекты команды **DaqGroup** являются многопоточными,  
   после менеджера общей памяти включен список системных модулей для каждой платформы:  
   **`{$IFDEF UNIX} cthreads, dl, {$ENDIF} {$IFDEF WINDOWS} windows, {$ENDIF}`**.  
   Включение модуля **cthreads** в **Unix** версии обеспечивает правильную инициализацию кода поддержки потоков.  
   **`Если не включать _crw_uses_first.inc первым модулем uses для КАЖДОГО модуля, то программа будет работать неверно!`**.  
   Таким образом, **`каноническое`** начало **`КАЖДОГО`** модуля будет выглядеть примерно так:

``` pascal
unit _crw_xxxx;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math,
 … и так далее …
```


4. В качестве шаблона нового модуля можно использовать файл **[_crw_xxxx.pas](sample/_crw_xxxx.pas)**.  
   Этот шаблон содержит пустой модуль **_crw_xxxx*, в котором надо **xxxx** заменить на нужное имя.  
   В шаблоне уже прописаны указанные выражения.

<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

## Состав библиотеки crwlib

Библиотека **crwlib** является частью проекта (пакета) **CRW-DAQ** и содержит следующие файлы.

| Модуль (файл)                                                     |                                                                                       |
|-------------------------------------------------------------------|---------------------------------------------------------------------------------------|
| **Основные файлы библиотеки:**                                    | Файлы модулей с программыми кодами библиотеки (Free Pascal).                          |
| **[_crw_alloc.pas](_crw_alloc.pas)**                              | Модуль работы с памятью, исключениями, реестр объектов и атомарные операции.          |
| **[_crw_adodb_tlb.pas](_crw_adodb_tlb.pas)**                      | Модуль заголовков интерфейса баз данных **ADO** (_ADO type library_) для **Windows**. |
| **[_crw_ascio.pas](_crw_ascio.pas)**                              | Модуль асинхронного консольного ввода-вывода (для консольных задач серверного типа).  |
| **[_crw_appforms.pas](_crw_appforms.pas)**                        | Модуль поддержки форм (окон) **TForm** и связанных с ними процедур.                   |
| **[_crw_apptools.pas](_crw_apptools.pas)**                        | Модуль команд уровня приложения (_application tools_) для облегчения кодирования.     |
| **[_crw_apputils.pas](_crw_apputils.pas)**                        | Модуль утилит уровня приложения (_application utilities_) для облегчения кодирования. |
| **[_crw_assoc.pas](_crw_assoc.pas)**                              | Модуль обработки файловых ассоциаций (_association_) - действий по расширению файла.  |
| **[_crw_az.pas](_crw_az.pas)**                                    | Модуль "анти-зомби" (_anti-zombie_) для завершения задач после завершения родителя.   |
| **[_crw_base32.pas](_crw_base32.pas)**                            | Модуль быстрого де/кодирования строк алгоритмом **base32** для передачи данных.       |
| **[_crw_base64.pas](_crw_base64.pas)**                            | Модуль быстрого де/кодирования строк алгоритмом **base64** для передачи данных.       |
| **[_crw_bsencode.pas](_crw_bsencode.pas)**                        | Модуль быстрого де/кодирования строк алгоритмом **backslash** для передачи данных.    |
| **[_crw_cmdargs.pas](_crw_cmdargs.pas)**                          | Модуль обработки аргументов командной строки (объект CmdArgs).                        |
| **[_crw_calib.pas](_crw_calib.pas)**                              | Модуль содержит объекты калибровки (_calibration_) для преобразования данных.         |
| **[_crw_cgi.pas](_crw_cgi.pas)**                                  | Модуль поддержки **CGI** (_common gateway interface_) для **WEB** программирования.   |
| **[_crw_colors.pas](_crw_colors.pas)**                            | Модуль определяет цветовые константы (именованные цвета) и цветовые функции.          |
| **[_crw_couple.pas](_crw_couple.pas)**                            | Модуль содержит таблицы термопар (_thremocpuple_) и зависимостей для калибровок.      |
| **[_crw_crypt.pas](_crw_crypt.pas)**                              | Модуль криптографических функций (_cryptography_), hex_encode/decode, вычисление MD5. |
| **[_crw_crwapi.pas](_crw_crwapi.pas)**                            | Модуль интерфейса (_CRW API_) для создания программных расширений (плагинов).         |
| **[_crw_curves.pas](_crw_curves.pas)**                            | Модуль содержит объект "кривые" (_curve_) для описания массивов точек (x,y).          |
| **[_crw_daqevnt.pas](_crw_daqevnt.pas)**                          | Модуль реализует события системы **DAQ** (_daq events_) и средства их обработки.      |
| **[_crw_daqtags.pas](_crw_daqtags.pas)**                          | Модуль реализует базу данных (таблицу) тегов для системы сбора данных (_daq tags_).   |
| **[_crw_dbapi.pas](_crw_dbapi.pas)**                              | Модуль интерфейса баз данных (_database API_), пока реализована для **Windows**.      |
| **[_crw_dbcon.pas](_crw_dbcon.pas)**                              | Модуль констант интерфейса баз данных **ADO** (_database constants_) для **Windows**. |
| **[_crw_dcc32.pas](_crw_dcc32.pas)**                              | Модуль оболочки для компилятора **Delphi** (_dcc32_) для **Windows**.                 |
| **[_crw_delauna.pas](_crw_delauna.pas)**                          | Модуль реализует метод триангуляции Делоне (_Delauna_) для рисования 3D поверхностей. |
| **[_crw_dim.pas](_crw_dim.pas)**                                  | Модуль интерфейса к библиотеке **DIM** (_distributed information manager_).           |
| **[_crw_dima.pas](_crw_dima.pas)**                                | Модуль **DIM**-агента (_dim_agent_) для связи по **DIM** через сервер **dimsrv**.     |
| **[_crw_dimc.pas](_crw_dimc.pas)**                                | Модуль реализует клиетскую библиотеку классов для **DIM** (_dim client_).             |
| **[_crw_dimq.pas](_crw_dimq.pas)**                                | Модуль реализует потокобезопасную очередь (_dim queue_) для обработки данных **DIM**. |
| **[_crw_dims.pas](_crw_dims.pas)**                                | Модуль реализует серверную библиотеку классов для **DIM** (_dim server_).             |
| **[_crw_dynar.pas](_crw_dynar.pas)**                              | Модуль димнамических 1,2D массивов (_dynamic array_) с потокобезопасностью и защитой. |
| **[_crw_ee.pas](_crw_ee.pas)**                                    | Модуль интерпретатора выражений (_expression evaluator_) для интерактивных расчетов.  |
| **[_crw_ef.pas](_crw_ef.pas)**                                    | Модуль элементарных математических функций (_elementary functions_) для расчетов.     |
| **[_crw_eldraw.pas](_crw_eldraw.pas)**                            | Модуль элементарных функций для рисования (_elementary drawing_) графики.             |
| **[_crw_environ.pas](_crw_environ.pas)**                          | Модуль для работы с переменными среды окружения (_environment variables_).            |
| **[_crw_fft24.pas](_crw_fft24.pas)**                              | Модуль функций быстрого преобразования Фурье для размера массивов, кратного 2 или 4.  |
| **[_crw_fft.pas](_crw_fft.pas)**                                  | Модуль функций преобразования Фурье (_fast Fourier transform_) для мат.расчетов.      |
| **[_crw_fifo.pas](_crw_fifo.pas)**                                | Модуль реализует быструю потокобезопасную очередь **FIFO** (_first in, first out_).   |
| **[_crw_fio.pas](_crw_fio.pas)**                                  | Модуль функций файлового ввода-вывода (_file input/output_).                          |
| **[_crw_fonts.pas](_crw_fonts.pas)**                              | Модуль функций поддержки шрифтов (_fonts_) для графических приложений.                |
| **[_crw_fpu.pas](_crw_fpu.pas)**                                  | Модуль **FPU** (_float point unit_) - функции поддержки математического сопроцессора. |
| **[_crw_fsm.pas](_crw_fsm.pas)**                                  | Модуль реализует Конечные Автоматы (_finite state machine_) для задач управления.     |
| **[_crw_funmin.pas](_crw_funmin.pas)**                            | Модуль функций многомерной минимизации (_function minimization_) для расчетов.        |
| **[_crw_geoid.pas](_crw_geoid.pas)**                              | Модуль региональных идентификаторов (_geolocation identifiers_), т.е. коды стран.     |
| **[_crw_gloss.pas](_crw_gloss.pas)**                              | Модуль реализует потокобезопасный глоссарий (_glossary_) - массив (ключ,значение).    |
| **[_crw_guard.pas](_crw_guard.pas)**                              | Модуль функций защиты (_guard_) для системы прав доступа пакета CRW-DAQ.              |
| **[_crw_guiutils.pas](_crw_guiutils.pas)**                        | Модуль графических (GUI) утилит - формы, кнопки, фонты и т.д.                         |
| **[_crw_hash.pas](_crw_hash.pas)**                                | Модуль функций быстрого некриптографического хеширования (_hash_) для индексации.     |
| **[_crw_hl.pas](_crw_hl.pas)**                                    | Модуль хешированного списка (_hash list_) для быстрой индексации данных по ключу.     |
| **[_crw_i8255.pas](_crw_i8255.pas)**                              | Модуль драйвера цифрового ввода-вывода на базе чипа **I8255** для систем управления.  |
| **[_crw_lm.pas](_crw_lm.pas)**                                    | Модуль сетевых функций (_lan manager_) для поддержки сети, в основном **Windows**.    |
| **[_crw_lmd.pas](_crw_lmd.pas)**                                  | Модуль для сбора данных в режиме списка данных (_list mode data_) для спектрометрии.  |
| **[_crw_lngid.pas](_crw_lngid.pas)**                              | Модуль языковых констант (_language identifiers_) для поддержки языков.               |
| **[_crw_lsqmin.pas](_crw_lsqmin.pas)**                            | Модуль функций минимизации методом МНК (_least squares minimization_) для расчетов.   |
| **[_crw_lsqpoly.pas](_crw_lsqpoly.pas)**                          | Модуль реализует полиномы методом наименьших квадратов (_least square polynoms_).     |
| **[_crw_lttb.pas](_crw_lttb.pas)**                                | Алгоритм **LTTB** понижения дискретности (_downsampling_) для ускорения графиков.     |
| **[_crw_memo.pas](_crw_memo.pas)**                                | Модуль поддержки функций редактирования текста (_TMemo_) - Undo/Redo,Find,Print.      |
| **[_crw_meta.pas](_crw_meta.pas)**                                | Модуль реализует метаданные (_metadata_) (контрольные суммы) для файлов конфигурации. |
| **[_crw_mimeapps.pas](_crw_mimeapps.pas)**                        | Модуль обработки файлов по типу **MIME** и расширению для **Unix**.                   |
| **[_crw_mmt.pas](_crw_mmt.pas)**                                  | Модуль мультимедийного таймера (_multimedia timer_) для периодического опроса.        |
| **[_crw_netif.pas](_crw_netif.pas)**                              | Модуль поддержки сетевого интерфейса (_network interface_) и чтения параметров сети.  |
| **[_crw_oledb.pas](_crw_oledb.pas)**                              | Модуль заголовков интерфейса баз данных **OLE DB** для **Windows**.                   |
| **[_crw_opc.pas](_crw_opc.pas)**                                  | Модуль заголовков интерфейса автоматизации **OPC DA** для **Windows**.                |
| **[_crw_pio.pas](_crw_pio.pas)**                                  | Модуль для работы с портами ввода-вывода (_port in/out_) процессора.                  |
| **[_crw_pipe.pas](_crw_pipe.pas)**                                | Модуль реализует именованные каналы (_named pipes_) для связи процессов **IPC**.      |
| **[_crw_pkk4.pas](_crw_pkk4.pas)**                                | Модуль содержит драйвер **CAMAC** контроллера **PKK4** для систем сбора данных.       |
| **[_crw_plut.pas](_crw_plut.pas)**                                | Модуль утилит рисования (_plot utilities_) для (виртуального) рисования 2D фигур.     |
| **[_crw_proc.pas](_crw_proc.pas)**                                | Модуль функций для работы с процессами (_process_) операционной системы.              |
| **[_crw_regexp.pas](_crw_regexp.pas)**                            | Модуль поддержки регулярных выражений (_regular expression_) для обработки текста.    |
| **[_crw_riff.pas](_crw_riff.pas)**                                | Модуль поддержки формата **RIFF** (_ResourceInterchangeFileFormat_) включая CRW, WAV. |
| **[_crw_rtc.pas](_crw_rtc.pas)**                                  | Модуль функций времени (_real time clock_) для быстрого измерения реального времени.  |
| **[_crw_rtdtc.pas](_crw_rtdtc.pas)**                              | Модуль содержит таблицы калибровок (_resistive thermo detectors + thrermo couples_).  |
| **[_crw_runerr.pas](_crw_runerr.pas)**                            | Модуль поддержки для обработки ошибок времени исполнения (_runtime errors_).          |
| **[_crw_sect.pas](_crw_sect.pas)**                                | Модуль содержит имена часто используемых секций (_section_) для файлов конфигураций.  |
| **[_crw_serio.pas](_crw_serio.pas)**                              | Модуль поддержки последовательных **COM** портов (_serial in/output_) ввода-вывода.   |
| **[_crw_sesman.pas](_crw_sesman.pas)**                            | Модуль поддержки сессий (_session manager_) при запуске нескольких сессий программы.  |
| **[_crw_sharemem.pas](_crw_sharemem.pas)**                        | Модуль менеджера (общей) памяти. Всегда **должен** быть первым **uses** модулем.      |
| **[_crw_sharm.pas](_crw_sharm.pas)**                              | Модуль общей памяти (_shared memory_) для межпроцессного взаимодействия **IPC**.      |
| **[_crw_simplex.pas](_crw_simplex.pas)**                          | Модуль для решения задач линейного программирования симплексным (_simplex_) методом.  |
| **[_crw_smirtl.pas](_crw_smirtl.pas)**                            | Модуль поддержки прокси (_smi runtime library_) для Конечных Автоматов **SMI**.       |
| **[_crw_smiuirtl.pas](_crw_smiuirtl.pas)**                        | Модуль интерфейса пользователя (_smi ui runtime library_) Конечных Автоматов **SMI**. |
| **[_crw_snd.pas](_crw_snd.pas)**                                  | Модуль звуковой системы (_sound_) для воспроизведения звуковых сообщений.             |
| **[_crw_spcfld.pas](_crw_spcfld.pas)**                            | Модуль определяет специальные каталоги (_special folder_) для хранения настроек .     |
| **[_crw_spk.pas](_crw_spk.pas)**                                  | Модуль речевого синтезатора (_speaker_) для произношения текстовых сообщений.         |
| **[_crw_spline.pas](_crw_spline.pas)**                            | Модуль реализует сглаживающие сплайны для аппроксимации данных.                       |
| **[_crw_sort.pas](_crw_sort.pas)**                                | Модуль реализует алгоритмы быстрого поиска и сортировки (_sort_).                     |
| **[_crw_str.pas](_crw_str.pas)**                                  | Модуль функций обработки строк (_string_) и тестов.                                   |
| **[_crw_svd.pas](_crw_ef.pas)**                                   | Модуль матричных операций **SVD** (_singular values decomposition_) для расчетов.     |
| **[_crw_syscal.pas](_crw_syscal.pas)**                            | Модуль системного калькулятора (_system calculator_) для потокобезопасных вычислений. |
| **[_crw_sysdef.inc](_crw_sysdef.inc)**                            | Файл общих определений. **Всегда** должен включаться в код: **`{$I _crw_sysdef.inc}`** |
| **[_crw_sysmode.inc](_crw_sysmode.inc)**                          | Файл режима совместимости. **Всегда** должен включаться в код: **`{$I _crw_sysmode.inc}`** |
| **[_crw_sysid.pas](_crw_sysid.pas)**                              | Модуль процедур для идентификации системы (_system identification_).                  |
| **[_crw_task.pas](_crw_task.pas)**                                | Модуль поддержки задач (_task_), т.е. управляемых процессов (супервизор процессов).   |
| **[_crw_tcp.pas](_crw_tcp.pas)**                                  | Модуль поддержки **TCP** сокетов (_TCP socket_) для связи по сети **TCP/IP**.         |
| **[_crw_th123.pas](_crw_th123.pas)**                              | Модуль реализует гистограммы (_type histogram 1D,2D,3D_) для статистических расчетов. |
| **[_crw_tslist.pas](_crw_tslist.pas)**                            | Модуль потокобезопасных списков (_thread safe list_) для многопоточных программ.      |
| **[_crw_uac.pas](_crw_uac.pas)**                                  | Модуль поддержки **UAC** (_user access control_), в основном для **Windows**.         |
| **[_crw_uart.pas](_crw_uart.pas)**                                | Модуль поддержки **UART** (последовательных **COM** портов).                          |
| **[_crw_vbox.pas](_crw_vbox.pas)**                                | Модуль поддержки **VirtualBox** для гостевых виртуальных систем.                      |
| **[_crw_wine.pas](_crw_wine.pas)**                                | Модуль поддержки **WINE** для приложений **Windows**.                                 |
| **[_crw_wmctrl.pas](_crw_wmctrl.pas)**                            | Модуль процедур для управления и работы с окнами (_window manager control_).          |
| **[_crw_zm.pas](_crw_zm.pas)**                                    | Модуль поиска нуля и минимума (zeromin), а также интеграла функции одной переменной.  |
| **[fpcx64mm.pas](mormot.core.fpcx64mm.pas)**                      | Модуль менеджера общей памяти из пакета MoRMot2 для Linux x86_64 (альтернативный).    |
| **[synfpcx64mm.pas]()**                                           | Модуль менеджера общей памяти из пакета MoRMot  для Linux x86_64 (вроде основной).    |
| **Вспомогательные файлы библиотеки:**                             | Описания, лицензия, статьи, и т.д.                                                    |
| **[index.htm](index.htm)**                                        | Описание библиотеки **crwlib** - этот файл, который вы сейчас читаете.                |
| **[license.htm](license.htm)**                                    | Файл лицензионного соглашения для данной библиотеки и пакета **CRW-DAQ**.             |
| **[habr-534466.pdf](inform/habr-534466.pdf)**                     | Очень полезная статья по переводу кода Delphi под Linux, рекомендуемая к прочтению.   |
| **[laz-unicode-en.pdf](inform/laz-unicode-en.pdf)**               | Статья (en) о поддержке Unicode в Lazarus.                                            |
| **[laz-unicode-ru.pdf](inform/laz-unicode-ru.pdf)**               | Статья (ru) о поддержке Unicode в Lazarus.                                            |
| **[laz-multiplatform-en.pdf](inform/laz-multiplatform-en.pdf)**   | Статья (en) о многоплатформенном программировании в Lazarus.                          |
| **[laz-multiplatform-ru.pdf](inform/laz-multiplatform-ru.pdf)**   | Статья (ru) о многоплатформенном программировании в Lazarus.                          |




<a href="#toc" class="bold memo">Перейти к Содержанию</a>

---

Успешного Вам использования библиотеки **crwlib**!

---

> CRW-DAQ Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru

---
