#!/bin/bash

function about(){
 echo "$(basename ${BASH_SOURCE[0]}) version 20250412";
 echo "##############################################################";
 echo "# Shell Installation Script.                                 #";
 echo "# Copyright (c) 2023-2024 Alexey Kuryakin daqgroup@mail.ru   #";
 echo "##############################################################";
};

function note(){ return; };
function fatal(){ echo -ne "\n$1\n\n"; exit 1; };

note "Script identification.";
note "######################";
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

note "Extract target package name from script name.";
note "#############################################";
readonly targetname="$(echo "$scriptbase" | sed 's/^[a-z]*-//')";

note "The payload directory contains user installer + data archive(s).";
note "################################################################";
readonly payloaddir="$scriptHOME";

note "Include the install-library.sh library source.";
note "##############################################";
readonly installlib="$payloaddir/install-library.sh";
source $installlib || fatal "Error: not found $installlib.";

note "#######################";
note "Install target package.";
note "#######################";
function install_target(){
 echo "";
 echo "Install: $targetname";
 echo "";
 common_predinst;
 note "##################################";
 note "### Begin User Installer code: ###";
 note "##################################";
 
 note "########################################";
 note "Check required packages to be installed.";
 note "########################################";
 check_install_dpkg zenity makeself zip unzip xz-utils p7zip;
 note "#############################";
 note "Unpack archive to target dir.";
 note "#############################";
 local archive="$targetname.tar";
 local targdir="/opt/daqgroup/suite";
 check_confirm_iam_user || fatal "Cancel: user mode expected.";
 tar_list_check_exist $archive $targdir || fatal "Cancel: file already exist.";
 root_mkdir $targdir; 
 sudo rm -fvr $targdir/crwlib/*;
 sudo rm -fvr $targdir/crwtst/*;
 unpack_tar $archive $targdir 777 root;
 note "Make all files readable.";
 sudo chmod -c ugo+rx $targdir;
 sudo chmod -c ugo+rx $targdir/..;
 sudo chmod -cR ugo+r $targdir/*;
 #note "Set Owner for all files.";
 #sudo chown -cR $USER:$USER $targdir/*;
 if [ -e $targdir/crwlib/ ]; then
  if [ -L /opt/crwlib ]; then
   sudo rm -fv /opt/crwlib;
  fi;
  sudo ln -sv -T $targdir/crwlib /opt/crwlib;
 fi;
 
 note "##################################";
 note "### End of User Installer code ###";
 note "##################################";
 common_postinst;
};

note "########";
note "# Main #";
note "########";
function main(){
 about; print_identification; sleep 1;
 check_sudo_is_avail || fatal "Error: sudo is not available.";
 check_install_package zenity makeself zip unzip xz:xz-utils 7za:p7zip;
 local ask="$(zen_hello_user)\n\n$(zen_do_you_want_to $(langstr en 'Run' ru 'Запустить'))\n";
 ask="$ask\n<big><b><span fgcolor='green'>install-$targetname.sh</span></b>?</big>";
 if ask_zenity 0 --question --text "$ask" --timeout 180 >/dev/null 2>&1; then
  install_target;
  echo -ne "\nDone\n\n";
 else
  echo -ne "\nCancel\n\n";
 fi;
};

mkdir -p $HOME/.local/share/makeself;

main "$@" | tee $HOME/.local/share/makeself/$scriptbase.log;

#############
# END OF FILE
#############
