#!/bin/bash

function update_build_makeself_library(){
 local nsuc=0; local nerr=0;
 for item in $(ls -1 .); do
  if [ $item = generic ]; then continue; fi;
  if [ ! -e $item/build-$item.sh ]; then continue; fi;
  if cp -fv generic/build-generic.sh $item/build-$item.sh; then let nsuc+=1; else let nerr+=1; fi;
  if cp -fv generic/payload-generic/install-library.sh $item/payload-$item/install-library.sh; then let nsuc+=1; else let nerr+=1; fi;
 done;
 local date="$(date +%Y.%m.%d-%H:%M:%S)";
 local name="$(basename ${BASH_SOURCE[0]})";
 local text="Copied: $nsuc file(s), $nerr error(s) found.";
 notify-send -t 10000 -i dialog-information "$date: $name" "$text";
 echo "$date: $name"; echo "$text";
};
update_build_makeself_library;
