#!/bin/bash

###########################################################
## Copyright (c) 2002-2025 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Utility to install default setting for klogg program.
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function show_vers(){
 echo "$scriptname version 1.0";
};

function show_help(){
 show_vers;
 echo "Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru";
 echo "The klogg control panel to install klogg defaults, etc.";
 echo "Usage: ${scriptname} [-options]";
 echo "Options:";
 echo " -h,--help         - show help";
 echo " --version         - show version";
 echo " -i,--install      - install klogg default settings";
 echo "Examples:";
 echo " $scriptname --help       # show help";
 echo " $scriptname --version    # show version";
 echo " $scriptname -i           # install klogg default settings";
};

function show_usage(){
 local optlist="--version|--help|--install";
 echo "Usage: $scriptname $optlist";
};

function execute(){
 colorize_head echo "$@";
                    "$@";
};

function klogg_inst(){
 local confdir="$HOME/.config/klogg";
 if [[ ! -e $confdir ]]; then execute mkdir -pv $confdir; fi;
 for fn in klogg.conf klogg_session.conf; do
  cp -fpv $scriptHOME/$fn $confdir/$fn;
  chmod -c u+rw $confdir/$fn;
 done; 
 sed -i $confdir/klogg_session.conf -e "s/\balex\b/$USER/g";
};

function main(){
 case $1 in
  --version)                          show_vers; return 0; ;;
  -h|-help|--help)                    show_help; return 0; ;;
  -i|-inst|--inst|-install|--install) klogg_inst; ;;
  ''|*)                               colorize_head show_usage; ;;
 esac;
};

main "$@";

##############
## END OF FILE
##############
